version=`grep 'VERSION_NUMBER = ' config.mk | cut -d" " -f3`
((version=version+1))
today=`date -I`
changelog=`awk '/^## /{p=0} p{print} /Unreleased/{p=1}' CHANGELOG.md`

sed -Ei "s/(VERSION_NUMBER = )[0-9]+/\1$version/" config.mk
sed -Ei "s/## Unreleased/\0\n\n## $version - $today/" CHANGELOG.md

git add config.mk CHANGELOG.md
git commit -m "Release z$version"
git tag -a "z$version" -m "$changelog"
git show "z$version"
