// SPDX-License-Identifier: CC0-1.0
/**
  A tool that transforms sound into format used by the Anarch game. Based on the
  `snd2array.py` tool by Miloslav Číž.

  Written in 2025 by Marcin Serwin <marcin@serwin.dev>

  To the extent possible under law, the author(s) have dedicated all copyright
  and related and neighboring rights to this software to the public domain
  worldwide. This software is distributed without any warranty.

  You should have received a copy of the CC0 Public Domain Dedication along with
  this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>
*/

#include <assert.h>
#include <stdbool.h>
#include <stdio.h>

void dump_file(char *filename) {
  FILE *f = fopen(filename, "rb");

  printf("{");
  while (true) {
    int byte = getc(f);
    if (byte == EOF) {
      break;
    }
    printf("%d,", byte & 0xF0);
  }
  printf("},\n");
  fclose(f);
}

int main(int argc, char **argv) {
  for (int i = 1; i < argc; i++) {
    printf("// %d, %s\n", i, argv[i]);
    dump_file(argv[i]);
  }
}
