# SPDX-License-Identifier: CC0-1.0
#
# Nixpkgs style derivation that describes building of the Anarch RE project.
#
# Written in 2025 by Marcin Serwin <marcin@serwin.dev>
#
# To the extent possible under law, the author(s) have dedicated all copyright
# and related and neighboring rights to this software to the public domain
# worldwide. This software is distributed without any warranty.
#
# You should have received a copy of the CC0 Public Domain Dedication along with
# this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>

{
  stdenv,
  sdl3,
  lib,
  buildPackages,
  pkg-config,
  versionCheckHook,
}:
stdenv.mkDerivation (finalAttrs: {
  pname = "anarch-re";
  version = "0-dev";
  src = ./.;

  strictDeps = true;
  depsBuildBuild = [ buildPackages.stdenv.cc ];
  nativeBuildInputs = [
    pkg-config
    versionCheckHook
  ];
  buildInputs = [ sdl3 ];

  dontConfigure = true;

  makeFlags = [
    "EXE=${stdenv.hostPlatform.extensions.executable}"
    "PREFIX=${placeholder "out"}"
    "HOSTCC=$(CC_FOR_BUILD)"
    "VERSION_NUMBER=0"
    "VERSION_SUFFIX=-dev"
  ];

  doCheck = true;
  doInstallCheck = true;

  meta = {
    license = lib.licenses.cc0;
    platforms = with lib.platforms; unix ++ windows;
    mainProgram = finalAttrs.pname;
  };
})
