# SPDX-License-Identifier: CC0-1.0
#
# Configuration options for building and installation of the Anarch RE project.
#
# Written in 2025 by Marcin Serwin <marcin@serwin.dev>
#
# To the extent possible under law, the author(s) have dedicated all copyright
# and related and neighboring rights to this software to the public domain
# worldwide. This software is distributed without any warranty.
#
# You should have received a copy of the CC0 Public Domain Dedication along with
# this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>

# Meta

# This is passed to the SDL3 as app id for OS recognition. It also affects the
# name of the installed desktop entry file.
APP_ID = dev.serwin.AnarchRE

# This will be appended to the version number. Can be used to advertise the
# building entity or specify the build commit for development versions,
# for example, "-fooOS" or "-40f4cf9".
VERSION_SUFFIX = 

# The current version of the project.
VERSION_NUMBER = 1

# Final version of the package displayed in the window title.
FULL_VERSION = z$(VERSION_NUMBER)$(VERSION_SUFFIX)

# Dependencies

# The pkg-config binary used for querying the flags needed by SDL3. If you do
# not want to use pkg-config you can set them directly via LIBS macro.
PKG_CONFIG ?= pkg-config

# Building

# Compilation and linking can be controlled with the usual CC, CFLAGS, and
# LDFLAGS macros. Note that certain flags will be added automatically during
# building. If you want full control over them you can override the FULL_CFLAGS
# macro.

# These macros are used when building tools necessary for asset conversion.
HOSTCC = $(CC)
HOSTCFLAGS = $(CFLAGS)
HOSTLDFLAGS = $(LDFLAGS)

# The extension appended to the produced executable. For example, when cross-
# compiling to Windows set it to ".exe".
EXE =

# Installation

# These macros control where the project files will be installed. Staged
# installation is supported via the usual DESTDIR macro.
PREFIX = /usr/local
BINDIR = $(PREFIX)/bin
DATADIR = $(PREFIX)/share
MANDIR = $(DATADIR)/man
