// SPDX-License-Identifier: CC0-1.0
/**
  A tool that transforms palette image into format used by the Anarch game.

  Written in 2025 by Marcin Serwin <marcin@serwin.dev>

  To the extent possible under law, the author(s) have dedicated all copyright
  and related and neighboring rights to this software to the public domain
  worldwide. This software is distributed without any warranty.

  You should have received a copy of the CC0 Public Domain Dedication along with
  this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>
*/

#include "qoi_decoder.h"

int main(int argc, char **argv) {
  assert(argc > 1);
  FILE *pf = fopen(argv[1], "rb");
  assert(pf);
  static Color palette[MAX_SIZE * MAX_SIZE];
  Header ph = readPixels(pf, palette);

  for (uint32_t i = 0; i < ph.width * ph.height; i++) {
    Color c = palette[i];
    printf("%d,", (c.r >> 3) << (5 + 6) | (c.g >> 2) << 5 | c.b >> 3);
  }
  printf("\n");

  return 0;
}
