// SPDX-License-Identifier: CC0-1.0
/**
  A tool that transforms image based Anarch font into C array. Based on the
  `font2array.py` tool by Miloslav Číž.

  Written in 2025 by Marcin Serwin <marcin@serwin.dev>

  To the extent possible under law, the author(s) have dedicated all copyright
  and related and neighboring rights to this software to the public domain
  worldwide. This software is distributed without any warranty.

  You should have received a copy of the CC0 Public Domain Dedication along with
  this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>
*/

#include "qoi_decoder.h"

#include <stdbool.h>

#define get_pixel(i, j) pixels[(i) * hdr.width + (j)]

int main(int argc, char *argv[]) {
  static const char CHARS[] = "ABCDEFGHIJKLMNOPQRSTUVWXYZ .,!?0123456789/-+()%";
  static const int LETTER_SIZE = 4;

  assert(argc > 1);
  FILE *pf = fopen(argv[1], "rb");
  assert(pf);

  static Color pixels[MAX_SIZE * MAX_SIZE];
  Header hdr = readPixels(pf, pixels);
  assert(hdr.width == 5 * (sizeof(CHARS) - 1) - 1);

  for (int c = 0; c < (int)sizeof(CHARS) - 1; c++) {
    int value = 0;
    for (int j = 0; j < LETTER_SIZE; j++) {
      for (int i = 0; i < LETTER_SIZE; i++) {
        value *= 2;
        value += get_pixel(i, c * (LETTER_SIZE + 1) + j).r < 128;
      }
    }
    printf("0x%x, // %d \"%c\"\n", value, c, CHARS[c]);
  }

  return 0;
}
