# SPDX-License-Identifier: CC0-1.0
#
# Specifications for building assets for the Anarch game.
#
# Written in 2025 by Marcin Serwin <marcin@serwin.dev>
#
# To the extent possible under law, the author(s) have dedicated all copyright
# and related and neighboring rights to this software to the public domain
# worldwide. This software is distributed without any warranty.
#
# You should have received a copy of the CC0 Public Domain Dedication along with
# this software. If not, see <http://creativecommons.org/publicdomain/zero/1.0/>

ASSETS = images_walls.txtdata images_items.txtdata images_backgrounds.txtdata \
	images_weapons.txtdata images_effects.txtdata images_monsters.txtdata \
	images_logo.txtdata images_font.txtdata palette.txtdata levels_data.h \
	sounds_data.h touchcontrols_data.h

touchcontrols_data.h: assets/img2touchcontrols
	assets/img2touchcontrols > $@ \
		assets/button_arrow.qoi ARROW \
		assets/button_a.qoi BUTTON_A \
		assets/button_b.qoi BUTTON_B \
		assets/button_c.qoi BUTTON_C
		
sounds_data.h: assets/snd2array
	assets/snd2array > $@ \
		assets/sfx_shot.raw \
		assets/sfx_door.raw \
		assets/sfx_explosion.raw \
		assets/sfx_click.raw \
		assets/sfx_plasma.raw \
		assets/sfx_monster.raw

images_walls.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/wall_texture0.qoi "white wooden planks" \
		assets/wall_texture1.qoi "skyscraper window" \
		assets/wall_texture2.qoi "pink high-tech wall" \
		assets/wall_texture3.qoi "partly mossy concrete wall" \
		assets/wall_texture4.qoi "wooden chess pattern" \
		assets/wall_texture5.qoi "red brick wall" \
		assets/wall_texture6.qoi "grass-covered concrete wall, tiles with skyscraper window" \
		assets/wall_texture7.qoi "steel door" \
		assets/wall_texture8.qoi "white skull on blue" \
		assets/wall_texture9.qoi "red lava with stones" \
		assets/wall_texture10.qoi "transparent window" \
		assets/wall_texture11.qoi "white steel blocks" \
		assets/wall_texture12.qoi "gray square-tiled wall" \
		assets/wall_texture13.qoi "scifi door" \
		assets/wall_texture14.qoi "concrete wall, tiles with skyscraper window" \
		assets/wall_texture15.qoi "computer tech wall"

images_items.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/item_barrel.qoi "barrel" \
		assets/item_health.qoi "health" \
		assets/item_bullets.qoi "ammo: bullets" \
		assets/item_rockets.qoi "ammo: rockets" \
		assets/item_plasma.qoi "ammo: plasma" \
		assets/item_tree.qoi "tree" \
		assets/item_finish.qoi "finish" \
		assets/item_teleport.qoi "teleport" \
		assets/item_terminal.qoi "computer terminal" \
		assets/item_column.qoi "column" \
		assets/item_ruin.qoi "ruin" \
		assets/item_lamp.qoi "lamp" \
		assets/item_card.qoi "access card"

images_backgrounds.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/background1.qoi "city" \
		assets/background2.qoi "reddish scifi interior" \
		assets/background3.qoi "red city at night"

images_weapons.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/weapon_knife.qoi "knife" \
		assets/weapon_shotgun.qoi "shotgun" \
		assets/weapon_machinegun.qoi "machine gun" \
		assets/weapon_rocketlauncher.qoi "rocket launcher" \
		assets/weapon_plasmagun.qoi "plasma gun" \
		assets/weapon_solution.qoi "solution"

images_effects.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/effect_explosion.qoi "explostion" \
		assets/effect_fireball.qoi "fireball" \
		assets/effect_plasma.qoi "plasma" \
		assets/effect_dust.qoi "dust"

images_monsters.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/monster_spider_idle.qoi "spider idle" \
		assets/monster_spider_attack.qoi "spider attacking" \
		assets/monster_spider_walk.qoi "spider walking" \
		assets/monster_destroyer_idle.qoi "destroyer idle" \
		assets/monster_destroyer_attack.qoi "destroyer attacking" \
		assets/monster_destroyer_walk.qoi "destroyer walking" \
		assets/monster_warrior_idle.qoi "warrior idle" \
		assets/monster_warrior_attack.qoi "warrior attacking" \
		assets/monster_plasmabot_idle.qoi "plasmabot idle" \
		assets/monster_plasmabot_attack.qoi "plasmabot attacking" \
		assets/monster_ender_idle.qoi "ender idle" \
		assets/monster_ender_walk.qoi "ender walking" \
		assets/monster_ender_attack.qoi "ender attacking" \
		assets/monster_turret_idle.qoi "turret idle" \
		assets/monster_turret_walk.qoi "turret walk" \
		assets/monster_turret_attack.qoi "turret attack" \
		assets/monster_exploder_walk.qoi "exploder walk" \
		assets/monster_dying.qoi "universal dying sprite" \
		assets/monster_dead.qoi "universal dead/corpse sprite"

images_logo.txtdata: assets/img2array
	assets/img2array > $@ \
		assets/palette565.qoi \
		assets/logo.qoi "logo"

palette.txtdata: assets/img2palette
	# There are tiny differences when palette header data is generated from the
	# included palette_adjusted file. This palette was reconstructed from the
	# data in the header.
	assets/img2palette > $@ \
		assets/palette_reconstructed.qoi
		# assets/palette_adjusted.qoi # manually adjusted, more saturated palette
		# assets/palette565.qoi # original palette

images_font.txtdata: assets/font2array
	assets/font2array > $@ \
		assets/font.qoi

levels_data.h: assets/img2map
	assets/img2map > $@ \
		assets/level0.qoi SFG_level0 \
		assets/level1.qoi SFG_level1 \
		assets/level2.qoi SFG_level2 \
		assets/level3.qoi SFG_level3 \
		assets/level4.qoi SFG_level4 \
		assets/level5.qoi SFG_level5 \
		assets/level6.qoi SFG_level6 \
		assets/level7.qoi SFG_level7 \
		assets/level8.qoi SFG_level8 \
		assets/level9_fixed.qoi SFG_level9
		# level9.qoi has a different starting position than the one present in levels.h

