# Building

The game building can be roughly divided into two phases: asset generation and
the game unit compilation. This split is important if you are cross-compiling or
building a different frontend.

Various aspects of the build and installation process can be controlled by
variables passed to `make` such as `PREFIX` or `VERSION_SUFFIX`. For the full
list and their default values refer to [config.mk](./config.mk).

## Asset generation

Asset generation produces architecture and operating system independent text
files containing C arrays and structures filled with numbers representing files
present in the `assets` directory needed by the game. Their generation requires
only a C/C++ compiler and the standard C library. To compile only assets you can
use the phony `assets` target:

```sh
make assets
```

Note that this step compiles C programs that transform assets and then executes
them on the build machine. If your `CC` points to the target compiler you can
use the `HOSTCC`, `HOSTCFLAGS`, and `HOSTLDFLAGS` macros so that the correct
compiler is used, e.g.:

```sh
make HOSTCC=tcc CC=aarch64-unknown-linux-gnu-gcc
```

The above command will use `tcc` for generating assets while producing the
`anarch-re` executable using `aarch64-unknown-linux-gnu-gcc`.

## Game unit compilation

This step requires that assets described above are already generated. If you are
using `make` command and this is not the case then the assets will be generated
as a dependency.

The phase consists entirely of compilation of a single C file with the desired
frontend; example invocations can be found in the `make.sh` file. The `Makefile`
is written with the SDL3 frontend in mind. If assets are already present, then
the `make` invocation will be roughly equivalent to:

```sh
cc -o anarch-re main_sdl3.c `pkg-config --cflags --libs sdl3`
```

If you do not want to use `pkg-config` then the required compiler flags can be
provided via `LIBS` macro, e.g.:

```sh
make LIBS="-I/path/to/SDL3/include -lSDL3"
```

Depending on your system it may be worthwhile to use aggressive optimizations
during this step. This can be achieved using the standard `CFLAGS` macro, e.g.:

```sh
make CFLAGS="-O3 -fwhole-program"
```

## Installing

To install the created executable along with some other files you can run:

```sh
make PREFIX=/some/path install
```

If you don't specify the path it will default to `/usr/local` which usually
requires root privileges. Run `make uninstall` with the same `PREFIX` to remove
the game. Staged installation is supported via the usual `DESTDIR` macro.

If you are packaging the project for some repository consider setting
`VERSION_SUFFIX` during build time to identify it.

## Android

There exists a dedicated repo with build files for the Android project at
<https://git.sr.ht/~marcin-serwin/anarch-re-android/>.
