# AppLock v1.0.0 Release Notes

<div align="center">
  <img src="screenshots/ic_screenshot.png" alt="AppLock" height="200" />
  <h2>First Official Release</h2>
  <p><em>June 3, 2025</em></p>
</div>

---

We're excited to announce the official release of **AppLock 1.0.0**! After months of development and
testing, we're proud to deliver a robust app protection solution with a beautiful Material You
design.

## What's Included

### Core Features

- **Complete App Protection System**: Lock any app installed on your device with a single tap
- **Biometric Authentication**: Unlock protected apps using fingerprint or face recognition
- **PIN/Password Security**: Alternative secure authentication method
- **Real-time Monitoring**: Background service that detects and secures app launches instantly
- **Intelligent App List**: Comprehensive list of installed apps with smart search functionality
- **Material You Design**: Beautiful UI that adapts to your system theme colors

### Privacy & Security

- **Zero Data Collection**: All security data stays on your device
- **No Internet Required**: Works completely offline for maximum privacy
- **Secure Storage**: All sensitive information is securely encrypted
- **Non-intrusive Protection**: Minimal battery and performance impact

### User Experience

- **Intuitive Onboarding**: Guided setup for permissions and security configuration
- **Quick App Selection**: Easily find and secure apps with efficient search and sorting
- **Seamless Authentication**: Non-disruptive authentication overlay when accessing protected apps
- **Visual Feedback**: Clear indicators showing which apps are protected

## Getting Started

1. Download AppLock from the [releases page](https://github.com/PranavPurwar/AppLock/releases)
2. Follow the initial setup to configure your password/PIN and grant necessary permissions
3. Select the apps you want to protect using the toggles
4. That's it! Your apps are now protected

## Permissions

AppLock requires the following permissions to function properly:

- **Usage Access**: To detect when protected apps are launched
- **Display Over Other Apps**: To show the authentication screen
- **Biometric**: For fingerprint/face recognition (optional)

## Known Issues

- On some devices, the app may need to be manually added to battery optimization exceptions for
  reliable background operation
- Authentication overlay may briefly flicker on certain devices when an app is launched

## Future Plans

We're already working on the next update with additional features:

- Enhanced theming options
- Custom unlock patterns
- Scheduled protection periods
- Individual authentication methods per app
- App usage statistics

---

Thank you for choosing AppLock for your privacy needs. We welcome your feedback and suggestions
through GitHub issues!

<div align="center">
  <p><b>AppLock Team</b></p>
  <a href="https://github.com/PranavPurwar/AppLock">GitHub</a> | 
  <a href="https://github.com/PranavPurwar/AppLock/issues">Report Issues</a>
</div>
