package sp.phone.mvp.presenter;

import android.text.TextUtils;

import gov.anzong.androidnga.R;
import gov.anzong.androidnga.http.OnHttpCallBack;
import sp.phone.http.bean.MessageDetailInfo;
import sp.phone.mvp.contract.MessageDetailContract;
import sp.phone.mvp.model.MessageDetailModel;
import sp.phone.ui.fragment.MessageDetailFragment;

/**
 * Created by Justwen on 2017/10/11.
 */

public class MessageDetailPresenter extends BasePresenter<MessageDetailFragment,MessageDetailModel> implements MessageDetailContract.IMessagePresenter {


    private OnHttpCallBack<MessageDetailInfo> mCallBack = new OnHttpCallBack<MessageDetailInfo>() {
        @Override
        public void onError(String text) {
            if (!isAttached()) {
                return;
            }
            mBaseView.setRefreshing(false);
            mBaseView.hideLoadingView();
            if (TextUtils.isEmpty(text)) {
                mBaseView.showToast(R.string.error_network);
            } else {
                mBaseView.showToast(text);
            }
        }

        @Override
        public void onSuccess(MessageDetailInfo data) {
            if (!isAttached()) {
                return;
            }
            mBaseView.setRefreshing(false);
            mBaseView.hideLoadingView();
            mBaseView.setData(data);
        }
    };

    @Override
    protected MessageDetailModel onCreateModel() {
        return new MessageDetailModel();
    }

    @Override
    public void loadPage(int page, int mid) {
        mBaseView.setRefreshing(true);
        mBaseModel.loadPage(page, mid, mCallBack);

    }
}
