// SPDX-License-Identifier: GPL-3.0-or-later
import java.io.FileInputStream
import java.util.Properties

plugins {
  alias(libs.plugins.android.application)
  alias(libs.plugins.kotlin.android)
  alias(libs.plugins.kotlin.compose)
  alias(libs.plugins.ksp)
  alias(libs.plugins.room)

  kotlin("plugin.serialization") version "2.0.21"
}

val keystorePropertiesFile = rootProject.file("keystore.properties")
val keystoreProperties = Properties()

if (keystorePropertiesFile.exists())
    keystoreProperties.load(FileInputStream(keystorePropertiesFile))

room { schemaDirectory("$projectDir/schemas") }

android {
  namespace = "dev.itsvic.parceltracker"
  compileSdk = 35

  defaultConfig {
    applicationId = "dev.itsvic.parceltracker"
    minSdk = 26
    targetSdk = 35
    // ((major * 100 + minor) * 100 + patch) * 1000 + build
    versionCode = 10400000
    versionName = "1.4.0"

    testInstrumentationRunner = "androidx.test.runner.AndroidJUnitRunner"
  }


  buildTypes {
    release {
      if (keystorePropertiesFile.exists()) {
      }

      isMinifyEnabled = true
      isShrinkResources = true
      proguardFiles(getDefaultProguardFile("proguard-android-optimize.txt"), "proguard-rules.pro")
    }

    debug { isPseudoLocalesEnabled = true }
  }

  androidResources { generateLocaleConfig = true }

  compileOptions {
    sourceCompatibility = JavaVersion.VERSION_11
    targetCompatibility = JavaVersion.VERSION_11
  }

  kotlinOptions { jvmTarget = "11" }

  buildFeatures {
    compose = true
    buildConfig = true
  }

  // Disables encrypted dependency info block as requested by the F-Droid team.
  dependenciesInfo {
    includeInApk = false
    includeInBundle = false
  }
}

dependencies {
  implementation(libs.androidx.core.ktx)
  implementation(libs.androidx.lifecycle.runtime.ktx)
  implementation(libs.androidx.activity.compose)
  implementation(platform(libs.androidx.compose.bom))
  implementation(libs.androidx.ui)
  implementation(libs.androidx.ui.graphics)
  implementation(libs.androidx.ui.tooling.preview)
  implementation(libs.androidx.material3)
  implementation(libs.androidx.material.icons)
  implementation(libs.okhttp)
  implementation(libs.okhttp.coroutines)
  implementation(libs.logging.interceptor)
  implementation(libs.moshi)
  implementation(libs.androidx.navigation.compose)
  implementation(libs.androidx.navigation.fragment)
  implementation(libs.androidx.navigation.ui)
  implementation(libs.kotlinx.serialization.json)
  implementation(libs.room.runtime)
  implementation(libs.room.ktx)
  implementation(libs.androidx.datastore.preferences)
  implementation(libs.retrofit)
  implementation(libs.converter.moshi)
  implementation(libs.work.runtime)
  implementation(libs.work.runtime.ktx)
  implementation(libs.kotlinx.coroutines.guava)
  implementation(libs.androidx.browser)

  ksp(libs.room.compiler)
  ksp(libs.moshi.kotlin.codegen)

  testImplementation(libs.junit)
  androidTestImplementation(libs.androidx.junit)
  androidTestImplementation(libs.androidx.espresso.core)
  androidTestImplementation(platform(libs.androidx.compose.bom))
  androidTestImplementation(libs.androidx.ui.test.junit4)
  debugImplementation(libs.androidx.ui.tooling)
  debugImplementation(libs.androidx.ui.test.manifest)
}
