import SwiftUI
import KotlinSharedUI

struct UserOnelineView<TrailingContent: View>: View {
    @Environment(\.openURL) private var openURL
    let data: UiUserV2
    let showAvatar: Bool
    let trailing: () -> TrailingContent
    let onClicked: (() -> Void)?
    var body: some View {
        HStack {
            if showAvatar {
                AvatarView(data: data.avatar)
                    .frame(width: 20, height: 20)
                    .if(onClicked != nil) { view in
                        view
                            .onTapGesture {
                                onClicked?()
                            }
                    }
            }
            HStack {
                RichText(text: data.name)
                Text(data.handle)
                    .font(.caption)
                    .foregroundStyle(.secondary)
            }
            .if(onClicked != nil) { view in
                view
                    .onTapGesture {
                        onClicked?()
                    }
            }
            .frame(maxWidth: .infinity, alignment: .leading)
            trailing()
        }
        .lineLimit(1)
    }
}

extension UserOnelineView {
    init(data: UiUserV2) where TrailingContent == EmptyView {
        self.data = data
        self.trailing = {
            EmptyView()
        }
        self.onClicked = nil
        self.showAvatar = true
    }
}
