package dev.dimension.flare.ui.icons

import androidx.compose.ui.graphics.Color
import androidx.compose.ui.graphics.PathFillType
import androidx.compose.ui.graphics.SolidColor
import androidx.compose.ui.graphics.StrokeCap
import androidx.compose.ui.graphics.StrokeJoin
import androidx.compose.ui.graphics.vector.ImageVector
import androidx.compose.ui.graphics.vector.group
import androidx.compose.ui.graphics.vector.path
import androidx.compose.ui.unit.dp
import compose.icons.fontawesomeicons.BrandsGroup

public val BrandsGroup.Misskey: ImageVector
    get() =
        ImageVector
            .Builder(
                name = "Misskey",
                defaultWidth = 135.47.dp,
                defaultHeight = 135.47.dp,
                viewportWidth = 135.47f,
                viewportHeight = 135.47f,
            ).apply {
                group(
                    scaleX = 1f,
                    scaleY = 1f,
                    translationX = -38.1f,
                    translationY = -100.7f,
                    pivotX = 0f,
                    pivotY = 0f,
                ) {
                    path(
                        fill = SolidColor(Color(0xFF000000)),
                        fillAlpha = 1.0f,
                        stroke = null,
                        strokeAlpha = 1.0f,
                        strokeLineWidth = 1.0f,
                        strokeLineCap = StrokeCap.Butt,
                        strokeLineJoin = StrokeJoin.Miter,
                        strokeLineMiter = 1.0f,
                        pathFillType = PathFillType.NonZero,
                    ) {
                        moveTo(54.63f, 120.96f)
                        curveToRelative(-1.97790f, 00f, -3.86180f, 0.32980f, -5.65130f, 0.98910f)
                        curveToRelative(-3.20230f, 1.13020f, -5.83960f, 3.15530f, -7.91170f, 6.07510f)
                        curveToRelative(-1.97790f, 2.82560f, -2.96670f, 5.98070f, -2.96670f, 9.46560f)
                        verticalLineToRelative(61.88f)
                        curveToRelative(00f, 4.52090f, 1.6010f, 8.42940f, 4.80330f, 11.7260f)
                        curveToRelative(3.29650f, 3.20230f, 7.20550f, 4.80380f, 11.7260f, 4.80380f)
                        curveToRelative(4.61510f, 00f, 8.52360f, -1.60150f, 11.7260f, -4.80380f)
                        curveToRelative(3.29650f, -3.29650f, 4.94490f, -7.2050f, 4.94490f, -11.7260f)
                        verticalLineToRelative(-11.253f)
                        curveToRelative(0.03560f, -2.43710f, 2.5460f, -1.79770f, 3.81480f, 00f)
                        curveToRelative(2.37630f, 4.11530f, 7.41420f, 7.64970f, 13.280f, 7.62950f)
                        curveToRelative(5.86560f, -0.02020f, 10.7370f, -2.92020f, 13.280f, -7.62950f)
                        curveToRelative(0.9630f, -1.13580f, 3.67740f, -3.0710f, 3.95580f, 00f)
                        verticalLineToRelative(11.253f)
                        curveToRelative(00f, 4.52090f, 1.6010f, 8.42940f, 4.80330f, 11.7260f)
                        curveToRelative(3.29650f, 3.20230f, 7.20550f, 4.80380f, 11.7260f, 4.80380f)
                        curveToRelative(4.61510f, 00f, 8.52360f, -1.60150f, 11.7260f, -4.80380f)
                        curveToRelative(3.29650f, -3.29650f, 4.94490f, -7.2050f, 4.94490f, -11.7260f)
                        verticalLineToRelative(-61.88f)
                        curveToRelative(00f, -3.48490f, -1.03570f, -6.640f, -3.10780f, -9.46560f)
                        curveToRelative(-1.97790f, -2.91980f, -4.56830f, -4.94480f, -7.77060f, -6.07510f)
                        curveToRelative(-1.88370f, -0.65930f, -3.76760f, -0.98910f, -5.65130f, -0.98910f)
                        curveToRelative(-5.0860f, 00f, -9.37120f, 1.97820f, -12.8560f, 5.9340f)
                        lineToRelative(-16.775f, 19.632f)
                        curveToRelative(-0.37670f, 0.28260f, -1.62480f, 2.44280f, -4.27570f, 2.44280f)
                        curveToRelative(-2.65090f, 00f, -3.75740f, -2.16020f, -4.13410f, -2.44280f)
                        lineToRelative(-16.916f, -19.632f)
                        curveToRelative(-3.39070f, -3.95580f, -7.62890f, -5.9340f, -12.7150f, -5.9340f)
                        close()
                        moveToRelative(104.53f, 0f)
                        curveToRelative(-3.95580f, 00f, -7.34640f, 1.41290f, -10.1720f, 4.23850f)
                        curveToRelative(-2.73140f, 2.73140f, -4.09690f, 6.07510f, -4.09690f, 10.0310f)
                        curveToRelative(00f, 3.95580f, 1.36550f, 7.34640f, 4.09690f, 10.1720f)
                        curveToRelative(2.82560f, 2.73140f, 6.21620f, 4.09740f, 10.1720f, 4.09740f)
                        curveToRelative(3.95580f, 00f, 7.34640f, -1.3660f, 10.1720f, -4.09740f)
                        curveToRelative(2.82560f, -2.82560f, 4.23850f, -6.21620f, 4.23850f, -10.1720f)
                        curveToRelative(00f, -3.95580f, -1.41290f, -7.29950f, -4.23850f, -10.0310f)
                        curveToRelative(-2.82560f, -2.82560f, -6.21620f, -4.23850f, -10.1720f, -4.23850f)
                        close()
                        moveToRelative(0.14107f, 31.364f)
                        curveToRelative(-3.95580f, 00f, -7.34640f, 1.41290f, -10.1720f, 4.23850f)
                        reflectiveCurveToRelative(-4.238f, 6.2162f, -4.238f, 10.172f)
                        verticalLineToRelative(34.896f)
                        curveToRelative(00f, 3.95580f, 1.41240f, 7.34640f, 4.2380f, 10.1720f)
                        curveToRelative(2.82560f, 2.73140f, 6.21620f, 4.09740f, 10.1720f, 4.09740f)
                        reflectiveCurveToRelative(7.2995f, -1.366f, 10.031f, -4.0974f)
                        curveToRelative(2.82560f, -2.82560f, 4.23850f, -6.21620f, 4.23850f, -10.1720f)
                        verticalLineToRelative(-34.896f)
                        curveToRelative(00f, -3.95580f, -1.41290f, -7.34640f, -4.23850f, -10.1720f)
                        curveToRelative(-2.73140f, -2.82560f, -6.07510f, -4.23850f, -10.0310f, -4.23850f)
                        close()
                    }
                }
            }.build()
