# Geplante Features 🚀

**🌍 Sprachen:** **Deutsch** · [English](UPCOMING.md)

> Was kommt als Nächstes? Hier findest du unsere Pläne für zukünftige Versionen.

---

## v1.5.0 - Jetpack Compose & Internationalisierung ✅

> **Status:** Released 🎉 (Januar 2026)

### 🎨 Jetpack Compose UI

- ✅ **Komplettes UI-Redesign** - Von XML-Views zu Jetpack Compose
- ✅ **Modernisierte Einstellungen** - 7 kategorisierte Screens
- ✅ **Selection Mode** - Long-Press für Mehrfachauswahl
- ✅ **Silent-Sync Mode** - Kein Banner bei Auto-Sync

### 🌍 Mehrsprachigkeit

- ✅ **Englisch + Deutsch** - 400+ übersetzte Strings
- ✅ **Automatische Spracherkennung** - Folgt der System-Sprache
- ✅ **Per-App Language (Android 13+)** - Native Sprachauswahl

### 🎨 UI-Verbesserungen

- ✅ **Splash Screen** - App-Foreground-Icon
- ✅ **App Icon** - In About Screen und Empty State
- ✅ **Slide-Animationen** - Flüssige Übergänge im NoteEditor

---

## v1.6.0 - Technische Modernisierung ✅

> **Status:** Released 🎉 (Januar 2026)

### ⚙️ Konfigurierbare Sync-Trigger

- ✅ **Individuelle Trigger-Kontrolle** - Jeden Sync-Trigger einzeln aktivieren/deaktivieren
- ✅ **Ereignisbasierte Defaults** - onSave, onResume, WiFi-Connect standardmäßig aktiv
- ✅ **Periodischer Sync optional** - 15/30/60 Min Intervalle (Standard: AUS)
- ✅ **Boot Sync optional** - Periodischen Sync nach Geräteneustart starten (Standard: AUS)
- ✅ **Offline-Modus UI** - Ausgegraute Toggles wenn kein Server konfiguriert
- ✅ **Akku-optimiert** - ~0.2%/Tag mit Defaults, bis zu ~1.0% mit Periodic

---

## v1.6.1 - Clean Code ✅

> **Status:** Released 🎉 (Januar 2026)

### 🧹 Code-Qualität

- ✅ **detekt: 0 Issues** - Alle 29 Code-Qualitäts-Issues behoben
- ✅ **Zero Build Warnings** - Alle 21 Deprecation Warnings eliminiert
- ✅ **ktlint reaktiviert** - Mit Compose-spezifischen Regeln
- ✅ **CI/CD Lint-Checks** - In PR Build Workflow integriert
- ✅ **Constants Refactoring** - Dimensions.kt, SyncConstants.kt

---

## v1.7.0 - Grid View, WiFi-Only & VPN ✅

> **Status:** Released 🎉 (Januar 2026)

### 🎨 Grid Layout

- ✅ **Pinterest-artiges Staggered Grid** - Lückenfreies Layout mit dynamischen Vorschauzeilen
- ✅ **Layout-Umschalter** - Zwischen Listen- und Grid-Ansicht wechseln
- ✅ **Adaptive Spalten** - 2-3 Spalten basierend auf Bildschirmgröße

### 📡 Sync-Verbesserungen

- ✅ **WiFi-Only Sync Toggle** - Nur über WiFi synchronisieren
- ✅ **VPN-Unterstützung** - Sync funktioniert korrekt über VPN-Tunnels
- ✅ **Self-Signed SSL** - Dokumentation und Unterstützung für selbstsignierte Zertifikate
- ✅ **Server-Wechsel-Erkennung** - Alle Notizen auf PENDING zurückgesetzt bei URL-Änderung

---

## v1.7.1 - Android 9 Fix & VPN ✅

> **Status:** Released 🎉 (Februar 2026)

- ✅ **Android 9 Crash Fix** - `getForegroundInfo()` für WorkManager auf API 28 implementiert
- ✅ **VPN-Kompatibilität** - WiFi Socket-Binding erkennt Wireguard VPN-Interfaces
- ✅ **SafeSardineWrapper** - Saubere HTTP-Verbindungs-Bereinigung

---

## v1.7.2 - Timestamp & Löschungs-Fixes ✅

> **Status:** Released 🎉 (Februar 2026)

- ✅ **Server-mtime als Wahrheitsquelle** - Behebt Timestamp-Probleme mit externen Editoren
- ✅ **Deletion Tracker Mutex** - Thread-sichere Batch-Löschungen
- ✅ **ISO8601 Timezone-Parsing** - Multi-Format-Unterstützung
- ✅ **E-Tag Batch-Caching** - Performance-Verbesserung
- ✅ **Memory Leak Prävention** - SafeSardineWrapper mit Closeable

---

## v1.8.0 - Widgets, Sortierung & Erweiterter Sync ✅

> **Status:** Released 🎉 (Februar 2026)

### 📌 Homescreen-Widgets

- ✅ **Volles Jetpack Glance Framework** - 5 responsive Größenklassen
- ✅ **Interaktive Checklisten** - Checkboxen die zum Server synchronisieren
- ✅ **Material You Farben** - Dynamische Farben mit einstellbarer Opazität
- ✅ **Sperr-Umschalter** - Versehentliche Bearbeitungen verhindern
- ✅ **Konfigurations-Activity** - Notiz-Auswahl und Einstellungen

### 📊 Sortierung

- ✅ **Notiz-Sortierung** - Nach Titel, Änderungsdatum, Erstelldatum, Typ
- ✅ **Checklisten-Sortierung** - Manuell, alphabetisch, offene zuerst, erledigte zuletzt
- ✅ **Visuelle Trenner** - Zwischen offenen/erledigten Gruppen
- ✅ **Drag über Grenzen** - Auto-Toggle beim Überqueren des Trenners

### 🔄 Sync-Verbesserungen

- ✅ **Parallele Downloads** - Bis zu 5 gleichzeitig (konfigurierbar)
- ✅ **Server-Löschungs-Erkennung** - Erkennt auf anderen Clients gelöschte Notizen
- ✅ **Live Sync-Fortschritt** - Phasen-Anzeige mit Zählern
- ✅ **Sync-Status Legende** - Hilfe-Dialog für alle Sync-Icons

### ✨ UX

- ✅ **Post-Update Changelog** - Zeigt lokalisierten Changelog nach Update
- ✅ **Grid als Standard** - Neue Installationen starten im Grid-Modus
- ✅ **Toast → Banner Migration** - Einheitliches Benachrichtigungssystem

---

## v1.8.1 - Bugfix & Polish ✅

> **Status:** Released 🎉 (Februar 2026)

- ✅ **Checklisten-Sortierung Persistenz** - Sortier-Option korrekt wiederhergestellt
- ✅ **Widget Scroll Fix** - Scroll funktioniert auf Standard 3×2 Widget-Größe
- ✅ **Widget Checklisten-Sortierung** - Widgets übernehmen gespeicherte Sortier-Option
- ✅ **Drag Cross-Boundary** - Drag & Drop über Checked/Unchecked-Trenner
- ✅ **Sync Rate-Limiting** - Globaler 30s Cooldown zwischen Auto-Syncs
- ✅ **Detekt: 0 Issues** - Alle 12 Findings behoben

---

## v2.0.0 - Legacy Cleanup

> **Status:** Geplant 📝

### 🗑️ Legacy Code Entfernung

- **SettingsActivity entfernen** - Ersetzt durch ComposeSettingsActivity
- **MainActivity entfernen** - Ersetzt durch ComposeMainActivity
- **LocalBroadcastManager → SharedFlow** - Moderne Event-Architektur
- **ProgressDialog → Material Dialog** - Volle Material 3 Konformität
- **AbstractSavedStateViewModelFactory → viewModelFactory** - Moderne ViewModel-Erstellung

---

## 📋 Backlog

> Features für zukünftige Überlegungen

### 🔐 Sicherheits-Verbesserungen

- **Passwortgeschützte lokale Backups** - Backup-ZIP mit Passwort verschlüsseln
- **Biometrische Entsperrung** - Fingerabdruck/Gesichtserkennung für App

### 🎨 UI Features

- **Kategorien/Tags** - Notizen organisieren
- **Suche** - Volltextsuche in Notizen

### 🌍 Community

- **Zusätzliche Sprachen** - Community-Übersetzungen (FR, ES, IT, ...)

---

## 💡 Feedback & Wünsche

Hast du eine Idee für ein neues Feature?

- **[Feature Request erstellen](https://github.com/inventory69/simple-notes-sync/issues/new?template=feature_request.yml)**
- **[Bestehende Wünsche ansehen](https://github.com/inventory69/simple-notes-sync/issues?q=is%3Aissue+label%3Aenhancement)**

---

**Hinweis:** Diese Roadmap zeigt unsere aktuellen Pläne. Prioritäten können sich basierend auf Community-Feedback ändern.

[← Zurück zur Dokumentation](DOCS.md)
