package dev.dettmer.simplenotes.ui.theme

import androidx.compose.ui.unit.dp

/**
 * Zentrale UI-Dimensionen für konsistentes Design
 */
object Dimensions {
    // Padding & Spacing
    val SpacingSmall = 4.dp
    val SpacingMedium = 8.dp
    val SpacingLarge = 16.dp
    val SpacingXLarge = 24.dp
    
    // Icon Sizes
    val IconSizeSmall = 16.dp
    val IconSizeMedium = 24.dp
    val IconSizeLarge = 32.dp
    
    // Minimum Touch Target (Material Design: 48dp)
    val MinTouchTarget = 48.dp
    
    // Checklist
    val ChecklistItemMinHeight = 48.dp
    
    // Status Bar Heights
    val StatusBarHeightDefault = 56.dp
}
