# Marian NMT code documentation and library API

This directory contains code documentation and library API for developers of Marian NMT.

The documentation is generated using
[Sphinx](https://www.sphinx-doc.org/en/master/usage/quickstart.html) +
[Breathe](https://breathe.readthedocs.io/en/latest/directives.html) +
[Doxygen](http://www.doxygen.nl/manual/docblocks.html) +
[Exhale](https://exhale.readthedocs.io/en/latest/usage.html).
The documentation source code is written in `.rst` or `.md` files with special directives that allow
to reference to C++ source code and documentation. The source documents are then build into static
HTML pages.


## Installation

On Ubuntu 20.04, install the following packages:

    sudo apt-get install python3 python3-pip python3-setuptools doxygen

Then set up a Python environment and install modules:

    pip3 install virtualenv
    virtualenv venv -p python3
    source venv/bin/activate
    pip install -r requirements.txt

Documentation building should also work on Windows, but it has not been tested.


## Generation

The documentation can be generated by running:

    make html

The website will be generated into `build/html` and accessible by opening _index.html_ in your
browser.

Directories:

- `build` - automatically output directory for HTML documentation
- `doxygen` - automatically generated Doxygen XML files
- `api` - automatic library API generated with Exhale
- `.rst` and `.md` files in this directory and its subdirectories are documentation source files
- `_static` - custom CSS and JavaScript files


## Writing documentation

To be documented...
