/*
 * Copyright (C) 2024 David V
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <https://www.gnu.org/licenses/>.
 */

// This file was generated by `generated.py`. Do not edit.

package dev.davidv.translator

object Constants {
  const val DICT_VERSION = 1
  const val DEFAULT_TRANSLATION_MODELS_BASE_URL =
    "https://media.githubusercontent.com/media/mozilla/firefox-translations-models/a06d4724eb95d7452f9251cf2cc4ca2706636d74/models"
  const val DEFAULT_TESSERACT_MODELS_BASE_URL = "https://raw.githubusercontent.com/tesseract-ocr/tessdata_fast/refs/heads/main"
  const val DEFAULT_DICTIONARY_BASE_URL = "https://translator.davidv.dev/dictionaries"
}

enum class ModelType(private val pathName: String) {
  BASE("base"),
  BASE_MEMORY("base-memory"),
  TINY("tiny"),
  ;

  override fun toString(): String = pathName
}

enum class Language(val code: String, val tessName: String, val displayName: String, val script: String, val sizeBytes: Int, val tessdataSizeBytes: Int) {
  ALBANIAN("sq", "sqi", "Albanian", "Latin", 32421521, 1874705),
  ARABIC("ar", "ara", "Arabic", "Arabic", 52249041, 1432056),
  AZERBAIJANI("az", "aze", "Azerbaijani", "Latin", 34314579, 3524799),
  BENGALI("bn", "ben", "Bengali", "Bengali", 31090144, 855841),
  BULGARIAN("bg", "bul", "Bulgarian", "Cyrillic", 43393000, 1675212),
  CATALAN("ca", "cat", "Catalan", "Latin", 52271256, 1146012),
  CHINESE("zh", "chi_sim", "Chinese", "Han", 78503531, 2469156),
  CROATIAN("hr", "hrv", "Croatian", "Latin", 34072743, 4103348),
  CZECH("cs", "ces", "Czech", "Latin", 63076435, 3795684),
  DANISH("da", "dan", "Danish", "Latin", 32381617, 2580059),
  DUTCH("nl", "nld", "Dutch", "Latin", 47671886, 6050296),
  ENGLISH("en", "eng", "English", "Latin", 4113088, 4113088),
  ESTONIAN("et", "est", "Estonian", "Latin", 44275522, 4458101),
  FINNISH("fi", "fin", "Finnish", "Latin", 48153267, 7865732),
  FRENCH("fr", "fra", "French", "Latin", 44255710, 1130365),
  GERMAN("de", "deu", "German", "Latin", 50237680, 1525436),
  GREEK("el", "ell", "Greek", "Greek", 30966420, 1419514),
  GUJARATI("gu", "guj", "Gujarati", "Gujarati", 31421848, 1418394),
  HEBREW("he", "heb", "Hebrew", "Hebrew", 31564867, 961404),
  HINDI("hi", "hin", "Hindi", "Devanagari", 31480886, 1122751),
  HUNGARIAN("hu", "hun", "Hungarian", "Latin", 47560320, 5296273),
  ICELANDIC("is", "isl", "Icelandic", "Latin", 52912843, 2278973),
  INDONESIAN("id", "ind", "Indonesian", "Latin", 30949027, 1122661),
  ITALIAN("it", "ita", "Italian", "Latin", 45061556, 2701314),
  JAPANESE("ja", "jpn", "Japanese", "Japanese", 76844178, 2471260),
  KANNADA("kn", "kan", "Kannada", "Kannada", 34140291, 3608331),
  KOREAN("ko", "kor", "Korean", "Hangul", 76943353, 1677415),
  LATVIAN("lv", "lav", "Latvian", "Latin", 43806510, 2717247),
  LITHUANIAN("lt", "lit", "Lithuanian", "Latin", 43477739, 3154896),
  MALAY("ms", "msa", "Malay", "Latin", 32319298, 1747801),
  MALAYALAM("ml", "mal", "Malayalam", "Malayalam", 35119747, 5275996),
  PERSIAN("fa", "fas", "Persian", "Arabic", 31061402, 431500),
  POLISH("pl", "pol", "Polish", "Latin", 36390308, 4765518),
  PORTUGUESE("pt", "por", "Portuguese", "Latin", 43444286, 1982756),
  ROMANIAN("ro", "ron", "Romanian", "Latin", 32105494, 2376323),
  RUSSIAN("ru", "rus", "Russian", "Cyrillic", 42643637, 3861738),
  SLOVAK("sk", "slk", "Slovak", "Latin", 45019909, 4427661),
  SLOVENIAN("sl", "slv", "Slovenian", "Latin", 54080964, 3003829),
  SPANISH("es", "spa", "Spanish", "Latin", 43273604, 2294433),
  SWEDISH("sv", "swe", "Swedish", "Latin", 34671873, 4167034),
  TAMIL("ta", "tam", "Tamil", "Tamil", 33195670, 3237963),
  TELUGU("te", "tel", "Telugu", "Telugu", 33103521, 2769654),
  TURKISH("tr", "tur", "Turkish", "Latin", 34894250, 4550554),
  UKRAINIAN("uk", "ukr", "Ukrainian", "Cyrillic", 43573734, 3825102),
  ;

  val tessFilename: String
    get() = "$tessName.traineddata"
}

data class LanguageFiles(
  val model: Pair<String, Int>,
  val srcVocab: Pair<String, Int>,
  val tgtVocab: Pair<String, Int>,
  val lex: Pair<String, Int>,
  val quality: ModelType,
) {
  fun allFiles(): List<String> = listOf(model.first, srcVocab.first, tgtVocab.first, lex.first).distinct()
}

val fromEnglishFiles =
  mapOf(
    Language.ARABIC to LanguageFiles(Pair("model.enar.intgemm.alphas.bin", 22857819), Pair("vocab.enar.spm", 418930), Pair("vocab.enar.spm", 418930), Pair("lex.50.50.enar.s2t.bin", 1639219), ModelType.BASE_MEMORY),
    Language.AZERBAIJANI to LanguageFiles(Pair("model.enaz.intgemm.alphas.bin", 13233108), Pair("vocab.enaz.spm", 418956), Pair("vocab.enaz.spm", 418956), Pair("lex.50.50.enaz.s2t.bin", 1711544), ModelType.TINY),
    Language.BULGARIAN to LanguageFiles(Pair("model.enbg.intgemm.alphas.bin", 13311038), Pair("vocab.enbg.spm", 435044), Pair("vocab.enbg.spm", 435044), Pair("lex.50.50.enbg.s2t.bin", 2950444), ModelType.TINY),
    Language.BENGALI to LanguageFiles(Pair("model.enbn.intgemm.alphas.bin", 12821521), Pair("vocab.enbn.spm", 437373), Pair("vocab.enbn.spm", 437373), Pair("lex.50.50.enbn.s2t.bin", 1607697), ModelType.TINY),
    Language.CATALAN to LanguageFiles(Pair("model.enca.intgemm.alphas.bin", 23174479), Pair("vocab.enca.spm", 409866), Pair("vocab.enca.spm", 409866), Pair("lex.50.50.enca.s2t.bin", 2085904), ModelType.BASE_MEMORY),
    Language.CZECH to LanguageFiles(Pair("model.encs.intgemm.alphas.bin", 31264424), Pair("vocab.encs.spm", 366392), Pair("vocab.encs.spm", 366392), Pair("lex.50.50.encs.s2t.bin", 1913246), ModelType.BASE),
    Language.DANISH to LanguageFiles(Pair("model.enda.intgemm.alphas.bin", 12723889), Pair("vocab.enda.spm", 398818), Pair("vocab.enda.spm", 398818), Pair("lex.50.50.enda.s2t.bin", 1582768), ModelType.TINY),
    Language.GERMAN to LanguageFiles(Pair("model.ende.intgemm.alphas.bin", 12768493), Pair("vocab.ende.spm", 410738), Pair("vocab.ende.spm", 410738), Pair("lex.50.50.ende.s2t.bin", 2113181), ModelType.TINY),
    Language.GREEK to LanguageFiles(Pair("model.enel.intgemm.alphas.bin", 12808027), Pair("vocab.enel.spm", 419275), Pair("vocab.enel.spm", 419275), Pair("lex.50.50.enel.s2t.bin", 1352643), ModelType.TINY),
    Language.SPANISH to LanguageFiles(Pair("model.enes.intgemm.alphas.bin", 12602853), Pair("vocab.enes.spm", 414566), Pair("vocab.enes.spm", 414566), Pair("lex.50.50.enes.s2t.bin", 1720700), ModelType.TINY),
    Language.ESTONIAN to LanguageFiles(Pair("model.enet.intgemm.alphas.bin", 12543318), Pair("vocab.enet.spm", 416995), Pair("vocab.enet.spm", 416995), Pair("lex.50.50.enet.s2t.bin", 1336443), ModelType.TINY),
    Language.PERSIAN to LanguageFiles(Pair("model.enfa.intgemm.alphas.bin", 13058508), Pair("vocab.enfa.spm", 416223), Pair("vocab.enfa.spm", 416223), Pair("lex.50.50.enfa.s2t.bin", 1728367), ModelType.TINY),
    Language.FINNISH to LanguageFiles(Pair("model.enfi.intgemm.alphas.bin", 12281951), Pair("vocab.enfi.spm", 398897), Pair("vocab.enfi.spm", 398897), Pair("lex.50.50.enfi.s2t.bin", 1676644), ModelType.TINY),
    Language.FRENCH to LanguageFiles(Pair("model.enfr.intgemm.alphas.bin", 12293754), Pair("vocab.enfr.spm", 419721), Pair("vocab.enfr.spm", 419721), Pair("lex.50.50.enfr.s2t.bin", 4177155), ModelType.TINY),
    Language.GUJARATI to LanguageFiles(Pair("model.engu.intgemm.alphas.bin", 12657911), Pair("vocab.engu.spm", 434881), Pair("vocab.engu.spm", 434881), Pair("lex.50.50.engu.s2t.bin", 1529098), ModelType.TINY),
    Language.HEBREW to LanguageFiles(Pair("model.enhe.intgemm.alphas.bin", 12979964), Pair("vocab.enhe.spm", 411686), Pair("vocab.enhe.spm", 411686), Pair("lex.50.50.enhe.s2t.bin", 1567190), ModelType.TINY),
    Language.HINDI to LanguageFiles(Pair("model.enhi.intgemm.alphas.bin", 12736263), Pair("vocab.enhi.spm", 430026), Pair("vocab.enhi.spm", 430026), Pair("lex.50.50.enhi.s2t.bin", 1690062), ModelType.TINY),
    Language.CROATIAN to LanguageFiles(Pair("model.enhr.intgemm.alphas.bin", 12790833), Pair("vocab.enhr.spm", 395216), Pair("vocab.enhr.spm", 395216), Pair("lex.50.50.enhr.s2t.bin", 1450314), ModelType.TINY),
    Language.HUNGARIAN to LanguageFiles(Pair("model.enhu.intgemm.alphas.bin", 23710206), Pair("vocab.enhu.spm", 405720), Pair("vocab.enhu.spm", 405720), Pair("lex.50.50.enhu.s2t.bin", 1768398), ModelType.BASE_MEMORY),
    Language.INDONESIAN to LanguageFiles(Pair("model.enid.intgemm.alphas.bin", 12503257), Pair("vocab.enid.spm", 379806), Pair("vocab.enid.spm", 379806), Pair("lex.50.50.enid.s2t.bin", 1734565), ModelType.TINY),
    Language.ICELANDIC to LanguageFiles(Pair("model.enis.intgemm.alphas.bin", 22588003), Pair("vocab.enis.spm", 413543), Pair("vocab.enis.spm", 413543), Pair("lex.50.50.enis.s2t.bin", 1977789), ModelType.BASE_MEMORY),
    Language.ITALIAN to LanguageFiles(Pair("model.enit.intgemm.alphas.bin", 13267138), Pair("vocab.enit.spm", 408834), Pair("vocab.enit.spm", 408834), Pair("lex.50.50.enit.s2t.bin", 2441969), ModelType.TINY),
    Language.JAPANESE to LanguageFiles(Pair("model.enja.intgemm.alphas.bin", 33052218), Pair("srcvocab.enja.spm", 404352), Pair("trgvocab.enja.spm", 431278), Pair("lex.50.50.enja.s2t.bin", 2341409), ModelType.BASE_MEMORY),
    Language.KANNADA to LanguageFiles(Pair("model.enkn.intgemm.alphas.bin", 13009213), Pair("vocab.enkn.spm", 450046), Pair("vocab.enkn.spm", 450046), Pair("lex.50.50.enkn.s2t.bin", 1416160), ModelType.TINY),
    Language.KOREAN to LanguageFiles(Pair("model.enko.intgemm.alphas.bin", 33738001), Pair("srcvocab.enko.spm", 402480), Pair("trgvocab.enko.spm", 412614), Pair("lex.50.50.enko.s2t.bin", 3471311), ModelType.BASE_MEMORY),
    Language.LITHUANIAN to LanguageFiles(Pair("model.enlt.intgemm.alphas.bin", 22865642), Pair("vocab.enlt.spm", 403356), Pair("vocab.enlt.spm", 403356), Pair("lex.50.50.enlt.s2t.bin", 1769752), ModelType.BASE_MEMORY),
    Language.LATVIAN to LanguageFiles(Pair("model.enlv.intgemm.alphas.bin", 23727668), Pair("vocab.enlv.spm", 407540), Pair("vocab.enlv.spm", 407540), Pair("lex.50.50.enlv.s2t.bin", 1725879), ModelType.BASE_MEMORY),
    Language.MALAYALAM to LanguageFiles(Pair("model.enml.intgemm.alphas.bin", 12570038), Pair("vocab.enml.spm", 454768), Pair("vocab.enml.spm", 454768), Pair("lex.50.50.enml.s2t.bin", 1275347), ModelType.TINY),
    Language.MALAY to LanguageFiles(Pair("model.enms.intgemm.alphas.bin", 13039668), Pair("vocab.enms.spm", 404033), Pair("vocab.enms.spm", 404033), Pair("lex.50.50.enms.s2t.bin", 2044118), ModelType.TINY),
    Language.DUTCH to LanguageFiles(Pair("model.ennl.intgemm.alphas.bin", 13081379), Pair("vocab.ennl.spm", 411799), Pair("vocab.ennl.spm", 411799), Pair("lex.50.50.ennl.s2t.bin", 2454349), ModelType.TINY),
    Language.POLISH to LanguageFiles(Pair("model.enpl.intgemm.alphas.bin", 12797631), Pair("vocab.enpl.spm", 415308), Pair("vocab.enpl.spm", 415308), Pair("lex.50.50.enpl.s2t.bin", 1945174), ModelType.TINY),
    Language.PORTUGUESE to LanguageFiles(Pair("model.enpt.intgemm.alphas.bin", 13099731), Pair("vocab.enpt.spm", 410584), Pair("vocab.enpt.spm", 410584), Pair("lex.50.50.enpt.s2t.bin", 2354273), ModelType.TINY),
    Language.ROMANIAN to LanguageFiles(Pair("model.enro.intgemm.alphas.bin", 12207487), Pair("vocab.enro.spm", 397137), Pair("vocab.enro.spm", 397137), Pair("lex.50.50.enro.s2t.bin", 1846074), ModelType.TINY),
    Language.RUSSIAN to LanguageFiles(Pair("model.enru.intgemm.alphas.bin", 21988864), Pair("vocab.enru.spm", 419005), Pair("vocab.enru.spm", 419005), Pair("lex.50.50.enru.s2t.bin", 1378563), ModelType.BASE_MEMORY),
    Language.SLOVAK to LanguageFiles(Pair("model.ensk.intgemm.alphas.bin", 22902983), Pair("vocab.ensk.spm", 405652), Pair("vocab.ensk.spm", 405652), Pair("lex.50.50.ensk.s2t.bin", 1708788), ModelType.BASE_MEMORY),
    Language.SLOVENIAN to LanguageFiles(Pair("model.ensl.intgemm.alphas.bin", 22669559), Pair("vocab.ensl.spm", 398763), Pair("vocab.ensl.spm", 398763), Pair("lex.50.50.ensl.s2t.bin", 1741316), ModelType.BASE_MEMORY),
    Language.ALBANIAN to LanguageFiles(Pair("model.ensq.intgemm.alphas.bin", 13366206), Pair("vocab.ensq.spm", 410650), Pair("vocab.ensq.spm", 410650), Pair("lex.50.50.ensq.s2t.bin", 1599959), ModelType.TINY),
    Language.SWEDISH to LanguageFiles(Pair("model.ensv.intgemm.alphas.bin", 12775086), Pair("vocab.ensv.spm", 398384), Pair("vocab.ensv.spm", 398384), Pair("lex.50.50.ensv.s2t.bin", 1921270), ModelType.TINY),
    Language.TAMIL to LanguageFiles(Pair("model.enta.intgemm.alphas.bin", 12645399), Pair("vocab.enta.spm", 446752), Pair("vocab.enta.spm", 446752), Pair("lex.50.50.enta.s2t.bin", 1453949), ModelType.TINY),
    Language.TELUGU to LanguageFiles(Pair("model.ente.intgemm.alphas.bin", 12590862), Pair("vocab.ente.spm", 448838), Pair("vocab.ente.spm", 448838), Pair("lex.50.50.ente.s2t.bin", 1434105), ModelType.TINY),
    Language.TURKISH to LanguageFiles(Pair("model.entr.intgemm.alphas.bin", 13159314), Pair("vocab.entr.spm", 395473), Pair("vocab.entr.spm", 395473), Pair("lex.50.50.entr.s2t.bin", 1546258), ModelType.TINY),
    Language.UKRAINIAN to LanguageFiles(Pair("model.enuk.intgemm.alphas.bin", 22864374), Pair("vocab.enuk.spm", 436850), Pair("vocab.enuk.spm", 436850), Pair("lex.50.50.enuk.s2t.bin", 1564122), ModelType.BASE_MEMORY),
    Language.CHINESE to LanguageFiles(Pair("model.enzh.intgemm.alphas.bin", 33375922), Pair("srcvocab.enzh.spm", 407784), Pair("trgvocab.enzh.spm", 425748), Pair("lex.50.50.enzh.s2t.bin", 3537095), ModelType.BASE_MEMORY),
  )

val toEnglishFiles =
  mapOf(
    Language.ARABIC to LanguageFiles(Pair("model.aren.intgemm.alphas.bin", 23224456), Pair("vocab.aren.spm", 416700), Pair("vocab.aren.spm", 416700), Pair("lex.50.50.aren.s2t.bin", 2259861), ModelType.BASE_MEMORY),
    Language.AZERBAIJANI to LanguageFiles(Pair("model.azen.intgemm.alphas.bin", 12740106), Pair("vocab.azen.spm", 418965), Pair("vocab.azen.spm", 418965), Pair("lex.50.50.azen.s2t.bin", 2267101), ModelType.TINY),
    Language.BULGARIAN to LanguageFiles(Pair("model.bgen.intgemm.alphas.bin", 22399269), Pair("vocab.bgen.spm", 434940), Pair("vocab.bgen.spm", 434940), Pair("lex.50.50.bgen.s2t.bin", 2187053), ModelType.BASE_MEMORY),
    Language.BENGALI to LanguageFiles(Pair("model.bnen.intgemm.alphas.bin", 12665857), Pair("vocab.bnen.spm", 437571), Pair("vocab.bnen.spm", 437571), Pair("lex.50.50.bnen.s2t.bin", 2264284), ModelType.TINY),
    Language.CATALAN to LanguageFiles(Pair("model.caen.intgemm.alphas.bin", 22787743), Pair("vocab.caen.spm", 409662), Pair("vocab.caen.spm", 409662), Pair("lex.50.50.caen.s2t.bin", 2257590), ModelType.BASE_MEMORY),
    Language.CZECH to LanguageFiles(Pair("model.csen.intgemm.alphas.bin", 22830296), Pair("vocab.csen.spm", 412691), Pair("vocab.csen.spm", 412691), Pair("lex.50.50.csen.s2t.bin", 2493702), ModelType.BASE_MEMORY),
    Language.DANISH to LanguageFiles(Pair("model.daen.intgemm.alphas.bin", 12525769), Pair("vocab.daen.spm", 399344), Pair("vocab.daen.spm", 399344), Pair("lex.50.50.daen.s2t.bin", 2170970), ModelType.TINY),
    Language.GERMAN to LanguageFiles(Pair("model.deen.intgemm.alphas.bin", 30375030), Pair("vocab.deen.spm", 413926), Pair("vocab.deen.spm", 413926), Pair("lex.50.50.deen.s2t.bin", 2630876), ModelType.BASE_MEMORY),
    Language.GREEK to LanguageFiles(Pair("model.elen.intgemm.alphas.bin", 12696541), Pair("vocab.elen.spm", 419174), Pair("vocab.elen.spm", 419174), Pair("lex.50.50.elen.s2t.bin", 1851246), ModelType.TINY),
    Language.SPANISH to LanguageFiles(Pair("model.esen.intgemm.alphas.bin", 23288494), Pair("vocab.esen.spm", 409312), Pair("vocab.esen.spm", 409312), Pair("lex.50.50.esen.s2t.bin", 2543246), ModelType.BASE_MEMORY),
    Language.ESTONIAN to LanguageFiles(Pair("model.eten.intgemm.alphas.bin", 22785077), Pair("vocab.eten.spm", 414262), Pair("vocab.eten.spm", 414262), Pair("lex.50.50.eten.s2t.bin", 2321326), ModelType.BASE_MEMORY),
    Language.PERSIAN to LanguageFiles(Pair("model.faen.intgemm.alphas.bin", 13071390), Pair("vocab.faen.spm", 416123), Pair("vocab.faen.spm", 416123), Pair("lex.50.50.faen.s2t.bin", 1939291), ModelType.TINY),
    Language.FINNISH to LanguageFiles(Pair("model.fien.intgemm.alphas.bin", 22935246), Pair("vocab.fien.spm", 414280), Pair("vocab.fien.spm", 414280), Pair("lex.50.50.fien.s2t.bin", 2580517), ModelType.BASE_MEMORY),
    Language.FRENCH to LanguageFiles(Pair("model.fren.intgemm.alphas.bin", 23175075), Pair("vocab.fren.spm", 409706), Pair("vocab.fren.spm", 409706), Pair("lex.50.50.fren.s2t.bin", 2649934), ModelType.BASE_MEMORY),
    Language.GUJARATI to LanguageFiles(Pair("model.guen.intgemm.alphas.bin", 12917932), Pair("vocab.guen.spm", 435011), Pair("vocab.guen.spm", 435011), Pair("lex.50.50.guen.s2t.bin", 2028621), ModelType.TINY),
    Language.HEBREW to LanguageFiles(Pair("model.heen.intgemm.alphas.bin", 12999905), Pair("vocab.heen.spm", 411769), Pair("vocab.heen.spm", 411769), Pair("lex.50.50.heen.s2t.bin", 2232949), ModelType.TINY),
    Language.HINDI to LanguageFiles(Pair("model.hien.intgemm.alphas.bin", 12752013), Pair("vocab.hien.spm", 430096), Pair("vocab.hien.spm", 430096), Pair("lex.50.50.hien.s2t.bin", 2319675), ModelType.TINY),
    Language.CROATIAN to LanguageFiles(Pair("model.hren.intgemm.alphas.bin", 13050395), Pair("vocab.hren.spm", 394548), Pair("vocab.hren.spm", 394548), Pair("lex.50.50.hren.s2t.bin", 1888089), ModelType.TINY),
    Language.HUNGARIAN to LanguageFiles(Pair("model.huen.intgemm.alphas.bin", 13181613), Pair("vocab.huen.spm", 419908), Pair("vocab.huen.spm", 419908), Pair("lex.50.50.huen.s2t.bin", 2778202), ModelType.TINY),
    Language.INDONESIAN to LanguageFiles(Pair("model.iden.intgemm.alphas.bin", 13010657), Pair("vocab.iden.spm", 379859), Pair("vocab.iden.spm", 379859), Pair("lex.50.50.iden.s2t.bin", 1818222), ModelType.TINY),
    Language.ICELANDIC to LanguageFiles(Pair("model.isen.intgemm.alphas.bin", 23229378), Pair("vocab.isen.spm", 412304), Pair("vocab.isen.spm", 412304), Pair("lex.50.50.isen.s2t.bin", 2012853), ModelType.BASE_MEMORY),
    Language.ITALIAN to LanguageFiles(Pair("model.iten.intgemm.alphas.bin", 23301774), Pair("vocab.iten.spm", 407598), Pair("vocab.iten.spm", 407598), Pair("lex.50.50.iten.s2t.bin", 2532929), ModelType.BASE_MEMORY),
    Language.JAPANESE to LanguageFiles(Pair("model.jaen.intgemm.alphas.bin", 32577435), Pair("vocab.jaen.spm", 746616), Pair("vocab.jaen.spm", 746616), Pair("lex.50.50.jaen.s2t.bin", 4819610), ModelType.BASE_MEMORY),
    Language.KANNADA to LanguageFiles(Pair("model.knen.intgemm.alphas.bin", 13077357), Pair("vocab.knen.spm", 450324), Pair("vocab.knen.spm", 450324), Pair("lex.50.50.knen.s2t.bin", 2128860), ModelType.TINY),
    Language.KOREAN to LanguageFiles(Pair("model.koen.intgemm.alphas.bin", 32152814), Pair("vocab.koen.spm", 706864), Pair("vocab.koen.spm", 706864), Pair("lex.50.50.koen.s2t.bin", 4381854), ModelType.BASE_MEMORY),
    Language.LITHUANIAN to LanguageFiles(Pair("model.lten.intgemm.alphas.bin", 12571257), Pair("vocab.lten.spm", 403960), Pair("vocab.lten.spm", 403960), Pair("lex.50.50.lten.s2t.bin", 2308876), ModelType.TINY),
    Language.LATVIAN to LanguageFiles(Pair("model.lven.intgemm.alphas.bin", 12689153), Pair("vocab.lven.spm", 407237), Pair("vocab.lven.spm", 407237), Pair("lex.50.50.lven.s2t.bin", 2131786), ModelType.TINY),
    Language.MALAYALAM to LanguageFiles(Pair("model.mlen.intgemm.alphas.bin", 12792306), Pair("vocab.mlen.spm", 454911), Pair("vocab.mlen.spm", 454911), Pair("lex.50.50.mlen.s2t.bin", 2296381), ModelType.TINY),
    Language.MALAY to LanguageFiles(Pair("model.msen.intgemm.alphas.bin", 12538542), Pair("vocab.msen.spm", 403877), Pair("vocab.msen.spm", 403877), Pair("lex.50.50.msen.s2t.bin", 2141259), ModelType.TINY),
    Language.DUTCH to LanguageFiles(Pair("model.nlen.intgemm.alphas.bin", 22647743), Pair("vocab.nlen.spm", 410222), Pair("vocab.nlen.spm", 410222), Pair("lex.50.50.nlen.s2t.bin", 2616098), ModelType.BASE_MEMORY),
    Language.POLISH to LanguageFiles(Pair("model.plen.intgemm.alphas.bin", 13421783), Pair("vocab.plen.spm", 415308), Pair("vocab.plen.spm", 415308), Pair("lex.50.50.plen.s2t.bin", 2629586), ModelType.TINY),
    Language.PORTUGUESE to LanguageFiles(Pair("model.pten.intgemm.alphas.bin", 22700409), Pair("vocab.pten.spm", 408686), Pair("vocab.pten.spm", 408686), Pair("lex.50.50.pten.s2t.bin", 2487847), ModelType.BASE_MEMORY),
    Language.ROMANIAN to LanguageFiles(Pair("model.roen.intgemm.alphas.bin", 12722200), Pair("vocab.roen.spm", 396717), Pair("vocab.roen.spm", 396717), Pair("lex.50.50.roen.s2t.bin", 2159556), ModelType.TINY),
    Language.RUSSIAN to LanguageFiles(Pair("model.ruen.intgemm.alphas.bin", 12613599), Pair("vocab.ruen.spm", 419860), Pair("vocab.ruen.spm", 419860), Pair("lex.50.50.ruen.s2t.bin", 1962008), ModelType.TINY),
    Language.SLOVAK to LanguageFiles(Pair("model.sken.intgemm.alphas.bin", 12821519), Pair("vocab.sken.spm", 405122), Pair("vocab.sken.spm", 405122), Pair("lex.50.50.sken.s2t.bin", 2348184), ModelType.TINY),
    Language.SLOVENIAN to LanguageFiles(Pair("model.slen.intgemm.alphas.bin", 23730414), Pair("vocab.slen.spm", 398535), Pair("vocab.slen.spm", 398535), Pair("lex.50.50.slen.s2t.bin", 2138548), ModelType.BASE_MEMORY),
    Language.ALBANIAN to LanguageFiles(Pair("model.sqen.intgemm.alphas.bin", 12593638), Pair("vocab.sqen.spm", 410423), Pair("vocab.sqen.spm", 410423), Pair("lex.50.50.sqen.s2t.bin", 2165940), ModelType.TINY),
    Language.SWEDISH to LanguageFiles(Pair("model.sven.intgemm.alphas.bin", 12847259), Pair("vocab.sven.spm", 397625), Pair("vocab.sven.spm", 397625), Pair("lex.50.50.sven.s2t.bin", 2165215), ModelType.TINY),
    Language.TAMIL to LanguageFiles(Pair("model.taen.intgemm.alphas.bin", 12511533), Pair("vocab.taen.spm", 446919), Pair("vocab.taen.spm", 446919), Pair("lex.50.50.taen.s2t.bin", 2453155), ModelType.TINY),
    Language.TELUGU to LanguageFiles(Pair("model.teen.intgemm.alphas.bin", 13202063), Pair("vocab.teen.spm", 448555), Pair("vocab.teen.spm", 448555), Pair("lex.50.50.teen.s2t.bin", 2209444), ModelType.TINY),
    Language.TURKISH to LanguageFiles(Pair("model.tren.intgemm.alphas.bin", 12362908), Pair("vocab.tren.spm", 409060), Pair("vocab.tren.spm", 409060), Pair("lex.50.50.tren.s2t.bin", 2470683), ModelType.TINY),
    Language.UKRAINIAN to LanguageFiles(Pair("model.uken.intgemm.alphas.bin", 12677432), Pair("vocab.uken.spm", 415266), Pair("vocab.uken.spm", 415266), Pair("lex.50.50.uken.s2t.bin", 1790588), ModelType.TINY),
    Language.CHINESE to LanguageFiles(Pair("model.zhen.intgemm.alphas.bin", 32726806), Pair("vocab.zhen.spm", 738862), Pair("vocab.zhen.spm", 738862), Pair("lex.50.50.zhen.s2t.bin", 4822158), ModelType.BASE_MEMORY),
  )

val extraFiles =
  mapOf(
    Language.JAPANESE to listOf("mucab.bin"),
  )
