#!/bin/bash

#####################################################################
# SUMMARY: Only a single tab-separated file is allowed with --tsv
# TAGS: multi-source sentencepiece tsv scorer
#####################################################################

# Exit on error
set -e

# Run Marian
$MRT_MARIAN/marian-scorer -c $MRT_MODELS/rnn-spm/score.yml --tsv --tsv-fields 2 -t score.tsv score.tsv > msg_multiple_tsv.log 2>&1 || true

test -e msg_multiple_tsv.log
grep -qi "single file must be provided" msg_multiple_tsv.log

# Exit with success code
exit 0
[?25l[J[J[J[J[J[J[?12l[?25h[?1049h[?1h=[1;66r[?12;25h[?12l[?25h[27m[24m[0m[H[2J[?25l[66;1H"cat" [New File][2;1H[94m~                                                                                                                                                                                                                                    [3;1H~                                                                                                                                                                                                                                    [4;1H~                                                                                                                                                                                                                                    [5;1H~                                                                                                                                                                                                                                    [6;1H~                                                                                                                                                                                                                                    [7;1H~                                                                                                                                                                                                                                    [8;1H~                                                                                                                                                                                                                                    [9;1H~                                                                                                                                                                                                                                    [10;1H~                                                                                                                                                                                                                                    [11;1H~                                                                                                                                                                                                                                    [12;1H~                                                                                                                                                                                                                                    [13;1H~                                                                                                                                                                                                                                    [14;1H~                                                                                                                                                                                                                                    [15;1H~                                                                                                                                                                                                                                    [16;1H~                                                                                                                                                                                                                                    [17;1H~                                                                                                                                                                                                                                    [18;1H~                                                                                                                                                                                                                                    [19;1H~                                                                                                                                                                                                                                    [20;1H~                                                                                                                                                                                                                                    [21;1H~                                                                                                                                                                                                                                    [22;1H~                                                                                                                                                                                                                                    [23;1H~                                                                                                                                                                                                                                    [24;1H~                                                                                                                                                                                                                                    [25;1H~                                                                                                                                                                                                                                    [26;1H~                                                                                                                                                                                                                                    [27;1H~                                                                                                                                                                                                                                    [28;1H~                                                                                                                                                                                                                                    [29;1H~                                                                                                                                                                                                                                    [30;1H~                                                                                                                                                                                                                                    [31;1H~                                                                                                                                                                                                                                    [32;1H~                                                                                                                                                                                                                                    [33;1H~                                                                                                                                                                                                                                    [34;1H~                                                                                                                                                                                                                                    [35;1H~                                                                                                                                                                                                                                    [36;1H~                                                                                                                                                                                                                                    [37;1H~                                                                                                                                                                                                                                    [38;1H~                                                                                                                                                                                                                                    [39;1H~                                                                                                                                                                                                                                    [40;1H~                                                                                                                                                                                                                                    [41;1H~                                                                                                                                                                                                                                    [42;1H~                                                                                                                                                                                                                                    [43;1H~                                                                                                                                                                                                                                    [44;1H~                                                                                                                                                                                                                                    [45;1H~                                                                                                                                                                                                                                    [46;1H~                                                                                                                                                                                                                                    [47;1H~                                                                                                                                                                                                                                    [48;1H~                                                                                                                                                                                                                                    [49;1H~                                                                                                                                                                                                                                    [50;1H~                                                                                                                                                                                                                                    [51;1H~                                                                                                                                                                                                                                    [52;1H~                                                                                                                                                                                                                                    [53;1H~                                                                                                                                                                                                                                    [54;1H~                                                                                                                                                                                                                                    [55;1H~                                                                                                                                                                                                                                    [56;1H~                                                                                                                                                                                                                                    [57;1H~                                                                                                                                                                                                                                    [58;1H~                                                                                                                                                                                                                                    [59;1H~                                                                                                                                                                                                                                    [60;1H~                                                                                                                                                                                                                                    [61;1H~                                                                                                                                                                                                                                    [62;1H~                                                                                                                                                                                                                                    [63;1H~                                                                                                                                                                                                                                    [64;1H~                                                                                                                                                                                                                                    [65;1H~                                                                                                                                                                                                                                    [1;1H[?12l[?25h[?25l[0m[66;1HType  :quit<Enter>  to exit Vim[1;1H[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[?25l[?12l[?25h[66;1H
[?1l>[?1049l#!/bin/bash -x

#####################################################################
# SUMMARY: Train a model from TSV input and create a joint vocabulary
# TAGS: sentencepiece tsv train
#####################################################################

# Exit on error
set -e

# Remove old artifacts and create working directory
rm -rf train_vocab train_vocab.{log,out,diff}
mkdir -p train_vocab

test -s train.de  || cat $MRT_DATA/train.max50.de | sed 's/@@ //g' > train.de
test -s train.en  || cat $MRT_DATA/train.max50.en | sed 's/@@ //g' > train.en
paste train.{de,en} > train.tsv

# Run marian command
$MRT_MARIAN/marian \
    --no-shuffle --seed 1111 --dim-emb 32 --dim-rnn 64 --maxi-batch 1 --maxi-batch-sort none --optimizer sgd \
    -m train_vocab/model.npz --tsv --tsv-size 2 -t train.tsv -v train_vocab/vocab.spm train_vocab/vocab.spm --dim-vocabs 2000 2000 -T train_vocab \
    --after-batches 20 --disp-freq 2 \
    --log train_vocab.log

# Check if files exist
test -e train_vocab/model.npz
test -e train_vocab.log

# Compare the current output with the expected output
cat train_vocab.log | $MRT_TOOLS/extract-costs.sh > train_vocab.out
$MRT_TOOLS/diff-nums.py train_vocab.out train_vocab.expected -p 0.1 -o train_vocab.diff

# Exit with success code
exit 0
#!/bin/bash -x

#####################################################################
# SUMMARY: Train a model from TSV input and create a joint vocabulary
# TAGS: sentencepiece tsv train
#####################################################################

# Exit on error
set -e

# Remove old artifacts and create working directory
rm -rf train_vocab train_vocab.{log,out,diff}
mkdir -p train_vocab

test -s train.de  || cat $MRT_DATA/train.max50.de | sed 's/@@ //g' > train.de
test -s train.en  || cat $MRT_DATA/train.max50.en | sed 's/@@ //g' > train.en
paste train.{de,en} > train.tsv

# Run marian command
$MRT_MARIAN/marian \
    --no-shuffle --seed 1111 --dim-emb 32 --dim-rnn 64 --maxi-batch 1 --maxi-batch-sort none --optimizer sgd \
    -m train_vocab/model.npz --tsv --tsv-size 2 -t train.tsv -v train_vocab/vocab.spm train_vocab/vocab.spm --dim-vocabs 2000 2000 -T train_vocab \
    --after-batches 20 --disp-freq 2 \
    --log train_vocab.log

# Check if files exist
test -e train_vocab/model.npz
test -e train_vocab.log

# Compare the current output with the expected output
cat train_vocab.log | $MRT_TOOLS/extract-costs.sh > train_vocab.out
$MRT_TOOLS/diff-nums.py train_vocab.out train_vocab.expected -p 0.1 -o train_vocab.diff

# Exit with success code
exit 0
