## Operators Support Table

The following table shows [ai.onnx](https://github.com/onnx/onnx/blob/master/docs/Operators.md) operators from which onnx opset version are currently supported by onnxjs. For example, `4-6, 8+` means ONNX.js currently support opset version 4 to 6, 8 and above.

See [Compatibility](../README.md#Compatibility) for a list of the supported platforms.

_This file is automatically generated from the def files via [this script](/tools/gen-doc.ts). Do not modify directly._

|                                                     Operator                                                      |                                                                                                                  Cpu Backend                                                                                                                  |                                                                                                          Wasm Backend                                                                                                          |                                                                                                                 WebGl Backend                                                                                                                 |
| :---------------------------------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :----------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: | :-------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------: |
|                       [Abs](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Abs)                       |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Abs-6)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Abs-6)                                                                                     |
|                      [Acos](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Acos)                      |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Acos-7)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Acos-7)                                                                                    |
|                     [Acosh](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Acosh)                     |                                                                                   [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Acosh-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Add](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Add)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Add-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Add-7)                                                                             |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Add-7)                                                                                     |
|                       [And](https://github.com/onnx/onnx/blob/master/docs/Operators.md#And)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#And-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#And-7)                                                                             |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#And-7)                                                                                     |
|                    [ArgMax](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ArgMax)                    |                                            [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ArgMax-1), [11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ArgMax-11)                                            |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [ArgMin](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ArgMin)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Asin](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Asin)                      |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Asin-7)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Asin-7)                                                                                    |
|                     [Asinh](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Asinh)                     |                                                                                   [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Asinh-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Atan](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Atan)                      |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Atan-7)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Atan-7)                                                                                    |
|                     [Atanh](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Atanh)                     |                                                                                   [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Atanh-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|               [AveragePool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#AveragePool)               |                                       [7-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#AveragePool-7), [10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#AveragePool-10)                                        |                                [7-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#AveragePool-7), [10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#AveragePool-10)                                |                                       [7-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#AveragePool-7), [10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#AveragePool-10)                                        |
|        [BatchNormalization](https://github.com/onnx/onnx/blob/master/docs/Operators.md#BatchNormalization)        |                                 [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#BatchNormalization-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#BatchNormalization-9)                                 |                         [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#BatchNormalization-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#BatchNormalization-9)                          |                                 [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#BatchNormalization-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#BatchNormalization-9)                                 |
|                  [BitShift](https://github.com/onnx/onnx/blob/master/docs/Operators.md#BitShift)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Cast](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Cast)                      |                                               [6-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Cast-6), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Cast-9)                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Ceil](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Ceil)                      |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Ceil-6)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Ceil-6)                                                                                    |
|                      [Celu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Celu)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Clip](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Clip)                      |                                                                                   [6-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Clip-6)                                                                                   |                                                                           [6-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Clip-6)                                                                            |                                                                                   [6-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Clip-6)                                                                                   |
|                  [Compress](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Compress)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [Concat](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Concat)                    |                                           [4-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Concat-4), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Concat-11)                                            |                                                                                                                                                                                                                                |                                           [4-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Concat-4), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Concat-11)                                            |
|        [ConcatFromSequence](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ConcatFromSequence)        |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [Constant](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Constant)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|           [ConstantOfShape](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ConstantOfShape)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Conv](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Conv)                      |                                             [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Conv-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Conv-11)                                              |                                      [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Conv-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Conv-11)                                      |                                             [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Conv-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Conv-11)                                              |
|               [ConvInteger](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ConvInteger)               |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|             [ConvTranspose](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ConvTranspose)             |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Cos](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Cos)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Cos-7)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Cos-7)                                                                                     |
|                      [Cosh](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Cosh)                      |                                                                                    [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Cosh-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [CumSum](https://github.com/onnx/onnx/blob/master/docs/Operators.md#CumSum)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|              [DepthToSpace](https://github.com/onnx/onnx/blob/master/docs/Operators.md#DepthToSpace)              |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|          [DequantizeLinear](https://github.com/onnx/onnx/blob/master/docs/Operators.md#DequantizeLinear)          |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Det](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Det)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Div](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Div)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Div-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Div-7)                                                                             |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Div-7)                                                                                     |
|                   [Dropout](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Dropout)                   |   [7-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Dropout-7), [10-11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Dropout-10), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Dropout-12)   |                                                                                                                                                                                                                                |   [7-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Dropout-7), [10-11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Dropout-10), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Dropout-12)   |
|     [DynamicQuantizeLinear](https://github.com/onnx/onnx/blob/master/docs/Operators.md#DynamicQuantizeLinear)     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [Einsum](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Einsum)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Elu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Elu)                       |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Elu-6)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Elu-6)                                                                                     |
|                     [Equal](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Equal)                     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                            [7-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Equal-7), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Equal-11)                                             |
|                       [Erf](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Erf)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Exp](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Exp)                       |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Exp-6)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Exp-6)                                                                                     |
|                    [Expand](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Expand)                    |                                                                                   [8+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Expand-8)                                                                                   |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [EyeLike](https://github.com/onnx/onnx/blob/master/docs/Operators.md#EyeLike)                   |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [Flatten](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Flatten)                   |    [1-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Flatten-1), [9-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Flatten-9), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Flatten-11)    |                                                                                                                                                                                                                                |    [1-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Flatten-1), [9-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Flatten-9), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Flatten-11)    |
|                     [Floor](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Floor)                     |                                                                                   [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Floor-6)                                                                                    |                                                                                                                                                                                                                                |                                                                                   [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Floor-6)                                                                                    |
|                       [GRU](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GRU)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [Gather](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Gather)                    |                                           [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gather-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gather-11)                                            |                                                                                                                                                                                                                                |                                           [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gather-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gather-11)                                            |
|            [GatherElements](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GatherElements)            |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [GatherND](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GatherND)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Gemm](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Gemm)                      |        [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-7), [9-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-9), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-11)         | [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-7), [9-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-9), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-11) |        [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-7), [9-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-9), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Gemm-11)         |
|         [GlobalAveragePool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GlobalAveragePool)         |                                                                             [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#GlobalAveragePool-1)                                                                              |                                                                      [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#GlobalAveragePool-1)                                                                      |                                                                             [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#GlobalAveragePool-1)                                                                              |
|              [GlobalLpPool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GlobalLpPool)              |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|             [GlobalMaxPool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GlobalMaxPool)             |                                                                               [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#GlobalMaxPool-1)                                                                                |                                                                        [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#GlobalMaxPool-1)                                                                        |                                                                               [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#GlobalMaxPool-1)                                                                                |
|                   [Greater](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Greater)                   |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                            [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Greater-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Greater-9)                                            |
|            [GreaterOrEqual](https://github.com/onnx/onnx/blob/master/docs/Operators.md#GreaterOrEqual)            |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|               [HardSigmoid](https://github.com/onnx/onnx/blob/master/docs/Operators.md#HardSigmoid)               |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [Hardmax](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Hardmax)                   |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [Identity](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Identity)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                  [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Identity-1)                                                                                  |
|                        [If](https://github.com/onnx/onnx/blob/master/docs/Operators.md#If)                        |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|     [InstanceNormalization](https://github.com/onnx/onnx/blob/master/docs/Operators.md#InstanceNormalization)     |                                                                           [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#InstanceNormalization-6)                                                                            |                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#InstanceNormalization-6)                                                                    |                                                                           [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#InstanceNormalization-6)                                                                            |
|                     [IsInf](https://github.com/onnx/onnx/blob/master/docs/Operators.md#IsInf)                     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                     [IsNaN](https://github.com/onnx/onnx/blob/master/docs/Operators.md#IsNaN)                     |                                                                                   [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#IsNaN-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [LRN](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LRN)                       |                                                                                    [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#LRN-1)                                                                                     |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [LSTM](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LSTM)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                 [LeakyRelu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LeakyRelu)                 |                                                                                 [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#LeakyRelu-6)                                                                                  |                                                                                                                                                                                                                                |                                                                                 [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#LeakyRelu-6)                                                                                  |
|                      [Less](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Less)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                               [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Less-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Less-9)                                               |
|               [LessOrEqual](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LessOrEqual)               |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Log](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Log)                       |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Log-6)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Log-6)                                                                                     |
|                [LogSoftmax](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LogSoftmax)                |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Loop](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Loop)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|           [LpNormalization](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LpNormalization)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [LpPool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#LpPool)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [MatMul](https://github.com/onnx/onnx/blob/master/docs/Operators.md#MatMul)                    |                                             [1-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MatMul-1), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MatMul-9)                                             |                                     [1-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MatMul-1), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MatMul-9)                                      |                                             [1-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MatMul-1), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MatMul-9)                                             |
|             [MatMulInteger](https://github.com/onnx/onnx/blob/master/docs/Operators.md#MatMulInteger)             |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Max](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Max)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [MaxPool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#MaxPool)                   |                                           [1-7](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MaxPool-1), [8-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MaxPool-8)                                            |                                    [1-7](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MaxPool-1), [8-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MaxPool-8)                                    |                                           [1-7](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MaxPool-1), [8-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#MaxPool-8)                                            |
|                [MaxRoiPool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#MaxRoiPool)                |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                 [MaxUnpool](https://github.com/onnx/onnx/blob/master/docs/Operators.md#MaxUnpool)                 |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Mean](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Mean)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
| [MeanVarianceNormalization](https://github.com/onnx/onnx/blob/master/docs/Operators.md#MeanVarianceNormalization) |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Min](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Min)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Mod](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Mod)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Mul](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Mul)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Mul-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Mul-7)                                                                             |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Mul-7)                                                                                     |
|               [Multinomial](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Multinomial)               |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Neg](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Neg)                       |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Neg-6)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Neg-6)                                                                                     |
| [NegativeLogLikelihoodLoss](https://github.com/onnx/onnx/blob/master/docs/Operators.md#NegativeLogLikelihoodLoss) |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|         [NonMaxSuppression](https://github.com/onnx/onnx/blob/master/docs/Operators.md#NonMaxSuppression)         |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [NonZero](https://github.com/onnx/onnx/blob/master/docs/Operators.md#NonZero)                   |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Not](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Not)                       |                                                                                    [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Not-1)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Not-1)                                                                                     |
|                    [OneHot](https://github.com/onnx/onnx/blob/master/docs/Operators.md#OneHot)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                        [Or](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Or)                        |                                                                                     [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Or-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Or-7)                                                                              |                                                                                     [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Or-7)                                                                                     |
|                     [PRelu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#PRelu)                     |                                              [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#PRelu-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#PRelu-9)                                              |                                      [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#PRelu-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#PRelu-9)                                       |                                              [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#PRelu-7), [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#PRelu-9)                                              |
|                       [Pad](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Pad)                       |                                                                                   [2-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Pad-2)                                                                                    |                                                                                                                                                                                                                                |                                                                                   [2-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Pad-2)                                                                                    |
|                       [Pow](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Pow)                       |                                              [7-11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Pow-7), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Pow-12)                                               |                                                                                                                                                                                                                                |                                              [7-11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Pow-7), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Pow-12)                                               |
|               [QLinearConv](https://github.com/onnx/onnx/blob/master/docs/Operators.md#QLinearConv)               |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|             [QLinearMatMul](https://github.com/onnx/onnx/blob/master/docs/Operators.md#QLinearMatMul)             |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|            [QuantizeLinear](https://github.com/onnx/onnx/blob/master/docs/Operators.md#QuantizeLinear)            |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [RNN](https://github.com/onnx/onnx/blob/master/docs/Operators.md#RNN)                       |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|              [RandomNormal](https://github.com/onnx/onnx/blob/master/docs/Operators.md#RandomNormal)              |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|          [RandomNormalLike](https://github.com/onnx/onnx/blob/master/docs/Operators.md#RandomNormalLike)          |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|             [RandomUniform](https://github.com/onnx/onnx/blob/master/docs/Operators.md#RandomUniform)             |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|         [RandomUniformLike](https://github.com/onnx/onnx/blob/master/docs/Operators.md#RandomUniformLike)         |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                     [Range](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Range)                     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                [Reciprocal](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Reciprocal)                |                                                                                 [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Reciprocal-6)                                                                                 |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [ReduceL1](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceL1)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [ReduceL2](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceL2)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|              [ReduceLogSum](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceLogSum)              |                                     [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceLogSum-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceLogSum-11)                                      |                                                                                                                                                                                                                                |                                     [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceLogSum-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceLogSum-11)                                      |
|           [ReduceLogSumExp](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceLogSumExp)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                 [ReduceMax](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceMax)                 | [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMax-1), [11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMax-11), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMax-12) |                                                                                                                                                                                                                                | [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMax-1), [11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMax-11), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMax-12) |
|                [ReduceMean](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceMean)                |                                       [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMean-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMean-11)                                        |                                                                                                                                                                                                                                |                                       [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMean-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMean-11)                                        |
|                 [ReduceMin](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceMin)                 | [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMin-1), [11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMin-11), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMin-12) |                                                                                                                                                                                                                                | [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMin-1), [11](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMin-11), [12+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceMin-12) |
|                [ReduceProd](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceProd)                |                                       [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceProd-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceProd-11)                                        |                                                                                                                                                                                                                                |                                       [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceProd-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceProd-11)                                        |
|                 [ReduceSum](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceSum)                 |                                        [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSum-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSum-11)                                         |                                                                                                                                                                                                                                |                                        [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSum-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSum-11)                                         |
|           [ReduceSumSquare](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReduceSumSquare)           |                                  [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSumSquare-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSumSquare-11)                                   |                                                                                                                                                                                                                                |                                  [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSumSquare-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#ReduceSumSquare-11)                                   |
|                      [Relu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Relu)                      |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Relu-6)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Relu-6)                                                                                    |
|                   [Reshape](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Reshape)                   |                                                                                  [5+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Reshape-5)                                                                                   |                                                                                                                                                                                                                                |                                                                                  [5+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Reshape-5)                                                                                   |
|                    [Resize](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Resize)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|           [ReverseSequence](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ReverseSequence)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [RoiAlign](https://github.com/onnx/onnx/blob/master/docs/Operators.md#RoiAlign)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                     [Round](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Round)                     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Scan](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Scan)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [Scatter](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Scatter)                   |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|           [ScatterElements](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ScatterElements)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                 [ScatterND](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ScatterND)                 |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Selu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Selu)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                [SequenceAt](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SequenceAt)                |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|         [SequenceConstruct](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SequenceConstruct)         |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|             [SequenceEmpty](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SequenceEmpty)             |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|             [SequenceErase](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SequenceErase)             |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|            [SequenceInsert](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SequenceInsert)            |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|            [SequenceLength](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SequenceLength)            |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                     [Shape](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Shape)                     |                                                                                   [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Shape-1)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                    [Shrink](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Shrink)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                   [Sigmoid](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sigmoid)                   |                                                                                  [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sigmoid-6)                                                                                   |                                                                                                                                                                                                                                |                                                                                  [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sigmoid-6)                                                                                   |
|                      [Sign](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sign)                      |                                                                                    [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sign-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Sin](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sin)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sin-7)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sin-7)                                                                                     |
|                      [Sinh](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sinh)                      |                                                                                    [9+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sinh-9)                                                                                    |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Size](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Size)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                     [Slice](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Slice)                     |       [1-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Slice-1), [10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Slice-10), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Slice-11)        |                                                                                                                                                                                                                                |       [1-9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Slice-1), [10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Slice-10), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Slice-11)        |
|                   [Softmax](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Softmax)                   |                                          [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Softmax-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Softmax-11)                                           |                                   [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Softmax-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Softmax-11)                                   |                                          [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Softmax-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Softmax-11)                                           |
|   [SoftmaxCrossEntropyLoss](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SoftmaxCrossEntropyLoss)   |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [Softplus](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Softplus)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                  [Softsign](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Softsign)                  |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|              [SpaceToDepth](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SpaceToDepth)              |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                     [Split](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Split)                     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                            [2-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Split-2), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Split-11)                                             |
|           [SplitToSequence](https://github.com/onnx/onnx/blob/master/docs/Operators.md#SplitToSequence)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Sqrt](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sqrt)                      |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sqrt-6)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sqrt-6)                                                                                    |
|                   [Squeeze](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Squeeze)                   |                                          [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Squeeze-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Squeeze-11)                                           |                                                                                                                                                                                                                                |                                          [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Squeeze-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Squeeze-11)                                           |
|          [StringNormalizer](https://github.com/onnx/onnx/blob/master/docs/Operators.md#StringNormalizer)          |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Sub](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sub)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sub-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sub-7)                                                                             |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sub-7)                                                                                     |
|                       [Sum](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Sum)                       |                                                [6-7](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sum-6), [8+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sum-8)                                                |                                        [6-7](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sum-6), [8+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sum-8)                                         |                                                [6-7](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sum-6), [8+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Sum-8)                                                |
|                       [Tan](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Tan)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Tan-7)                                                                                     |                                                                                                                                                                                                                                |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Tan-7)                                                                                     |
|                      [Tanh](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Tanh)                      |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Tanh-6)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Tanh-6)                                                                                    |
|           [TfIdfVectorizer](https://github.com/onnx/onnx/blob/master/docs/Operators.md#TfIdfVectorizer)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|           [ThresholdedRelu](https://github.com/onnx/onnx/blob/master/docs/Operators.md#ThresholdedRelu)           |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                      [Tile](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Tile)                      |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Tile-6)                                                                                    |                                                                                                                                                                                                                                |                                                                                    [6+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Tile-6)                                                                                    |
|                      [TopK](https://github.com/onnx/onnx/blob/master/docs/Operators.md#TopK)                      |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                 [Transpose](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Transpose)                 |                                                                                 [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Transpose-1)                                                                                  |                                                                                                                                                                                                                                |                                                                                 [1+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Transpose-1)                                                                                  |
|                    [Unique](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Unique)                    |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                 [Unsqueeze](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Unsqueeze)                 |                                        [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Unsqueeze-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Unsqueeze-11)                                         |                                                                                                                                                                                                                                |                                        [1-10](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Unsqueeze-1), [11+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Unsqueeze-11)                                         |
|                  [Upsample](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Upsample)                  |                                           [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Upsample-7), [9](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Upsample-9)                                            |                                                                                                                                                                                                                                |                                                                                 [7-8](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Upsample-7)                                                                                  |
|                     [Where](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Where)                     |                                                                                                                                                                                                                                               |                                                                                                                                                                                                                                |                                                                                                                                                                                                                                               |
|                       [Xor](https://github.com/onnx/onnx/blob/master/docs/Operators.md#Xor)                       |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Xor-7)                                                                                     |                                                                             [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Xor-7)                                                                             |                                                                                    [7+](https://github.com/onnx/onnx/blob/master/docs/Changelog.md#Xor-7)                                                                                     |
