# Contributing to DNSNet

If you want to contribute code to DNSNet, you are more than welcome to do so.
DNSNet uses GitHub pull requests for code contributions.

## Pull requests
A pull request should consist of a series of logical commits leading from a
point in the master branch to whatever you are implementing. The pull request
should not contain any fixup commits -- rebase your branch instead, and squash
the fixup commits into their respective commits.

### Commit messages
Make sure you have good commit messages. In particular, the first line should
be a very short description, followed by an empty line, followed by one or more
paragraphs explaining the change. The last paragraph should mention any github
issues being fixed in a syntax understood by github.

If you squash changes together during a rebase, edit the commit message to
describe the squashed commit as a whole - do not just stick the commit messages
together.

## Coding style
Code is usually automatically formatted with Android Studio using the default
coding style. Sometimes it is forgotten, but please try to make sure to follow
the same coding style for any of your contributions.

## Licensing
Any code contribution will be considered to grant an implicit license under
the GPL, version 3 or later, as stated below, or (on special exceptions) a
different license explicitly included in the contribution that is compatible
to the GPL 3.

Icons are welcome too. Modifications of existing icons shall have the same
license as the modified file. New icons may be contributed under the GPL,
version 3 or later (as below), or the Apache license, version 2.

## Code of Conduct
Please note that this project is released with a Contributor Code of
Conduct. By participating in this project you agree to abide by its terms.

