// Package api provides primitives to interact with the openapi HTTP API.
//
// Code generated by github.com/deepmap/oapi-codegen version v1.11.1-0.20220912230023-4a1477f6a8ba DO NOT EDIT.
package api

import (
	"time"
)

const (
	BearerAuthScopes = "BearerAuth.Scopes"
	TokenAuthScopes  = "TokenAuth.Scopes"
)

// Defines values for EventActivityCode.
const (
	EventActivityCodeAccountCreate                            EventActivityCode = "account.create"
	EventActivityCodeAccountSettingPeerLoginExpirationDisable EventActivityCode = "account.setting.peer.login.expiration.disable"
	EventActivityCodeAccountSettingPeerLoginExpirationEnable  EventActivityCode = "account.setting.peer.login.expiration.enable"
	EventActivityCodeAccountSettingPeerLoginExpirationUpdate  EventActivityCode = "account.setting.peer.login.expiration.update"
	EventActivityCodeDnsSettingDisabledManagementGroupAdd     EventActivityCode = "dns.setting.disabled.management.group.add"
	EventActivityCodeDnsSettingDisabledManagementGroupDelete  EventActivityCode = "dns.setting.disabled.management.group.delete"
	EventActivityCodeGroupAdd                                 EventActivityCode = "group.add"
	EventActivityCodeGroupUpdate                              EventActivityCode = "group.update"
	EventActivityCodeNameserverGroupAdd                       EventActivityCode = "nameserver.group.add"
	EventActivityCodeNameserverGroupDelete                    EventActivityCode = "nameserver.group.delete"
	EventActivityCodeNameserverGroupUpdate                    EventActivityCode = "nameserver.group.update"
	EventActivityCodePeerLoginExpirationDisable               EventActivityCode = "peer.login.expiration.disable"
	EventActivityCodePeerLoginExpirationEnable                EventActivityCode = "peer.login.expiration.enable"
	EventActivityCodePeerLoginExpire                          EventActivityCode = "peer.login.expire"
	EventActivityCodePeerRename                               EventActivityCode = "peer.rename"
	EventActivityCodePeerSshDisable                           EventActivityCode = "peer.ssh.disable"
	EventActivityCodePeerSshEnable                            EventActivityCode = "peer.ssh.enable"
	EventActivityCodePersonalAccessTokenCreate                EventActivityCode = "personal.access.token.create"
	EventActivityCodePersonalAccessTokenDelete                EventActivityCode = "personal.access.token.delete"
	EventActivityCodePolicyAdd                                EventActivityCode = "policy.add"
	EventActivityCodePolicyDelete                             EventActivityCode = "policy.delete"
	EventActivityCodePolicyUpdate                             EventActivityCode = "policy.update"
	EventActivityCodeRouteAdd                                 EventActivityCode = "route.add"
	EventActivityCodeRouteDelete                              EventActivityCode = "route.delete"
	EventActivityCodeRouteUpdate                              EventActivityCode = "route.update"
	EventActivityCodeRuleAdd                                  EventActivityCode = "rule.add"
	EventActivityCodeRuleDelete                               EventActivityCode = "rule.delete"
	EventActivityCodeRuleUpdate                               EventActivityCode = "rule.update"
	EventActivityCodeServiceUserCreate                        EventActivityCode = "service.user.create"
	EventActivityCodeServiceUserDelete                        EventActivityCode = "service.user.delete"
	EventActivityCodeSetupkeyAdd                              EventActivityCode = "setupkey.add"
	EventActivityCodeSetupkeyGroupAdd                         EventActivityCode = "setupkey.group.add"
	EventActivityCodeSetupkeyGroupDelete                      EventActivityCode = "setupkey.group.delete"
	EventActivityCodeSetupkeyOveruse                          EventActivityCode = "setupkey.overuse"
	EventActivityCodeSetupkeyPeerAdd                          EventActivityCode = "setupkey.peer.add"
	EventActivityCodeSetupkeyRevoke                           EventActivityCode = "setupkey.revoke"
	EventActivityCodeSetupkeyUpdate                           EventActivityCode = "setupkey.update"
	EventActivityCodeUserBlock                                EventActivityCode = "user.block"
	EventActivityCodeUserGroupAdd                             EventActivityCode = "user.group.add"
	EventActivityCodeUserGroupDelete                          EventActivityCode = "user.group.delete"
	EventActivityCodeUserInvite                               EventActivityCode = "user.invite"
	EventActivityCodeUserJoin                                 EventActivityCode = "user.join"
	EventActivityCodeUserPeerAdd                              EventActivityCode = "user.peer.add"
	EventActivityCodeUserPeerDelete                           EventActivityCode = "user.peer.delete"
	EventActivityCodeUserPeerLogin                            EventActivityCode = "user.peer.login"
	EventActivityCodeUserRoleUpdate                           EventActivityCode = "user.role.update"
	EventActivityCodeUserUnblock                              EventActivityCode = "user.unblock"
)

// Defines values for GeoLocationCheckAction.
const (
	GeoLocationCheckActionAllow GeoLocationCheckAction = "allow"
	GeoLocationCheckActionDeny  GeoLocationCheckAction = "deny"
)

// Defines values for GroupIssued.
const (
	GroupIssuedApi         GroupIssued = "api"
	GroupIssuedIntegration GroupIssued = "integration"
	GroupIssuedJwt         GroupIssued = "jwt"
)

// Defines values for GroupMinimumIssued.
const (
	GroupMinimumIssuedApi         GroupMinimumIssued = "api"
	GroupMinimumIssuedIntegration GroupMinimumIssued = "integration"
	GroupMinimumIssuedJwt         GroupMinimumIssued = "jwt"
)

// Defines values for IngressPortAllocationPortMappingProtocol.
const (
	IngressPortAllocationPortMappingProtocolTcp    IngressPortAllocationPortMappingProtocol = "tcp"
	IngressPortAllocationPortMappingProtocolTcpudp IngressPortAllocationPortMappingProtocol = "tcp/udp"
	IngressPortAllocationPortMappingProtocolUdp    IngressPortAllocationPortMappingProtocol = "udp"
)

// Defines values for IngressPortAllocationRequestDirectPortProtocol.
const (
	IngressPortAllocationRequestDirectPortProtocolTcp    IngressPortAllocationRequestDirectPortProtocol = "tcp"
	IngressPortAllocationRequestDirectPortProtocolTcpudp IngressPortAllocationRequestDirectPortProtocol = "tcp/udp"
	IngressPortAllocationRequestDirectPortProtocolUdp    IngressPortAllocationRequestDirectPortProtocol = "udp"
)

// Defines values for IngressPortAllocationRequestPortRangeProtocol.
const (
	IngressPortAllocationRequestPortRangeProtocolTcp    IngressPortAllocationRequestPortRangeProtocol = "tcp"
	IngressPortAllocationRequestPortRangeProtocolTcpudp IngressPortAllocationRequestPortRangeProtocol = "tcp/udp"
	IngressPortAllocationRequestPortRangeProtocolUdp    IngressPortAllocationRequestPortRangeProtocol = "udp"
)

// Defines values for NameserverNsType.
const (
	NameserverNsTypeUdp NameserverNsType = "udp"
)

// Defines values for NetworkResourceType.
const (
	NetworkResourceTypeDomain NetworkResourceType = "domain"
	NetworkResourceTypeHost   NetworkResourceType = "host"
	NetworkResourceTypeSubnet NetworkResourceType = "subnet"
)

// Defines values for PeerNetworkRangeCheckAction.
const (
	PeerNetworkRangeCheckActionAllow PeerNetworkRangeCheckAction = "allow"
	PeerNetworkRangeCheckActionDeny  PeerNetworkRangeCheckAction = "deny"
)

// Defines values for PolicyRuleAction.
const (
	PolicyRuleActionAccept PolicyRuleAction = "accept"
	PolicyRuleActionDrop   PolicyRuleAction = "drop"
)

// Defines values for PolicyRuleProtocol.
const (
	PolicyRuleProtocolAll  PolicyRuleProtocol = "all"
	PolicyRuleProtocolIcmp PolicyRuleProtocol = "icmp"
	PolicyRuleProtocolTcp  PolicyRuleProtocol = "tcp"
	PolicyRuleProtocolUdp  PolicyRuleProtocol = "udp"
)

// Defines values for PolicyRuleMinimumAction.
const (
	PolicyRuleMinimumActionAccept PolicyRuleMinimumAction = "accept"
	PolicyRuleMinimumActionDrop   PolicyRuleMinimumAction = "drop"
)

// Defines values for PolicyRuleMinimumProtocol.
const (
	PolicyRuleMinimumProtocolAll  PolicyRuleMinimumProtocol = "all"
	PolicyRuleMinimumProtocolIcmp PolicyRuleMinimumProtocol = "icmp"
	PolicyRuleMinimumProtocolTcp  PolicyRuleMinimumProtocol = "tcp"
	PolicyRuleMinimumProtocolUdp  PolicyRuleMinimumProtocol = "udp"
)

// Defines values for PolicyRuleUpdateAction.
const (
	PolicyRuleUpdateActionAccept PolicyRuleUpdateAction = "accept"
	PolicyRuleUpdateActionDrop   PolicyRuleUpdateAction = "drop"
)

// Defines values for PolicyRuleUpdateProtocol.
const (
	PolicyRuleUpdateProtocolAll  PolicyRuleUpdateProtocol = "all"
	PolicyRuleUpdateProtocolIcmp PolicyRuleUpdateProtocol = "icmp"
	PolicyRuleUpdateProtocolTcp  PolicyRuleUpdateProtocol = "tcp"
	PolicyRuleUpdateProtocolUdp  PolicyRuleUpdateProtocol = "udp"
)

// Defines values for ResourceType.
const (
	ResourceTypeDomain ResourceType = "domain"
	ResourceTypeHost   ResourceType = "host"
	ResourceTypeSubnet ResourceType = "subnet"
)

// Defines values for UserStatus.
const (
	UserStatusActive  UserStatus = "active"
	UserStatusBlocked UserStatus = "blocked"
	UserStatusInvited UserStatus = "invited"
)

// Defines values for GetApiEventsNetworkTrafficParamsType.
const (
	GetApiEventsNetworkTrafficParamsTypeTYPEDROP    GetApiEventsNetworkTrafficParamsType = "TYPE_DROP"
	GetApiEventsNetworkTrafficParamsTypeTYPEEND     GetApiEventsNetworkTrafficParamsType = "TYPE_END"
	GetApiEventsNetworkTrafficParamsTypeTYPESTART   GetApiEventsNetworkTrafficParamsType = "TYPE_START"
	GetApiEventsNetworkTrafficParamsTypeTYPEUNKNOWN GetApiEventsNetworkTrafficParamsType = "TYPE_UNKNOWN"
)

// Defines values for GetApiEventsNetworkTrafficParamsConnectionType.
const (
	GetApiEventsNetworkTrafficParamsConnectionTypeP2P    GetApiEventsNetworkTrafficParamsConnectionType = "P2P"
	GetApiEventsNetworkTrafficParamsConnectionTypeROUTED GetApiEventsNetworkTrafficParamsConnectionType = "ROUTED"
)

// Defines values for GetApiEventsNetworkTrafficParamsDirection.
const (
	GetApiEventsNetworkTrafficParamsDirectionDIRECTIONUNKNOWN GetApiEventsNetworkTrafficParamsDirection = "DIRECTION_UNKNOWN"
	GetApiEventsNetworkTrafficParamsDirectionEGRESS           GetApiEventsNetworkTrafficParamsDirection = "EGRESS"
	GetApiEventsNetworkTrafficParamsDirectionINGRESS          GetApiEventsNetworkTrafficParamsDirection = "INGRESS"
)

// AccessiblePeer defines model for AccessiblePeer.
type AccessiblePeer struct {
	// CityName Commonly used English name of the city
	CityName CityName `json:"city_name"`

	// Connected Peer to Management connection status
	Connected bool `json:"connected"`

	// CountryCode 2-letter ISO 3166-1 alpha-2 code that represents the country
	CountryCode CountryCode `json:"country_code"`

	// DnsLabel Peer's DNS label is the parsed peer name for domain resolution. It is used to form an FQDN by appending the account's domain to the peer label. e.g. peer-dns-label.netbird.cloud
	DnsLabel string `json:"dns_label"`

	// GeonameId Unique identifier from the GeoNames database for a specific geographical location.
	GeonameId int `json:"geoname_id"`

	// Id Peer ID
	Id string `json:"id"`

	// Ip Peer's IP address
	Ip string `json:"ip"`

	// LastSeen Last time peer connected to Netbird's management service
	LastSeen time.Time `json:"last_seen"`

	// Name Peer's hostname
	Name string `json:"name"`

	// Os Peer's operating system and version
	Os string `json:"os"`

	// UserId User ID of the user that enrolled this peer
	UserId string `json:"user_id"`
}

// Account defines model for Account.
type Account struct {
	// CreatedAt Account creation date (UTC)
	CreatedAt time.Time `json:"created_at"`

	// CreatedBy Account creator
	CreatedBy string `json:"created_by"`

	// Domain Account domain
	Domain string `json:"domain"`

	// DomainCategory Account domain category
	DomainCategory string `json:"domain_category"`

	// Id Account ID
	Id         string            `json:"id"`
	Onboarding AccountOnboarding `json:"onboarding"`
	Settings   AccountSettings   `json:"settings"`
}

// AccountExtraSettings defines model for AccountExtraSettings.
type AccountExtraSettings struct {
	// NetworkTrafficLogsEnabled Enables or disables network traffic logging. If enabled, all network traffic events from peers will be stored.
	NetworkTrafficLogsEnabled bool `json:"network_traffic_logs_enabled"`

	// NetworkTrafficLogsGroups Limits traffic logging to these groups. If unset all peers are enabled.
	NetworkTrafficLogsGroups []string `json:"network_traffic_logs_groups"`

	// NetworkTrafficPacketCounterEnabled Enables or disables network traffic packet counter. If enabled, network packets and their size will be counted and reported. (This can have an slight impact on performance)
	NetworkTrafficPacketCounterEnabled bool `json:"network_traffic_packet_counter_enabled"`

	// PeerApprovalEnabled (Cloud only) Enables or disables peer approval globally. If enabled, all peers added will be in pending state until approved by an admin.
	PeerApprovalEnabled bool `json:"peer_approval_enabled"`
}

// AccountOnboarding defines model for AccountOnboarding.
type AccountOnboarding struct {
	// OnboardingFlowPending Indicates whether the account onboarding flow is pending
	OnboardingFlowPending bool `json:"onboarding_flow_pending"`

	// SignupFormPending Indicates whether the account signup form is pending
	SignupFormPending bool `json:"signup_form_pending"`
}

// AccountRequest defines model for AccountRequest.
type AccountRequest struct {
	Onboarding *AccountOnboarding `json:"onboarding,omitempty"`
	Settings   AccountSettings    `json:"settings"`
}

// AccountSettings defines model for AccountSettings.
type AccountSettings struct {
	// DnsDomain Allows to define a custom dns domain for the account
	DnsDomain *string               `json:"dns_domain,omitempty"`
	Extra     *AccountExtraSettings `json:"extra,omitempty"`

	// GroupsPropagationEnabled Allows propagate the new user auto groups to peers that belongs to the user
	GroupsPropagationEnabled *bool `json:"groups_propagation_enabled,omitempty"`

	// JwtAllowGroups List of groups to which users are allowed access
	JwtAllowGroups *[]string `json:"jwt_allow_groups,omitempty"`

	// JwtGroupsClaimName Name of the claim from which we extract groups names to add it to account groups.
	JwtGroupsClaimName *string `json:"jwt_groups_claim_name,omitempty"`

	// JwtGroupsEnabled Allows extract groups from JWT claim and add it to account groups.
	JwtGroupsEnabled *bool `json:"jwt_groups_enabled,omitempty"`

	// LazyConnectionEnabled Enables or disables experimental lazy connection
	LazyConnectionEnabled *bool `json:"lazy_connection_enabled,omitempty"`

	// NetworkRange Allows to define a custom network range for the account in CIDR format
	NetworkRange *string `json:"network_range,omitempty"`

	// PeerInactivityExpiration Period of time of inactivity after which peer session expires (seconds).
	PeerInactivityExpiration int `json:"peer_inactivity_expiration"`

	// PeerInactivityExpirationEnabled Enables or disables peer inactivity expiration globally. After peer's session has expired the user has to log in (authenticate). Applies only to peers that were added by a user (interactive SSO login).
	PeerInactivityExpirationEnabled bool `json:"peer_inactivity_expiration_enabled"`

	// PeerLoginExpiration Period of time after which peer login expires (seconds).
	PeerLoginExpiration int `json:"peer_login_expiration"`

	// PeerLoginExpirationEnabled Enables or disables peer login expiration globally. After peer's login has expired the user has to log in (authenticate). Applies only to peers that were added by a user (interactive SSO login).
	PeerLoginExpirationEnabled bool `json:"peer_login_expiration_enabled"`

	// RegularUsersViewBlocked Allows blocking regular users from viewing parts of the system.
	RegularUsersViewBlocked bool `json:"regular_users_view_blocked"`

	// RoutingPeerDnsResolutionEnabled Enables or disables DNS resolution on the routing peers
	RoutingPeerDnsResolutionEnabled *bool `json:"routing_peer_dns_resolution_enabled,omitempty"`
}

// AvailablePorts defines model for AvailablePorts.
type AvailablePorts struct {
	// Tcp Number of available TCP  ports left on the ingress peer
	Tcp int `json:"tcp"`

	// Udp Number of available UDP ports left on the ingress peer
	Udp int `json:"udp"`
}

// Checks List of objects that perform the actual checks
type Checks struct {
	// GeoLocationCheck Posture check for geo location
	GeoLocationCheck *GeoLocationCheck `json:"geo_location_check,omitempty"`

	// NbVersionCheck Posture check for the version of operating system
	NbVersionCheck *NBVersionCheck `json:"nb_version_check,omitempty"`

	// OsVersionCheck Posture check for the version of operating system
	OsVersionCheck *OSVersionCheck `json:"os_version_check,omitempty"`

	// PeerNetworkRangeCheck Posture check for allow or deny access based on peer local network addresses
	PeerNetworkRangeCheck *PeerNetworkRangeCheck `json:"peer_network_range_check,omitempty"`

	// ProcessCheck Posture Check for binaries exist and are running in the peer’s system
	ProcessCheck *ProcessCheck `json:"process_check,omitempty"`
}

// City Describe city geographical location information
type City struct {
	// CityName Commonly used English name of the city
	CityName string `json:"city_name"`

	// GeonameId Integer ID of the record in GeoNames database
	GeonameId int `json:"geoname_id"`
}

// CityName Commonly used English name of the city
type CityName = string

// Country Describe country geographical location information
type Country struct {
	// CountryCode 2-letter ISO 3166-1 alpha-2 code that represents the country
	CountryCode CountryCode `json:"country_code"`

	// CountryName Commonly used English name of the country
	CountryName string `json:"country_name"`
}

// CountryCode 2-letter ISO 3166-1 alpha-2 code that represents the country
type CountryCode = string

// CreateSetupKeyRequest defines model for CreateSetupKeyRequest.
type CreateSetupKeyRequest struct {
	// AllowExtraDnsLabels Allow extra DNS labels to be added to the peer
	AllowExtraDnsLabels *bool `json:"allow_extra_dns_labels,omitempty"`

	// AutoGroups List of group IDs to auto-assign to peers registered with this key
	AutoGroups []string `json:"auto_groups"`

	// Ephemeral Indicate that the peer will be ephemeral or not
	Ephemeral *bool `json:"ephemeral,omitempty"`

	// ExpiresIn Expiration time in seconds
	ExpiresIn int `json:"expires_in"`

	// Name Setup Key name
	Name string `json:"name"`

	// Type Setup key type, one-off for single time usage and reusable
	Type string `json:"type"`

	// UsageLimit A number of times this key can be used. The value of 0 indicates the unlimited usage.
	UsageLimit int `json:"usage_limit"`
}

// DNSSettings defines model for DNSSettings.
type DNSSettings struct {
	// DisabledManagementGroups Groups whose DNS management is disabled
	DisabledManagementGroups []string `json:"disabled_management_groups"`
}

// Event defines model for Event.
type Event struct {
	// Activity The activity that occurred during the event
	Activity string `json:"activity"`

	// ActivityCode The string code of the activity that occurred during the event
	ActivityCode EventActivityCode `json:"activity_code"`

	// Id Event unique identifier
	Id string `json:"id"`

	// InitiatorEmail The e-mail address of the initiator of the event. E.g., an e-mail of a user that triggered the event.
	InitiatorEmail string `json:"initiator_email"`

	// InitiatorId The ID of the initiator of the event. E.g., an ID of a user that triggered the event.
	InitiatorId string `json:"initiator_id"`

	// InitiatorName The name of the initiator of the event.
	InitiatorName string `json:"initiator_name"`

	// Meta The metadata of the event
	Meta map[string]string `json:"meta"`

	// TargetId The ID of the target of the event. E.g., an ID of the peer that a user removed.
	TargetId string `json:"target_id"`

	// Timestamp The date and time when the event occurred
	Timestamp time.Time `json:"timestamp"`
}

// EventActivityCode The string code of the activity that occurred during the event
type EventActivityCode string

// GeoLocationCheck Posture check for geo location
type GeoLocationCheck struct {
	// Action Action to take upon policy match
	Action GeoLocationCheckAction `json:"action"`

	// Locations List of geo locations to which the policy applies
	Locations []Location `json:"locations"`
}

// GeoLocationCheckAction Action to take upon policy match
type GeoLocationCheckAction string

// Group defines model for Group.
type Group struct {
	// Id Group ID
	Id string `json:"id"`

	// Issued How the group was issued (api, integration, jwt)
	Issued *GroupIssued `json:"issued,omitempty"`

	// Name Group Name identifier
	Name string `json:"name"`

	// Peers List of peers object
	Peers []PeerMinimum `json:"peers"`

	// PeersCount Count of peers associated to the group
	PeersCount int        `json:"peers_count"`
	Resources  []Resource `json:"resources"`

	// ResourcesCount Count of resources associated to the group
	ResourcesCount int `json:"resources_count"`
}

// GroupIssued How the group was issued (api, integration, jwt)
type GroupIssued string

// GroupMinimum defines model for GroupMinimum.
type GroupMinimum struct {
	// Id Group ID
	Id string `json:"id"`

	// Issued How the group was issued (api, integration, jwt)
	Issued *GroupMinimumIssued `json:"issued,omitempty"`

	// Name Group Name identifier
	Name string `json:"name"`

	// PeersCount Count of peers associated to the group
	PeersCount int `json:"peers_count"`

	// ResourcesCount Count of resources associated to the group
	ResourcesCount int `json:"resources_count"`
}

// GroupMinimumIssued How the group was issued (api, integration, jwt)
type GroupMinimumIssued string

// GroupRequest defines model for GroupRequest.
type GroupRequest struct {
	// Name Group name identifier
	Name string `json:"name"`

	// Peers List of peers ids
	Peers     *[]string   `json:"peers,omitempty"`
	Resources *[]Resource `json:"resources,omitempty"`
}

// IngressPeer defines model for IngressPeer.
type IngressPeer struct {
	AvailablePorts AvailablePorts `json:"available_ports"`

	// Connected Indicates if an ingress peer is connected to the management server
	Connected bool `json:"connected"`

	// Enabled Indicates if an ingress peer is enabled
	Enabled bool `json:"enabled"`

	// Fallback Indicates if an ingress peer can be used as a fallback if no ingress peer can be found in the region of the forwarded peer
	Fallback bool `json:"fallback"`

	// Id ID of the ingress peer
	Id string `json:"id"`

	// IngressIp Ingress IP address of the ingress peer where the traffic arrives
	IngressIp string `json:"ingress_ip"`

	// PeerId ID of the peer that is used as an ingress peer
	PeerId string `json:"peer_id"`

	// Region Region of the ingress peer
	Region string `json:"region"`
}

// IngressPeerCreateRequest defines model for IngressPeerCreateRequest.
type IngressPeerCreateRequest struct {
	// Enabled Defines if an ingress peer is enabled
	Enabled bool `json:"enabled"`

	// Fallback Defines if an ingress peer can be used as a fallback if no ingress peer can be found in the region of the forwarded peer
	Fallback bool `json:"fallback"`

	// PeerId ID of the peer that is used as an ingress peer
	PeerId string `json:"peer_id"`
}

// IngressPeerUpdateRequest defines model for IngressPeerUpdateRequest.
type IngressPeerUpdateRequest struct {
	// Enabled Defines if an ingress peer is enabled
	Enabled bool `json:"enabled"`

	// Fallback Defines if an ingress peer can be used as a fallback if no ingress peer can be found in the region of the forwarded peer
	Fallback bool `json:"fallback"`
}

// IngressPortAllocation defines model for IngressPortAllocation.
type IngressPortAllocation struct {
	// Enabled Indicates if an ingress port allocation is enabled
	Enabled bool `json:"enabled"`

	// Id ID of the ingress port allocation
	Id string `json:"id"`

	// IngressIp Ingress IP address of the ingress peer where the traffic arrives
	IngressIp string `json:"ingress_ip"`

	// IngressPeerId ID of the ingress peer that forwards the ports
	IngressPeerId string `json:"ingress_peer_id"`

	// Name Name of the ingress port allocation
	Name string `json:"name"`

	// PortRangeMappings List of port ranges that are allowed to be used by the ingress peer
	PortRangeMappings []IngressPortAllocationPortMapping `json:"port_range_mappings"`

	// Region Region of the ingress peer
	Region string `json:"region"`
}

// IngressPortAllocationPortMapping defines model for IngressPortAllocationPortMapping.
type IngressPortAllocationPortMapping struct {
	// IngressEnd The ending port of the range of ingress ports mapped to the forwarded ports
	IngressEnd int `json:"ingress_end"`

	// IngressStart The starting port of the range of ingress ports mapped to the forwarded ports
	IngressStart int `json:"ingress_start"`

	// Protocol Protocol accepted by the ports
	Protocol IngressPortAllocationPortMappingProtocol `json:"protocol"`

	// TranslatedEnd The ending port of the translated range of forwarded ports
	TranslatedEnd int `json:"translated_end"`

	// TranslatedStart The starting port of the translated range of forwarded ports
	TranslatedStart int `json:"translated_start"`
}

// IngressPortAllocationPortMappingProtocol Protocol accepted by the ports
type IngressPortAllocationPortMappingProtocol string

// IngressPortAllocationRequest defines model for IngressPortAllocationRequest.
type IngressPortAllocationRequest struct {
	DirectPort *IngressPortAllocationRequestDirectPort `json:"direct_port,omitempty"`

	// Enabled Indicates if an ingress port allocation is enabled
	Enabled bool `json:"enabled"`

	// Name Name of the ingress port allocation
	Name string `json:"name"`

	// PortRanges List of port ranges that are forwarded by the ingress peer
	PortRanges *[]IngressPortAllocationRequestPortRange `json:"port_ranges,omitempty"`
}

// IngressPortAllocationRequestDirectPort defines model for IngressPortAllocationRequestDirectPort.
type IngressPortAllocationRequestDirectPort struct {
	// Count The number of ports to be forwarded
	Count int `json:"count"`

	// Protocol The protocol accepted by the port
	Protocol IngressPortAllocationRequestDirectPortProtocol `json:"protocol"`
}

// IngressPortAllocationRequestDirectPortProtocol The protocol accepted by the port
type IngressPortAllocationRequestDirectPortProtocol string

// IngressPortAllocationRequestPortRange defines model for IngressPortAllocationRequestPortRange.
type IngressPortAllocationRequestPortRange struct {
	// End The ending port of the range of forwarded ports
	End int `json:"end"`

	// Protocol The protocol accepted by the port range
	Protocol IngressPortAllocationRequestPortRangeProtocol `json:"protocol"`

	// Start The starting port of the range of forwarded ports
	Start int `json:"start"`
}

// IngressPortAllocationRequestPortRangeProtocol The protocol accepted by the port range
type IngressPortAllocationRequestPortRangeProtocol string

// Location Describe geographical location information
type Location struct {
	// CityName Commonly used English name of the city
	CityName *CityName `json:"city_name,omitempty"`

	// CountryCode 2-letter ISO 3166-1 alpha-2 code that represents the country
	CountryCode CountryCode `json:"country_code"`
}

// MinKernelVersionCheck Posture check with the kernel version
type MinKernelVersionCheck struct {
	// MinKernelVersion Minimum acceptable version
	MinKernelVersion string `json:"min_kernel_version"`
}

// MinVersionCheck Posture check for the version of operating system
type MinVersionCheck struct {
	// MinVersion Minimum acceptable version
	MinVersion string `json:"min_version"`
}

// NBVersionCheck Posture check for the version of operating system
type NBVersionCheck = MinVersionCheck

// Nameserver defines model for Nameserver.
type Nameserver struct {
	// Ip Nameserver IP
	Ip string `json:"ip"`

	// NsType Nameserver Type
	NsType NameserverNsType `json:"ns_type"`

	// Port Nameserver Port
	Port int `json:"port"`
}

// NameserverNsType Nameserver Type
type NameserverNsType string

// NameserverGroup defines model for NameserverGroup.
type NameserverGroup struct {
	// Description Description of the nameserver group
	Description string `json:"description"`

	// Domains Match domain list. It should be empty only if primary is true.
	Domains []string `json:"domains"`

	// Enabled Nameserver group status
	Enabled bool `json:"enabled"`

	// Groups Distribution group IDs that defines group of peers that will use this nameserver group
	Groups []string `json:"groups"`

	// Id Nameserver group ID
	Id string `json:"id"`

	// Name Name of nameserver group name
	Name string `json:"name"`

	// Nameservers Nameserver list
	Nameservers []Nameserver `json:"nameservers"`

	// Primary Defines if a nameserver group is primary that resolves all domains. It should be true only if domains list is empty.
	Primary bool `json:"primary"`

	// SearchDomainsEnabled Search domain status for match domains. It should be true only if domains list is not empty.
	SearchDomainsEnabled bool `json:"search_domains_enabled"`
}

// NameserverGroupRequest defines model for NameserverGroupRequest.
type NameserverGroupRequest struct {
	// Description Description of the nameserver group
	Description string `json:"description"`

	// Domains Match domain list. It should be empty only if primary is true.
	Domains []string `json:"domains"`

	// Enabled Nameserver group status
	Enabled bool `json:"enabled"`

	// Groups Distribution group IDs that defines group of peers that will use this nameserver group
	Groups []string `json:"groups"`

	// Name Name of nameserver group name
	Name string `json:"name"`

	// Nameservers Nameserver list
	Nameservers []Nameserver `json:"nameservers"`

	// Primary Defines if a nameserver group is primary that resolves all domains. It should be true only if domains list is empty.
	Primary bool `json:"primary"`

	// SearchDomainsEnabled Search domain status for match domains. It should be true only if domains list is not empty.
	SearchDomainsEnabled bool `json:"search_domains_enabled"`
}

// Network defines model for Network.
type Network struct {
	// Description Network description
	Description *string `json:"description,omitempty"`

	// Id Network ID
	Id string `json:"id"`

	// Name Network name
	Name string `json:"name"`

	// Policies List of policy IDs associated with the network
	Policies []string `json:"policies"`

	// Resources List of network resource IDs associated with the network
	Resources []string `json:"resources"`

	// Routers List of router IDs associated with the network
	Routers []string `json:"routers"`

	// RoutingPeersCount Count of routing peers associated with the network
	RoutingPeersCount int `json:"routing_peers_count"`
}

// NetworkRequest defines model for NetworkRequest.
type NetworkRequest struct {
	// Description Network description
	Description *string `json:"description,omitempty"`

	// Name Network name
	Name string `json:"name"`
}

// NetworkResource defines model for NetworkResource.
type NetworkResource struct {
	// Address Network resource address (either a direct host like 1.1.1.1 or 1.1.1.1/32, or a subnet like 192.168.178.0/24, or domains like example.com and *.example.com)
	Address string `json:"address"`

	// Description Network resource description
	Description *string `json:"description,omitempty"`

	// Enabled Network resource status
	Enabled bool `json:"enabled"`

	// Groups Groups that the resource belongs to
	Groups []GroupMinimum `json:"groups"`

	// Id Network Resource ID
	Id string `json:"id"`

	// Name Network resource name
	Name string `json:"name"`

	// Type Network resource type based of the address
	Type NetworkResourceType `json:"type"`
}

// NetworkResourceMinimum defines model for NetworkResourceMinimum.
type NetworkResourceMinimum struct {
	// Address Network resource address (either a direct host like 1.1.1.1 or 1.1.1.1/32, or a subnet like 192.168.178.0/24, or domains like example.com and *.example.com)
	Address string `json:"address"`

	// Description Network resource description
	Description *string `json:"description,omitempty"`

	// Enabled Network resource status
	Enabled bool `json:"enabled"`

	// Name Network resource name
	Name string `json:"name"`
}

// NetworkResourceRequest defines model for NetworkResourceRequest.
type NetworkResourceRequest struct {
	// Address Network resource address (either a direct host like 1.1.1.1 or 1.1.1.1/32, or a subnet like 192.168.178.0/24, or domains like example.com and *.example.com)
	Address string `json:"address"`

	// Description Network resource description
	Description *string `json:"description,omitempty"`

	// Enabled Network resource status
	Enabled bool `json:"enabled"`

	// Groups Group IDs containing the resource
	Groups []string `json:"groups"`

	// Name Network resource name
	Name string `json:"name"`
}

// NetworkResourceType Network resource type based of the address
type NetworkResourceType string

// NetworkRouter defines model for NetworkRouter.
type NetworkRouter struct {
	// Enabled Network router status
	Enabled bool `json:"enabled"`

	// Id Network Router Id
	Id string `json:"id"`

	// Masquerade Indicate if peer should masquerade traffic to this route's prefix
	Masquerade bool `json:"masquerade"`

	// Metric Route metric number. Lowest number has higher priority
	Metric int `json:"metric"`

	// Peer Peer Identifier associated with route. This property can not be set together with `peer_groups`
	Peer *string `json:"peer,omitempty"`

	// PeerGroups Peers Group Identifier associated with route. This property can not be set together with `peer`
	PeerGroups *[]string `json:"peer_groups,omitempty"`
}

// NetworkRouterRequest defines model for NetworkRouterRequest.
type NetworkRouterRequest struct {
	// Enabled Network router status
	Enabled bool `json:"enabled"`

	// Masquerade Indicate if peer should masquerade traffic to this route's prefix
	Masquerade bool `json:"masquerade"`

	// Metric Route metric number. Lowest number has higher priority
	Metric int `json:"metric"`

	// Peer Peer Identifier associated with route. This property can not be set together with `peer_groups`
	Peer *string `json:"peer,omitempty"`

	// PeerGroups Peers Group Identifier associated with route. This property can not be set together with `peer`
	PeerGroups *[]string `json:"peer_groups,omitempty"`
}

// NetworkTrafficEndpoint defines model for NetworkTrafficEndpoint.
type NetworkTrafficEndpoint struct {
	// Address IP address (and possibly port) in string form.
	Address string `json:"address"`

	// DnsLabel DNS label/name if available.
	DnsLabel    *string                `json:"dns_label"`
	GeoLocation NetworkTrafficLocation `json:"geo_location"`

	// Id ID of this endpoint (e.g., peer ID or resource ID).
	Id string `json:"id"`

	// Name Name is the name of the endpoint object (e.g., a peer name).
	Name string `json:"name"`

	// Os Operating system of the peer, if applicable.
	Os *string `json:"os"`

	// Type Type of the endpoint object (e.g., UNKNOWN, PEER, HOST_RESOURCE).
	Type string `json:"type"`
}

// NetworkTrafficEvent defines model for NetworkTrafficEvent.
type NetworkTrafficEvent struct {
	Destination NetworkTrafficEndpoint `json:"destination"`

	// Direction Direction of the traffic (e.g. DIRECTION_UNKNOWN, INGRESS, EGRESS).
	Direction string `json:"direction"`

	// Events List of events that are correlated to this flow (e.g., start, end).
	Events []NetworkTrafficSubEvent `json:"events"`

	// FlowId FlowID is the ID of the connection flow. Not unique because it can be the same for multiple events (e.g., start and end of the connection).
	FlowId string               `json:"flow_id"`
	Icmp   NetworkTrafficICMP   `json:"icmp"`
	Policy NetworkTrafficPolicy `json:"policy"`

	// Protocol Protocol is the protocol of the traffic (e.g. 1 = ICMP, 6 = TCP, 17 = UDP, etc.).
	Protocol int `json:"protocol"`

	// ReporterId ID of the reporter of the event (e.g., the peer that reported the event).
	ReporterId string `json:"reporter_id"`

	// RxBytes Number of bytes received.
	RxBytes int `json:"rx_bytes"`

	// RxPackets Number of packets received.
	RxPackets int                    `json:"rx_packets"`
	Source    NetworkTrafficEndpoint `json:"source"`

	// TxBytes Number of bytes transmitted.
	TxBytes int `json:"tx_bytes"`

	// TxPackets Number of packets transmitted.
	TxPackets int                `json:"tx_packets"`
	User      NetworkTrafficUser `json:"user"`
}

// NetworkTrafficEventsResponse defines model for NetworkTrafficEventsResponse.
type NetworkTrafficEventsResponse struct {
	// Data List of network traffic events
	Data []NetworkTrafficEvent `json:"data"`

	// Page Current page number
	Page int `json:"page"`

	// PageSize Number of items per page
	PageSize int `json:"page_size"`

	// TotalPages Total number of pages available
	TotalPages int `json:"total_pages"`

	// TotalRecords Total number of event records available
	TotalRecords int `json:"total_records"`
}

// NetworkTrafficICMP defines model for NetworkTrafficICMP.
type NetworkTrafficICMP struct {
	// Code ICMP code (if applicable).
	Code int `json:"code"`

	// Type ICMP type (if applicable).
	Type int `json:"type"`
}

// NetworkTrafficLocation defines model for NetworkTrafficLocation.
type NetworkTrafficLocation struct {
	// CityName Name of the city (if known).
	CityName string `json:"city_name"`

	// CountryCode ISO country code (if known).
	CountryCode string `json:"country_code"`
}

// NetworkTrafficPolicy defines model for NetworkTrafficPolicy.
type NetworkTrafficPolicy struct {
	// Id ID of the policy that allowed this event.
	Id string `json:"id"`

	// Name Name of the policy that allowed this event.
	Name string `json:"name"`
}

// NetworkTrafficSubEvent defines model for NetworkTrafficSubEvent.
type NetworkTrafficSubEvent struct {
	// Timestamp Timestamp of the event as sent by the peer.
	Timestamp time.Time `json:"timestamp"`

	// Type Type of the event (e.g., TYPE_UNKNOWN, TYPE_START, TYPE_END, TYPE_DROP).
	Type string `json:"type"`
}

// NetworkTrafficUser defines model for NetworkTrafficUser.
type NetworkTrafficUser struct {
	// Email Email of the user who initiated the event (if any).
	Email string `json:"email"`

	// Id UserID is the ID of the user that initiated the event (can be empty as not every event is user-initiated).
	Id string `json:"id"`

	// Name Name of the user who initiated the event (if any).
	Name string `json:"name"`
}

// OSVersionCheck Posture check for the version of operating system
type OSVersionCheck struct {
	// Android Posture check for the version of operating system
	Android *MinVersionCheck `json:"android,omitempty"`

	// Darwin Posture check for the version of operating system
	Darwin *MinVersionCheck `json:"darwin,omitempty"`

	// Ios Posture check for the version of operating system
	Ios *MinVersionCheck `json:"ios,omitempty"`

	// Linux Posture check with the kernel version
	Linux *MinKernelVersionCheck `json:"linux,omitempty"`

	// Windows Posture check with the kernel version
	Windows *MinKernelVersionCheck `json:"windows,omitempty"`
}

// Peer defines model for Peer.
type Peer struct {
	// ApprovalRequired (Cloud only) Indicates whether peer needs approval
	ApprovalRequired bool `json:"approval_required"`

	// CityName Commonly used English name of the city
	CityName CityName `json:"city_name"`

	// Connected Peer to Management connection status
	Connected bool `json:"connected"`

	// ConnectionIp Peer's public connection IP address
	ConnectionIp string `json:"connection_ip"`

	// CountryCode 2-letter ISO 3166-1 alpha-2 code that represents the country
	CountryCode CountryCode `json:"country_code"`

	// DnsLabel Peer's DNS label is the parsed peer name for domain resolution. It is used to form an FQDN by appending the account's domain to the peer label. e.g. peer-dns-label.netbird.cloud
	DnsLabel string `json:"dns_label"`

	// Ephemeral Indicates whether the peer is ephemeral or not
	Ephemeral bool `json:"ephemeral"`

	// ExtraDnsLabels Extra DNS labels added to the peer
	ExtraDnsLabels []string `json:"extra_dns_labels"`

	// GeonameId Unique identifier from the GeoNames database for a specific geographical location.
	GeonameId int `json:"geoname_id"`

	// Groups Groups that the peer belongs to
	Groups []GroupMinimum `json:"groups"`

	// Hostname Hostname of the machine
	Hostname string `json:"hostname"`

	// Id Peer ID
	Id string `json:"id"`

	// InactivityExpirationEnabled Indicates whether peer inactivity expiration has been enabled or not
	InactivityExpirationEnabled bool `json:"inactivity_expiration_enabled"`

	// Ip Peer's IP address
	Ip string `json:"ip"`

	// KernelVersion Peer's operating system kernel version
	KernelVersion string `json:"kernel_version"`

	// LastLogin Last time this peer performed log in (authentication). E.g., user authenticated.
	LastLogin time.Time `json:"last_login"`

	// LastSeen Last time peer connected to Netbird's management service
	LastSeen time.Time `json:"last_seen"`

	// LoginExpirationEnabled Indicates whether peer login expiration has been enabled or not
	LoginExpirationEnabled bool `json:"login_expiration_enabled"`

	// LoginExpired Indicates whether peer's login expired or not
	LoginExpired bool `json:"login_expired"`

	// Name Peer's hostname
	Name string `json:"name"`

	// Os Peer's operating system and version
	Os string `json:"os"`

	// SerialNumber System serial number
	SerialNumber string `json:"serial_number"`

	// SshEnabled Indicates whether SSH server is enabled on this peer
	SshEnabled bool `json:"ssh_enabled"`

	// UiVersion Peer's desktop UI version
	UiVersion string `json:"ui_version"`

	// UserId User ID of the user that enrolled this peer
	UserId string `json:"user_id"`

	// Version Peer's daemon or cli version
	Version string `json:"version"`
}

// PeerBatch defines model for PeerBatch.
type PeerBatch struct {
	// AccessiblePeersCount Number of accessible peers
	AccessiblePeersCount int `json:"accessible_peers_count"`

	// ApprovalRequired (Cloud only) Indicates whether peer needs approval
	ApprovalRequired bool `json:"approval_required"`

	// CityName Commonly used English name of the city
	CityName CityName `json:"city_name"`

	// Connected Peer to Management connection status
	Connected bool `json:"connected"`

	// ConnectionIp Peer's public connection IP address
	ConnectionIp string `json:"connection_ip"`

	// CountryCode 2-letter ISO 3166-1 alpha-2 code that represents the country
	CountryCode CountryCode `json:"country_code"`

	// DnsLabel Peer's DNS label is the parsed peer name for domain resolution. It is used to form an FQDN by appending the account's domain to the peer label. e.g. peer-dns-label.netbird.cloud
	DnsLabel string `json:"dns_label"`

	// Ephemeral Indicates whether the peer is ephemeral or not
	Ephemeral bool `json:"ephemeral"`

	// ExtraDnsLabels Extra DNS labels added to the peer
	ExtraDnsLabels []string `json:"extra_dns_labels"`

	// GeonameId Unique identifier from the GeoNames database for a specific geographical location.
	GeonameId int `json:"geoname_id"`

	// Groups Groups that the peer belongs to
	Groups []GroupMinimum `json:"groups"`

	// Hostname Hostname of the machine
	Hostname string `json:"hostname"`

	// Id Peer ID
	Id string `json:"id"`

	// InactivityExpirationEnabled Indicates whether peer inactivity expiration has been enabled or not
	InactivityExpirationEnabled bool `json:"inactivity_expiration_enabled"`

	// Ip Peer's IP address
	Ip string `json:"ip"`

	// KernelVersion Peer's operating system kernel version
	KernelVersion string `json:"kernel_version"`

	// LastLogin Last time this peer performed log in (authentication). E.g., user authenticated.
	LastLogin time.Time `json:"last_login"`

	// LastSeen Last time peer connected to Netbird's management service
	LastSeen time.Time `json:"last_seen"`

	// LoginExpirationEnabled Indicates whether peer login expiration has been enabled or not
	LoginExpirationEnabled bool `json:"login_expiration_enabled"`

	// LoginExpired Indicates whether peer's login expired or not
	LoginExpired bool `json:"login_expired"`

	// Name Peer's hostname
	Name string `json:"name"`

	// Os Peer's operating system and version
	Os string `json:"os"`

	// SerialNumber System serial number
	SerialNumber string `json:"serial_number"`

	// SshEnabled Indicates whether SSH server is enabled on this peer
	SshEnabled bool `json:"ssh_enabled"`

	// UiVersion Peer's desktop UI version
	UiVersion string `json:"ui_version"`

	// UserId User ID of the user that enrolled this peer
	UserId string `json:"user_id"`

	// Version Peer's daemon or cli version
	Version string `json:"version"`
}

// PeerMinimum defines model for PeerMinimum.
type PeerMinimum struct {
	// Id Peer ID
	Id string `json:"id"`

	// Name Peer's hostname
	Name string `json:"name"`
}

// PeerNetworkRangeCheck Posture check for allow or deny access based on peer local network addresses
type PeerNetworkRangeCheck struct {
	// Action Action to take upon policy match
	Action PeerNetworkRangeCheckAction `json:"action"`

	// Ranges List of peer network ranges in CIDR notation
	Ranges []string `json:"ranges"`
}

// PeerNetworkRangeCheckAction Action to take upon policy match
type PeerNetworkRangeCheckAction string

// PeerRequest defines model for PeerRequest.
type PeerRequest struct {
	// ApprovalRequired (Cloud only) Indicates whether peer needs approval
	ApprovalRequired            *bool `json:"approval_required,omitempty"`
	InactivityExpirationEnabled bool  `json:"inactivity_expiration_enabled"`

	// Ip Peer's IP address
	Ip                     *string `json:"ip,omitempty"`
	LoginExpirationEnabled bool    `json:"login_expiration_enabled"`
	Name                   string  `json:"name"`
	SshEnabled             bool    `json:"ssh_enabled"`
}

// PersonalAccessToken defines model for PersonalAccessToken.
type PersonalAccessToken struct {
	// CreatedAt Date the token was created
	CreatedAt time.Time `json:"created_at"`

	// CreatedBy User ID of the user who created the token
	CreatedBy string `json:"created_by"`

	// ExpirationDate Date the token expires
	ExpirationDate time.Time `json:"expiration_date"`

	// Id ID of a token
	Id string `json:"id"`

	// LastUsed Date the token was last used
	LastUsed *time.Time `json:"last_used,omitempty"`

	// Name Name of the token
	Name string `json:"name"`
}

// PersonalAccessTokenGenerated defines model for PersonalAccessTokenGenerated.
type PersonalAccessTokenGenerated struct {
	PersonalAccessToken PersonalAccessToken `json:"personal_access_token"`

	// PlainToken Plain text representation of the generated token
	PlainToken string `json:"plain_token"`
}

// PersonalAccessTokenRequest defines model for PersonalAccessTokenRequest.
type PersonalAccessTokenRequest struct {
	// ExpiresIn Expiration in days
	ExpiresIn int `json:"expires_in"`

	// Name Name of the token
	Name string `json:"name"`
}

// Policy defines model for Policy.
type Policy struct {
	// Description Policy friendly description
	Description *string `json:"description,omitempty"`

	// Enabled Policy status
	Enabled bool `json:"enabled"`

	// Id Policy ID
	Id *string `json:"id,omitempty"`

	// Name Policy name identifier
	Name string `json:"name"`

	// Rules Policy rule object for policy UI editor
	Rules []PolicyRule `json:"rules"`

	// SourcePostureChecks Posture checks ID's applied to policy source groups
	SourcePostureChecks []string `json:"source_posture_checks"`
}

// PolicyCreate defines model for PolicyCreate.
type PolicyCreate struct {
	// Description Policy friendly description
	Description *string `json:"description,omitempty"`

	// Enabled Policy status
	Enabled bool `json:"enabled"`

	// Name Policy name identifier
	Name string `json:"name"`

	// Rules Policy rule object for policy UI editor
	Rules []PolicyRuleUpdate `json:"rules"`

	// SourcePostureChecks Posture checks ID's applied to policy source groups
	SourcePostureChecks *[]string `json:"source_posture_checks,omitempty"`
}

// PolicyMinimum defines model for PolicyMinimum.
type PolicyMinimum struct {
	// Description Policy friendly description
	Description *string `json:"description,omitempty"`

	// Enabled Policy status
	Enabled bool `json:"enabled"`

	// Name Policy name identifier
	Name string `json:"name"`
}

// PolicyRule defines model for PolicyRule.
type PolicyRule struct {
	// Action Policy rule accept or drops packets
	Action PolicyRuleAction `json:"action"`

	// Bidirectional Define if the rule is applicable in both directions, sources, and destinations.
	Bidirectional bool `json:"bidirectional"`

	// Description Policy rule friendly description
	Description         *string   `json:"description,omitempty"`
	DestinationResource *Resource `json:"destinationResource,omitempty"`

	// Destinations Policy rule destination group IDs
	Destinations *[]GroupMinimum `json:"destinations,omitempty"`

	// Enabled Policy rule status
	Enabled bool `json:"enabled"`

	// Id Policy rule ID
	Id *string `json:"id,omitempty"`

	// Name Policy rule name identifier
	Name string `json:"name"`

	// PortRanges Policy rule affected ports ranges list
	PortRanges *[]RulePortRange `json:"port_ranges,omitempty"`

	// Ports Policy rule affected ports
	Ports *[]string `json:"ports,omitempty"`

	// Protocol Policy rule type of the traffic
	Protocol       PolicyRuleProtocol `json:"protocol"`
	SourceResource *Resource          `json:"sourceResource,omitempty"`

	// Sources Policy rule source group IDs
	Sources *[]GroupMinimum `json:"sources,omitempty"`
}

// PolicyRuleAction Policy rule accept or drops packets
type PolicyRuleAction string

// PolicyRuleProtocol Policy rule type of the traffic
type PolicyRuleProtocol string

// PolicyRuleMinimum defines model for PolicyRuleMinimum.
type PolicyRuleMinimum struct {
	// Action Policy rule accept or drops packets
	Action PolicyRuleMinimumAction `json:"action"`

	// Bidirectional Define if the rule is applicable in both directions, sources, and destinations.
	Bidirectional bool `json:"bidirectional"`

	// Description Policy rule friendly description
	Description *string `json:"description,omitempty"`

	// Enabled Policy rule status
	Enabled bool `json:"enabled"`

	// Name Policy rule name identifier
	Name string `json:"name"`

	// PortRanges Policy rule affected ports ranges list
	PortRanges *[]RulePortRange `json:"port_ranges,omitempty"`

	// Ports Policy rule affected ports
	Ports *[]string `json:"ports,omitempty"`

	// Protocol Policy rule type of the traffic
	Protocol PolicyRuleMinimumProtocol `json:"protocol"`
}

// PolicyRuleMinimumAction Policy rule accept or drops packets
type PolicyRuleMinimumAction string

// PolicyRuleMinimumProtocol Policy rule type of the traffic
type PolicyRuleMinimumProtocol string

// PolicyRuleUpdate defines model for PolicyRuleUpdate.
type PolicyRuleUpdate struct {
	// Action Policy rule accept or drops packets
	Action PolicyRuleUpdateAction `json:"action"`

	// Bidirectional Define if the rule is applicable in both directions, sources, and destinations.
	Bidirectional bool `json:"bidirectional"`

	// Description Policy rule friendly description
	Description         *string   `json:"description,omitempty"`
	DestinationResource *Resource `json:"destinationResource,omitempty"`

	// Destinations Policy rule destination group IDs
	Destinations *[]string `json:"destinations,omitempty"`

	// Enabled Policy rule status
	Enabled bool `json:"enabled"`

	// Id Policy rule ID
	Id *string `json:"id,omitempty"`

	// Name Policy rule name identifier
	Name string `json:"name"`

	// PortRanges Policy rule affected ports ranges list
	PortRanges *[]RulePortRange `json:"port_ranges,omitempty"`

	// Ports Policy rule affected ports
	Ports *[]string `json:"ports,omitempty"`

	// Protocol Policy rule type of the traffic
	Protocol       PolicyRuleUpdateProtocol `json:"protocol"`
	SourceResource *Resource                `json:"sourceResource,omitempty"`

	// Sources Policy rule source group IDs
	Sources *[]string `json:"sources,omitempty"`
}

// PolicyRuleUpdateAction Policy rule accept or drops packets
type PolicyRuleUpdateAction string

// PolicyRuleUpdateProtocol Policy rule type of the traffic
type PolicyRuleUpdateProtocol string

// PolicyUpdate defines model for PolicyUpdate.
type PolicyUpdate struct {
	// Description Policy friendly description
	Description *string `json:"description,omitempty"`

	// Enabled Policy status
	Enabled bool `json:"enabled"`

	// Name Policy name identifier
	Name string `json:"name"`

	// Rules Policy rule object for policy UI editor
	Rules []PolicyRuleUpdate `json:"rules"`

	// SourcePostureChecks Posture checks ID's applied to policy source groups
	SourcePostureChecks *[]string `json:"source_posture_checks,omitempty"`
}

// PostureCheck defines model for PostureCheck.
type PostureCheck struct {
	// Checks List of objects that perform the actual checks
	Checks Checks `json:"checks"`

	// Description Posture check friendly description
	Description *string `json:"description,omitempty"`

	// Id Posture check ID
	Id string `json:"id"`

	// Name Posture check unique name identifier
	Name string `json:"name"`
}

// PostureCheckUpdate defines model for PostureCheckUpdate.
type PostureCheckUpdate struct {
	// Checks List of objects that perform the actual checks
	Checks *Checks `json:"checks,omitempty"`

	// Description Posture check friendly description
	Description string `json:"description"`

	// Name Posture check name identifier
	Name string `json:"name"`
}

// Process Describes the operational activity within a peer's system.
type Process struct {
	// LinuxPath Path to the process executable file in a Linux operating system
	LinuxPath *string `json:"linux_path,omitempty"`

	// MacPath Path to the process executable file in a Mac operating system
	MacPath *string `json:"mac_path,omitempty"`

	// WindowsPath Path to the process executable file in a Windows operating system
	WindowsPath *string `json:"windows_path,omitempty"`
}

// ProcessCheck Posture Check for binaries exist and are running in the peer’s system
type ProcessCheck struct {
	Processes []Process `json:"processes"`
}

// Resource defines model for Resource.
type Resource struct {
	// Id ID of the resource
	Id   string       `json:"id"`
	Type ResourceType `json:"type"`
}

// ResourceType defines model for ResourceType.
type ResourceType string

// Route defines model for Route.
type Route struct {
	// AccessControlGroups Access control group identifier associated with route.
	AccessControlGroups *[]string `json:"access_control_groups,omitempty"`

	// Description Route description
	Description string `json:"description"`

	// Domains Domain list to be dynamically resolved. Max of 32 domains can be added per route configuration. Conflicts with network
	Domains *[]string `json:"domains,omitempty"`

	// Enabled Route status
	Enabled bool `json:"enabled"`

	// Groups Group IDs containing routing peers
	Groups []string `json:"groups"`

	// Id Route Id
	Id string `json:"id"`

	// KeepRoute Indicate if the route should be kept after a domain doesn't resolve that IP anymore
	KeepRoute bool `json:"keep_route"`

	// Masquerade Indicate if peer should masquerade traffic to this route's prefix
	Masquerade bool `json:"masquerade"`

	// Metric Route metric number. Lowest number has higher priority
	Metric int `json:"metric"`

	// Network Network range in CIDR format, Conflicts with domains
	Network *string `json:"network,omitempty"`

	// NetworkId Route network identifier, to group HA routes
	NetworkId string `json:"network_id"`

	// NetworkType Network type indicating if it is a domain route or a IPv4/IPv6 route
	NetworkType string `json:"network_type"`

	// Peer Peer Identifier associated with route. This property can not be set together with `peer_groups`
	Peer *string `json:"peer,omitempty"`

	// PeerGroups Peers Group Identifier associated with route. This property can not be set together with `peer`
	PeerGroups *[]string `json:"peer_groups,omitempty"`
}

// RouteRequest defines model for RouteRequest.
type RouteRequest struct {
	// AccessControlGroups Access control group identifier associated with route.
	AccessControlGroups *[]string `json:"access_control_groups,omitempty"`

	// Description Route description
	Description string `json:"description"`

	// Domains Domain list to be dynamically resolved. Max of 32 domains can be added per route configuration. Conflicts with network
	Domains *[]string `json:"domains,omitempty"`

	// Enabled Route status
	Enabled bool `json:"enabled"`

	// Groups Group IDs containing routing peers
	Groups []string `json:"groups"`

	// KeepRoute Indicate if the route should be kept after a domain doesn't resolve that IP anymore
	KeepRoute bool `json:"keep_route"`

	// Masquerade Indicate if peer should masquerade traffic to this route's prefix
	Masquerade bool `json:"masquerade"`

	// Metric Route metric number. Lowest number has higher priority
	Metric int `json:"metric"`

	// Network Network range in CIDR format, Conflicts with domains
	Network *string `json:"network,omitempty"`

	// NetworkId Route network identifier, to group HA routes
	NetworkId string `json:"network_id"`

	// Peer Peer Identifier associated with route. This property can not be set together with `peer_groups`
	Peer *string `json:"peer,omitempty"`

	// PeerGroups Peers Group Identifier associated with route. This property can not be set together with `peer`
	PeerGroups *[]string `json:"peer_groups,omitempty"`
}

// RulePortRange Policy rule affected ports range
type RulePortRange struct {
	// End The ending port of the range
	End int `json:"end"`

	// Start The starting port of the range
	Start int `json:"start"`
}

// SetupKey defines model for SetupKey.
type SetupKey struct {
	// AllowExtraDnsLabels Allow extra DNS labels to be added to the peer
	AllowExtraDnsLabels bool `json:"allow_extra_dns_labels"`

	// AutoGroups List of group IDs to auto-assign to peers registered with this key
	AutoGroups []string `json:"auto_groups"`

	// Ephemeral Indicate that the peer will be ephemeral or not
	Ephemeral bool `json:"ephemeral"`

	// Expires Setup Key expiration date
	Expires time.Time `json:"expires"`

	// Id Setup Key ID
	Id string `json:"id"`

	// Key Setup Key as secret
	Key string `json:"key"`

	// LastUsed Setup key last usage date
	LastUsed time.Time `json:"last_used"`

	// Name Setup key name identifier
	Name string `json:"name"`

	// Revoked Setup key revocation status
	Revoked bool `json:"revoked"`

	// State Setup key status, "valid", "overused","expired" or "revoked"
	State string `json:"state"`

	// Type Setup key type, one-off for single time usage and reusable
	Type string `json:"type"`

	// UpdatedAt Setup key last update date
	UpdatedAt time.Time `json:"updated_at"`

	// UsageLimit A number of times this key can be used. The value of 0 indicates the unlimited usage.
	UsageLimit int `json:"usage_limit"`

	// UsedTimes Usage count of setup key
	UsedTimes int `json:"used_times"`

	// Valid Setup key validity status
	Valid bool `json:"valid"`
}

// SetupKeyBase defines model for SetupKeyBase.
type SetupKeyBase struct {
	// AllowExtraDnsLabels Allow extra DNS labels to be added to the peer
	AllowExtraDnsLabels bool `json:"allow_extra_dns_labels"`

	// AutoGroups List of group IDs to auto-assign to peers registered with this key
	AutoGroups []string `json:"auto_groups"`

	// Ephemeral Indicate that the peer will be ephemeral or not
	Ephemeral bool `json:"ephemeral"`

	// Expires Setup Key expiration date
	Expires time.Time `json:"expires"`

	// Id Setup Key ID
	Id string `json:"id"`

	// LastUsed Setup key last usage date
	LastUsed time.Time `json:"last_used"`

	// Name Setup key name identifier
	Name string `json:"name"`

	// Revoked Setup key revocation status
	Revoked bool `json:"revoked"`

	// State Setup key status, "valid", "overused","expired" or "revoked"
	State string `json:"state"`

	// Type Setup key type, one-off for single time usage and reusable
	Type string `json:"type"`

	// UpdatedAt Setup key last update date
	UpdatedAt time.Time `json:"updated_at"`

	// UsageLimit A number of times this key can be used. The value of 0 indicates the unlimited usage.
	UsageLimit int `json:"usage_limit"`

	// UsedTimes Usage count of setup key
	UsedTimes int `json:"used_times"`

	// Valid Setup key validity status
	Valid bool `json:"valid"`
}

// SetupKeyClear defines model for SetupKeyClear.
type SetupKeyClear struct {
	// AllowExtraDnsLabels Allow extra DNS labels to be added to the peer
	AllowExtraDnsLabels bool `json:"allow_extra_dns_labels"`

	// AutoGroups List of group IDs to auto-assign to peers registered with this key
	AutoGroups []string `json:"auto_groups"`

	// Ephemeral Indicate that the peer will be ephemeral or not
	Ephemeral bool `json:"ephemeral"`

	// Expires Setup Key expiration date
	Expires time.Time `json:"expires"`

	// Id Setup Key ID
	Id string `json:"id"`

	// Key Setup Key as plain text
	Key string `json:"key"`

	// LastUsed Setup key last usage date
	LastUsed time.Time `json:"last_used"`

	// Name Setup key name identifier
	Name string `json:"name"`

	// Revoked Setup key revocation status
	Revoked bool `json:"revoked"`

	// State Setup key status, "valid", "overused","expired" or "revoked"
	State string `json:"state"`

	// Type Setup key type, one-off for single time usage and reusable
	Type string `json:"type"`

	// UpdatedAt Setup key last update date
	UpdatedAt time.Time `json:"updated_at"`

	// UsageLimit A number of times this key can be used. The value of 0 indicates the unlimited usage.
	UsageLimit int `json:"usage_limit"`

	// UsedTimes Usage count of setup key
	UsedTimes int `json:"used_times"`

	// Valid Setup key validity status
	Valid bool `json:"valid"`
}

// SetupKeyRequest defines model for SetupKeyRequest.
type SetupKeyRequest struct {
	// AutoGroups List of group IDs to auto-assign to peers registered with this key
	AutoGroups []string `json:"auto_groups"`

	// Revoked Setup key revocation status
	Revoked bool `json:"revoked"`
}

// User defines model for User.
type User struct {
	// AutoGroups Group IDs to auto-assign to peers registered by this user
	AutoGroups []string `json:"auto_groups"`

	// Email User's email address
	Email string `json:"email"`

	// Id User ID
	Id string `json:"id"`

	// IsBlocked Is true if this user is blocked. Blocked users can't use the system
	IsBlocked bool `json:"is_blocked"`

	// IsCurrent Is true if authenticated user is the same as this user
	IsCurrent *bool `json:"is_current,omitempty"`

	// IsServiceUser Is true if this user is a service user
	IsServiceUser *bool `json:"is_service_user,omitempty"`

	// Issued How user was issued by API or Integration
	Issued *string `json:"issued,omitempty"`

	// LastLogin Last time this user performed a login to the dashboard
	LastLogin *time.Time `json:"last_login,omitempty"`

	// Name User's name from idp provider
	Name        string           `json:"name"`
	Permissions *UserPermissions `json:"permissions,omitempty"`

	// Role User's NetBird account role
	Role string `json:"role"`

	// Status User's status
	Status UserStatus `json:"status"`
}

// UserStatus User's status
type UserStatus string

// UserCreateRequest defines model for UserCreateRequest.
type UserCreateRequest struct {
	// AutoGroups Group IDs to auto-assign to peers registered by this user
	AutoGroups []string `json:"auto_groups"`

	// Email User's Email to send invite to
	Email *string `json:"email,omitempty"`

	// IsServiceUser Is true if this user is a service user
	IsServiceUser bool `json:"is_service_user"`

	// Name User's full name
	Name *string `json:"name,omitempty"`

	// Role User's NetBird account role
	Role string `json:"role"`
}

// UserPermissions defines model for UserPermissions.
type UserPermissions struct {
	// IsRestricted Indicates whether this User's Peers view is restricted
	IsRestricted bool                       `json:"is_restricted"`
	Modules      map[string]map[string]bool `json:"modules"`
}

// UserRequest defines model for UserRequest.
type UserRequest struct {
	// AutoGroups Group IDs to auto-assign to peers registered by this user
	AutoGroups []string `json:"auto_groups"`

	// IsBlocked If set to true then user is blocked and can't use the system
	IsBlocked bool `json:"is_blocked"`

	// Role User's NetBird account role
	Role string `json:"role"`
}

// GetApiEventsNetworkTrafficParams defines parameters for GetApiEventsNetworkTraffic.
type GetApiEventsNetworkTrafficParams struct {
	// Page Page number
	Page *int `form:"page,omitempty" json:"page,omitempty"`

	// PageSize Number of items per page
	PageSize *int `form:"page_size,omitempty" json:"page_size,omitempty"`

	// UserId Filter by user ID
	UserId *string `form:"user_id,omitempty" json:"user_id,omitempty"`

	// ReporterId Filter by reporter ID
	ReporterId *string `form:"reporter_id,omitempty" json:"reporter_id,omitempty"`

	// Protocol Filter by protocol
	Protocol *int `form:"protocol,omitempty" json:"protocol,omitempty"`

	// Type Filter by event type
	Type *GetApiEventsNetworkTrafficParamsType `form:"type,omitempty" json:"type,omitempty"`

	// ConnectionType Filter by connection type
	ConnectionType *GetApiEventsNetworkTrafficParamsConnectionType `form:"connection_type,omitempty" json:"connection_type,omitempty"`

	// Direction Filter by direction
	Direction *GetApiEventsNetworkTrafficParamsDirection `form:"direction,omitempty" json:"direction,omitempty"`

	// Search Case-insensitive partial match on user email, source/destination names, and source/destination addresses
	Search *string `form:"search,omitempty" json:"search,omitempty"`

	// StartDate Start date for filtering events (ISO 8601 format, e.g., 2024-01-01T00:00:00Z).
	StartDate *time.Time `form:"start_date,omitempty" json:"start_date,omitempty"`

	// EndDate End date for filtering events (ISO 8601 format, e.g., 2024-01-31T23:59:59Z).
	EndDate *time.Time `form:"end_date,omitempty" json:"end_date,omitempty"`
}

// GetApiEventsNetworkTrafficParamsType defines parameters for GetApiEventsNetworkTraffic.
type GetApiEventsNetworkTrafficParamsType string

// GetApiEventsNetworkTrafficParamsConnectionType defines parameters for GetApiEventsNetworkTraffic.
type GetApiEventsNetworkTrafficParamsConnectionType string

// GetApiEventsNetworkTrafficParamsDirection defines parameters for GetApiEventsNetworkTraffic.
type GetApiEventsNetworkTrafficParamsDirection string

// GetApiPeersParams defines parameters for GetApiPeers.
type GetApiPeersParams struct {
	// Name Filter peers by name
	Name *string `form:"name,omitempty" json:"name,omitempty"`

	// Ip Filter peers by IP address
	Ip *string `form:"ip,omitempty" json:"ip,omitempty"`
}

// GetApiPeersPeerIdIngressPortsParams defines parameters for GetApiPeersPeerIdIngressPorts.
type GetApiPeersPeerIdIngressPortsParams struct {
	// Name Filters ingress port allocations by name
	Name *string `form:"name,omitempty" json:"name,omitempty"`
}

// GetApiUsersParams defines parameters for GetApiUsers.
type GetApiUsersParams struct {
	// ServiceUser Filters users and returns either regular users or service users
	ServiceUser *bool `form:"service_user,omitempty" json:"service_user,omitempty"`
}

// PutApiAccountsAccountIdJSONRequestBody defines body for PutApiAccountsAccountId for application/json ContentType.
type PutApiAccountsAccountIdJSONRequestBody = AccountRequest

// PostApiDnsNameserversJSONRequestBody defines body for PostApiDnsNameservers for application/json ContentType.
type PostApiDnsNameserversJSONRequestBody = NameserverGroupRequest

// PutApiDnsNameserversNsgroupIdJSONRequestBody defines body for PutApiDnsNameserversNsgroupId for application/json ContentType.
type PutApiDnsNameserversNsgroupIdJSONRequestBody = NameserverGroupRequest

// PutApiDnsSettingsJSONRequestBody defines body for PutApiDnsSettings for application/json ContentType.
type PutApiDnsSettingsJSONRequestBody = DNSSettings

// PostApiGroupsJSONRequestBody defines body for PostApiGroups for application/json ContentType.
type PostApiGroupsJSONRequestBody = GroupRequest

// PutApiGroupsGroupIdJSONRequestBody defines body for PutApiGroupsGroupId for application/json ContentType.
type PutApiGroupsGroupIdJSONRequestBody = GroupRequest

// PostApiIngressPeersJSONRequestBody defines body for PostApiIngressPeers for application/json ContentType.
type PostApiIngressPeersJSONRequestBody = IngressPeerCreateRequest

// PutApiIngressPeersIngressPeerIdJSONRequestBody defines body for PutApiIngressPeersIngressPeerId for application/json ContentType.
type PutApiIngressPeersIngressPeerIdJSONRequestBody = IngressPeerUpdateRequest

// PostApiNetworksJSONRequestBody defines body for PostApiNetworks for application/json ContentType.
type PostApiNetworksJSONRequestBody = NetworkRequest

// PutApiNetworksNetworkIdJSONRequestBody defines body for PutApiNetworksNetworkId for application/json ContentType.
type PutApiNetworksNetworkIdJSONRequestBody = NetworkRequest

// PostApiNetworksNetworkIdResourcesJSONRequestBody defines body for PostApiNetworksNetworkIdResources for application/json ContentType.
type PostApiNetworksNetworkIdResourcesJSONRequestBody = NetworkResourceRequest

// PutApiNetworksNetworkIdResourcesResourceIdJSONRequestBody defines body for PutApiNetworksNetworkIdResourcesResourceId for application/json ContentType.
type PutApiNetworksNetworkIdResourcesResourceIdJSONRequestBody = NetworkResourceRequest

// PostApiNetworksNetworkIdRoutersJSONRequestBody defines body for PostApiNetworksNetworkIdRouters for application/json ContentType.
type PostApiNetworksNetworkIdRoutersJSONRequestBody = NetworkRouterRequest

// PutApiNetworksNetworkIdRoutersRouterIdJSONRequestBody defines body for PutApiNetworksNetworkIdRoutersRouterId for application/json ContentType.
type PutApiNetworksNetworkIdRoutersRouterIdJSONRequestBody = NetworkRouterRequest

// PutApiPeersPeerIdJSONRequestBody defines body for PutApiPeersPeerId for application/json ContentType.
type PutApiPeersPeerIdJSONRequestBody = PeerRequest

// PostApiPeersPeerIdIngressPortsJSONRequestBody defines body for PostApiPeersPeerIdIngressPorts for application/json ContentType.
type PostApiPeersPeerIdIngressPortsJSONRequestBody = IngressPortAllocationRequest

// PutApiPeersPeerIdIngressPortsAllocationIdJSONRequestBody defines body for PutApiPeersPeerIdIngressPortsAllocationId for application/json ContentType.
type PutApiPeersPeerIdIngressPortsAllocationIdJSONRequestBody = IngressPortAllocationRequest

// PostApiPoliciesJSONRequestBody defines body for PostApiPolicies for application/json ContentType.
type PostApiPoliciesJSONRequestBody = PolicyUpdate

// PutApiPoliciesPolicyIdJSONRequestBody defines body for PutApiPoliciesPolicyId for application/json ContentType.
type PutApiPoliciesPolicyIdJSONRequestBody = PolicyCreate

// PostApiPostureChecksJSONRequestBody defines body for PostApiPostureChecks for application/json ContentType.
type PostApiPostureChecksJSONRequestBody = PostureCheckUpdate

// PutApiPostureChecksPostureCheckIdJSONRequestBody defines body for PutApiPostureChecksPostureCheckId for application/json ContentType.
type PutApiPostureChecksPostureCheckIdJSONRequestBody = PostureCheckUpdate

// PostApiRoutesJSONRequestBody defines body for PostApiRoutes for application/json ContentType.
type PostApiRoutesJSONRequestBody = RouteRequest

// PutApiRoutesRouteIdJSONRequestBody defines body for PutApiRoutesRouteId for application/json ContentType.
type PutApiRoutesRouteIdJSONRequestBody = RouteRequest

// PostApiSetupKeysJSONRequestBody defines body for PostApiSetupKeys for application/json ContentType.
type PostApiSetupKeysJSONRequestBody = CreateSetupKeyRequest

// PutApiSetupKeysKeyIdJSONRequestBody defines body for PutApiSetupKeysKeyId for application/json ContentType.
type PutApiSetupKeysKeyIdJSONRequestBody = SetupKeyRequest

// PostApiUsersJSONRequestBody defines body for PostApiUsers for application/json ContentType.
type PostApiUsersJSONRequestBody = UserCreateRequest

// PutApiUsersUserIdJSONRequestBody defines body for PutApiUsersUserId for application/json ContentType.
type PutApiUsersUserIdJSONRequestBody = UserRequest

// PostApiUsersUserIdTokensJSONRequestBody defines body for PostApiUsersUserIdTokens for application/json ContentType.
type PostApiUsersUserIdTokensJSONRequestBody = PersonalAccessTokenRequest
