/// Reserved email addresses taken from
/// https://github.com/forwardemail/reserved-email-addresses-list/blob/master/index.json
class ReservedEmailAddresses {
  static const reserved = {
    '0',
    '100',
    '101',
    '102',
    '1xx',
    '200',
    '201',
    '202',
    '203',
    '204',
    '205',
    '206',
    '207',
    '226',
    '2xx',
    '300',
    '301',
    '302',
    '303',
    '304',
    '305',
    '307',
    '308',
    '3xx',
    '400',
    '401',
    '402',
    '403',
    '404',
    '405',
    '406',
    '407',
    '408',
    '409',
    '410',
    '411',
    '412',
    '413',
    '414',
    '415',
    '416',
    '417',
    '418',
    '422',
    '423',
    '424',
    '426',
    '428',
    '429',
    '431',
    '451',
    '4xx',
    '500',
    '501',
    '502',
    '503',
    '504',
    '505',
    '506',
    '507',
    '511',
    '5xx',
    '7xx',
    'about',
    'abuse',
    'ac',
    'access',
    'account',
    'accounts',
    'activate',
    'activities',
    'activity',
    'ad',
    'add',
    'added',
    'address',
    'adm',
    'admin',
    'administracion',
    'administration',
    'administrator',
    'ads',
    'adult',
    'advertising',
    'advisor',
    'ae',
    'af',
    'affiliate',
    'affiliates',
    'ag',
    'ai',
    'ajax',
    'al',
    'album',
    'albums',
    'all',
    'alpha',
    'am',
    'an',
    'analysis',
    'analytics',
    'android',
    'anon',
    'anonymous',
    'ao',
    'api',
    'app',
    'apple',
    'apps',
    'aq',
    'ar',
    'arabic',
    'archive',
    'archived',
    'archives',
    'as',
    'asset',
    'at',
    'atom',
    'au',
    'auth',
    'authentication',
    'auto',
    'autoconfig',
    'automatic',
    'available',
    'avatar',
    'aw',
    'awadhi',
    'ax',
    'az',
    'azerbaijani',
    'ba',
    'backup',
    'backups',
    'bank',
    'banner',
    'banners',
    'bb',
    'bd',
    'be',
    'bengali',
    'beta',
    'bf',
    'bg',
    'bh',
    'bhojpuri',
    'bi',
    'billing',
    'bin',
    'bj',
    'blob',
    'blobs',
    'blog',
    'blogs',
    'bm',
    'bn',
    'bo',
    'board',
    'bookmark',
    'bookmarked',
    'bookmarks',
    'bot',
    'bots',
    'bottom',
    'br',
    'broadcasthost',
    'browse',
    'bs',
    'bt',
    'bug',
    'bugs',
    'build',
    'builds',
    'built',
    'burmese',
    'bursar',
    'busdev',
    'business',
    'bv',
    'bw',
    'by',
    'bz',
    'ca',
    'cache',
    'cadastro',
    'calendar',
    'call',
    'callback',
    'campaign',
    'cancel',
    'captcha',
    'career',
    'careers',
    'cart',
    'categories',
    'category',
    'cc',
    'cd',
    'cdn',
    'center',
    'ceo',
    'cf',
    'cfo',
    'cg',
    'cgi',
    'cgi-bin',
    'ch',
    'changelog',
    'chat',
    'check',
    'checking',
    'checkout',
    'checkpoint',
    'chinese',
    'ci',
    'ck',
    'cl',
    'classic',
    'client',
    'cliente',
    'clients',
    'cloud',
    'cm',
    'cmo',
    'cn',
    'cname',
    'co',
    'co-op',
    'code',
    'codereview',
    'comercial',
    'comment',
    'comments',
    'communities',
    'community',
    'company',
    'compare',
    'compete',
    'compras',
    'config',
    'configuration',
    'configure',
    'connect',
    'consultant',
    'contact',
    'contact-us',
    'contact_us',
    'contacto',
    'contacts',
    'contactus',
    'contest',
    'contribute',
    'control',
    'convert',
    'copied',
    'copy',
    'copyright',
    'corp',
    'cr',
    'crash',
    'create',
    'crew',
    'crypt',
    'cs',
    'css',
    'cto',
    'cu',
    'customercare',
    'customerservice',
    'cv',
    'cx',
    'cy',
    'cz',
    'dashboard',
    'data',
    'database',
    'db',
    'dd',
    'de',
    'default',
    'delete',
    'deleted',
    'demo',
    'demos',
    'denied',
    'deny',
    'deploy',
    'deployed',
    'deploys',
    'design',
    'designer',
    'destroy',
    'dev',
    'devel',
    'developer',
    'developers',
    'die',
    'digsitesvalue',
    'dir',
    'direct_messages',
    'director',
    'directors',
    'directory',
    'dist',
    'dj',
    'dk',
    'dm',
    'dns',
    'do',
    'doc',
    'docker',
    'docs',
    'document',
    'documentation',
    'documents',
    'domain',
    'download',
    'downloaded',
    'downloads',
    'dutch',
    'dvd',
    'dz',
    'ec',
    'ecommerce',
    'edit',
    'edited',
    'editor',
    'editorial',
    'editors',
    'edits',
    'ee',
    'eg',
    'eh',
    'email',
    'emails',
    'employment',
    'empty',
    'end',
    'eng',
    'english',
    'enquire',
    'enquiries',
    'enquiry',
    'enterprise',
    'entries',
    'entry',
    'er',
    'erase',
    'erased',
    'error',
    'errors',
    'es',
    'et',
    'etc',
    'eu',
    'eula',
    'eval',
    'event',
    'events',
    'everyone',
    'example',
    'examples',
    'exec',
    'executive',
    'executives',
    'exit',
    'expert',
    'experts',
    'expire',
    'expired',
    'explore',
    'export',
    'exported',
    'exports',
    'facebook',
    'faq',
    'farsi',
    'favorite',
    'favorites',
    'fbi',
    'fbl',
    'feature',
    'features',
    'feed',
    'feedback',
    'feeds',
    'fetch',
    'fi',
    'file',
    'files',
    'finance',
    'find',
    'firewall',
    'first',
    'fj',
    'fk',
    'flag',
    'flagged',
    'flags',
    'fleet',
    'fleets',
    'flog',
    'fm',
    'fo',
    'follow',
    'followers',
    'following',
    'forbidden',
    'forgot',
    'forgot-password',
    'forgot_password',
    'forgotpassword',
    'form',
    'forum',
    'forums',
    'fr',
    'free',
    'french',
    'friend',
    'friends',
    'ftp',
    'ftps',
    'ga',
    'gadget',
    'gadgets',
    'games',
    'gan',
    'gb',
    'gd',
    'ge',
    'german',
    'get',
    'gf',
    'gg',
    'gh',
    'gi',
    'gif',
    'gifs',
    'gift',
    'gifts',
    'gist',
    'git',
    'github',
    'gl',
    'gm',
    'gn',
    'google',
    'gp',
    'gq',
    'gr',
    'graph',
    'group',
    'groups',
    'gs',
    'gt',
    'gu',
    'guest',
    'guests',
    'guide',
    'guidelines',
    'gujarati',
    'gw',
    'gy',
    'hakka',
    'hash',
    'hausa',
    'head',
    'head.office',
    'headoffice',
    'headteacher',
    'help',
    'hidden',
    'hide',
    'hindi',
    'history',
    'hk',
    'hm',
    'hn',
    'home',
    'homepage',
    'hooks',
    'host',
    'hosting',
    'hostmaster',
    'hostname',
    'howto',
    'hpg',
    'hr',
    'ht',
    'html',
    'http',
    'http2',
    'httpd',
    'https',
    'hu',
    'i',
    'id',
    'idea',
    'ideas',
    'ids',
    'ie',
    'il',
    'im',
    'image',
    'images',
    'imap',
    'img',
    'imgs',
    'import',
    'imported',
    'imports',
    'imulus',
    'in',
    'inbox',
    'index',
    'indice',
    'info',
    'information',
    'informativo',
    'inquiry',
    'internal',
    'intranet',
    'intro',
    'investorrelations',
    'invitations',
    'invite',
    'invites',
    'io',
    'ios',
    'ip',
    'ipad',
    'iphone',
    'ipod',
    'iq',
    'ir',
    'irc',
    'is',
    'isatap',
    'issue',
    'issues',
    'it',
    'italian',
    'item',
    'items',
    'japanese',
    'java',
    'javanese',
    'javascript',
    'je',
    'jinyu',
    'jm',
    'jo',
    'job',
    'jobs',
    'join',
    'jp',
    'js',
    'json',
    'kannada',
    'ke',
    'key',
    'keys',
    'keyserver',
    'kg',
    'kh',
    'ki',
    'km',
    'kn',
    'knowledgebase',
    'korean',
    'kp',
    'kr',
    'kw',
    'ky',
    'kz',
    'la',
    'language',
    'languages',
    'last',
    'lb',
    'lc',
    'left',
    'legacy',
    'legal',
    'li',
    'lib',
    'license',
    'like',
    'liked',
    'likes',
    'link',
    'linked',
    'links',
    'list',
    'lists',
    'lk',
    'local',
    'localdomain',
    'localhost',
    'lock',
    'locked',
    'log',
    'log-in',
    'log-out',
    'log_in',
    'log_out',
    'logged',
    'login',
    'logout',
    'logs',
    'lot',
    'lr',
    'ls',
    'lt',
    'lu',
    'lv',
    'ly',
    'm',
    'ma',
    'mac',
    'macos',
    'macosx',
    'magazine',
    'mail',
    'mail1',
    'mail2',
    'mail3',
    'mail4',
    'mail5',
    'mailer',
    'mailer-daemon',
    'mailing',
    'maintenance',
    'maithili',
    'majordomo',
    'malayalam',
    'manage',
    'manager',
    'managers',
    'mandarin',
    'manual',
    'map',
    'maps',
    'marathi',
    'market',
    'marketing',
    'marketplace',
    'markets',
    'master',
    'mc',
    'md',
    'me',
    'media',
    'member',
    'members',
    'memory',
    'message',
    'messages',
    'messenger',
    'mg',
    'mh',
    'microblog',
    'microblogs',
    'migrate',
    'migrator',
    'min-nan',
    'mine',
    'mis',
    'mk',
    'ml',
    'mm',
    'mn',
    'mo',
    'mob',
    'mobile',
    'movie',
    'movies',
    'mp',
    'mp3',
    'mq',
    'mr',
    'ms',
    'msg',
    'msn',
    'mt',
    'mu',
    'music',
    'musicas',
    'mv',
    'mw',
    'mx',
    'my',
    'mysql',
    'mz',
    'na',
    'name',
    'named',
    'names',
    'namespace',
    'namespaces',
    'nan',
    'navi',
    'navigation',
    'nc',
    'ne',
    'net',
    'network',
    'new',
    'news',
    'newsletter',
    'next',
    'nf',
    'ng',
    'ni',
    'nick',
    'nickname',
    'nl',
    'no',
    'no-reply',
    'nobody',
    'noc',
    'noreply',
    'notes',
    'noticias',
    'notification',
    'notifications',
    'notify',
    'np',
    'nr',
    'ns',
    'ns1',
    'ns10',
    'ns2',
    'ns3',
    'ns4',
    'ns5',
    'ns6',
    'ns7',
    'ns8',
    'ns9',
    'nu',
    'null',
    'nz',
    'oauth',
    'oauth_clients',
    'offer',
    'offers',
    'office',
    'officeadmin',
    'official',
    'old',
    'om',
    'online',
    'open',
    'opened',
    'openid',
    'operations',
    'operator',
    'ops',
    'order',
    'orders',
    'organization',
    'organizations',
    'orgs',
    'oriya',
    'os',
    'osx',
    'overview',
    'owner',
    'owners',
    'pa',
    'package',
    'page',
    'pager',
    'pages',
    'panel',
    'panjabi',
    'passwd',
    'password',
    'passwords',
    'patch',
    'pay',
    'payment',
    'payments',
    'pdf',
    'pdfs',
    'pe',
    'perl',
    'personal',
    'pf',
    'pg',
    'pgp',
    'ph',
    'photo',
    'photoalbum',
    'photos',
    'php',
    'pic',
    'pics',
    'ping',
    'pk',
    'pl',
    'plan',
    'plans',
    'play',
    'plugin',
    'plugins',
    'pm',
    'pn',
    'policies',
    'policy',
    'polish',
    'pop',
    'pop3',
    'popular',
    'portal',
    'portuguese',
    'post',
    'postbox',
    'postfix',
    'postmaster',
    'posts',
    'pr',
    'premium',
    'present',
    'president',
    'press',
    'price',
    'pricing',
    'prime',
    'principal',
    'privacy',
    'privacy-policy',
    'privacy_policy',
    'privacypolicy',
    'private',
    'proc',
    'prod',
    'product',
    'production',
    'products',
    'profile',
    'profiles',
    'project',
    'projects',
    'promo',
    'ps',
    'pt',
    'pub',
    'public',
    'push',
    'put',
    'pw',
    'py',
    'python',
    'qa',
    'query',
    'queue',
    'quota',
    'random',
    'ranking',
    're',
    'read',
    'readme',
    'recent',
    'reception',
    'recover',
    'recovery',
    'recruit',
    'recruiting',
    'recruitment',
    'refund',
    'refunds',
    'register',
    'registration',
    'release',
    'releases',
    'remember',
    'remote',
    'remove',
    'removed',
    'replies',
    'reply',
    'report',
    'reported',
    'reports',
    'repositories',
    'repository',
    'req',
    'request',
    'requests',
    'res',
    'reset',
    'reset-password',
    'reset_password',
    'resetpassword',
    'resource',
    'resources',
    'restore',
    'restored',
    'result',
    'results',
    'return',
    'returns',
    'revert',
    'review',
    'reviewed',
    'reviews',
    'right',
    'ro',
    'robot',
    'robots',
    'romanian',
    'root',
    'rs',
    'rss',
    'ru',
    'ruby',
    'rule',
    'rules',
    'russian',
    'rw',
    'sa',
    'sale',
    'sales',
    'sample',
    'samples',
    'save',
    'saved',
    'sb',
    'sc',
    'scan',
    'scanning',
    'school',
    'schooloffice',
    'script',
    'scripts',
    'sd',
    'se',
    'search',
    'searched',
    'secret',
    'secretary',
    'secrets',
    'secure',
    'security',
    'self',
    'send',
    'sent',
    'serbo-croatian',
    'serve',
    'server',
    'server-info',
    'server-status',
    'servers',
    'service',
    'services',
    'session',
    'sessions',
    'setting',
    'settings',
    'setup',
    'sftp',
    'sg',
    'sh',
    'share',
    'shared',
    'shares',
    'sharing',
    'shop',
    'shopping',
    'show',
    'si',
    'sign-in',
    'sign-up',
    'sign_in',
    'sign_up',
    'signin',
    'signout',
    'signup',
    'sindhi',
    'site',
    'sitemap',
    'sites',
    'sj',
    'sk',
    'sl',
    'sm',
    'smb',
    'smtp',
    'sn',
    'so',
    'sony',
    'soporte',
    'source',
    'sources',
    'spam',
    'spanish',
    'spec',
    'special',
    'specs',
    'sql',
    'sr',
    'src',
    'ss',
    'ssh',
    'ssl',
    'ssl-admin',
    'ssladmin',
    'ssladministrator',
    'sslwebmaster',
    'st',
    'stacks',
    'staff',
    'stage',
    'staging',
    'star',
    'starred',
    'stars',
    'start',
    'stat',
    'state',
    'static',
    'statistics',
    'stats',
    'status',
    'statuses',
    'storage',
    'store',
    'stores',
    'stories',
    'style',
    'styleguide',
    'styles',
    'stylesheet',
    'stylesheets',
    'su',
    'subdomain',
    'subscribe',
    'subscribed',
    'subscribers',
    'subscriptions',
    'sunda',
    'suporte',
    'support',
    'support-details',
    'supportdetails',
    'survey',
    'sv',
    'svn',
    'sy',
    'sys',
    'sysadmin',
    'sysadministrator',
    'system',
    'sz',
    'tablet',
    'tablets',
    'tag',
    'tags',
    'talk',
    'tamil',
    'task',
    'tasks',
    'tc',
    'td',
    'team',
    'teams',
    'tech',
    'technologies',
    'technology',
    'telnet',
    'telugu',
    'term',
    'terms',
    'terms-of-service',
    'terms_of_service',
    'termsofservice',
    'test',
    'test1',
    'test2',
    'test3',
    'teste',
    'testing',
    'tests',
    'tf',
    'tg',
    'th',
    'thai',
    'theme',
    'themes',
    'theoffice',
    'thread',
    'threads',
    'timeline',
    'tj',
    'tk',
    'tl',
    'tls',
    'tm',
    'tmp',
    'tn',
    'to',
    'todo',
    'token',
    'tokens',
    'tokenserver',
    'tool',
    'tools',
    'top',
    'topic',
    'topics',
    'tos',
    'tour',
    'tp',
    'tr',
    'translations',
    'trash',
    'trending',
    'trends',
    'trial',
    'trials',
    'tt',
    'turkish',
    'tutorial',
    'tv',
    'tw',
    'twitter',
    'txt',
    'tz',
    'ua',
    'ug',
    'ui',
    'uk',
    'ukrainian',
    'unavailable',
    'undef',
    'unfollow',
    'unread',
    'unsubscribe',
    'unsupported',
    'update',
    'updated',
    'upgrade',
    'upload',
    'uploaded',
    'uploads',
    'uptime',
    'urdu',
    'url',
    'us',
    'usage',
    'usenet',
    'user',
    'username',
    'users',
    'usr',
    'usuario',
    'util',
    'uucp',
    'ux',
    'uy',
    'uz',
    'va',
    'vault',
    'vc',
    've',
    'vendas',
    'vendor',
    'ver',
    'version',
    'vg',
    'vi',
    'vicepresident',
    'video',
    'videos',
    'vietnamese',
    'view',
    'views',
    'visitor',
    'vn',
    'vp',
    'vpn',
    'vu',
    'wallet',
    'warranty',
    'watch',
    'weather',
    'web',
    'webmail',
    'webmaster',
    'webmasters',
    'website',
    'websites',
    'welcome',
    'wf',
    'widget',
    'widgets',
    'wiki',
    'win',
    'windows',
    'wishlist',
    'work',
    'workplace',
    'works',
    'workshop',
    'wpad',
    'ws',
    'wu',
    'ww',
    'wws',
    'www',
    'www1',
    'www2',
    'www3',
    'www4',
    'www5',
    'www6',
    'www7',
    'wwws',
    'wwww',
    'x',
    'xfn',
    'xiang',
    'xml',
    'xmpp',
    'xpg',
    'xss',
    'xx',
    'xxx',
    'yahoo',
    'yaml',
    'ye',
    'year',
    'yes',
    'yml',
    'yoruba',
    'you',
    'yourdomain',
    'yourname',
    'yoursite',
    'yourusername',
    'yt',
    'yu',
    'za',
    'zip',
    'zm',
    'zuck',
    'zw'
  };

  /// Checks whether the [localPart] is a commonly reserved email address.
  /// (e.g. `postmaster` or `admin`).
  static bool isReserved(String localPart) => reserved.contains(localPart);
}
