import 'package:flutter/material.dart';

class AddExerciseTextArea extends StatelessWidget {
  AddExerciseTextArea({
    super.key,
    required this.title,
    ValueChanged<String>? onChange,
    this.helperText = '',
    this.isMultiline = false,
    this.initialValue = '',
    this.validator,
    this.onSaved,
  }) : onChange = onChange ?? ((String value) {});

  final ValueChanged<String> onChange;
  final bool isMultiline;
  final String title;
  final String helperText;
  final String? initialValue;
  final FormFieldValidator<String?>? validator;
  final FormFieldSetter<String?>? onSaved;

  static const MULTILINE_MIN_LINES = 4;
  static const DEFAULT_LINES = 1;

  @override
  Widget build(BuildContext context) {
    return Padding(
      padding: const EdgeInsets.all(8.0),
      child: TextFormField(
        initialValue: initialValue,
        keyboardType: isMultiline ? TextInputType.multiline : TextInputType.text,
        maxLines: isMultiline ? null : DEFAULT_LINES,
        minLines: isMultiline ? MULTILINE_MIN_LINES : DEFAULT_LINES,
        validator: validator,
        onSaved: onSaved,
        decoration: InputDecoration(
          contentPadding: const EdgeInsets.symmetric(horizontal: 10, vertical: 10),
          border: const OutlineInputBorder(borderRadius: BorderRadius.all(Radius.circular(10))),
          labelText: title,
          alignLabelWithHint: true,
          helperText: helperText,
          helperMaxLines: 3,
        ),
        onChanged: onChange,
      ),
    );
  }
}
