/*
 * This file is part of wger Workout Manager <https://github.com/wger-project>.
 * Copyright (c) 2020 - 2026 wger Team
 *
 * wger Workout Manager is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

import 'package:flutter/material.dart';
import 'package:provider/provider.dart';
import 'package:wger/core/wide_screen_wrapper.dart';
import 'package:wger/providers/routines.dart';
import 'package:wger/widgets/core/app_bar.dart';
import 'package:wger/widgets/routines/logs/log_overview_routine.dart';

class WorkoutLogsScreen extends StatelessWidget {
  const WorkoutLogsScreen();

  static const routeName = '/workout-logs';

  @override
  Widget build(BuildContext context) {
    final routineId = ModalRoute.of(context)!.settings.arguments as int;
    final routine = Provider.of<RoutinesProvider>(context).findById(routineId);

    return Scaffold(
      appBar: EmptyAppBar(routine.name),
      body: WidescreenWrapper(child: WorkoutLogs(routine)),
    );
  }
}
