// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Chinese (`zh`).
class AppLocalizationsZh extends AppLocalizations {
  AppLocalizationsZh([String locale = 'zh']) : super(locale);

  @override
  String get userProfile => '个人资料';

  @override
  String get login => '登录';

  @override
  String get logout => '退出';

  @override
  String get register => '注册';

  @override
  String get useDefaultServer => '默认服务器';

  @override
  String get useCustomServer => '自定义服务器';

  @override
  String get invalidUrl => '请输入服务器地址';

  @override
  String get usernameValidChars => '用户名应至少包含字符，数字和特殊字符@+.-_';

  @override
  String get passwordsDontMatch => '密码和用户名不匹配';

  @override
  String get passwordTooShort => '密码长度不够';

  @override
  String get selectAvailablePlates => '选择可用的杠片';

  @override
  String get barWeight => '杠铃重量';

  @override
  String get useColors => '使用颜色';

  @override
  String get password => '密码';

  @override
  String get confirmPassword => '重新输入密码';

  @override
  String get invalidEmail => '请输入正确的邮箱地址';

  @override
  String get email => '邮箱';

  @override
  String get username => '用户名';

  @override
  String get invalidUsername => '请输入正确的用户名';

  @override
  String get useApiToken => '使用API密钥';

  @override
  String get useUsernameAndPassword => '使用用户名与密码';

  @override
  String get apiToken => 'API密钥';

  @override
  String get invalidApiToken => '请输入有效API值';

  @override
  String get apiTokenValidChars => 'API 密钥只能包含字母 a-f、数字 0-9，长度为 40 个字符';

  @override
  String get customServerUrl => '服务器地址';

  @override
  String get customServerHint => '请输入要连接的服务器地址';

  @override
  String get reset => '重置';

  @override
  String get registerInstead => '没有帐户？点击注册';

  @override
  String get loginInstead => '已经有帐号了吗？立即登入';

  @override
  String get labelBottomNavWorkout => '锻炼';

  @override
  String get labelBottomNavNutrition => '饮食';

  @override
  String get labelWorkoutLogs => '锻炼记录';

  @override
  String get labelWorkoutPlan => '锻炼计划';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => '主页';

  @override
  String get success => '成功';

  @override
  String get successfullyDeleted => '已删除';

  @override
  String get successfullySaved => '已保存';

  @override
  String get exerciseList => '锻炼清单';

  @override
  String get exercise => '锻炼';

  @override
  String get exercises => '锻炼项目';

  @override
  String get exerciseName => '锻炼名';

  @override
  String get searchExercise => '搜索';

  @override
  String get noIngredientsDefined => '还没有定义配料';

  @override
  String get noMatchingExerciseFound => '未找到匹配的锻炼';

  @override
  String get searchNamesInEnglish => '同时搜索英文名称';

  @override
  String get equipment => '器材';

  @override
  String get muscles => '主要部位';

  @override
  String get musclesSecondary => '次要部位';

  @override
  String get category => '类别';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => '训练计划';

  @override
  String get newRoutine => '新计划';

  @override
  String get noRoutines => '你没有训练计划';

  @override
  String get reps => '重复次数';

  @override
  String get restTime => '休息时间';

  @override
  String get sets => '组';

  @override
  String get rir => '保留次数';

  @override
  String get rirNotUsed => '保留次数未储存';

  @override
  String get useMetric => '使用公制单位表示体重';

  @override
  String get weightUnit => '重量单位';

  @override
  String get repetitionUnit => '计数单位';

  @override
  String get set => '设置';

  @override
  String get dayDescriptionHelp => '起个名称，可以填写锻炼项目或者锻炼的身体部位';

  @override
  String exerciseNr(String nr) {
    return '练习$nr';
  }

  @override
  String supersetNr(String nr) {
    return '特别组$nr';
  }

  @override
  String get sameRepetitions =>
      '如果您对所有组别进行相同的重复次数和重量，则只需填写一行即可。例如，对于 4 组，只需输入 10 次重复，这会自动变成「4 x 10」。';

  @override
  String get comment => '评论';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => '自我感觉';

  @override
  String get notes => '笔记';

  @override
  String get workoutSession => '健身记录';

  @override
  String get restDay => '休息日';

  @override
  String get isRestDay => '是休息日';

  @override
  String get isRestDayHelp => '请注意，当您将某天标记为休息日时，所有的组数和练习都将被删除。';

  @override
  String get needsLogsToAdvance => '需要日志以前进';

  @override
  String get needsLogsToAdvanceHelp => '选择您是否希望只有在当天记录了锻炼后，训练计划才会进入下一个计划日';

  @override
  String get routineDays => '计划中的天数';

  @override
  String get resultingRoutine => '最终生成的训练计划';

  @override
  String get newDay => '训练日';

  @override
  String get newSet => '新增训练日';

  @override
  String get selectExercises => '可以搜索多个练习项目，组成混合训练';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => '健身房模式';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => '圈';

  @override
  String get plateCalculatorNotDivisible => '达不到预定重量';

  @override
  String get pause => '暂停';

  @override
  String get jumpTo => '转到';

  @override
  String get todaysWorkout => '锻炼项目';

  @override
  String get logHelpEntries => '如果一天内有多个相同重复次数但重量不同的条目，图表只会显示重量较高的条目。';

  @override
  String get logHelpEntriesUnits => '请注意，系统只会绘制带重量单位（公斤或磅）和重复次数的纪录，其他组合（例如时间或直到力竭）将被忽略。';

  @override
  String get description => '描述';

  @override
  String get name => '名称';

  @override
  String get save => '保存';

  @override
  String get verify => '确认';

  @override
  String get addSet => '增加训练项目';

  @override
  String get addMeal => '增加用餐';

  @override
  String get mealLogged => '用餐情况保存到日记中';

  @override
  String get ingredientLogged => '记录在日记中的成分';

  @override
  String get logMeal => '记录用餐';

  @override
  String get addIngredient => '添加营养成分';

  @override
  String get logIngredient => '记录食材至营养日志';

  @override
  String get searchIngredient => '搜索营养成分';

  @override
  String get nutritionalPlan => '饮食计划';

  @override
  String get nutritionalDiary => '摄食日记';

  @override
  String get nutritionalPlans => '营养规划';

  @override
  String get noNutritionalPlans => '您还没有设定营养规划';

  @override
  String get onlyLogging => '只记录卡路里';

  @override
  String get onlyLoggingHelpText => '如果你只想记录你的卡路里，而不想为特定的膳食制定详细的营养计划，请勾选此复选框';

  @override
  String get goalMacro => '宏观目标';

  @override
  String get selectMealToLog => '选择一顿饭记在日记里';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet => '你当前的营养计划中没有设定任何餐食';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails => '若要为营养计划添加餐食，请前往营养计划详情页面';

  @override
  String get goalEnergy => '能量目标';

  @override
  String get goalProtein => '蛋白质目标';

  @override
  String get goalCarbohydrates => '碳水化合物目标';

  @override
  String get goalFat => '脂肪目标';

  @override
  String get goalFiber => '纤维素目标';

  @override
  String get anErrorOccurred => '出错了!';

  @override
  String get errorInfoDescription => '很抱歉，出现了一些问题。您可以通过在 GitHub 上报告此问题来帮助我们修复它。';

  @override
  String get errorInfoDescription2 => '您可以继续使用这款应用，但部分功能可能无法正常运行。';

  @override
  String get errorViewDetails => '错误技术详情';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => '无法连接到服务器';

  @override
  String get errorCouldNotConnectToServerDetails =>
      '应用程序无法连接到服务器。请检查您的网络连接或服务器网址，然后重试。如果问题持续存在，请联系服务器管理员。';

  @override
  String get copyToClipboard => '复制';

  @override
  String get weight => '重量';

  @override
  String get min => '分钟';

  @override
  String get max => '最大';

  @override
  String chartAllTimeTitle(String name) {
    return '$name 历史记录曲线';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name 过去三十天';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName 在计划 \"$planName\" 期间的改变曲线';
  }

  @override
  String get measurement => '测量';

  @override
  String get measurements => '测量值';

  @override
  String get measurementCategoriesHelpText => '测量类别，例如“二头肌”或“体脂”';

  @override
  String get measurementEntriesHelpText => '用于测量类别的单位，例如「cm」或「%」';

  @override
  String get date => '日期';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => '数值';

  @override
  String get start => '开始';

  @override
  String get time => '时间';

  @override
  String get timeStart => '开始时间';

  @override
  String get timeEnd => '结束时间';

  @override
  String get timeStartAhead => '开始时间不能早于结束时间';

  @override
  String get ingredient => '营养成分';

  @override
  String get energy => '热量';

  @override
  String get energyShort => '热量';

  @override
  String get macronutrients => '常量营养元素';

  @override
  String get planned => '过去计划';

  @override
  String get logged => '已记录';

  @override
  String get today => '今天';

  @override
  String get loggedToday => '今天的记录';

  @override
  String get weekAverage => '7天平均';

  @override
  String get surplus => '剩余';

  @override
  String get deficit => '不足额';

  @override
  String get difference => '差异';

  @override
  String get percentEnergy => '每日能量百分比';

  @override
  String get gPerBodyKg => '克每千克体重';

  @override
  String get total => '总共';

  @override
  String get kcal => '千卡';

  @override
  String kcalValue(String value) {
    return '$value 千卡';
  }

  @override
  String get kJ => '千焦';

  @override
  String get g => '克';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => '蛋白质';

  @override
  String get proteinShort => '蛋白质';

  @override
  String get carbohydrates => '碳水化合物';

  @override
  String get carbohydratesShort => '碳水化合物';

  @override
  String get sugars => '糖';

  @override
  String get fat => '脂肪';

  @override
  String get fatShort => '脂肪';

  @override
  String get saturatedFat => '饱和脂肪';

  @override
  String get fiber => '纤维';

  @override
  String get sodium => '钠';

  @override
  String get amount => '数量';

  @override
  String get unit => '单位';

  @override
  String get newEntry => '新增';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => '您还没有记录过体重';

  @override
  String get noMeasurementEntries => '您没有测量条目';

  @override
  String get moreMeasurementEntries => '添加新围度';

  @override
  String get edit => '编辑';

  @override
  String get loadingText => '加载中...';

  @override
  String get delete => '删除';

  @override
  String confirmDelete(String toDelete) {
    return '你确定要删除 \'$toDelete\'吗?';
  }

  @override
  String get newNutritionalPlan => '新增营养规划';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => '查看更多';

  @override
  String get goToDetailPage => '查看详细信息';

  @override
  String get aboutWhySupportTitle => '开源 & 免费使用';

  @override
  String get aboutDescription => '感谢您使用wger！ wger 是一个协作开源项目，由来自世界各地的健身爱好者创建。';

  @override
  String get aboutDonateTitle => '进行捐赠';

  @override
  String get aboutDonateText =>
      '尽管该项目是免费的，且将始终保持免费，但服务器的运营并非如此！开发工作也需要志愿者投入大量的时间和精力。您的捐赠将直接用于支付这些成本，助力维持服务的稳定可靠。';

  @override
  String get aboutContributeTitle => '贡献';

  @override
  String get aboutContributeText => '我们鼓励各种形式的贡献。无论您是开发者、翻译人员，还是单纯热爱健身的人士，每一份支持都值得我们由衷感谢！';

  @override
  String get aboutBugsListTitle => '报告问题或提出功能建议';

  @override
  String get aboutTranslationListTitle => '翻译此软件';

  @override
  String get aboutSourceListTitle => '查看源代码';

  @override
  String get aboutJoinCommunityTitle => '加入社区';

  @override
  String get aboutMastodonTitle => '长毛象';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => '其他';

  @override
  String get calendar => '日历';

  @override
  String get goToToday => '今天';

  @override
  String get enterValue => '必填项';

  @override
  String get selectEntry => '请选择一项';

  @override
  String get selectExercise => '请选择一个锻炼项目';

  @override
  String enterCharacters(String min, String max) {
    return '最短长度是$min 位，最长 $max位';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return '请输入最少$min个字符';
  }

  @override
  String get baseNameEnglish => '所有运动需要一个英文代号';

  @override
  String nrOfSets(String nrOfSets) {
    return '锻炼次数: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => '设置计量单位和组内重复次数';

  @override
  String get enterValidNumber => '请输入有效数值';

  @override
  String get selectIngredient => '请选择一个营养成分';

  @override
  String get recentlyUsedIngredients => '最近添加的饮食';

  @override
  String get selectImage => '请选择一张图片';

  @override
  String get optionsLabel => '设置';

  @override
  String get takePicture => '拍照';

  @override
  String get chooseFromLibrary => '选一张';

  @override
  String get gallery => '图记';

  @override
  String get addImage => '增加一张图片';

  @override
  String get dataCopied => '数据已添加';

  @override
  String get appUpdateTitle => '需要更新';

  @override
  String get appUpdateContent => '此版本的应用程序与服务器端不符，请更新应用程序。';

  @override
  String get productFound => '产品已发现';

  @override
  String productFoundDescription(String productName) {
    return '此条码对应这产品：$productName。您想继续吗？';
  }

  @override
  String get productNotFound => '产品未发现';

  @override
  String productNotFoundDescription(String barcode) {
    return '条形码$barcode的产品不在wger数据库中';
  }

  @override
  String get scanBarcode => '扫描条形码';

  @override
  String get close => '关闭';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license => '图像必须符合 CC BY-SA 知识共享许可。如果你不太确定，那请仅上传你自己拍摄的照片。';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => '变式';

  @override
  String alsoKnownAs(String aliases) {
    return '又名：$aliases';
  }

  @override
  String get verifiedEmail => '已验证的邮箱';

  @override
  String get unVerifiedEmail => '未验证的邮箱';

  @override
  String get verifiedEmailReason => '你需要验证邮箱来参与贡献';

  @override
  String verifiedEmailInfo(String email) {
    return '验证邮件已经发往$email';
  }

  @override
  String get alternativeNames => '別称';

  @override
  String get oneNamePerLine => '每行一个名字';

  @override
  String get whatVariationsExist => '这个动作有什么变体吗？';

  @override
  String get previous => '前';

  @override
  String get next => '后';

  @override
  String get images => '图像';

  @override
  String get language => '语言';

  @override
  String get addExercise => '添加动作';

  @override
  String get fitInWeek => '一周健身计划';

  @override
  String get fitInWeekHelp => '如果启用，天数将以周为周期重复，否则天数将依次重复，而不考虑新一周的开始。';

  @override
  String get addSuperset => '增加超级组';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => '此组已经有训练进度';

  @override
  String get setHasProgressionWarning => '请注意，目前还无法在移动应用程序上编辑一个设置的所有设置，也无法配置自动升级。目前，请使用Web应用程序。';

  @override
  String get setHasNoExercises => '此训练组还没有任何练习！';

  @override
  String get contributeExercise => '贡献一个动作';

  @override
  String get translation => '翻译';

  @override
  String get translateExercise => '翻译该动作';

  @override
  String get baseData => '英文基础动作';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => '设置';

  @override
  String get settingsCacheTitle => '缓存';

  @override
  String get settingsExerciseCacheDescription => '动作缓存';

  @override
  String get settingsIngredientCacheDescription => '营养成分缓存';

  @override
  String get settingsCacheDeletedSnackbar => '成功清除缓存';

  @override
  String get aboutPageTitle => '关于我们&支持';

  @override
  String contributeExerciseWarning(String days) {
    return '账号注册$days天且邮箱验证通过后，你方可贡献动作';
  }

  @override
  String get simpleMode => '简易模式';

  @override
  String get simpleModeHelp => '在编辑练习时隐藏更多高级设置';

  @override
  String get progressionRules => '此练习有进度规则，无法在移动应用程序上编辑。请使用Web应用程序编辑此练习。';

  @override
  String get cacheWarning => '由于缓存，申请中的变动或需一段时间方可呈现。';

  @override
  String get textPromptTitle => '准备就绪？';

  @override
  String get textPromptSubheading => '点击右下角按钮开始';

  @override
  String get abs => '腹肌';

  @override
  String get arms => '手臂';

  @override
  String get back => '背';

  @override
  String get barbell => '杠铃';

  @override
  String get bench => '凳';

  @override
  String get biceps => '肱二头肌';

  @override
  String get body_weight => '体重';

  @override
  String get calves => '小腿';

  @override
  String get cardio => '有氧';

  @override
  String get chest => '胸';

  @override
  String get dumbbell => '哑铃';

  @override
  String get glutes => '臀';

  @override
  String get gym_mat => '健身垫';

  @override
  String get hamstrings => '大腿后侧';

  @override
  String get incline_bench => '上斜凳';

  @override
  String get kettlebell => '壶铃';

  @override
  String get kilometers => '公里';

  @override
  String get kilometers_per_hour => '千米每小时';

  @override
  String get lats => '背阔肌';

  @override
  String get legs => '腿';

  @override
  String get lower_back => '下背';

  @override
  String get max_reps => '最大次数';

  @override
  String get miles => '英里';

  @override
  String get miles_per_hour => '迈';

  @override
  String get minutes => '分钟';

  @override
  String get plates => '盘';

  @override
  String get pull_up_bar => '引体向上杆';

  @override
  String get quads => '大腿前侧';

  @override
  String get repetitions => '重复次数';

  @override
  String get resistance_band => '弹力带';

  @override
  String get sz_bar => 'W型曲杆';

  @override
  String get seconds => '秒';

  @override
  String get shoulders => '肩';

  @override
  String get swiss_ball => '瑜伽球';

  @override
  String get triceps => '肱三头肌';

  @override
  String get until_failure => '直至力竭';

  @override
  String get kg => '千克';

  @override
  String get lb => '磅';

  @override
  String get none__bodyweight_exercise_ => '无（自重动作）';

  @override
  String get log => '记录';

  @override
  String get done => '完成';

  @override
  String get overallChangeWeight => '总体变化';

  @override
  String get goalTypeMeals => '从饮食出发';

  @override
  String get goalTypeBasic => '基础';

  @override
  String get goalTypeAdvanced => '进阶';

  @override
  String get indicatorRaw => '原始值';

  @override
  String get indicatorAvg => '平均值';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => '主题模式';

  @override
  String get darkMode => '总是暗色模式';

  @override
  String get lightMode => '总是亮色模式';

  @override
  String get systemMode => '系统设置';
}

/// The translations for Chinese, using the Han script (`zh_Hant`).
class AppLocalizationsZhHant extends AppLocalizationsZh {
  AppLocalizationsZhHant() : super('zh_Hant');

  @override
  String get userProfile => '你的檔案';

  @override
  String get login => '登入';

  @override
  String get logout => '登出';

  @override
  String get register => '註冊';

  @override
  String get useDefaultServer => '使用預設伺服器';

  @override
  String get useCustomServer => '使用自訂伺服器';

  @override
  String get invalidUrl => '請輸入有效的 URL';

  @override
  String get usernameValidChars => '使用者名稱只能包含字母、數字，以及 @、+、.、-、_ 等符號';

  @override
  String get passwordsDontMatch => '密碼不一致';

  @override
  String get passwordTooShort => '密碼過短';

  @override
  String get password => '密碼';

  @override
  String get confirmPassword => '確認密碼';

  @override
  String get invalidEmail => '請輸入有效的電子郵件地址';

  @override
  String get email => '電子郵件地址';

  @override
  String get username => '使用者名稱';

  @override
  String get invalidUsername => '請輸入有效的使用者名稱';

  @override
  String get customServerUrl => 'wger 服務的 URL';

  @override
  String get customServerHint => '輸入您自架的伺服器位址，否則將使用預設伺服器';

  @override
  String get reset => '重設';

  @override
  String get registerInstead => '還沒有帳號嗎？現在就註冊吧';

  @override
  String get loginInstead => '已經有帳號了嗎？立即登入';

  @override
  String get labelBottomNavWorkout => '健身';

  @override
  String get labelBottomNavNutrition => '營養';

  @override
  String get labelWorkoutLogs => '訓練記錄';

  @override
  String get labelWorkoutPlan => '健身計劃';

  @override
  String get labelDashboard => '儀表板';

  @override
  String get success => '成功';

  @override
  String get successfullyDeleted => '已刪除';

  @override
  String get successfullySaved => '已儲存';

  @override
  String get exerciseList => '動作清單';

  @override
  String get exercise => '動作';

  @override
  String get exercises => '動作';

  @override
  String get exerciseName => '動作名稱';

  @override
  String get searchExercise => '搜尋待加入的動作';

  @override
  String get noIngredientsDefined => '尚未定義食材';

  @override
  String get noMatchingExerciseFound => '沒有找到符合的動作項目';

  @override
  String get searchNamesInEnglish => '也搜尋英文名稱';

  @override
  String get equipment => '器材';

  @override
  String get muscles => '主要肌群';

  @override
  String get musclesSecondary => '輔助肌群';

  @override
  String get category => '類別';

  @override
  String get reps => '次';

  @override
  String get rir => '保留次數';

  @override
  String get rirNotUsed => '未使用保留次數';

  @override
  String get useMetric => '用公制單位表示體重';

  @override
  String get weightUnit => '重量單位';

  @override
  String get repetitionUnit => '重複次數單位';

  @override
  String get set => '組';

  @override
  String get dayDescriptionHelp => '描述這一天做了什麼（例如：拉力日）或訓練了哪些部位（例如：胸部和肩膀）';

  @override
  String get sameRepetitions =>
      '如果您對所有組別進行相同的重複次數和重量，則只需填寫一行即可。例如，4 組每組 10 下，只要輸入 10 次重複，系統會自動變成「4 x 10」。';

  @override
  String get comment => '註解';

  @override
  String get impression => '感受';

  @override
  String get notes => '筆記';

  @override
  String get workoutSession => '健身（節）';

  @override
  String get newDay => '新的一天';

  @override
  String get newSet => '新增一組';

  @override
  String get selectExercises => '如果您想進行超級組訓練，您可以搜尋多個動作項目，它們會被組合在一起';

  @override
  String get gymMode => '健身房模式';

  @override
  String get plateCalculator => '槓片';

  @override
  String get plateCalculatorNotDivisible => '沒有足夠的槓片達到目標重量';

  @override
  String get pause => '休息';

  @override
  String get jumpTo => '跳到';

  @override
  String get todaysWorkout => '今天的訓練';

  @override
  String get logHelpEntries => '如果同一天有多筆相同重複次數但不同重量的紀錄，圖表只會顯示重量較重的那筆紀錄。';

  @override
  String get logHelpEntriesUnits => '請注意，圖表只會顯示包含重量單位（公斤或磅）和重複次數的紀錄，其他組合（例如時間或直到力竭）不會被顯示。';

  @override
  String get description => '描述';

  @override
  String get name => '名稱';

  @override
  String get save => '儲存';

  @override
  String get verify => '驗證';

  @override
  String get addSet => '新增一組';

  @override
  String get addMeal => '新增餐點';

  @override
  String get mealLogged => '餐點已紀錄到日記';

  @override
  String get ingredientLogged => '食材已紀錄到日記';

  @override
  String get logMeal => '紀錄餐點到營養日記';

  @override
  String get addIngredient => '新增食材';

  @override
  String get logIngredient => '紀錄食材到營養日記';

  @override
  String get searchIngredient => '搜尋食材';

  @override
  String get nutritionalPlan => '營養計劃';

  @override
  String get nutritionalDiary => '營養日記';

  @override
  String get nutritionalPlans => '營養計劃';

  @override
  String get noNutritionalPlans => '您沒有營養計劃';

  @override
  String get onlyLogging => '僅追蹤卡路里';

  @override
  String get onlyLoggingHelpText => '如果您只想紀錄卡路里但不想設定詳細的營養計劃和特定餐點，請勾選此項';

  @override
  String get goalMacro => '巨量營養素目標';

  @override
  String get selectMealToLog => '選擇要紀錄到日記的餐點';

  @override
  String get goalEnergy => '熱量目標';

  @override
  String get goalProtein => '蛋白質目標';

  @override
  String get goalCarbohydrates => '碳水化合物目標';

  @override
  String get goalFat => '脂肪目標';

  @override
  String get goalFiber => '纖維目標';

  @override
  String get anErrorOccurred => '發生錯誤！';

  @override
  String get errorCouldNotConnectToServerDetails => '無法連接到伺服器';

  @override
  String get copyToClipboard => '複製到剪貼簿';

  @override
  String get weight => '重量';

  @override
  String chartAllTimeTitle(String name) {
    return '$name 歷史紀錄';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name 最近 30 天';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '營養計劃 $planName 期間的 $chartName';
  }

  @override
  String get measurement => '測量';

  @override
  String get measurements => '測量項目';

  @override
  String get measurementCategoriesHelpText => '測量類別，例如「二頭肌」或「體脂率」';

  @override
  String get measurementEntriesHelpText => '用於測量該類別的單位，例如「公分」或「%」';

  @override
  String get date => '日期';

  @override
  String get value => '數值';

  @override
  String get start => '開始';

  @override
  String get time => '時間';

  @override
  String get timeStart => '開始時間';

  @override
  String get timeEnd => '結束時間';

  @override
  String get timeStartAhead => '開始時間不能早於結束時間';

  @override
  String get ingredient => '食材';

  @override
  String get energy => '熱量';

  @override
  String get energyShort => '熱量';

  @override
  String get macronutrients => '巨量營養素';

  @override
  String get planned => '計劃';

  @override
  String get logged => '實際';

  @override
  String get today => '今天';

  @override
  String get loggedToday => '今天的紀錄';

  @override
  String get weekAverage => '七天平均值';

  @override
  String get surplus => '過剩';

  @override
  String get deficit => '不足';

  @override
  String get difference => '差異';

  @override
  String get percentEnergy => '熱量百分比';

  @override
  String get gPerBodyKg => '克/體重公斤';

  @override
  String get total => '總計';

  @override
  String get kcal => '大卡';

  @override
  String kcalValue(String value) {
    return '$value 大卡';
  }

  @override
  String get kJ => '千焦';

  @override
  String get g => '克';

  @override
  String gValue(String value) {
    return '$value 克';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => '蛋白質';

  @override
  String get proteinShort => '蛋白質';

  @override
  String get carbohydrates => '碳水化合物';

  @override
  String get carbohydratesShort => '碳水';

  @override
  String get sugars => '糖分';

  @override
  String get fat => '脂肪';

  @override
  String get fatShort => '脂肪';

  @override
  String get saturatedFat => '飽和脂肪';

  @override
  String get fiber => '纖維';

  @override
  String get sodium => '鈉';

  @override
  String get amount => '份量';

  @override
  String get unit => '單位';

  @override
  String get newEntry => '新增紀錄';

  @override
  String get noWeightEntries => '您沒有體重紀錄';

  @override
  String get noMeasurementEntries => '您沒有測量紀錄';

  @override
  String get moreMeasurementEntries => '新增測量紀錄';

  @override
  String get edit => '編輯';

  @override
  String get loadingText => '載入中...';

  @override
  String get delete => '刪除';

  @override
  String confirmDelete(String toDelete) {
    return '您確定要刪除「$toDelete」嗎？';
  }

  @override
  String get newNutritionalPlan => '新的營養計劃';

  @override
  String get toggleDetails => '切換詳細資訊';

  @override
  String get goToDetailPage => '前往詳細資訊頁面';

  @override
  String get aboutWhySupportTitle => '開源且免費使用❤️';

  @override
  String get aboutDescription => '感謝您使用 wger！wger 是一個協作式開源專案，由來自世界各地的健身愛好者共同打造。';

  @override
  String get aboutDonateTitle => '贊助';

  @override
  String get aboutDonateText => '請我們喝杯咖啡來支持專案、支付伺服器費用，讓我們持續前進';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get calendar => '日曆';

  @override
  String get goToToday => '回到今天';

  @override
  String get enterValue => '請輸入數值';

  @override
  String get selectEntry => '請選擇一個項目';

  @override
  String get selectExercise => '請選擇一個動作';

  @override
  String enterCharacters(String min, String max) {
    return '請輸入 $min 到 $max 個字元';
  }

  @override
  String enterMinCharacters(String min) {
    return '請輸入至少 $min 個字元';
  }

  @override
  String get baseNameEnglish => '所有動作都需要一個英文基本名稱';

  @override
  String nrOfSets(String nrOfSets) {
    return '每個動作的組數：$nrOfSets';
  }

  @override
  String get setUnitsAndRir => '設定單位和保留次數';

  @override
  String get enterValidNumber => '請輸入有效數字';

  @override
  String get selectIngredient => '請選擇一個食材';

  @override
  String get recentlyUsedIngredients => '最近新增的食材';

  @override
  String get selectImage => '請選擇圖片';

  @override
  String get optionsLabel => '選項';

  @override
  String get takePicture => '拍照';

  @override
  String get chooseFromLibrary => '從相簿中選擇';

  @override
  String get gallery => '相簿';

  @override
  String get addImage => '新增圖片';

  @override
  String get dataCopied => '資料已複製到新紀錄';

  @override
  String get appUpdateTitle => '需要更新';

  @override
  String get appUpdateContent => '此版本的應用程式與伺服器不相容，請更新您的應用程式。';

  @override
  String get productFound => '找到產品';

  @override
  String productFoundDescription(String productName) {
    return '此條碼對應到這個產品：$productName。您要繼續嗎？';
  }

  @override
  String get productNotFound => '找不到產品';

  @override
  String productNotFoundDescription(String barcode) {
    return '在 wger 資料庫中找不到條碼為 $barcode 的產品';
  }

  @override
  String get scanBarcode => '掃描條碼';

  @override
  String get close => '關閉';

  @override
  String get add_exercise_image_license => '影像必須與 CC BY SA 授權相容。如有疑慮，請僅上傳您自己拍攝的照片。';

  @override
  String get variations => '變化';

  @override
  String alsoKnownAs(String aliases) {
    return '也稱為：$aliases';
  }

  @override
  String get verifiedEmail => '已驗證的電子郵件';

  @override
  String get unVerifiedEmail => '未驗證的電子郵件';

  @override
  String get verifiedEmailReason => '您需要驗證您的電子郵件才能貢獻動作項目';

  @override
  String verifiedEmailInfo(String email) {
    return '驗證郵件已寄送至 $email';
  }

  @override
  String get alternativeNames => '替代名稱';

  @override
  String get oneNamePerLine => '每行一個名稱';

  @override
  String get whatVariationsExist => '這個動作有哪些變化（如果有的話）？';

  @override
  String get previous => '上一個';

  @override
  String get next => '下一個';

  @override
  String get images => '圖片';

  @override
  String get language => '語言';

  @override
  String get addExercise => '新增動作';

  @override
  String get contributeExercise => '貢獻一個動作';

  @override
  String get translation => '翻譯';

  @override
  String get translateExercise => '立即翻譯此動作';

  @override
  String get baseData => '英文基本資料';

  @override
  String get settingsTitle => '設定';

  @override
  String get settingsCacheTitle => '快取';

  @override
  String get settingsExerciseCacheDescription => '動作快取';

  @override
  String get settingsIngredientCacheDescription => '食材快取';

  @override
  String get settingsCacheDeletedSnackbar => '成功清除快取';

  @override
  String get aboutPageTitle => '關於 Wger';

  @override
  String contributeExerciseWarning(String days) {
    return '只有當您的帳號已超過 $days 天且已驗證您的電子郵件時，您才能貢獻動作項目';
  }

  @override
  String get cacheWarning => '由於快取機制，變更可能需要一些時間才會在整個應用程式中顯示。';

  @override
  String get textPromptTitle => '準備開始了嗎？';

  @override
  String get textPromptSubheading => '按下動作按鈕開始';

  @override
  String get abs => '腹肌';

  @override
  String get arms => '手臂';

  @override
  String get back => '背部';

  @override
  String get barbell => '槓鈴';

  @override
  String get bench => '重訓椅';

  @override
  String get biceps => '二頭肌';

  @override
  String get body_weight => '體重';

  @override
  String get calves => '小腿肌群';

  @override
  String get cardio => '有氧運動';

  @override
  String get chest => '胸';

  @override
  String get dumbbell => '啞鈴';

  @override
  String get glutes => '臀大肌群';

  @override
  String get gym_mat => '健身墊';

  @override
  String get hamstrings => '腿後肌群';

  @override
  String get incline_bench => '上斜椅';

  @override
  String get kettlebell => '壺鈴';

  @override
  String get kilometers => '公里';

  @override
  String get kilometers_per_hour => '公里／小時';

  @override
  String get lats => '背闊肌';

  @override
  String get legs => '腿部';

  @override
  String get lower_back => '下背';

  @override
  String get max_reps => '最大次數';

  @override
  String get miles => '英里';

  @override
  String get miles_per_hour => '英里／小時';

  @override
  String get minutes => '分鐘';

  @override
  String get plates => '槓片';

  @override
  String get pull_up_bar => '引體向上桿';

  @override
  String get quads => '股四頭肌';

  @override
  String get repetitions => '次數';

  @override
  String get sz_bar => '彎曲槓';

  @override
  String get seconds => '秒';

  @override
  String get shoulders => '肩膀';

  @override
  String get swiss_ball => '瑜伽球';

  @override
  String get triceps => '三頭肌';

  @override
  String get until_failure => '直到力竭';

  @override
  String get kg => '公斤';

  @override
  String get lb => '磅';

  @override
  String get none__bodyweight_exercise_ => '無（徒手運動）';

  @override
  String get log => '紀錄';

  @override
  String get done => '完成';

  @override
  String get overallChangeWeight => '整體變化';

  @override
  String get goalTypeMeals => '來自餐點';

  @override
  String get goalTypeBasic => '基本';

  @override
  String get goalTypeAdvanced => '進階';

  @override
  String get indicatorRaw => '原始';

  @override
  String get indicatorAvg => '平均';

  @override
  String get themeMode => '主題模式';

  @override
  String get darkMode => '保持深色模式';

  @override
  String get lightMode => '保持淺色模式';

  @override
  String get systemMode => '系統設定';
}
