// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Romanian Moldavian Moldovan (`ro`).
class AppLocalizationsRo extends AppLocalizations {
  AppLocalizationsRo([String locale = 'ro']) : super(locale);

  @override
  String get userProfile => 'Profilul tău';

  @override
  String get login => 'Log in';

  @override
  String get logout => 'Deconectează-te';

  @override
  String get register => 'Înregistrează-te';

  @override
  String get useDefaultServer => 'Folosește serverul implicit';

  @override
  String get useCustomServer => 'Folosește un server personalizat';

  @override
  String get invalidUrl => 'Te rugăm să introduci o adresă URL validă';

  @override
  String get usernameValidChars =>
      'Un nume de utilizator poate conține numai litere, cifre și caracterele @, +, ., - și _';

  @override
  String get passwordsDontMatch => 'Parolele nu se potrivesc';

  @override
  String get passwordTooShort => 'Parola e prea scurtă';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'Parolă';

  @override
  String get confirmPassword => 'Confirmă parola';

  @override
  String get invalidEmail => 'Te rugăm să introduci o adresă de email validă';

  @override
  String get email => 'Adresă de e-mail';

  @override
  String get username => 'Nume de utilizator';

  @override
  String get invalidUsername => 'Introdu, te rugăm, un nume de utilizator valid';

  @override
  String get useApiToken => 'Folosește Token-ul API';

  @override
  String get useUsernameAndPassword => 'Folosește numele de utilizator și parola';

  @override
  String get apiToken => 'Token API';

  @override
  String get invalidApiToken => 'Te rugăm să introduci o cheie API validă';

  @override
  String get apiTokenValidChars =>
      'Cheia API poate conține doar litere a-f, numere 0-9 și trebuie să aibă exact 40 de caractere';

  @override
  String get customServerUrl => 'URL-ul instanței wger';

  @override
  String get customServerHint =>
      'Introdu adresa propriului server, altfel va fi folosită cea implicită';

  @override
  String get reset => 'Resetare';

  @override
  String get registerInstead => 'Nu ai un cont? Înregistrează-te acum';

  @override
  String get loginInstead => 'Ai deja un cont? Log in';

  @override
  String get labelBottomNavWorkout => 'Antrenament';

  @override
  String get labelBottomNavNutrition => 'Nutriție';

  @override
  String get labelWorkoutLogs => 'Jurnale de antrenament';

  @override
  String get labelWorkoutPlan => 'Plan de antrenament';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'Tablou de bord';

  @override
  String get success => 'Succes';

  @override
  String get successfullyDeleted => 'S-a șters';

  @override
  String get successfullySaved => 'S-a salvat';

  @override
  String get exerciseList => 'Lista exercițiilor';

  @override
  String get exercise => 'Exercițiu';

  @override
  String get exercises => 'Exerciții';

  @override
  String get exerciseName => 'Numele exercițiului';

  @override
  String get searchExercise => 'Caută un exercițiu pentru a-l adăuga';

  @override
  String get noIngredientsDefined => 'Nici un ingredient definit';

  @override
  String get noMatchingExerciseFound => 'Nu s-au găsit exerciții potrivite';

  @override
  String get searchNamesInEnglish => 'Caută nume și în engleză';

  @override
  String get equipment => 'Echipament';

  @override
  String get muscles => 'Mușchi';

  @override
  String get musclesSecondary => 'Mușchi ajutători';

  @override
  String get category => 'Catogorie';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Repetiții';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RîR';

  @override
  String get rirNotUsed => 'RîR nu e folosit';

  @override
  String get useMetric => 'Utilizați unități metrice pentru greutatea corporală';

  @override
  String get weightUnit => 'Unitate de greutate';

  @override
  String get repetitionUnit => 'Unitatea de repetiții';

  @override
  String get set => 'Serie';

  @override
  String get dayDescriptionHelp =>
      'O descriere a ceea ce se face în această zi (de exemplu, „zi de tragere”) sau ce părți ale corpului sunt antrenate (de ex.: „piept și umeri”)';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Dacă faci n.r de repetări și greutatea la fel pentru toate seriile, poți completa doar un rând. De exemplu, pentru 4 serii, introdu 10 la repetări și devine automat „4 x 10”.';

  @override
  String get comment => 'Comentariu';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Impresie';

  @override
  String get notes => 'Notițe';

  @override
  String get workoutSession => 'Sesiune de antrenament';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'Zi nouă';

  @override
  String get newSet => 'Set nou';

  @override
  String get selectExercises =>
      'Dacă vrei să faci un superset poți căuta mai multe exerciții, acestea vor fi grupate împreună';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'Modul sală';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Discuri';

  @override
  String get plateCalculatorNotDivisible => 'Nu se poate atinge greutatea cu plăcile disponibile';

  @override
  String get pause => 'Pauză';

  @override
  String get jumpTo => 'Sari la';

  @override
  String get todaysWorkout => 'Antrenamentul tău de astăzi';

  @override
  String get logHelpEntries =>
      'Dacă într-o singură zi există mai multe înregistrări cu același număr de repetări, dar greutăți diferite, în diagramă este prezentată doar intrarea cu greutatea mai mare.';

  @override
  String get logHelpEntriesUnits =>
      'Rețineți că numai intrările cu o unitate de greutate (kg sau lb) și repetări sunt grafice, alte combinații precum timpul sau până la eșec sunt ignorate aici.';

  @override
  String get description => 'Descriere';

  @override
  String get name => 'Nume';

  @override
  String get save => 'Salvează';

  @override
  String get verify => 'Verifică';

  @override
  String get addSet => 'Adaugă set';

  @override
  String get addMeal => 'Adaugă masa';

  @override
  String get mealLogged => 'Masa înregistrată în jurnal';

  @override
  String get ingredientLogged => 'Ingredient logged to diary';

  @override
  String get logMeal => 'Înregistrează această masă';

  @override
  String get addIngredient => 'Adaugă ingredient';

  @override
  String get logIngredient => 'Salvează în jurnalul de nutriție';

  @override
  String get searchIngredient => 'Caută ingredient';

  @override
  String get nutritionalPlan => 'Planul nutrițional';

  @override
  String get nutritionalDiary => 'Jurnal de nutriție';

  @override
  String get nutritionalPlans => 'Planuri nutriționale';

  @override
  String get noNutritionalPlans => 'Nu ai planuri nutriționale';

  @override
  String get onlyLogging => 'Only track calories';

  @override
  String get onlyLoggingHelpText =>
      'Check the box if you only want to log your calories and don\'t want to setup a detailed nutritional plan with specific meals';

  @override
  String get goalMacro => 'Macro goals';

  @override
  String get selectMealToLog => 'Select a meal to log to diary';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Energy goal';

  @override
  String get goalProtein => 'Protein goal';

  @override
  String get goalCarbohydrates => 'Carbohydrates goal';

  @override
  String get goalFat => 'Fat goal';

  @override
  String get goalFiber => 'Fiber goal';

  @override
  String get anErrorOccurred => 'A aparut o eroare!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'Greutate';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'Măsurare';

  @override
  String get measurements => 'Măsurători';

  @override
  String get measurementCategoriesHelpText =>
      'Categoria de măsurare, cum ar fi „biceps” sau „grăsimi corporale”';

  @override
  String get measurementEntriesHelpText =>
      'Unitatea utilizată pentru măsurarea categoriei, cum ar fi „cm” sau „%”';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Valoare';

  @override
  String get start => 'Start';

  @override
  String get time => 'Timp';

  @override
  String get timeStart => 'Timpul de începere';

  @override
  String get timeEnd => 'Sfârșitul timpului';

  @override
  String get timeStartAhead => 'Ora de început nu poate fi înaintea orei de încheiere';

  @override
  String get ingredient => 'Ingredient';

  @override
  String get energy => 'Energy';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrients';

  @override
  String get planned => 'Planned';

  @override
  String get logged => 'Logged';

  @override
  String get today => 'Today';

  @override
  String get loggedToday => 'Logged today';

  @override
  String get weekAverage => '7 day average';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'Difference';

  @override
  String get percentEnergy => 'Percent of energy';

  @override
  String get gPerBodyKg => 'g per body kg';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Protein';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carbohydrates';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Sugars';

  @override
  String get fat => 'Fat';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'Saturated fat';

  @override
  String get fiber => 'Fibers';

  @override
  String get sodium => 'Sodium';

  @override
  String get amount => 'Amount';

  @override
  String get unit => 'Unit';

  @override
  String get newEntry => 'New entry';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'You have no weight entries';

  @override
  String get noMeasurementEntries => 'You have no measurement entries';

  @override
  String get moreMeasurementEntries => 'Add new measurement';

  @override
  String get edit => 'Edit';

  @override
  String get loadingText => 'Loading...';

  @override
  String get delete => 'Delete';

  @override
  String confirmDelete(String toDelete) {
    return 'Are you sure you want to delete \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'New nutritional plan';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Toggle details';

  @override
  String get goToDetailPage => 'Go to detail page';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Thank you for using wger! wger is a collaborative open source project, made by fitness enthusiasts from around the world.';

  @override
  String get aboutDonateTitle => 'Make a donation';

  @override
  String get aboutDonateText =>
      'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Calendar';

  @override
  String get goToToday => 'Go to today';

  @override
  String get enterValue => 'Please enter a value';

  @override
  String get selectEntry => 'Please select an entry';

  @override
  String get selectExercise => 'Please select an exercise';

  @override
  String enterCharacters(String min, String max) {
    return 'Please enter between $min and $max characters';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Please enter at least $min characters';
  }

  @override
  String get baseNameEnglish => 'All exercises need a base name in English';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sets per exercise: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Set units and RiR';

  @override
  String get enterValidNumber => 'Please enter a valid number';

  @override
  String get selectIngredient => 'Please select an ingredient';

  @override
  String get recentlyUsedIngredients => 'Recently added ingredients';

  @override
  String get selectImage => 'Please select an image';

  @override
  String get optionsLabel => 'Options';

  @override
  String get takePicture => 'Take a picture';

  @override
  String get chooseFromLibrary => 'Choose from photo library';

  @override
  String get gallery => 'Gallery';

  @override
  String get addImage => 'Add image';

  @override
  String get dataCopied => 'Data copied to new entry';

  @override
  String get appUpdateTitle => 'Update needed';

  @override
  String get appUpdateContent =>
      'This version of the app is not compatible with the server, please update your application.';

  @override
  String get productFound => 'Product found';

  @override
  String productFoundDescription(String productName) {
    return 'The barcode corresponds to this product: $productName. Do you want to continue?';
  }

  @override
  String get productNotFound => 'Product not found';

  @override
  String productNotFoundDescription(String barcode) {
    return 'The product with the scanned barcode $barcode was not found in the wger database';
  }

  @override
  String get scanBarcode => 'Scan barcode';

  @override
  String get close => 'Close';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Images must be compatible with the CC BY SA license. If in doubt, upload only photos you\'ve taken yourself.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variations';

  @override
  String alsoKnownAs(String aliases) {
    return 'Also known as: $aliases';
  }

  @override
  String get verifiedEmail => 'Verified email';

  @override
  String get unVerifiedEmail => 'Unverified email';

  @override
  String get verifiedEmailReason => 'You need to verify your email to contribute exercises';

  @override
  String verifiedEmailInfo(String email) {
    return 'A verification email was sent to $email';
  }

  @override
  String get alternativeNames => 'Alternative names';

  @override
  String get oneNamePerLine => 'One name per line';

  @override
  String get whatVariationsExist => 'What variations of this exercise exist, if any?';

  @override
  String get previous => 'Previous';

  @override
  String get next => 'Next';

  @override
  String get images => 'Images';

  @override
  String get language => 'Language';

  @override
  String get addExercise => 'Add exercise';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Contribute an exercise';

  @override
  String get translation => 'Translation';

  @override
  String get translateExercise => 'Translate this exercise now';

  @override
  String get baseData => 'Basics in English';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Exercise cache';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache successfully cleared';

  @override
  String get aboutPageTitle => 'About us & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'You can only contribute exercises if your account is older than $days days and have verified your email';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Due to caching it might take some time till the changes are visible throughout the application.';

  @override
  String get textPromptTitle => 'Ready to start?';

  @override
  String get textPromptSubheading => 'Press the action button to begin';

  @override
  String get abs => 'Abs';

  @override
  String get arms => 'Arms';

  @override
  String get back => 'Back';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => 'Bench';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Body Weight';

  @override
  String get calves => 'Calves';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Chest';

  @override
  String get dumbbell => 'Dumbbell';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'Gym mat';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometers';

  @override
  String get kilometers_per_hour => 'Kilometers Per Hour';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'Legs';

  @override
  String get lower_back => 'Lower back';

  @override
  String get max_reps => 'Max Reps';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Per Hour';

  @override
  String get minutes => 'Minutes';

  @override
  String get plates => 'Plates';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'Repetitions';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Seconds';

  @override
  String get shoulders => 'Shoulders';

  @override
  String get swiss_ball => 'Swiss Ball';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Until Failure';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'none (bodyweight exercise)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Done';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
