// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Polish (`pl`).
class AppLocalizationsPl extends AppLocalizations {
  AppLocalizationsPl([String locale = 'pl']) : super(locale);

  @override
  String get userProfile => 'Twój profil';

  @override
  String get login => 'Zaloguj się';

  @override
  String get logout => 'Wyloguj się';

  @override
  String get register => 'Zarejestruj się';

  @override
  String get useDefaultServer => 'Używaj domyślnego serwera';

  @override
  String get useCustomServer => 'Używaj niestandardowego serwera';

  @override
  String get invalidUrl => 'Wpisz poprawny adres URL';

  @override
  String get usernameValidChars =>
      'Nazwa użytkownika może zawierać tylko litery, cyfry i znaki specjalne: @,+,.,-, _';

  @override
  String get passwordsDontMatch => 'Hasła nie są identyczne';

  @override
  String get passwordTooShort => 'Hasło jest zbyt krótkie';

  @override
  String get selectAvailablePlates => 'Wybierz dostępne obciążenie';

  @override
  String get barWeight => 'Waga sztangi';

  @override
  String get useColors => 'Użyj kolorów';

  @override
  String get password => 'Hasło';

  @override
  String get confirmPassword => 'Potwierdź hasło';

  @override
  String get invalidEmail => 'Podaj poprawny adres email';

  @override
  String get email => 'Adres email';

  @override
  String get username => 'Nazwa użytkownika';

  @override
  String get invalidUsername => 'Podaj poprawną nazwę użytkownika';

  @override
  String get useApiToken => 'Użyj API Token';

  @override
  String get useUsernameAndPassword => 'Użyj nazwy użytkownika i hasła';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Wpisz poprawny token API';

  @override
  String get apiTokenValidChars =>
      'Klucz API może zawierać wyłącznie litery od a-f (ang.), i cyrfy (0-9) i musi mieć długość dokładnie 40 znaków';

  @override
  String get customServerUrl => 'Adres URL instancji wger';

  @override
  String get customServerHint =>
      'Wpisz adres własnego serwera, w przeciwnym razie zostanie użyty domyślny';

  @override
  String get reset => 'Reset';

  @override
  String get registerInstead => 'Nie posiadasz konta? Zarejestruj się teraz';

  @override
  String get loginInstead => 'Posiadasz konto? Zaloguj się';

  @override
  String get labelBottomNavWorkout => 'Trening';

  @override
  String get labelBottomNavNutrition => 'Żywienie';

  @override
  String get labelWorkoutLogs => 'Dzienniki treningowe';

  @override
  String get labelWorkoutPlan => 'Plan treningu';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'Pulpit';

  @override
  String get success => 'Sukces';

  @override
  String get successfullyDeleted => 'Usunięto';

  @override
  String get successfullySaved => 'Zapisane';

  @override
  String get exerciseList => 'Lista ćwiczeń';

  @override
  String get exercise => 'Ćwiczenie';

  @override
  String get exercises => 'Ćwiczenia';

  @override
  String get exerciseName => 'Nazwa ćwiczenia';

  @override
  String get searchExercise => 'Wyszukaj ćwiczenie do dodania';

  @override
  String get noIngredientsDefined => 'Nie zdefiniowano jeszcze żadnych składników';

  @override
  String get noMatchingExerciseFound => 'Nie znaleziono ćwiczeń';

  @override
  String get searchNamesInEnglish => 'Szukaj również w języku angielskim';

  @override
  String get equipment => 'Sprzęt';

  @override
  String get muscles => 'Mięśnie';

  @override
  String get musclesSecondary => 'Mięśnie pomocnicze';

  @override
  String get category => 'Kategoria';

  @override
  String get startDate => 'Data rozpoczęcia';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Rutyny';

  @override
  String get newRoutine => 'Nowa rutyna';

  @override
  String get noRoutines => 'Ty nie masz żadnej rutyny';

  @override
  String get reps => 'Powtórzenia';

  @override
  String get restTime => 'Czas odpoczynku';

  @override
  String get sets => 'Liczba serii do wykonania dla jednego ćwiczenia';

  @override
  String get rir => 'Liczba powtórzeń w rezerwie';

  @override
  String get rirNotUsed => 'Bez rezerwy powtórzeń';

  @override
  String get useMetric => 'Używaj systemu metrycznego (kg) dla masy ciała';

  @override
  String get weightUnit => 'Jednostka wagi';

  @override
  String get repetitionUnit => 'Jednostka powtórzeń';

  @override
  String get set => 'Seria';

  @override
  String get dayDescriptionHelp =>
      'Opis tego, co jest robione w tym dniu (np. „dzień podciągania”) lub jakie części ciała są trenowane (np. „klatka piersiowa i ramiona”)';

  @override
  String exerciseNr(String nr) {
    return 'Ćwiczenie $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Jeśli wykonasz tą sama liczbę powtórzenia z tym samym ciężarem dla wszystkich serii, możesz po prostu wypełnić jeden wiersz. Na przykład dla 4 serii wystarczy wpisać 10 dla powtórzeń, automatycznie zmieni się to na „4 x 10”.';

  @override
  String get comment => 'Komentarz';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Ocena treningu';

  @override
  String get notes => 'Notatki';

  @override
  String get workoutSession => 'Sesja treningowa';

  @override
  String get restDay => 'Dzień odpoczynkowy';

  @override
  String get isRestDay => 'Czy to dzień odpoczynku';

  @override
  String get isRestDayHelp =>
      'Pamiętaj, że wszystkie zestawy i ćwiczenia zostaną usunięte, gdy oznaczysz dzień jako dzień odpoczynku.';

  @override
  String get needsLogsToAdvance => 'Potrzebuje dzienników, aby przejść dalej';

  @override
  String get needsLogsToAdvanceHelp =>
      'Wybierz tę opcję, jeśli chcesz, aby program przechodził do następnego zaplanowanego dnia tylko wtedy, gdy zarejestrowałeś trening w danym dniu';

  @override
  String get routineDays => 'Dni w danym planie';

  @override
  String get resultingRoutine => 'Rezultaty planu';

  @override
  String get newDay => 'Nowy dzień';

  @override
  String get newSet => 'Nowa seria';

  @override
  String get selectExercises =>
      'Jeśli chcesz zrobić super serię, możesz wyszukać kilka ćwiczeń, zostaną one zgrupowane razem';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'Tryb treningu';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Obciążnik';

  @override
  String get plateCalculatorNotDivisible => 'Nie można osiągnąć wagi z dostępnymi obciążeniami';

  @override
  String get pause => 'Przerwa';

  @override
  String get jumpTo => 'Wybierz ćwiczenie';

  @override
  String get todaysWorkout => 'Twój dzisiejszy trening';

  @override
  String get logHelpEntries =>
      'Jeśli w ciągu jednego dnia jest więcej niż jeden wpis z tą samą liczbą powtórzeń, ale z różnymi wagami, na wykresie pokazany jest tylko wpis o wyższej wadze.';

  @override
  String get logHelpEntriesUnits =>
      'Zwróć uwagę, że na wykresie są tylko wpisy z jednostką masy (kg lub lb) i powtórzeniami, inne kombinacje, takie jak czas lub czas do błędu, są tutaj ignorowane.';

  @override
  String get description => 'Opis';

  @override
  String get name => 'Nazwa';

  @override
  String get save => 'Zapisz';

  @override
  String get verify => 'Zweryfikuj';

  @override
  String get addSet => 'Dodaj serię';

  @override
  String get addMeal => 'Dodaj posiłek';

  @override
  String get mealLogged => 'Posiłek zarejestrowany w dzienniku';

  @override
  String get ingredientLogged => 'Składnik zarejestrowany w dzienniku';

  @override
  String get logMeal => 'Zapisz ten posiłek w dzienniku';

  @override
  String get addIngredient => 'Dodaj składnik';

  @override
  String get logIngredient => 'Zapisz składnik w dzienniku żywieniowym';

  @override
  String get searchIngredient => 'Wyszukaj składnik';

  @override
  String get nutritionalPlan => 'Plan diety';

  @override
  String get nutritionalDiary => 'Dziennik żywieniowy';

  @override
  String get nutritionalPlans => 'Plany żywieniowe';

  @override
  String get noNutritionalPlans => 'Nie masz planów żywieniowych';

  @override
  String get onlyLogging => 'Tylko licz kalorie';

  @override
  String get onlyLoggingHelpText =>
      'Zaznacz to pole jeśli wyłącznie chcesz śledzić kalorie i nie chcesz tworzyć szczegółowego planu diety z poszczególnymi posiłkami';

  @override
  String get goalMacro => 'Cele makro';

  @override
  String get selectMealToLog => 'Wybierz posiłek, który chcesz zapisać w dzienniku';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Twój obecny plan żywieniowy nie zawiera żadnych posiłków';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Aby dodać posiłki do planu, przejdź do szczegółów planu żywieniowego';

  @override
  String get goalEnergy => 'Cel energii';

  @override
  String get goalProtein => 'Cel białka';

  @override
  String get goalCarbohydrates => 'Cel węglowodanów';

  @override
  String get goalFat => 'Cel tłuszczów';

  @override
  String get goalFiber => 'Cel błonnikowy';

  @override
  String get anErrorOccurred => 'Wystąpił błąd!';

  @override
  String get errorInfoDescription =>
      'Przepraszamy coś poszło źle. Możesz pomóc nam rozwiązać ten problem zgłaszając go na GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Możesz kontynuować używanie tej aplikacji, ale niektóre funkcje mogą być niedostępne.';

  @override
  String get errorViewDetails => 'Techniczne szczegóły';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Nie możemy połączyć się z serwerem';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'Aplikacja nie może połączyć się z serwerem. Prosimy sprawdzić swoje połączenie z internetem lub adres URL i spróbować ponownie. Jeżeli problem nadal występuje, skontaktuj się z administratorem.';

  @override
  String get copyToClipboard => 'Skopiuj do schowku (clipboard)';

  @override
  String get weight => 'Waga';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name Z całego okresu';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name ostatnie 30 dni';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName w planie żywieniowym $planName';
  }

  @override
  String get measurement => 'Pomiar';

  @override
  String get measurements => 'Pomiar';

  @override
  String get measurementCategoriesHelpText =>
      'Kategoria pomiaru, np. „biceps” lub „pomiar warstwy podskórnej tłuszczu”';

  @override
  String get measurementEntriesHelpText => 'Jednostka pomiaru np. „cm” lub „%”';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'Data zakończenia';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Wartość';

  @override
  String get start => 'Uruchom';

  @override
  String get time => 'Czas';

  @override
  String get timeStart => 'Czas rozpoczęcia';

  @override
  String get timeEnd => 'Czas zakończenia';

  @override
  String get timeStartAhead => 'Czas rozpoczęcia nie może być wcześniejszy niż czas zakończenia';

  @override
  String get ingredient => 'Składnik';

  @override
  String get energy => 'Energia';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Makroelementy';

  @override
  String get planned => 'Zaplanowane';

  @override
  String get logged => 'Zapisane';

  @override
  String get today => 'Dzisiaj';

  @override
  String get loggedToday => 'Zarejestrowane dzisiaj';

  @override
  String get weekAverage => 'Średnia z poprzedniego tygodnia';

  @override
  String get surplus => 'nadwyżka';

  @override
  String get deficit => 'deficyt';

  @override
  String get difference => 'Różnice';

  @override
  String get percentEnergy => 'Procent energii';

  @override
  String get gPerBodyKg => 'g / kg';

  @override
  String get total => 'Sumarycznie';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Białko';

  @override
  String get proteinShort => 'B';

  @override
  String get carbohydrates => 'Węglowodany';

  @override
  String get carbohydratesShort => 'W';

  @override
  String get sugars => 'Cukier';

  @override
  String get fat => 'Tłuszcz';

  @override
  String get fatShort => 'T';

  @override
  String get saturatedFat => 'Tłuszcz nasycony';

  @override
  String get fiber => 'Błonnik';

  @override
  String get sodium => 'Sód';

  @override
  String get amount => 'Ilość';

  @override
  String get unit => 'Jednostka';

  @override
  String get newEntry => 'Nowy';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'Nie masz wpisów dotyczących wagi';

  @override
  String get noMeasurementEntries => 'Nie masz wpisów pomiarowych';

  @override
  String get moreMeasurementEntries => 'Dodaj nowy pomiar';

  @override
  String get edit => 'Edytuj';

  @override
  String get loadingText => 'Ładowanie...';

  @override
  String get delete => 'Usuń';

  @override
  String confirmDelete(String toDelete) {
    return 'Czy na pewno chcesz usunąć \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Nowy plan żywieniowy';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Przełącz szczegóły';

  @override
  String get goToDetailPage => 'Przejdź do strony szczegółów';

  @override
  String get aboutWhySupportTitle => 'Open Source & za darmo ❤️';

  @override
  String get aboutDescription =>
      'Dziękujemy za używanie wger! Wger jest projektem open-source stworzonym przy współpracy entuzjastów fitnessu z całego świata.';

  @override
  String get aboutDonateTitle => 'Wspomóż';

  @override
  String get aboutDonateText =>
      'Dopóki nasz projekt jest darmowy i tak zostanie na zawsze, ale działanie serweru nie jest! Także tworzenie naszego projektu zajmuje dużo czasu i wysiłku od wolontariuszów. Twoja kontrybucja bezpośrednią pokrywa te koszty, sprawia że nasz projekt się rowzija.';

  @override
  String get aboutContributeTitle => 'Współtwórz';

  @override
  String get aboutContributeText =>
      'Zachęcamy do wszelkiego rodzaju wkładu. Niezależnie od tego, czy jesteś programistą, tłumaczem, czy po prostu pasjonatem fitnessu, każda forma wsparcia jest mile widziana!';

  @override
  String get aboutBugsListTitle => 'Zgłoś problem lub zaproponuj funkcję';

  @override
  String get aboutTranslationListTitle => 'Przetłumacz aplikację';

  @override
  String get aboutSourceListTitle => 'Wyświetl kod źródłowy';

  @override
  String get aboutJoinCommunityTitle => 'Dołącz do społeczności';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Inne';

  @override
  String get calendar => 'Kalendarz';

  @override
  String get goToToday => 'Przejdź do dziś';

  @override
  String get enterValue => 'proszę wprowadzić wartość';

  @override
  String get selectEntry => 'Wybierz wpis';

  @override
  String get selectExercise => 'Wybierz ćwiczenie';

  @override
  String enterCharacters(String min, String max) {
    return 'Wprowadź od $min do $max znaków';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Proszę wpisać co najmniej $min znaków';
  }

  @override
  String get baseNameEnglish =>
      'Wszystkie ćwiczenia wymagają nazwy podstawowej w języku angielskim';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Ilość serii ćwiczenia: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Ustaw jednostki oraz rezerwę liczby powtórzeń';

  @override
  String get enterValidNumber => 'Proszę wprowadzić poprawny numer';

  @override
  String get selectIngredient => 'Wybierz składnik';

  @override
  String get recentlyUsedIngredients => 'Ostatnio dodane składniki';

  @override
  String get selectImage => 'Wybierz obraz';

  @override
  String get optionsLabel => 'Opcje';

  @override
  String get takePicture => 'Zrób zdjęcie';

  @override
  String get chooseFromLibrary => 'Wybierz z galerii zdjęć';

  @override
  String get gallery => 'Galeria';

  @override
  String get addImage => 'Dodaj obraz';

  @override
  String get dataCopied => 'Dane skopiowane do nowego dziennika';

  @override
  String get appUpdateTitle => 'Wymagana aktualizacja';

  @override
  String get appUpdateContent =>
      'Ta wersja aplikacji nie jest kompatybilna z serwerem, zaktualizuj swoją aplikację.';

  @override
  String get productFound => 'Znaleziono produkt';

  @override
  String productFoundDescription(String productName) {
    return 'Kod kreskowy odpowiada temu produktowi: $productName. Czy chcesz kontynuować?';
  }

  @override
  String get productNotFound => 'Produkt nie znaleziony';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Produkt z zeskanowanym kodem kreskowym $barcode nie został znaleziony w bazie danych wger';
  }

  @override
  String get scanBarcode => 'Zeskanuj kod kreskowy';

  @override
  String get close => 'Zamknij';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Obrazy muszą być zgodne z licencją CC BY SA. Jeśli masz wątpliwości przesyłaj tylko zdjęcia które sam zrobiłeś.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Wariacje';

  @override
  String alsoKnownAs(String aliases) {
    return 'Znany również jako: $aliases';
  }

  @override
  String get verifiedEmail => 'Zweryfikowany adres e-mail';

  @override
  String get unVerifiedEmail => 'Niezweryfikowany adres e-mail';

  @override
  String get verifiedEmailReason =>
      'Aby współtworzyć ćwiczenia musisz zweryfikować swój adres e-mail';

  @override
  String verifiedEmailInfo(String email) {
    return 'Wiadomość weryfikacyjna została wysłana na adres $email';
  }

  @override
  String get alternativeNames => 'Alternatywne nazwy';

  @override
  String get oneNamePerLine => 'Jedna nazwa w wierszu';

  @override
  String get whatVariationsExist => 'Czy istnieją wariacje tego ćwiczenia?';

  @override
  String get previous => 'Wstecz';

  @override
  String get next => 'Następny';

  @override
  String get images => 'Obrazy';

  @override
  String get language => 'Język';

  @override
  String get addExercise => 'Dodaj ćwiczenie';

  @override
  String get fitInWeek => 'Dopasuj w tygodniu';

  @override
  String get fitInWeekHelp =>
      'Jeśli opcja jest włączona, dni będą się powtarzać w cyklu tygodniowym, w przeciwnym razie dni będą następować po sobie sekwencyjnie, bez względu na początek nowego tygodnia.';

  @override
  String get addSuperset => 'Dodaj superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set ma progresję';

  @override
  String get setHasProgressionWarning =>
      'Należy pamiętać, że obecnie nie ma możliwości edycji wszystkich ustawień zestawu w aplikacji mobilnej ani skonfigurowania automatycznego postępu. Na razie prosimy korzystać z aplikacji internetowej.';

  @override
  String get setHasNoExercises => 'Ten zestaw nie zawiera jeszcze żadnych ćwiczeń!';

  @override
  String get contributeExercise => 'Przekaż ćwiczenie';

  @override
  String get translation => 'Tłumaczenie';

  @override
  String get translateExercise => 'Przetłumacz to ćwiczenie teraz';

  @override
  String get baseData => 'Podstawy po angielsku';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Ustawienia';

  @override
  String get settingsCacheTitle => 'Pamięć podręczna';

  @override
  String get settingsExerciseCacheDescription => 'Pamięć podręczna ćwiczeń';

  @override
  String get settingsIngredientCacheDescription => 'Pamięć podręczna składników';

  @override
  String get settingsCacheDeletedSnackbar => 'Pamięć podręczna pomyślnie została wyczyszczona';

  @override
  String get aboutPageTitle => 'O nas i wsparcie';

  @override
  String contributeExerciseWarning(String days) {
    return 'Możesz dodawać ćwiczenia tylko wtedy, gdy Twoje konto jest starsze niż $days dni i zweryfikowałeś swój adres e-mail';
  }

  @override
  String get simpleMode => 'Tryb prosty';

  @override
  String get simpleModeHelp =>
      'Ukryj niektóre z bardziej zaawansowanych ustawień podczas edycji ćwiczeń';

  @override
  String get progressionRules =>
      'To ćwiczenie ma zasady progresji i nie można go edytować w aplikacji mobilnej. Aby edytować to ćwiczenie, należy skorzystać z aplikacji internetowej.';

  @override
  String get cacheWarning =>
      'Ze względu na buforowanie może minąć trochę czasu zanim zmiany będą widoczne w całej aplikacji.';

  @override
  String get textPromptTitle => 'Gotowy do startu?';

  @override
  String get textPromptSubheading => 'Naciśnij przycisk, aby rozpocząć';

  @override
  String get abs => 'Brzuch';

  @override
  String get arms => 'Ręce';

  @override
  String get back => 'Plecy';

  @override
  String get barbell => 'Sztanga';

  @override
  String get bench => 'Ławka';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Masa ciała';

  @override
  String get calves => 'Łydki';

  @override
  String get cardio => 'Kardio';

  @override
  String get chest => 'Klatka piersiowa';

  @override
  String get dumbbell => 'Hantla';

  @override
  String get glutes => 'Pośladki';

  @override
  String get gym_mat => 'Mata gimnastyczna';

  @override
  String get hamstrings => 'Mięsień dwugłowy uda';

  @override
  String get incline_bench => 'Ławka skośna';

  @override
  String get kettlebell => 'Kettle';

  @override
  String get kilometers => 'Kilometry';

  @override
  String get kilometers_per_hour => 'Kilometrów na godzinę';

  @override
  String get lats => 'Mięsień najszerszy pleców';

  @override
  String get legs => 'Nogi';

  @override
  String get lower_back => 'Dolna część pleców';

  @override
  String get max_reps => 'Maksymalna ilość powtórzeń';

  @override
  String get miles => 'Mile';

  @override
  String get miles_per_hour => 'Mil na godzinę';

  @override
  String get minutes => 'Minuty';

  @override
  String get plates => 'Talerze';

  @override
  String get pull_up_bar => 'Drążek do podciągania';

  @override
  String get quads => 'Mięsień czworogłowy uda';

  @override
  String get repetitions => 'Powtórzenia';

  @override
  String get resistance_band => 'Guma oporowa';

  @override
  String get sz_bar => 'Gryf łamany';

  @override
  String get seconds => 'Sekundy';

  @override
  String get shoulders => 'Barki';

  @override
  String get swiss_ball => 'Piłka lekarska';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Aż do awarii';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'brak (ćwiczenie z masą ciała)';

  @override
  String get log => 'Zarejestruj';

  @override
  String get done => 'Ukończone';

  @override
  String get overallChangeWeight => 'Zmiana wagi';

  @override
  String get goalTypeMeals => 'Z posiłków';

  @override
  String get goalTypeBasic => 'Proste';

  @override
  String get goalTypeAdvanced => 'Zaawansowane';

  @override
  String get indicatorRaw => 'surowe';

  @override
  String get indicatorAvg => 'średnio';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Tryb tematyczny';

  @override
  String get darkMode => 'Zawsze używaj trybu ciemnego';

  @override
  String get lightMode => 'Zawsze używaj trybu jasnego';

  @override
  String get systemMode => 'Ustawienia systemu';
}
