// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Dutch Flemish (`nl`).
class AppLocalizationsNl extends AppLocalizations {
  AppLocalizationsNl([String locale = 'nl']) : super(locale);

  @override
  String get userProfile => 'Jouw profiel';

  @override
  String get login => 'Inloggen';

  @override
  String get logout => 'Uitloggen';

  @override
  String get register => 'Registreren';

  @override
  String get useDefaultServer => 'Gebruik standaard server';

  @override
  String get useCustomServer => 'Gebruik aangepaste server';

  @override
  String get invalidUrl => 'Vul een geldige URL in';

  @override
  String get usernameValidChars =>
      'Een gebruikersnaam mag alleen letters, nummers en de tekens @, +, ., -, en _ bevatten';

  @override
  String get passwordsDontMatch => 'De wachtwoorden komen niet overeen';

  @override
  String get passwordTooShort => 'Het wachtwoord is te kort';

  @override
  String get selectAvailablePlates => 'Selecteer beschikbare platen';

  @override
  String get barWeight => 'Gewicht stang';

  @override
  String get useColors => 'Gebruik kleuren';

  @override
  String get password => 'Wachtwoord';

  @override
  String get confirmPassword => 'Bevestig wachtwoord';

  @override
  String get invalidEmail => 'Vul een geldig e-mailadres in';

  @override
  String get email => 'E-mailadres';

  @override
  String get username => 'Gebruikersnaam';

  @override
  String get invalidUsername => 'Vul een geldige gebruikersnaam in';

  @override
  String get useApiToken => 'Gebruik API Token';

  @override
  String get useUsernameAndPassword => 'Gebruik gebruikersnaam en wachtwoord';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Voer alstublieft een correcte API key in';

  @override
  String get apiTokenValidChars =>
      'Een API key mag enkel letters a-f, nummers 0-9 en exact 40 karakters lang zijn';

  @override
  String get customServerUrl => 'URL van de wger instantie';

  @override
  String get customServerHint =>
      'Voer het adres van uw eigen server in, anders wordt de standaard optie gebruikt';

  @override
  String get reset => 'Reset';

  @override
  String get registerInstead => 'Nog geen account? Registreer nu';

  @override
  String get loginInstead => 'Heeft u al een account? Login';

  @override
  String get labelBottomNavWorkout => 'Workout';

  @override
  String get labelBottomNavNutrition => 'Voeding';

  @override
  String get labelWorkoutLogs => 'Trainings logboek';

  @override
  String get labelWorkoutPlan => 'Workout schema';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'Dashboard';

  @override
  String get success => 'Succes';

  @override
  String get successfullyDeleted => 'Verwijderd';

  @override
  String get successfullySaved => 'Opgeslagen';

  @override
  String get exerciseList => 'Oefeningen lijst';

  @override
  String get exercise => 'Oefening';

  @override
  String get exercises => 'Oefeningen';

  @override
  String get exerciseName => 'Oefening naam';

  @override
  String get searchExercise => 'Zoek een oefening om hem toe te voegen';

  @override
  String get noIngredientsDefined => 'Nog geen ingrediënten gedefinieerd';

  @override
  String get noMatchingExerciseFound => 'Geen overeenkomende oefeningen gevonden';

  @override
  String get searchNamesInEnglish => 'Zoek ook voor namen in het Engels';

  @override
  String get equipment => 'Uitrusting';

  @override
  String get muscles => 'Spieren';

  @override
  String get musclesSecondary => 'Secundaire spieren';

  @override
  String get category => 'Categorie';

  @override
  String get startDate => 'Start datum';

  @override
  String get dayTypeCustom => 'Aangepast';

  @override
  String get dayTypeEnom => 'Elke minuut op de minuut';

  @override
  String get dayTypeAmrap => 'Zoveel mogelijk rondes mogelijk';

  @override
  String get dayTypeHiit => 'Hoge intensiteit interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escaleerende dichtheids training';

  @override
  String get dayTypeRft => 'Rondes voor tijd';

  @override
  String get dayTypeAfap => 'Zo snel mogelijk';

  @override
  String get slotEntryTypeNormal => 'Normaal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Deels';

  @override
  String get slotEntryTypeForced => 'Verplicht';

  @override
  String get slotEntryTypeTut => 'Tijd onder spanning';

  @override
  String get slotEntryTypeIso => 'Isometrische houding';

  @override
  String get slotEntryTypeJump => 'Springen';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'Nieuwe routine';

  @override
  String get noRoutines => 'U heeft geen routines';

  @override
  String get reps => 'Herhalingen';

  @override
  String get restTime => 'Rust tijd';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'Ongebruikt RiR';

  @override
  String get useMetric => 'Gebruik metrische eenheden voor lichaamsgewicht';

  @override
  String get weightUnit => 'Gewichtseenheid';

  @override
  String get repetitionUnit => 'Herhalingseenheid';

  @override
  String get set => 'Set';

  @override
  String get dayDescriptionHelp =>
      'Een beschrijving van wat er deze dag is gedaan (b.v. \'pull dag\') of welk lichaamsdeel getraind is (b.v. \'borst en schouders\')';

  @override
  String exerciseNr(String nr) {
    return 'Oefening $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Als je dezelfde herhalingen en gewichten gebruikt voor alle sets kan je één rij invullen. Voor 4 sets kan je bijvoorbeeld 10 invullen voor de herhalingen, dit wordt dan automatisch \"4 x 10\".';

  @override
  String get comment => 'Commentaar';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Goed';

  @override
  String get impressionNeutral => 'Neutraal';

  @override
  String get impressionBad => 'Slecht';

  @override
  String get impression => 'Impressie';

  @override
  String get notes => 'Notities';

  @override
  String get workoutSession => 'Workout sessie';

  @override
  String get restDay => 'Rust dag';

  @override
  String get isRestDay => 'Is rust dag';

  @override
  String get isRestDayHelp =>
      'Houd er rekening mee dat alle sets en oefeningen verwijderd worden als u deze dag markeert als rust dag.';

  @override
  String get needsLogsToAdvance => 'Vereist logs om door te gaan';

  @override
  String get needsLogsToAdvanceHelp =>
      'Selecteer als je wilt dat de routine alleen doorgaat naar de volgende dag als je voor de dag een workout hebt vastgelegd';

  @override
  String get routineDays => 'Dagen in routine';

  @override
  String get resultingRoutine => 'Resulterende routine';

  @override
  String get newDay => 'Nieuwe dag';

  @override
  String get newSet => 'Nieuwe set';

  @override
  String get selectExercises =>
      'Als je een superset wilt doen kan je naar verschillende oefeningen zoeken, en kan je ze samen groeperen';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'Gym modus';

  @override
  String get gymModeShowExercises => 'Toon oefeningsoverzicht paginas';

  @override
  String get gymModeShowTimer => 'Toon timer tussen sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText =>
      'Als een set pauze tijd heeft, wordt altijd een afteller gebruikt.';

  @override
  String get countdown => 'Afteller';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Standaard afteltijd, in secondes';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notificeer op einde aftelling';

  @override
  String get duration => 'Duur';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}u ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout voltooid';

  @override
  String get plateCalculator => 'Platen';

  @override
  String get plateCalculatorNotDivisible =>
      'Niet mogelijk om gewicht te bereiken met beschikbare platen';

  @override
  String get pause => 'Pauzeer';

  @override
  String get jumpTo => 'Ga naar';

  @override
  String get todaysWorkout => 'Uw workout vandaag';

  @override
  String get logHelpEntries =>
      'Als er op een enkele dag meerdere oefeningen met hetzelfde aantal herhalingen, maar verschillende gewichten zijn, wordt in het diagram alleen de oefening met het hoogste gewicht weergegeven.';

  @override
  String get logHelpEntriesUnits =>
      'Let op: alleen gegevens met een gewichtseenheid (kg of lb) en herhalingen worden weergegeven; andere combinaties, zoals tijd of tot uitputting, worden hier buiten beschouwing gelaten.';

  @override
  String get description => 'Beschrijving';

  @override
  String get name => 'Naam';

  @override
  String get save => 'Opslaan';

  @override
  String get verify => 'Bevestig';

  @override
  String get addSet => 'Set toevoegen';

  @override
  String get addMeal => 'Maaltijd toevoegen';

  @override
  String get mealLogged => 'Maaltijd geregistreerd in dagboek';

  @override
  String get ingredientLogged => 'Ingrediënten geregistreerd in dagboek';

  @override
  String get logMeal => 'Noteer de maaltijd in je voedingsdagboek';

  @override
  String get addIngredient => 'Voeg ingrediënt toe';

  @override
  String get logIngredient => 'Noteer ingrediënt in je voedingsdagboek';

  @override
  String get searchIngredient => 'Zoek ingrediënt';

  @override
  String get nutritionalPlan => 'Voedingsplan';

  @override
  String get nutritionalDiary => 'Voedingsdagboek';

  @override
  String get nutritionalPlans => 'Voedingsplannen';

  @override
  String get noNutritionalPlans => 'U heeft geen voedingsplannen';

  @override
  String get onlyLogging => 'Alleen calorieën bijhouden';

  @override
  String get onlyLoggingHelpText =>
      'Vink dit vakje aan als u alleen uw calorieën wilt registreren en geen gedetailleerd voedingsplan met specifieke maaltijden wilt opstellen';

  @override
  String get goalMacro => 'Macro doelen';

  @override
  String get selectMealToLog => 'Selecteer een maaltijd om in je dagboek te registreren';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'In je huidige voedingsplan zijn geen maaltijden vastgelegd';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Om maaltijden aan het plan toe te voegen, ga naar de details van het voedingsplan';

  @override
  String get goalEnergy => 'Energie doel';

  @override
  String get goalProtein => 'Proteïne doel';

  @override
  String get goalCarbohydrates => 'Koolhydratendoel';

  @override
  String get goalFat => 'Vet doel';

  @override
  String get goalFiber => 'Vezel doel';

  @override
  String get anErrorOccurred => 'Er is een fout opgetreden!';

  @override
  String get errorInfoDescription =>
      'Het spijt ons, maar er is iets misgegaan. Je kunt ons helpen dit op te lossen door het probleem te melden op GitHub.';

  @override
  String get errorInfoDescription2 =>
      'Je kunt de app blijven gebruiken, maar sommige functies werken mogelijk niet.';

  @override
  String get errorViewDetails => 'Technische details';

  @override
  String get applicationLogs => 'Applicatie logboek';

  @override
  String get errorCouldNotConnectToServer => 'Kon niet verbinden met de server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'De applicatie kon geen verbinding maken met de server. Controleer uw internetverbinding of de server-URL en probeer het opnieuw. Als het probleem aanhoudt, neem dan contact op met de serverbeheerder.';

  @override
  String get copyToClipboard => 'Kopieer naar klembord';

  @override
  String get weight => 'Gewicht';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name over gehele tijd';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name afgelopen 30 dagen';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName tijdens voedingsplan $planName';
  }

  @override
  String get measurement => 'Meting';

  @override
  String get measurements => 'Metingen';

  @override
  String get measurementCategoriesHelpText => 'Meetcategorie, zoals \'biceps\' of \'lichaamsvet\'';

  @override
  String get measurementEntriesHelpText =>
      'De eenheid die wordt gebruikt om de categorie te meten, zoals \'cm\' of \'%\'';

  @override
  String get date => 'Datum';

  @override
  String get endDate => 'Einddatum';

  @override
  String get openEnded => 'Open einde';

  @override
  String get value => 'Waarde';

  @override
  String get start => 'Start';

  @override
  String get time => 'Tijd';

  @override
  String get timeStart => 'Start tijd';

  @override
  String get timeEnd => 'Eind tijd';

  @override
  String get timeStartAhead => 'De begintijd mag niet voor de eindtijd liggen';

  @override
  String get ingredient => 'Ingrediënt';

  @override
  String get energy => 'Energie';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutriënten';

  @override
  String get planned => 'Gepland';

  @override
  String get logged => 'Gelogd';

  @override
  String get today => 'Vandaag';

  @override
  String get loggedToday => 'Vandaag gelogd';

  @override
  String get weekAverage => '7 dagen gemiddelde';

  @override
  String get surplus => 'overschot';

  @override
  String get deficit => 'tekort';

  @override
  String get difference => 'Verschil';

  @override
  String get percentEnergy => 'Procent energie';

  @override
  String get gPerBodyKg => 'g per lichaams kg';

  @override
  String get total => 'Totaal';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteïne';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Koolhydraten';

  @override
  String get carbohydratesShort => 'K';

  @override
  String get sugars => 'Suikers';

  @override
  String get fat => 'Vet';

  @override
  String get fatShort => 'V';

  @override
  String get saturatedFat => 'Verzadigd vet';

  @override
  String get fiber => 'Vezels';

  @override
  String get sodium => 'Natrium';

  @override
  String get amount => 'Hoeveelheid';

  @override
  String get unit => 'Eenheid';

  @override
  String get newEntry => 'Nieuwe invoer';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'Je hebt geen gewichtsinvoer';

  @override
  String get noMeasurementEntries => 'U heeft geen meetgegevens ingevoerd';

  @override
  String get moreMeasurementEntries => 'Nieuwe meting toevoegen';

  @override
  String get edit => 'Wijzig';

  @override
  String get loadingText => 'Laden...';

  @override
  String get delete => 'Verwijder';

  @override
  String confirmDelete(String toDelete) {
    return 'Weet je zeker dat je \'$toDelete\' wilt verwijderen?';
  }

  @override
  String get newNutritionalPlan => 'Nieuw voedingsplan';

  @override
  String get overview => 'Overzicht';

  @override
  String get toggleDetails => 'Schakel details in';

  @override
  String get goToDetailPage => 'Ga naar detail pagina';

  @override
  String get aboutWhySupportTitle => 'Open Source & gratis te gebruiken ❤️';

  @override
  String get aboutDescription =>
      'Bedankt voor het gebruiken van wger! wger is een collaboratief open source project, gemaakt door fitness fans van over de hele wereld.';

  @override
  String get aboutDonateTitle => 'Maak een donatie';

  @override
  String get aboutDonateText =>
      'Hoewel het project gratis is en dat ook altijd zal blijven, zijn de kosten voor het draaien van de server dat niet! De ontwikkeling vergt bovendien veel tijd en inzet van vrijwilligers. Uw bijdrage dekt deze kosten direct en helpt de betrouwbaarheid van de dienst te waarborgen.';

  @override
  String get aboutContributeTitle => 'Bijdragen';

  @override
  String get aboutContributeText =>
      'Alle soorten bijdragen zijn welkom. Of je nu ontwikkelaar bent, vertaler of gewoon een fitnessliefhebber, elke vorm van steun wordt gewaardeerd!';

  @override
  String get aboutBugsListTitle => 'Meld een probleem of stel een functie voor';

  @override
  String get aboutTranslationListTitle => 'Vertaal de applicatie';

  @override
  String get aboutSourceListTitle => 'Bekijk broncode';

  @override
  String get aboutJoinCommunityTitle => 'Sluit je aan bij de community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Anderen';

  @override
  String get calendar => 'Kalender';

  @override
  String get goToToday => 'Ga naar vandaag';

  @override
  String get enterValue => 'Voer een waarde in';

  @override
  String get selectEntry => 'Selecteer een entry';

  @override
  String get selectExercise => 'Selecteer een oefening';

  @override
  String enterCharacters(String min, String max) {
    return 'Voer tussen $min en $max tekens in';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Voer een waarde tussen $min en $max in';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Voer minstens $min tekens in';
  }

  @override
  String get baseNameEnglish => 'Alle oefeningen moeten een basisnaam in het Engels hebben';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sets per oefening: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Stel eenheden en RiR in';

  @override
  String get enterValidNumber => 'Voer een geldig nummer in';

  @override
  String get selectIngredient => 'Selecteer een ingrediënt';

  @override
  String get recentlyUsedIngredients => 'Recent toegevoegde ingrediënten';

  @override
  String get selectImage => 'Selecteer een afbeelding';

  @override
  String get optionsLabel => 'Opties';

  @override
  String get takePicture => 'Neem een foto';

  @override
  String get chooseFromLibrary => 'Kies uit foto galerij';

  @override
  String get gallery => 'Galerij';

  @override
  String get addImage => 'Afbeelding toevoegen';

  @override
  String get dataCopied => 'Gegevens gekopieerd naar een nieuw item';

  @override
  String get appUpdateTitle => 'Update vereist';

  @override
  String get appUpdateContent =>
      'Deze versie van de app is niet compatibel met de server, update uw applicatie.';

  @override
  String get productFound => 'Product gevonden';

  @override
  String productFoundDescription(String productName) {
    return 'De barcode hoort bij dit product: $productName. Wilt u doorgaan?';
  }

  @override
  String get productNotFound => 'Product niet gevonden';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Het product met de gescande barcode $barcode is niet gevonden in de wger database';
  }

  @override
  String get scanBarcode => 'Scan barcode';

  @override
  String get close => 'Sluiten';

  @override
  String get identicalExercisePleaseDiscard =>
      'Als je een oefening ziet die identiek is aan degene die je toevoegt, gooi dan je concept weg en bewerk die oefening in plaats daarvan.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Controleer of de ingevoerde gegevens correct zijn voordat u de oefening indient';

  @override
  String get add_exercise_image_license =>
      'Afbeeldingen moeten compatibel zijn met de CC BY SA-licentie. Upload bij twijfel alleen foto\'s die je zelf hebt gemaakt.';

  @override
  String get imageDetailsTitle => 'Afbeeldingsdetails';

  @override
  String get imageDetailsLicenseTitle => 'Titel';

  @override
  String get imageDetailsLicenseTitleHint => 'Voer afbeeldingsnaam in';

  @override
  String get imageDetailsSourceLink => 'Link naar de bronwebsite';

  @override
  String get author => 'Auteur(s)';

  @override
  String get authorHint => 'Voer auteursnaam in';

  @override
  String get imageDetailsAuthorLink => 'Link naar de website of het profiel van de auteur';

  @override
  String get imageDetailsDerivativeSource =>
      'Link naar de originele bron, als dit een afgeleid werk is';

  @override
  String get imageDetailsDerivativeHelp => 'Hulptekst ter uitleg van afgeleide werken.';

  @override
  String get imageDetailsImageType => 'Afbeeldingstype';

  @override
  String get imageDetailsLicenseNotice =>
      'Door deze afbeelding in te dienen, stemt u ermee in deze vrij te geven onder de CC-BY-SA-4-licentie. De afbeelding moet uw eigen werk zijn of de auteur moet deze hebben vrijgegeven onder een licentie die hiermee compatibel is.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Zie licentie tekst.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat wordt niet ondersteund';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return 'Afbeeldingen met het formaat $imageFormat worden nog niet ondersteund.';
  }

  @override
  String get add => 'toevoegen';

  @override
  String get variations => 'Variaties';

  @override
  String alsoKnownAs(String aliases) {
    return 'Ook bekend als: $aliases';
  }

  @override
  String get verifiedEmail => 'Geverifieerde email';

  @override
  String get unVerifiedEmail => 'Niet-geverifieerde e-mail';

  @override
  String get verifiedEmailReason =>
      'Je moet je e-mailadres verifiëren om oefeningen te kunnen doen';

  @override
  String verifiedEmailInfo(String email) {
    return 'Er is een verificatiemail verzonden naar $email';
  }

  @override
  String get alternativeNames => 'Alternatieve namen';

  @override
  String get oneNamePerLine => 'Een naam per lijn';

  @override
  String get whatVariationsExist =>
      'Welke varianten van deze oefening bestaan er, indien van toepassing?';

  @override
  String get previous => 'Vorige';

  @override
  String get next => 'Volgende';

  @override
  String get images => 'Afbeeldingen';

  @override
  String get language => 'Taal';

  @override
  String get addExercise => 'Voeg oefening toe';

  @override
  String get fitInWeek => 'In week passen';

  @override
  String get fitInWeekHelp =>
      'Indien ingeschakeld, zullen de dagen zich herhalen in een wekelijkse cyclus; anders zullen de dagen elkaar opeenvolgend opvolgen, ongeacht het begin van een nieuwe week.';

  @override
  String get addSuperset => 'Superset toevoegen';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set heeft progressie';

  @override
  String get setHasProgressionWarning =>
      'Houd er rekening mee dat het momenteel niet mogelijk is om alle instellingen voor een set te bewerken in de mobiele app of om de automatische voortgang te configureren. Gebruik hiervoor voorlopig de webapp.';

  @override
  String get setHasNoExercises => 'Deze set heeft nog geen oefeningen!';

  @override
  String get contributeExercise => 'Draag een oefening bij';

  @override
  String get translation => 'Vertaling';

  @override
  String get translateExercise => 'Vertaal deze oefening';

  @override
  String get baseData => 'Basics in Engels';

  @override
  String get enterTextInLanguage => 'Voer de tekst in de juiste taal in!';

  @override
  String get settingsTitle => 'Instellingen';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Oefeningscache';

  @override
  String get settingsIngredientCacheDescription => 'Ingrediënten cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache succesvol geleegd';

  @override
  String get aboutPageTitle => 'Over ons & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'Je kunt alleen oefeningen bijdragen als je account ouder is dan $days dagen en je e-mailadres is geverifieerd';
  }

  @override
  String get simpleMode => 'Eenvoudige modus';

  @override
  String get simpleModeHelp =>
      'Verberg enkele van de meer geavanceerde instellingen tijdens het bewerken van oefeningen';

  @override
  String get progressionRules =>
      'Deze oefening heeft voortgangsregels en kan niet worden bewerkt in de mobiele app. Gebruik de webapplicatie om deze oefening te bewerken.';

  @override
  String get cacheWarning =>
      'Vanwege de caching kan het even duren voordat de wijzigingen in de hele applicatie zichtbaar zijn.';

  @override
  String get textPromptTitle => 'Klaar om te starten?';

  @override
  String get textPromptSubheading => 'Druk op de actieknop om te beginnen';

  @override
  String get abs => 'Buikspieren';

  @override
  String get arms => 'Armen';

  @override
  String get back => 'Rug';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => 'Bench';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Gewicht';

  @override
  String get calves => 'Kuiten';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Borst';

  @override
  String get dumbbell => 'Dumbbell';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'Gym matje';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometers';

  @override
  String get kilometers_per_hour => 'Kilometers Per Uur';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'Benen';

  @override
  String get lower_back => 'Onderrug';

  @override
  String get max_reps => 'Max Herhalingen';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Per Uur';

  @override
  String get minutes => 'Minuten';

  @override
  String get plates => 'Platen';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'Herhalingen';

  @override
  String get resistance_band => 'Weerstandsband';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Seconden';

  @override
  String get shoulders => 'Schouders';

  @override
  String get swiss_ball => 'Zwitserse Bal';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Tot Falen';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'geen (lichaamsgewicht)';

  @override
  String get log => 'Vastleggen';

  @override
  String get done => 'Klaar';

  @override
  String get overallChangeWeight => 'Algemene verandering';

  @override
  String get goalTypeMeals => 'Van maaltijden';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Geavanceerd';

  @override
  String get indicatorRaw => 'rauw';

  @override
  String get indicatorAvg => 'gemiddeld';

  @override
  String get endWorkout => 'Beëindig workout';

  @override
  String get themeMode => 'Thema modus';

  @override
  String get darkMode => 'Altijd donkere modus';

  @override
  String get lightMode => 'Altijd lichte modus';

  @override
  String get systemMode => 'Systeem instellingen';
}
