// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Hindi (`hi`).
class AppLocalizationsHi extends AppLocalizations {
  AppLocalizationsHi([String locale = 'hi']) : super(locale);

  @override
  String get userProfile => 'आपकी प्रोफ़ाइल';

  @override
  String get login => 'लोग इन';

  @override
  String get logout => 'लोग आउट';

  @override
  String get register => 'रजिस्टर';

  @override
  String get useDefaultServer => 'डिफ़ॉल्ट सर्वर का प्रयोग करें';

  @override
  String get useCustomServer => 'कस्टम सर्वर का प्रयोग करें';

  @override
  String get invalidUrl => 'कृपया एक वैलिड URL दीजिये';

  @override
  String get usernameValidChars =>
      'एक उपयोगकर्ता नाम में केवल अक्षर, अंक और वर्ण @, +, ., - और _ हो सकते हैं।';

  @override
  String get passwordsDontMatch => 'पासवर्ड मेल नहीं खाता';

  @override
  String get passwordTooShort => 'पासवर्ड कम से कम 6 अक्षर होना चाहिए';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'पासवर्ड';

  @override
  String get confirmPassword => 'पासवर्ड की पुष्टि करें';

  @override
  String get invalidEmail => 'कृपया एक वैलिड ईमेल दीजिये';

  @override
  String get email => 'ईमेल';

  @override
  String get username => 'उपयोगकर्ता नाम';

  @override
  String get invalidUsername => 'कृपया सही यूजरनेम प्रविष्ट करे';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'कस्टम सर्वर URL wger के लिए';

  @override
  String get customServerHint =>
      'अपने स्वयं के सर्वर का पता दर्ज करें, अन्यथा डिफ़ॉल्ट का उपयोग किया जाएगा';

  @override
  String get reset => 'रीसेट';

  @override
  String get registerInstead => 'इसके बजाय रजिस्टर करें';

  @override
  String get loginInstead => 'इसके बजाय लॉग इन करें';

  @override
  String get labelBottomNavWorkout => 'कसरत';

  @override
  String get labelBottomNavNutrition => 'पोषण';

  @override
  String get labelWorkoutLogs => 'प्रशिक्षण लॉग';

  @override
  String get labelWorkoutPlan => 'कसरत योजना';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'डैशबोर्ड';

  @override
  String get success => 'Success';

  @override
  String get successfullyDeleted => 'हटाया गया';

  @override
  String get successfullySaved => 'सहेजा गया';

  @override
  String get exerciseList => 'Exercise list';

  @override
  String get exercise => 'व्यायाम';

  @override
  String get exercises => 'Exercises';

  @override
  String get exerciseName => 'Exercise Name';

  @override
  String get searchExercise => 'जोड़ने के लिए व्यायाम खोजें';

  @override
  String get noIngredientsDefined => 'No ingredients defined yet';

  @override
  String get noMatchingExerciseFound => 'No matching exercises found';

  @override
  String get searchNamesInEnglish => 'Also search for names in English';

  @override
  String get equipment => 'उपकरण';

  @override
  String get muscles => 'मांसपेशियों';

  @override
  String get musclesSecondary => 'माध्यमिक मांसपेशियां';

  @override
  String get category => 'श्रेणी';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'रेप्स';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RiR';

  @override
  String get rirNotUsed => 'RiR उपयोग नहीं किया गया';

  @override
  String get useMetric => 'Use metric units for body weight';

  @override
  String get weightUnit => 'वजन इकाई';

  @override
  String get repetitionUnit => 'दोहराव इकाई';

  @override
  String get set => 'सेट';

  @override
  String get dayDescriptionHelp =>
      'इस दिन क्या किया जाता है (जैसे \'पुल डे\') या शरीर के किन अंगों को प्रशिक्षित किया जाता है (जैसे \'छाती और कंधे\') का विवरण';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'यदि आप सभी सेटों के लिए समान दोहराव और वजन करते हैं तो आप केवल एक पंक्ति भर सकते हैं। उदाहरण के लिए, 4 सेटों के लिए, दोहराव के लिए केवल 10 दर्ज करें, यह स्वचालित रूप से \"4 x 10\" हो जाता है।';

  @override
  String get comment => 'टिप्पणी';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'प्रभाव जमाना';

  @override
  String get notes => 'टिप्पणियाँ';

  @override
  String get workoutSession => 'कसरत सत्र';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'नया दिन';

  @override
  String get newSet => 'नया सेट';

  @override
  String get selectExercises =>
      'यदि आप एक सुपरसेट करना चाहते हैं तो आप कई अभ्यास खोज सकते हैं, उन्हें एक साथ समूहीकृत किया जाएगा';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'जिम मोड';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'प्लेट्स';

  @override
  String get plateCalculatorNotDivisible => 'उपलब्ध प्लेटों के साथ वजन तक पहुंचना संभव नहीं है';

  @override
  String get pause => 'रोकें';

  @override
  String get jumpTo => 'यहां जाएं';

  @override
  String get todaysWorkout => 'आज आपका वर्कआउट';

  @override
  String get logHelpEntries =>
      'यदि एक ही दिन में एक से अधिक प्रविष्टियाँ समान संख्या में दोहराव के साथ होती हैं, लेकिन अलग-अलग भार होते हैं, तो केवल उच्च भार वाली प्रविष्टि को आरेख में दिखाया जाता है।';

  @override
  String get logHelpEntriesUnits =>
      'ध्यान दें कि केवल वज़न इकाई (किलो या एलबी) और दोहराव वाली प्रविष्टियां चार्ट की जाती हैं, अन्य संयोजन जैसे समय या विफलता को यहां अनदेखा किया जाता है।';

  @override
  String get description => 'विवरण';

  @override
  String get name => 'नाम';

  @override
  String get save => 'सेव';

  @override
  String get verify => 'Verify';

  @override
  String get addSet => 'सेट जोड़ें';

  @override
  String get addMeal => 'खाना जोड़ें';

  @override
  String get mealLogged => 'भोजन डायरी में दर्ज';

  @override
  String get ingredientLogged => 'Ingredient logged to diary';

  @override
  String get logMeal => 'इस भोजन को दर्ज करें';

  @override
  String get addIngredient => 'सामग्री जोड़ें';

  @override
  String get logIngredient => 'पोषण डायरी में सामग्री दर्ज करें';

  @override
  String get searchIngredient => 'सामग्री खोजें';

  @override
  String get nutritionalPlan => 'पोषण योजना';

  @override
  String get nutritionalDiary => 'पोषण डायरी';

  @override
  String get nutritionalPlans => 'पोषण योजनाएं';

  @override
  String get noNutritionalPlans => 'आपके पास कोई पोषण योजना नहीं है';

  @override
  String get onlyLogging => 'सिर्फ कैलोरी ट्रैक करें';

  @override
  String get onlyLoggingHelpText =>
      'यदि आप केवल अपनी कैलोरी लॉग करना चाहते हैं और विशिष्ट भोजन के साथ विस्तृत पोषण योजना नहीं बनाना चाहते हैं तो बॉक्स को चेक करें';

  @override
  String get goalMacro => 'Macro goals';

  @override
  String get selectMealToLog => 'Select a meal to log to diary';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Energy goal';

  @override
  String get goalProtein => 'Protein goal';

  @override
  String get goalCarbohydrates => 'Carbohydrates goal';

  @override
  String get goalFat => 'Fat goal';

  @override
  String get goalFiber => 'Fiber goal';

  @override
  String get anErrorOccurred => 'कुछ गड़बड़ी हुई!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'वजन';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'माप';

  @override
  String get measurements => 'मापन';

  @override
  String get measurementCategoriesHelpText => 'मापन श्रेणी, जैसे \'बाइसेप्स\' या \'बॉडी फैट\'';

  @override
  String get measurementEntriesHelpText =>
      '\'सेमी\' या \'%\' जैसी श्रेणी को मापने के लिए इस्तेमाल की जाने वाली इकाई';

  @override
  String get date => 'दिनांक';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'मान';

  @override
  String get start => 'शुरु';

  @override
  String get time => 'समय';

  @override
  String get timeStart => 'शुरु समय';

  @override
  String get timeEnd => 'अंत समय';

  @override
  String get timeStartAhead => 'प्रारंभ समय समाप्ति समय से आगे का नहीं हो सकता';

  @override
  String get ingredient => 'सामग्री';

  @override
  String get energy => 'ऊर्जा';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'मैक्रोन्ट्रीय प्रयोग';

  @override
  String get planned => 'की योजना बनाई';

  @override
  String get logged => 'की योजना की दर्ज हुई';

  @override
  String get today => 'Today';

  @override
  String get loggedToday => 'Logged today';

  @override
  String get weekAverage => '7 दिन का औसत';

  @override
  String get surplus => 'surplus';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'अंतर';

  @override
  String get percentEnergy => 'ऊर्जा का प्रतिशत';

  @override
  String get gPerBodyKg => 'ग्राम प्रति शरीर किलो';

  @override
  String get total => 'कुल';

  @override
  String get kcal => 'किलो कैलोरी';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'ग्राम';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'प्रोटीन';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'कार्बोहाइड्रेट्स';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'शुगर्स';

  @override
  String get fat => 'चर्बी';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'संतृप्त चर्बी';

  @override
  String get fiber => 'रेशा';

  @override
  String get sodium => 'सोड़ियम';

  @override
  String get amount => 'मात्रा';

  @override
  String get unit => 'इकाई';

  @override
  String get newEntry => 'नया प्रविष्टि';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'आपके पास कोई वजन प्रविष्टि नहीं है';

  @override
  String get noMeasurementEntries => 'You have no measurement entries';

  @override
  String get moreMeasurementEntries => 'Add new measurement';

  @override
  String get edit => 'संपादित करें';

  @override
  String get loadingText => 'लोड हो रहा है...';

  @override
  String get delete => 'हटाएं';

  @override
  String confirmDelete(String toDelete) {
    return 'क्या आप वाकई \'$toDelete\' को हटाना चाहते हैं?';
  }

  @override
  String get newNutritionalPlan => 'नई पोषण योजना';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'विवरण टॉगल करें';

  @override
  String get goToDetailPage => 'विवरण पेज पर जाएं';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Wger का उपयोग करने के लिए धन्यवाद! Wger एक सहयोगी ओपन सोर्स प्रोजेक्ट है, जिसे दुनिया भर के फिटनेस उत्साही लोगों द्वारा बनाया गया है।';

  @override
  String get aboutDonateTitle => 'Make a donation';

  @override
  String get aboutDonateText =>
      'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'कैलेंडर';

  @override
  String get goToToday => 'Go to today';

  @override
  String get enterValue => 'कृपया मान दर्ज करें';

  @override
  String get selectEntry => 'Please select an entry';

  @override
  String get selectExercise => 'कृपया एक पाठ्यक्रम का चयन करें';

  @override
  String enterCharacters(String min, String max) {
    return 'कृपया $min और $max वर्णों के बीच दर्ज करें';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Please enter at least $min characters';
  }

  @override
  String get baseNameEnglish => 'All exercises need a base name in English';

  @override
  String nrOfSets(String nrOfSets) {
    return 'प्रति व्यायाम सेट: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'इकाइयाँ सेट करें और RiR';

  @override
  String get enterValidNumber => 'कृपया वैध संख्या दर्ज करें';

  @override
  String get selectIngredient => 'कृपया एक सामग्री का चयन करें';

  @override
  String get recentlyUsedIngredients => 'हाल ही में उपयोग की गई सामग्री';

  @override
  String get selectImage => 'कृपया एक चित्र का चयन करें';

  @override
  String get optionsLabel => 'विकल्प';

  @override
  String get takePicture => 'चित्र लें';

  @override
  String get chooseFromLibrary => 'लाइब्रेरी से चुनें';

  @override
  String get gallery => 'ग्यालरी';

  @override
  String get addImage => 'चित्र जोड़ें';

  @override
  String get dataCopied => 'डेटा की प्रतिलिपि बना दिया गया है';

  @override
  String get appUpdateTitle => 'एप्लिकेशन अपडेट की जरूरत है';

  @override
  String get appUpdateContent =>
      'ऐप का यह संस्करण सर्वर के अनुकूल नहीं है, कृपया अपना एप्लिकेशन अपडेट करें।';

  @override
  String get productFound => 'उत्पाद मिला';

  @override
  String productFoundDescription(String productName) {
    return 'बारकोड इस उत्पाद से मेल खाता है: $productName। क्या आप जारी रखना चाहते हैं?';
  }

  @override
  String get productNotFound => 'उत्पाद नहीं मिला';

  @override
  String productNotFoundDescription(String barcode) {
    return 'स्कैन किए गए बारकोड $barcode वाला उत्पाद wger डेटाबेस में नहीं मिला';
  }

  @override
  String get scanBarcode => 'बारकोड स्कैन करें';

  @override
  String get close => 'बंद करें';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Images must be compatible with the CC BY SA license. If in doubt, upload only photos you\'ve taken yourself.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variations';

  @override
  String alsoKnownAs(String aliases) {
    return 'Also known as: $aliases';
  }

  @override
  String get verifiedEmail => 'Verified email';

  @override
  String get unVerifiedEmail => 'Unverified email';

  @override
  String get verifiedEmailReason => 'You need to verify your email to contribute exercises';

  @override
  String verifiedEmailInfo(String email) {
    return 'A verification email was sent to $email';
  }

  @override
  String get alternativeNames => 'Alternative names';

  @override
  String get oneNamePerLine => 'One name per line';

  @override
  String get whatVariationsExist => 'What variations of this exercise exist, if any?';

  @override
  String get previous => 'Previous';

  @override
  String get next => 'Next';

  @override
  String get images => 'Images';

  @override
  String get language => 'Language';

  @override
  String get addExercise => 'Add exercise';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Contribute an exercise';

  @override
  String get translation => 'Translation';

  @override
  String get translateExercise => 'Translate this exercise now';

  @override
  String get baseData => 'Basics in English';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Settings';

  @override
  String get settingsCacheTitle => 'Cache';

  @override
  String get settingsExerciseCacheDescription => 'Exercise cache';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Cache successfully cleared';

  @override
  String get aboutPageTitle => 'About us & Support';

  @override
  String contributeExerciseWarning(String days) {
    return 'You can only contribute exercises if your account is older than $days days and have verified your email';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Due to caching it might take some time till the changes are visible throughout the application.';

  @override
  String get textPromptTitle => 'Ready to start?';

  @override
  String get textPromptSubheading => 'Press the action button to begin';

  @override
  String get abs => 'Abs';

  @override
  String get arms => 'Arms';

  @override
  String get back => 'Back';

  @override
  String get barbell => 'Barbell';

  @override
  String get bench => 'Bench';

  @override
  String get biceps => 'Biceps';

  @override
  String get body_weight => 'Body Weight';

  @override
  String get calves => 'Calves';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Chest';

  @override
  String get dumbbell => 'Dumbbell';

  @override
  String get glutes => 'Glutes';

  @override
  String get gym_mat => 'Gym mat';

  @override
  String get hamstrings => 'Hamstrings';

  @override
  String get incline_bench => 'Incline bench';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometers';

  @override
  String get kilometers_per_hour => 'Kilometers Per Hour';

  @override
  String get lats => 'Lats';

  @override
  String get legs => 'Legs';

  @override
  String get lower_back => 'Lower back';

  @override
  String get max_reps => 'Max Reps';

  @override
  String get miles => 'Miles';

  @override
  String get miles_per_hour => 'Miles Per Hour';

  @override
  String get minutes => 'Minutes';

  @override
  String get plates => 'Plates';

  @override
  String get pull_up_bar => 'Pull-up bar';

  @override
  String get quads => 'Quads';

  @override
  String get repetitions => 'दोहराव';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Seconds';

  @override
  String get shoulders => 'Shoulders';

  @override
  String get swiss_ball => 'Swiss Ball';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Until Failure';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'none (bodyweight exercise)';

  @override
  String get log => 'Log';

  @override
  String get done => 'Done';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
