// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Catalan Valencian (`ca`).
class AppLocalizationsCa extends AppLocalizations {
  AppLocalizationsCa([String locale = 'ca']) : super(locale);

  @override
  String get userProfile => 'El teu perfil';

  @override
  String get login => 'Entra';

  @override
  String get logout => 'Surt';

  @override
  String get register => 'Registra\'t';

  @override
  String get useDefaultServer => 'Usa el servidor per defecte';

  @override
  String get useCustomServer => 'Usa un servidor personalitzat';

  @override
  String get invalidUrl => 'Entra un URL vàlid';

  @override
  String get usernameValidChars =>
      'Un nom d\'usuari només pot contenir lletres, números i els caràcters @, +, ., -, i _';

  @override
  String get passwordsDontMatch => 'Les contrasenyes no coincideixen';

  @override
  String get passwordTooShort => 'La contrasenya és massa curta';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'Contrasenya';

  @override
  String get confirmPassword => 'Confirma la contrasenya';

  @override
  String get invalidEmail => 'Introdueix una adreça electrònica vàlida';

  @override
  String get email => 'Adreça electrònica';

  @override
  String get username => 'Nom d\'usuari';

  @override
  String get invalidUsername => 'Introdueix un nom d\'usuari vàlid';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'URL de la instància de wger';

  @override
  String get customServerHint =>
      'Introdueix l\'adreça del teu propi servidor, altrament s\'usarà el servidor per defecte';

  @override
  String get reset => 'Reinicialitza';

  @override
  String get registerInstead => 'No tens compte? Registra\'t';

  @override
  String get loginInstead => 'Ja tens un compte? Entra';

  @override
  String get labelBottomNavWorkout => 'Entrenament';

  @override
  String get labelBottomNavNutrition => 'Nutrició';

  @override
  String get labelWorkoutLogs => 'Registes d\'entrenament';

  @override
  String get labelWorkoutPlan => 'Pla d\'entrenament';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'Consola';

  @override
  String get success => 'Èxit';

  @override
  String get successfullyDeleted => 'Esborrat';

  @override
  String get successfullySaved => 'Desat';

  @override
  String get exerciseList => 'Llista d\'exercicis';

  @override
  String get exercise => 'Exercici';

  @override
  String get exercises => 'Exercicis';

  @override
  String get exerciseName => 'Nom de l\'Exercici';

  @override
  String get searchExercise => 'Cerca exercici a afegir';

  @override
  String get noIngredientsDefined => 'Encara no s\'han definit ingredients';

  @override
  String get noMatchingExerciseFound => 'No s\'han trobat exercicis coincidents';

  @override
  String get searchNamesInEnglish => 'Cerca també noms en anglès';

  @override
  String get equipment => 'Equipament';

  @override
  String get muscles => 'Músculs';

  @override
  String get musclesSecondary => 'Músculs secundaris';

  @override
  String get category => 'Categoria';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Reps';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'RER';

  @override
  String get rirNotUsed => 'Valor RER no usat';

  @override
  String get useMetric => 'Utilitza unitats mètriques per al pes corporal';

  @override
  String get weightUnit => 'Unitat de pes';

  @override
  String get repetitionUnit => 'Unitat de repetició';

  @override
  String get set => 'Sèrie';

  @override
  String get dayDescriptionHelp =>
      'Descripció de què es fa aquest dia (p. e. «dia de tracció») o quines parts del cos d\'exerciten (p. e. «pit i espatlles»)';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Si fas les mateixes repeticions i pesos per a totes les sèries, pots omplir només una línia. Per exemple, per a 4 sèries simplement introdueix 10 per a les repeticions; això esdevé automàticament «4 x 10».';

  @override
  String get comment => 'Comentaris';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Impressió';

  @override
  String get notes => 'Notes';

  @override
  String get workoutSession => 'Sessió d\'entrenament';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'Nou dia';

  @override
  String get newSet => 'Nova sèrie';

  @override
  String get selectExercises =>
      'Si vols fer una supersèrie, pots cercar diversos exercicis: s\'agruparan junts';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'Mode gimnàs';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Plaques';

  @override
  String get plateCalculatorNotDivisible =>
      'No es pot assolir aquest pes amb les plaques disponibles';

  @override
  String get pause => 'Pausa';

  @override
  String get jumpTo => 'Vés a';

  @override
  String get todaysWorkout => 'El teu entrenament avui';

  @override
  String get logHelpEntries =>
      'Si en un únic dia hi ha més d\'una entrada amb el mateix nombre de repeticions però diferents pesos, al diagrama es mostra només l\'entrada amb el pes més gran.';

  @override
  String get logHelpEntriesUnits =>
      'Tingues en compte que només es fa la gràfica de les entrades amb unitats de pes (kg o lb) i repeticions, altres combinacions com ara temps o fins la fallada s\'ignoren aquí.';

  @override
  String get description => 'Descripció';

  @override
  String get name => 'Nom';

  @override
  String get save => 'Desa';

  @override
  String get verify => 'Verifica';

  @override
  String get addSet => 'Afegeix sèrie';

  @override
  String get addMeal => 'Afegeix àpat';

  @override
  String get mealLogged => 'Àpat registrat al diari';

  @override
  String get ingredientLogged => 'Ingredient registrat al diari';

  @override
  String get logMeal => 'Registra l\'àpat al diari de nutrició';

  @override
  String get addIngredient => 'Afegeix ingredient';

  @override
  String get logIngredient => 'Registra l\'ingredient al diari nutricional';

  @override
  String get searchIngredient => 'Cerca ingredient';

  @override
  String get nutritionalPlan => 'Pla nutricional';

  @override
  String get nutritionalDiary => 'Diari nutricional';

  @override
  String get nutritionalPlans => 'Plans nutricionals';

  @override
  String get noNutritionalPlans => 'No tens plans nutricionals';

  @override
  String get onlyLogging => 'Només rastreja les calories';

  @override
  String get onlyLoggingHelpText =>
      'Marca la casella si només vols registrar les teves calories i no vols configurar un pla nutricional detallat amb àpats específics';

  @override
  String get goalMacro => 'Objectius de macronutrients';

  @override
  String get selectMealToLog => 'Selecciona un àpat per registrar al diari';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Objectiu energètic';

  @override
  String get goalProtein => 'Objectiu de proteïnes';

  @override
  String get goalCarbohydrates => 'Objectiu de carbohidrats';

  @override
  String get goalFat => 'Objectiu de greixos';

  @override
  String get goalFiber => 'Objectiu de fibra';

  @override
  String get anErrorOccurred => 'S\'ha produït un error!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'Pes';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'Mesura';

  @override
  String get measurements => 'Mesures';

  @override
  String get measurementCategoriesHelpText =>
      'Categoria de la mesura, com ara «bíceps» o «greix corporal»';

  @override
  String get measurementEntriesHelpText =>
      'La unitat usada per a mesurar la categoria, com ara «cm» o «%»';

  @override
  String get date => 'Data';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Valor';

  @override
  String get start => 'Comença';

  @override
  String get time => 'Temps';

  @override
  String get timeStart => 'Hora d\'inici';

  @override
  String get timeEnd => 'Hora de finalització';

  @override
  String get timeStartAhead => 'L\'hora d\'inici no pot ser posterior a la de finalització';

  @override
  String get ingredient => 'Ingredient';

  @override
  String get energy => 'Energia';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Macronutrients';

  @override
  String get planned => 'Previst';

  @override
  String get logged => 'Registrat';

  @override
  String get today => 'Avui';

  @override
  String get loggedToday => 'Registrat avui';

  @override
  String get weekAverage => 'Mitjana de 7 dies';

  @override
  String get surplus => 'excedent';

  @override
  String get deficit => 'deficit';

  @override
  String get difference => 'Diferència';

  @override
  String get percentEnergy => 'Percentatge d\'energia';

  @override
  String get gPerBodyKg => 'g per kg de pes corporal';

  @override
  String get total => 'Total';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteïna';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Carbohidrats';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Sucres';

  @override
  String get fat => 'Greix';

  @override
  String get fatShort => 'G';

  @override
  String get saturatedFat => 'Greix saturat';

  @override
  String get fiber => 'Fibra';

  @override
  String get sodium => 'Sodi';

  @override
  String get amount => 'Quantitat';

  @override
  String get unit => 'Unitat';

  @override
  String get newEntry => 'Nova entrada';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'No teniu cap entrada de pes';

  @override
  String get noMeasurementEntries => 'No tens dades de mesura';

  @override
  String get moreMeasurementEntries => 'Afegeix una nova mesura';

  @override
  String get edit => 'Edita';

  @override
  String get loadingText => 'Carregant...';

  @override
  String get delete => 'Esborra';

  @override
  String confirmDelete(String toDelete) {
    return 'Esteu segur de voler esborrar \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Nou pla nutricional';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Commuta detalls';

  @override
  String get goToDetailPage => 'Vés a la pàgina dels detalls';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Gràcies per usar wger! wger és un projecte col·laboratiu de codi obert, fet per entusiastes del fitness d\'arreu del món.';

  @override
  String get aboutDonateTitle => 'Dona';

  @override
  String get aboutDonateText =>
      'Compra\'ns un cafè per ajudar amb el projecte, pagar els costos del servidor i mantenir-nos enèrgics';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Calendari';

  @override
  String get goToToday => 'Vés a avui';

  @override
  String get enterValue => 'Introduïu un valor';

  @override
  String get selectEntry => 'Si us plau, selecciona una entrada';

  @override
  String get selectExercise => 'Seleccioneu un exercici';

  @override
  String enterCharacters(String min, String max) {
    return 'Introduïu entre $min i $max caràcters';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Si us plau, introdueix almenys $min caràcters';
  }

  @override
  String get baseNameEnglish => 'Tots els exercicis necessiten un nom base en anglès';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Sèries per exercici: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Unitats de la sèrie i RER';

  @override
  String get enterValidNumber => 'Introduïu un número vàlid';

  @override
  String get selectIngredient => 'Seleccioneu un ingredient';

  @override
  String get recentlyUsedIngredients => 'Ingredients afegits recentment';

  @override
  String get selectImage => 'Seleccioneu una imatge';

  @override
  String get optionsLabel => 'Opcions';

  @override
  String get takePicture => 'Fes una foto';

  @override
  String get chooseFromLibrary => 'Escull del rodet de fotos';

  @override
  String get gallery => 'Galeria';

  @override
  String get addImage => 'Afegeix imatge';

  @override
  String get dataCopied => 'Dades copiades a una nova entrada';

  @override
  String get appUpdateTitle => 'Cal actualitzar';

  @override
  String get appUpdateContent =>
      'Aquesta versió de l\'app no és compatible amb el servidor, actualitzeu l\'aplicació.';

  @override
  String get productFound => 'S\'ha trobat el producte';

  @override
  String productFoundDescription(String productName) {
    return 'El codi de barres es correspon amb aquest producte: $productName. Voleu continuar?';
  }

  @override
  String get productNotFound => 'No s\'ha trobat el producte';

  @override
  String productNotFoundDescription(String barcode) {
    return 'El producte amb el codi de barres escanejat $barcode no s\'ha trobat a la base de dades de wger';
  }

  @override
  String get scanBarcode => 'Escaneja un codi de barres';

  @override
  String get close => 'Tanca';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Les imatges han de ser compatibles amb la llicència CC BY SA. Si tens dubtes, puja només fotos que hagis pres tu mateix.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat no és compatible';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return 'Les imatges $imageFormat encara no són compatibles.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variacions';

  @override
  String alsoKnownAs(String aliases) {
    return 'També conegut com: $aliases';
  }

  @override
  String get verifiedEmail => 'Correu electrònic verificat';

  @override
  String get unVerifiedEmail => 'Correu electrònic no verificat';

  @override
  String get verifiedEmailReason =>
      'Has de verificar el teu correu electrònic per contribuir amb exercicis';

  @override
  String verifiedEmailInfo(String email) {
    return 'S\'ha enviat un correu electrònic de verificació a $email';
  }

  @override
  String get alternativeNames => 'Noms alternatius';

  @override
  String get oneNamePerLine => 'Un nom per línia';

  @override
  String get whatVariationsExist => 'Quines variacions d\'aquest exercici existeixen, si n\'hi ha?';

  @override
  String get previous => 'Anterior';

  @override
  String get next => 'Següent';

  @override
  String get images => 'Imatges';

  @override
  String get language => 'Llenguatge';

  @override
  String get addExercise => 'Afegeix un exercici';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Contribueix un exercici';

  @override
  String get translation => 'Traducció';

  @override
  String get translateExercise => 'Tradueix aquest exercici ara';

  @override
  String get baseData => 'Bàsics en anglès';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Configuració';

  @override
  String get settingsCacheTitle => 'Caché';

  @override
  String get settingsExerciseCacheDescription => 'Caché d\'exercicis';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Caché esborrada correctament';

  @override
  String get aboutPageTitle => 'Sobre Wger';

  @override
  String contributeExerciseWarning(String days) {
    return 'Només pots contribuir amb exercicis si el teu compte té més de $days dies i has verificat el teu correu electrònic';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'A causa del caché, podria trigar una estona fins que els canvis siguin visibles a tota l\'aplicació.';

  @override
  String get textPromptTitle => 'Llest per començar?';

  @override
  String get textPromptSubheading => 'Prem el botó d\'acció per començar';

  @override
  String get abs => 'Abdominals';

  @override
  String get arms => 'Braços';

  @override
  String get back => 'Esquena';

  @override
  String get barbell => 'Barra';

  @override
  String get bench => 'Banc';

  @override
  String get biceps => 'Bíceps';

  @override
  String get body_weight => 'Pes Corporal';

  @override
  String get calves => 'Pantorrilles';

  @override
  String get cardio => 'Cardio';

  @override
  String get chest => 'Pit/pectorals';

  @override
  String get dumbbell => 'Manuelles';

  @override
  String get glutes => 'Glutis';

  @override
  String get gym_mat => 'Matalàs de gimnàs';

  @override
  String get hamstrings => 'Isquiotibials';

  @override
  String get incline_bench => 'Banc inclinat';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Quilòmetres';

  @override
  String get kilometers_per_hour => 'Quilòmetres per hora';

  @override
  String get lats => 'Dorsals';

  @override
  String get legs => 'Cames';

  @override
  String get lower_back => 'Lumbar';

  @override
  String get max_reps => 'Repetitions màximes';

  @override
  String get miles => 'Milles';

  @override
  String get miles_per_hour => 'Milles per hora';

  @override
  String get minutes => 'Minuts';

  @override
  String get plates => 'Discs';

  @override
  String get pull_up_bar => 'Barra de pull-ups';

  @override
  String get quads => 'Quadriceps';

  @override
  String get repetitions => 'Repeticions';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'Barra Z';

  @override
  String get seconds => 'Segons';

  @override
  String get shoulders => 'Espatlles';

  @override
  String get swiss_ball => 'Fitball';

  @override
  String get triceps => 'Tríceps';

  @override
  String get until_failure => 'Fins al falliment';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'cap (exercici de pes corporal)';

  @override
  String get log => 'Registre';

  @override
  String get done => 'Ok';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
