import 'dart:async';

import 'package:flutter/foundation.dart';
import 'package:flutter/widgets.dart';
import 'package:flutter_localizations/flutter_localizations.dart';
import 'package:intl/intl.dart' as intl;

import 'app_localizations_am.dart';
import 'app_localizations_ar.dart';
import 'app_localizations_ca.dart';
import 'app_localizations_cs.dart';
import 'app_localizations_de.dart';
import 'app_localizations_el.dart';
import 'app_localizations_en.dart';
import 'app_localizations_es.dart';
import 'app_localizations_fa.dart';
import 'app_localizations_fil.dart';
import 'app_localizations_fr.dart';
import 'app_localizations_he.dart';
import 'app_localizations_hi.dart';
import 'app_localizations_hr.dart';
import 'app_localizations_hu.dart';
import 'app_localizations_id.dart';
import 'app_localizations_it.dart';
import 'app_localizations_ja.dart';
import 'app_localizations_ko.dart';
import 'app_localizations_nb.dart';
import 'app_localizations_nl.dart';
import 'app_localizations_pl.dart';
import 'app_localizations_pt.dart';
import 'app_localizations_ro.dart';
import 'app_localizations_ru.dart';
import 'app_localizations_sk.dart';
import 'app_localizations_ta.dart';
import 'app_localizations_th.dart';
import 'app_localizations_tr.dart';
import 'app_localizations_uk.dart';
import 'app_localizations_zh.dart';

// ignore_for_file: type=lint

/// Callers can lookup localized strings with an instance of AppLocalizations
/// returned by `AppLocalizations.of(context)`.
///
/// Applications need to include `AppLocalizations.delegate()` in their app's
/// `localizationDelegates` list, and the locales they support in the app's
/// `supportedLocales` list. For example:
///
/// ```dart
/// import 'generated/app_localizations.dart';
///
/// return MaterialApp(
///   localizationsDelegates: AppLocalizations.localizationsDelegates,
///   supportedLocales: AppLocalizations.supportedLocales,
///   home: MyApplicationHome(),
/// );
/// ```
///
/// ## Update pubspec.yaml
///
/// Please make sure to update your pubspec.yaml to include the following
/// packages:
///
/// ```yaml
/// dependencies:
///   # Internationalization support.
///   flutter_localizations:
///     sdk: flutter
///   intl: any # Use the pinned version from flutter_localizations
///
///   # Rest of dependencies
/// ```
///
/// ## iOS Applications
///
/// iOS applications define key application metadata, including supported
/// locales, in an Info.plist file that is built into the application bundle.
/// To configure the locales supported by your app, you’ll need to edit this
/// file.
///
/// First, open your project’s ios/Runner.xcworkspace Xcode workspace file.
/// Then, in the Project Navigator, open the Info.plist file under the Runner
/// project’s Runner folder.
///
/// Next, select the Information Property List item, select Add Item from the
/// Editor menu, then select Localizations from the pop-up menu.
///
/// Select and expand the newly-created Localizations item then, for each
/// locale your application supports, add a new item and select the locale
/// you wish to add from the pop-up menu in the Value field. This list should
/// be consistent with the languages listed in the AppLocalizations.supportedLocales
/// property.
abstract class AppLocalizations {
  AppLocalizations(String locale) : localeName = intl.Intl.canonicalizedLocale(locale.toString());

  final String localeName;

  static AppLocalizations of(BuildContext context) {
    return Localizations.of<AppLocalizations>(context, AppLocalizations)!;
  }

  static const LocalizationsDelegate<AppLocalizations> delegate = _AppLocalizationsDelegate();

  /// A list of this localizations delegate along with the default localizations
  /// delegates.
  ///
  /// Returns a list of localizations delegates containing this delegate along with
  /// GlobalMaterialLocalizations.delegate, GlobalCupertinoLocalizations.delegate,
  /// and GlobalWidgetsLocalizations.delegate.
  ///
  /// Additional delegates can be added by appending to this list in
  /// MaterialApp. This list does not have to be used at all if a custom list
  /// of delegates is preferred or required.
  static const List<LocalizationsDelegate<dynamic>> localizationsDelegates =
      <LocalizationsDelegate<dynamic>>[
        delegate,
        GlobalMaterialLocalizations.delegate,
        GlobalCupertinoLocalizations.delegate,
        GlobalWidgetsLocalizations.delegate,
      ];

  /// A list of this localizations delegate's supported locales.
  static const List<Locale> supportedLocales = <Locale>[
    Locale('en'),
    Locale('am'),
    Locale('ar'),
    Locale('ca'),
    Locale('cs'),
    Locale('de'),
    Locale('el'),
    Locale('es'),
    Locale('fa'),
    Locale('fil'),
    Locale('fr'),
    Locale('he'),
    Locale('hi'),
    Locale('hr'),
    Locale('hu'),
    Locale('id'),
    Locale('it'),
    Locale('ja'),
    Locale('ko'),
    Locale('nb'),
    Locale('nl'),
    Locale('pl'),
    Locale('pt'),
    Locale('pt', 'BR'),
    Locale('pt', 'PT'),
    Locale('ro'),
    Locale('ru'),
    Locale('sk'),
    Locale('ta'),
    Locale('th'),
    Locale('tr'),
    Locale('uk'),
    Locale('zh'),
    Locale.fromSubtags(languageCode: 'zh', scriptCode: 'Hant'),
  ];

  /// No description provided for @userProfile.
  ///
  /// In en, this message translates to:
  /// **'Your profile'**
  String get userProfile;

  /// Text for login button
  ///
  /// In en, this message translates to:
  /// **'Log in'**
  String get login;

  /// Text for logout button
  ///
  /// In en, this message translates to:
  /// **'Log out'**
  String get logout;

  /// Text for registration button
  ///
  /// In en, this message translates to:
  /// **'Register'**
  String get register;

  /// Toggle button allowing users to switch between the default and a custom wger server
  ///
  /// In en, this message translates to:
  /// **'Use default server'**
  String get useDefaultServer;

  /// Toggle button allowing users to switch between the default and a custom wger server
  ///
  /// In en, this message translates to:
  /// **'Use custom server'**
  String get useCustomServer;

  /// Error message when the user enters an invalid URL, e.g. in the login form
  ///
  /// In en, this message translates to:
  /// **'Please enter a valid URL'**
  String get invalidUrl;

  /// Error message when the user tries to register a username with forbidden characters
  ///
  /// In en, this message translates to:
  /// **'A username may only contain letters, digits, and the characters @, +, ., -, and _'**
  String get usernameValidChars;

  /// Error message when the user enters two different passwords during registration
  ///
  /// In en, this message translates to:
  /// **'The passwords don\'t match'**
  String get passwordsDontMatch;

  /// Error message when the user a password that is too short
  ///
  /// In en, this message translates to:
  /// **'The password is too short'**
  String get passwordTooShort;

  /// No description provided for @selectAvailablePlates.
  ///
  /// In en, this message translates to:
  /// **'Select available plates'**
  String get selectAvailablePlates;

  /// No description provided for @barWeight.
  ///
  /// In en, this message translates to:
  /// **'Bar weight'**
  String get barWeight;

  /// No description provided for @useColors.
  ///
  /// In en, this message translates to:
  /// **'Use colors'**
  String get useColors;

  /// No description provided for @password.
  ///
  /// In en, this message translates to:
  /// **'Password'**
  String get password;

  /// No description provided for @confirmPassword.
  ///
  /// In en, this message translates to:
  /// **'Confirm password'**
  String get confirmPassword;

  /// Error message when the user enters an invalid email
  ///
  /// In en, this message translates to:
  /// **'Please enter a valid e-mail address'**
  String get invalidEmail;

  /// No description provided for @email.
  ///
  /// In en, this message translates to:
  /// **'E-mail address'**
  String get email;

  /// No description provided for @username.
  ///
  /// In en, this message translates to:
  /// **'Username'**
  String get username;

  /// Error message when the user enters an invalid username
  ///
  /// In en, this message translates to:
  /// **'Please enter a valid username'**
  String get invalidUsername;

  /// No description provided for @useApiToken.
  ///
  /// In en, this message translates to:
  /// **'Use API Token'**
  String get useApiToken;

  /// No description provided for @useUsernameAndPassword.
  ///
  /// In en, this message translates to:
  /// **'Use username and password'**
  String get useUsernameAndPassword;

  /// No description provided for @apiToken.
  ///
  /// In en, this message translates to:
  /// **'API Token'**
  String get apiToken;

  /// Error message when the user enters an invalid API key
  ///
  /// In en, this message translates to:
  /// **'Please enter a valid API key'**
  String get invalidApiToken;

  /// Error message when the user tries to input a API key with forbidden characters
  ///
  /// In en, this message translates to:
  /// **'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long'**
  String get apiTokenValidChars;

  /// Label in the form where the users can enter their own wger instance
  ///
  /// In en, this message translates to:
  /// **'URL of the wger instance'**
  String get customServerUrl;

  /// Hint text for the form where the users can enter their own wger instance
  ///
  /// In en, this message translates to:
  /// **'Enter the address of your own server, otherwise the default one will be used'**
  String get customServerHint;

  /// Button text allowing the user to reset the entered values to the default
  ///
  /// In en, this message translates to:
  /// **'Reset'**
  String get reset;

  /// No description provided for @registerInstead.
  ///
  /// In en, this message translates to:
  /// **'Don\'t have an account? Register now'**
  String get registerInstead;

  /// No description provided for @loginInstead.
  ///
  /// In en, this message translates to:
  /// **'Already have an account? Login'**
  String get loginInstead;

  /// Label used in bottom navigation, use a short word
  ///
  /// In en, this message translates to:
  /// **'Workout'**
  String get labelBottomNavWorkout;

  /// Label used in bottom navigation, use a short word
  ///
  /// In en, this message translates to:
  /// **'Nutrition'**
  String get labelBottomNavNutrition;

  /// (Workout) logs
  ///
  /// In en, this message translates to:
  /// **'Training logs'**
  String get labelWorkoutLogs;

  /// Title for screen workout plan
  ///
  /// In en, this message translates to:
  /// **'Workout plan'**
  String get labelWorkoutPlan;

  /// No description provided for @dashboardWidgets.
  ///
  /// In en, this message translates to:
  /// **'Dashboard widgets'**
  String get dashboardWidgets;

  /// Title for screen dashboard
  ///
  /// In en, this message translates to:
  /// **'Dashboard'**
  String get labelDashboard;

  /// Message when an action completed successfully, usually used as a heading
  ///
  /// In en, this message translates to:
  /// **'Success'**
  String get success;

  /// Message when an item was successfully deleted
  ///
  /// In en, this message translates to:
  /// **'Deleted'**
  String get successfullyDeleted;

  /// Message when an item was successfully saved
  ///
  /// In en, this message translates to:
  /// **'Saved'**
  String get successfullySaved;

  /// No description provided for @exerciseList.
  ///
  /// In en, this message translates to:
  /// **'Exercise list'**
  String get exerciseList;

  /// An exercise for a workout
  ///
  /// In en, this message translates to:
  /// **'Exercise'**
  String get exercise;

  /// Multiple exercises for a workout
  ///
  /// In en, this message translates to:
  /// **'Exercises'**
  String get exercises;

  /// Label for the name of a workout exercise
  ///
  /// In en, this message translates to:
  /// **'Exercise Name'**
  String get exerciseName;

  /// Label on set form. Selected exercises are added to the set
  ///
  /// In en, this message translates to:
  /// **'Search exercise to add'**
  String get searchExercise;

  /// No description provided for @noIngredientsDefined.
  ///
  /// In en, this message translates to:
  /// **'No ingredients defined yet'**
  String get noIngredientsDefined;

  /// Message returned if no exercises match the searched string
  ///
  /// In en, this message translates to:
  /// **'No matching exercises found'**
  String get noMatchingExerciseFound;

  /// No description provided for @searchNamesInEnglish.
  ///
  /// In en, this message translates to:
  /// **'Also search for names in English'**
  String get searchNamesInEnglish;

  /// Equipment needed to perform an exercise
  ///
  /// In en, this message translates to:
  /// **'Equipment'**
  String get equipment;

  /// (main) muscles trained by an exercise
  ///
  /// In en, this message translates to:
  /// **'Muscles'**
  String get muscles;

  /// secondary muscles trained by an exercise
  ///
  /// In en, this message translates to:
  /// **'Secondary muscles'**
  String get musclesSecondary;

  /// Category for an exercise, ingredient, etc.
  ///
  /// In en, this message translates to:
  /// **'Category'**
  String get category;

  /// The start date of a nutritional plan or routine
  ///
  /// In en, this message translates to:
  /// **'Start date'**
  String get startDate;

  /// No description provided for @dayTypeCustom.
  ///
  /// In en, this message translates to:
  /// **'Custom'**
  String get dayTypeCustom;

  /// No description provided for @dayTypeEnom.
  ///
  /// In en, this message translates to:
  /// **'Every minute on the minute'**
  String get dayTypeEnom;

  /// No description provided for @dayTypeAmrap.
  ///
  /// In en, this message translates to:
  /// **'As many rounds as possible'**
  String get dayTypeAmrap;

  /// No description provided for @dayTypeHiit.
  ///
  /// In en, this message translates to:
  /// **'High intensity interval training'**
  String get dayTypeHiit;

  /// No description provided for @dayTypeTabata.
  ///
  /// In en, this message translates to:
  /// **'Tabata'**
  String get dayTypeTabata;

  /// No description provided for @dayTypeEdt.
  ///
  /// In en, this message translates to:
  /// **'Escalating density training'**
  String get dayTypeEdt;

  /// No description provided for @dayTypeRft.
  ///
  /// In en, this message translates to:
  /// **'Rounds for time'**
  String get dayTypeRft;

  /// No description provided for @dayTypeAfap.
  ///
  /// In en, this message translates to:
  /// **'As fast as possible'**
  String get dayTypeAfap;

  /// No description provided for @slotEntryTypeNormal.
  ///
  /// In en, this message translates to:
  /// **'Normal'**
  String get slotEntryTypeNormal;

  /// No description provided for @slotEntryTypeDropset.
  ///
  /// In en, this message translates to:
  /// **'Dropset'**
  String get slotEntryTypeDropset;

  /// No description provided for @slotEntryTypeMyo.
  ///
  /// In en, this message translates to:
  /// **'Myo'**
  String get slotEntryTypeMyo;

  /// No description provided for @slotEntryTypePartial.
  ///
  /// In en, this message translates to:
  /// **'Partial'**
  String get slotEntryTypePartial;

  /// No description provided for @slotEntryTypeForced.
  ///
  /// In en, this message translates to:
  /// **'Forced'**
  String get slotEntryTypeForced;

  /// No description provided for @slotEntryTypeTut.
  ///
  /// In en, this message translates to:
  /// **'Time under Tension'**
  String get slotEntryTypeTut;

  /// No description provided for @slotEntryTypeIso.
  ///
  /// In en, this message translates to:
  /// **'Isometric hold'**
  String get slotEntryTypeIso;

  /// No description provided for @slotEntryTypeJump.
  ///
  /// In en, this message translates to:
  /// **'Jump'**
  String get slotEntryTypeJump;

  /// No description provided for @trophies.
  ///
  /// In en, this message translates to:
  /// **'Trophies'**
  String get trophies;

  /// No description provided for @routines.
  ///
  /// In en, this message translates to:
  /// **'Routines'**
  String get routines;

  /// No description provided for @newRoutine.
  ///
  /// In en, this message translates to:
  /// **'New routine'**
  String get newRoutine;

  /// No description provided for @noRoutines.
  ///
  /// In en, this message translates to:
  /// **'You have no routines'**
  String get noRoutines;

  /// Shorthand for repetitions, used when space constraints are tighter
  ///
  /// In en, this message translates to:
  /// **'Reps'**
  String get reps;

  /// No description provided for @restTime.
  ///
  /// In en, this message translates to:
  /// **'Rest time'**
  String get restTime;

  /// The number of sets to be done for one exercise
  ///
  /// In en, this message translates to:
  /// **'Sets'**
  String get sets;

  /// Shorthand for Repetitions In Reserve
  ///
  /// In en, this message translates to:
  /// **'RiR'**
  String get rir;

  /// Label used in RiR slider when the RiR value is not used/saved for the current setting or log
  ///
  /// In en, this message translates to:
  /// **'RiR not used'**
  String get rirNotUsed;

  /// No description provided for @useMetric.
  ///
  /// In en, this message translates to:
  /// **'Use metric units for body weight'**
  String get useMetric;

  /// No description provided for @weightUnit.
  ///
  /// In en, this message translates to:
  /// **'Weight unit'**
  String get weightUnit;

  /// No description provided for @repetitionUnit.
  ///
  /// In en, this message translates to:
  /// **'Repetition unit'**
  String get repetitionUnit;

  /// A set in a workout plan
  ///
  /// In en, this message translates to:
  /// **'Set'**
  String get set;

  /// No description provided for @dayDescriptionHelp.
  ///
  /// In en, this message translates to:
  /// **'A description of what is done on this day (e.g. \'pull day\') or what body parts are trained (e.g. \'chest and shoulders\')'**
  String get dayDescriptionHelp;

  /// Header in form indicating the number of the current exercise. Can also be translated as something like 'Set Nr. xy'.
  ///
  /// In en, this message translates to:
  /// **'Exercise {nr}'**
  String exerciseNr(String nr);

  /// Header in form indicating the number of the current exercise. Can also be translated as something like 'Superset Nr. xy'.
  ///
  /// In en, this message translates to:
  /// **'Superset {nr}'**
  String supersetNr(String nr);

  /// No description provided for @sameRepetitions.
  ///
  /// In en, this message translates to:
  /// **'If you do the same repetitions and weight for all sets you can just fill in one row. For example for 4 sets just enter 10 for the repetitions, this automatically becomes \"4 x 10\".'**
  String get sameRepetitions;

  /// Comment, additional information
  ///
  /// In en, this message translates to:
  /// **'Comment'**
  String get comment;

  /// Value is a representation of the set, like '10 x 80kg'
  ///
  /// In en, this message translates to:
  /// **'Top set: {value}'**
  String topSet(String value);

  /// No description provided for @impressionGood.
  ///
  /// In en, this message translates to:
  /// **'Good'**
  String get impressionGood;

  /// No description provided for @impressionNeutral.
  ///
  /// In en, this message translates to:
  /// **'Neutral'**
  String get impressionNeutral;

  /// No description provided for @impressionBad.
  ///
  /// In en, this message translates to:
  /// **'Bad'**
  String get impressionBad;

  /// General impression (e.g. for a workout session) such as good, bad, etc.
  ///
  /// In en, this message translates to:
  /// **'Impression'**
  String get impression;

  /// Personal notes, e.g. for a workout session
  ///
  /// In en, this message translates to:
  /// **'Notes'**
  String get notes;

  /// A (logged) workout session
  ///
  /// In en, this message translates to:
  /// **'Workout session'**
  String get workoutSession;

  /// No description provided for @restDay.
  ///
  /// In en, this message translates to:
  /// **'Rest day'**
  String get restDay;

  /// No description provided for @isRestDay.
  ///
  /// In en, this message translates to:
  /// **'Is rest day'**
  String get isRestDay;

  /// No description provided for @isRestDayHelp.
  ///
  /// In en, this message translates to:
  /// **'Please note that all sets and exercises will be removed when you mark a day as a rest day.'**
  String get isRestDayHelp;

  /// No description provided for @needsLogsToAdvance.
  ///
  /// In en, this message translates to:
  /// **'Needs logs to advance'**
  String get needsLogsToAdvance;

  /// No description provided for @needsLogsToAdvanceHelp.
  ///
  /// In en, this message translates to:
  /// **'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day'**
  String get needsLogsToAdvanceHelp;

  /// No description provided for @routineDays.
  ///
  /// In en, this message translates to:
  /// **'Days in routine'**
  String get routineDays;

  /// No description provided for @resultingRoutine.
  ///
  /// In en, this message translates to:
  /// **'Resulting routine'**
  String get resultingRoutine;

  /// No description provided for @newDay.
  ///
  /// In en, this message translates to:
  /// **'New day'**
  String get newDay;

  /// Header when adding a new set to a workout day
  ///
  /// In en, this message translates to:
  /// **'New set'**
  String get newSet;

  /// No description provided for @selectExercises.
  ///
  /// In en, this message translates to:
  /// **'If you want to do a superset you can search for several exercises, they will be grouped together'**
  String get selectExercises;

  /// No description provided for @personalRecords.
  ///
  /// In en, this message translates to:
  /// **'Personal records'**
  String get personalRecords;

  /// Label when starting the gym mode
  ///
  /// In en, this message translates to:
  /// **'Gym mode'**
  String get gymMode;

  /// No description provided for @gymModeShowExercises.
  ///
  /// In en, this message translates to:
  /// **'Show exercise overview pages'**
  String get gymModeShowExercises;

  /// No description provided for @gymModeShowTimer.
  ///
  /// In en, this message translates to:
  /// **'Show timer between sets'**
  String get gymModeShowTimer;

  /// No description provided for @gymModeTimerType.
  ///
  /// In en, this message translates to:
  /// **'Timer type'**
  String get gymModeTimerType;

  /// No description provided for @gymModeTimerTypeHelText.
  ///
  /// In en, this message translates to:
  /// **'If a set has pause time, a countdown is always used.'**
  String get gymModeTimerTypeHelText;

  /// No description provided for @countdown.
  ///
  /// In en, this message translates to:
  /// **'Countdown'**
  String get countdown;

  /// No description provided for @stopwatch.
  ///
  /// In en, this message translates to:
  /// **'Stopwatch'**
  String get stopwatch;

  /// No description provided for @gymModeDefaultCountdownTime.
  ///
  /// In en, this message translates to:
  /// **'Default countdown time, in seconds'**
  String get gymModeDefaultCountdownTime;

  /// No description provided for @gymModeNotifyOnCountdownFinish.
  ///
  /// In en, this message translates to:
  /// **'Notify on countdown end'**
  String get gymModeNotifyOnCountdownFinish;

  /// No description provided for @duration.
  ///
  /// In en, this message translates to:
  /// **'Duration'**
  String get duration;

  /// A duration, in hours and minutes
  ///
  /// In en, this message translates to:
  /// **'{hours}h {minutes}m'**
  String durationHoursMinutes(int hours, int minutes);

  /// The volume of a workout or set, i.e. weight x reps
  ///
  /// In en, this message translates to:
  /// **'Volume'**
  String get volume;

  /// No description provided for @workoutCompleted.
  ///
  /// In en, this message translates to:
  /// **'Workout completed'**
  String get workoutCompleted;

  /// Label used for the plate calculator in the gym mode
  ///
  /// In en, this message translates to:
  /// **'Plates'**
  String get plateCalculator;

  /// Error message when the current weight is not reachable with plates (e.g. 33.1 kg)
  ///
  /// In en, this message translates to:
  /// **'Not possible to reach weight with available plates'**
  String get plateCalculatorNotDivisible;

  /// Noun, not an imperative! Label used for the pause when using the gym mode
  ///
  /// In en, this message translates to:
  /// **'Pause'**
  String get pause;

  /// Imperative. Label used in popup allowing the user to jump to a specific exercise while in the gym mode
  ///
  /// In en, this message translates to:
  /// **'Jump to'**
  String get jumpTo;

  /// No description provided for @todaysWorkout.
  ///
  /// In en, this message translates to:
  /// **'Your workout today'**
  String get todaysWorkout;

  /// No description provided for @logHelpEntries.
  ///
  /// In en, this message translates to:
  /// **'If on a single day there is more than one entry with the same number of repetitions, but different weights, only the entry with the higher weight is shown in the diagram.'**
  String get logHelpEntries;

  /// No description provided for @logHelpEntriesUnits.
  ///
  /// In en, this message translates to:
  /// **'Note that only entries with a weight unit (kg or lb) and repetitions are charted, other combinations such as time or until failure are ignored here.'**
  String get logHelpEntriesUnits;

  /// No description provided for @description.
  ///
  /// In en, this message translates to:
  /// **'Description'**
  String get description;

  /// Name for a workout or nutritional plan
  ///
  /// In en, this message translates to:
  /// **'Name'**
  String get name;

  /// No description provided for @save.
  ///
  /// In en, this message translates to:
  /// **'Save'**
  String get save;

  /// No description provided for @verify.
  ///
  /// In en, this message translates to:
  /// **'Verify'**
  String get verify;

  /// Label for the button that adds a set (to a workout day)
  ///
  /// In en, this message translates to:
  /// **'Add set'**
  String get addSet;

  /// No description provided for @addMeal.
  ///
  /// In en, this message translates to:
  /// **'Add meal'**
  String get addMeal;

  /// No description provided for @mealLogged.
  ///
  /// In en, this message translates to:
  /// **'Meal logged to diary'**
  String get mealLogged;

  /// No description provided for @ingredientLogged.
  ///
  /// In en, this message translates to:
  /// **'Ingredient logged to diary'**
  String get ingredientLogged;

  /// No description provided for @logMeal.
  ///
  /// In en, this message translates to:
  /// **'Log meal to nutrition diary'**
  String get logMeal;

  /// No description provided for @addIngredient.
  ///
  /// In en, this message translates to:
  /// **'Add ingredient'**
  String get addIngredient;

  /// No description provided for @logIngredient.
  ///
  /// In en, this message translates to:
  /// **'Log ingredient to nutrition diary'**
  String get logIngredient;

  /// Label on ingredient search form
  ///
  /// In en, this message translates to:
  /// **'Search ingredient'**
  String get searchIngredient;

  /// No description provided for @nutritionalPlan.
  ///
  /// In en, this message translates to:
  /// **'Nutritional plan'**
  String get nutritionalPlan;

  /// No description provided for @nutritionalDiary.
  ///
  /// In en, this message translates to:
  /// **'Nutritional diary'**
  String get nutritionalDiary;

  /// No description provided for @nutritionalPlans.
  ///
  /// In en, this message translates to:
  /// **'Nutritional plans'**
  String get nutritionalPlans;

  /// Message shown when the user has no nutritional plans
  ///
  /// In en, this message translates to:
  /// **'You have no nutritional plans'**
  String get noNutritionalPlans;

  /// No description provided for @onlyLogging.
  ///
  /// In en, this message translates to:
  /// **'Only track calories'**
  String get onlyLogging;

  /// No description provided for @onlyLoggingHelpText.
  ///
  /// In en, this message translates to:
  /// **'Check the box if you only want to log your calories and don\'t want to setup a detailed nutritional plan with specific meals'**
  String get onlyLoggingHelpText;

  /// The goal for macronutrients
  ///
  /// In en, this message translates to:
  /// **'Macro goals'**
  String get goalMacro;

  /// No description provided for @selectMealToLog.
  ///
  /// In en, this message translates to:
  /// **'Select a meal to log to diary'**
  String get selectMealToLog;

  /// Message shown when a nutrition plan doesn't have any meals
  ///
  /// In en, this message translates to:
  /// **'Your current nutrition plan has no meals defined'**
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet;

  /// Message shown to guide users to the nutritional plan details page to add meals
  ///
  /// In en, this message translates to:
  /// **'To add meals to the plan, go to the nutritional plan details'**
  String get toAddMealsToThePlanGoToNutritionalPlanDetails;

  /// No description provided for @goalEnergy.
  ///
  /// In en, this message translates to:
  /// **'Energy goal'**
  String get goalEnergy;

  /// No description provided for @goalProtein.
  ///
  /// In en, this message translates to:
  /// **'Protein goal'**
  String get goalProtein;

  /// No description provided for @goalCarbohydrates.
  ///
  /// In en, this message translates to:
  /// **'Carbohydrates goal'**
  String get goalCarbohydrates;

  /// No description provided for @goalFat.
  ///
  /// In en, this message translates to:
  /// **'Fat goal'**
  String get goalFat;

  /// No description provided for @goalFiber.
  ///
  /// In en, this message translates to:
  /// **'Fiber goal'**
  String get goalFiber;

  /// No description provided for @anErrorOccurred.
  ///
  /// In en, this message translates to:
  /// **'An Error Occurred!'**
  String get anErrorOccurred;

  /// No description provided for @errorInfoDescription.
  ///
  /// In en, this message translates to:
  /// **'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.'**
  String get errorInfoDescription;

  /// No description provided for @errorInfoDescription2.
  ///
  /// In en, this message translates to:
  /// **'You can continue using the app, but some features may not work.'**
  String get errorInfoDescription2;

  /// No description provided for @errorViewDetails.
  ///
  /// In en, this message translates to:
  /// **'Technical details'**
  String get errorViewDetails;

  /// No description provided for @applicationLogs.
  ///
  /// In en, this message translates to:
  /// **'Application logs'**
  String get applicationLogs;

  /// No description provided for @errorCouldNotConnectToServer.
  ///
  /// In en, this message translates to:
  /// **'Couldn\'t connect to server'**
  String get errorCouldNotConnectToServer;

  /// No description provided for @errorCouldNotConnectToServerDetails.
  ///
  /// In en, this message translates to:
  /// **'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.'**
  String get errorCouldNotConnectToServerDetails;

  /// No description provided for @copyToClipboard.
  ///
  /// In en, this message translates to:
  /// **'Copy to clipboard'**
  String get copyToClipboard;

  /// The weight of a workout log or body weight entry
  ///
  /// In en, this message translates to:
  /// **'Weight'**
  String get weight;

  /// No description provided for @min.
  ///
  /// In en, this message translates to:
  /// **'Min'**
  String get min;

  /// No description provided for @max.
  ///
  /// In en, this message translates to:
  /// **'Max'**
  String get max;

  /// All-time chart of 'name' (e.g. 'weight', 'body fat' etc.)
  ///
  /// In en, this message translates to:
  /// **'{name} all-time'**
  String chartAllTimeTitle(String name);

  /// last 30 days chart of 'name' (e.g. 'weight', 'body fat' etc.)
  ///
  /// In en, this message translates to:
  /// **'{name} last 30 days'**
  String chart30DaysTitle(String name);

  /// chart of 'chartName' (e.g. 'weight', 'body fat' etc.) logged during plan
  ///
  /// In en, this message translates to:
  /// **'{chartName} during nutritional plan {planName}'**
  String chartDuringPlanTitle(String chartName, String planName);

  /// No description provided for @measurement.
  ///
  /// In en, this message translates to:
  /// **'Measurement'**
  String get measurement;

  /// Categories for the measurements such as biceps size, body fat, etc.
  ///
  /// In en, this message translates to:
  /// **'Measurements'**
  String get measurements;

  /// No description provided for @measurementCategoriesHelpText.
  ///
  /// In en, this message translates to:
  /// **'Measurement category, such as \'biceps\' or \'body fat\''**
  String get measurementCategoriesHelpText;

  /// No description provided for @measurementEntriesHelpText.
  ///
  /// In en, this message translates to:
  /// **'The unit used to measure the category such as \'cm\' or \'%\''**
  String get measurementEntriesHelpText;

  /// The date of a workout log or body weight entry
  ///
  /// In en, this message translates to:
  /// **'Date'**
  String get date;

  /// The End date of a nutritional plan or routine
  ///
  /// In en, this message translates to:
  /// **'End date'**
  String get endDate;

  /// When a nutrition plan has no pre-defined end date
  ///
  /// In en, this message translates to:
  /// **'Open ended'**
  String get openEnded;

  /// The value of a measurement entry
  ///
  /// In en, this message translates to:
  /// **'Value'**
  String get value;

  /// Label on button to start the gym mode (i.e., an imperative)
  ///
  /// In en, this message translates to:
  /// **'Start'**
  String get start;

  /// The time of a meal or workout
  ///
  /// In en, this message translates to:
  /// **'Time'**
  String get time;

  /// The starting time of a workout
  ///
  /// In en, this message translates to:
  /// **'Start time'**
  String get timeStart;

  /// The end time of a workout
  ///
  /// In en, this message translates to:
  /// **'End time'**
  String get timeEnd;

  /// No description provided for @timeStartAhead.
  ///
  /// In en, this message translates to:
  /// **'Start time cannot be ahead of end time'**
  String get timeStartAhead;

  /// No description provided for @ingredient.
  ///
  /// In en, this message translates to:
  /// **'Ingredient'**
  String get ingredient;

  /// Energy in a meal, ingredient etc. e.g. in kJ
  ///
  /// In en, this message translates to:
  /// **'Energy'**
  String get energy;

  /// The first letter or short name of the word 'Energy', used in overviews
  ///
  /// In en, this message translates to:
  /// **'E'**
  String get energyShort;

  /// No description provided for @macronutrients.
  ///
  /// In en, this message translates to:
  /// **'Macronutrients'**
  String get macronutrients;

  /// Header for the column of 'planned' nutritional values, i.e. what should be eaten
  ///
  /// In en, this message translates to:
  /// **'Planned'**
  String get planned;

  /// Header for the column of 'logged' nutritional values, i.e. what was eaten
  ///
  /// In en, this message translates to:
  /// **'Logged'**
  String get logged;

  /// No description provided for @today.
  ///
  /// In en, this message translates to:
  /// **'Today'**
  String get today;

  /// No description provided for @loggedToday.
  ///
  /// In en, this message translates to:
  /// **'Logged today'**
  String get loggedToday;

  /// Header for the column of '7 day average' nutritional values, i.e. what was logged last week
  ///
  /// In en, this message translates to:
  /// **'7 day average'**
  String get weekAverage;

  /// Caloric surplus (either planned or unplanned)
  ///
  /// In en, this message translates to:
  /// **'surplus'**
  String get surplus;

  /// Caloric deficit (either planned or unplanned)
  ///
  /// In en, this message translates to:
  /// **'deficit'**
  String get deficit;

  /// No description provided for @difference.
  ///
  /// In en, this message translates to:
  /// **'Difference'**
  String get difference;

  /// No description provided for @percentEnergy.
  ///
  /// In en, this message translates to:
  /// **'Percent of energy'**
  String get percentEnergy;

  /// Label used for total sums of e.g. calories or similar in grams per Kg of body weight
  ///
  /// In en, this message translates to:
  /// **'g per body kg'**
  String get gPerBodyKg;

  /// Label used for total sums of e.g. calories or similar
  ///
  /// In en, this message translates to:
  /// **'Total'**
  String get total;

  /// Energy in a meal in kilocalories, kcal
  ///
  /// In en, this message translates to:
  /// **'kcal'**
  String get kcal;

  /// A value in kcal, e.g. 500 kcal
  ///
  /// In en, this message translates to:
  /// **'{value} kcal'**
  String kcalValue(String value);

  /// Energy in a meal in kilo joules, kJ
  ///
  /// In en, this message translates to:
  /// **'kJ'**
  String get kJ;

  /// Abbreviation for gram
  ///
  /// In en, this message translates to:
  /// **'g'**
  String get g;

  /// A value in grams, e.g. 5 g
  ///
  /// In en, this message translates to:
  /// **'{value} g'**
  String gValue(String value);

  /// A value in percent, e.g. 10 %
  ///
  /// In en, this message translates to:
  /// **'{value} %'**
  String percentValue(String value);

  /// No description provided for @protein.
  ///
  /// In en, this message translates to:
  /// **'Protein'**
  String get protein;

  /// The first letter or short name of the word 'Protein', used in overviews
  ///
  /// In en, this message translates to:
  /// **'P'**
  String get proteinShort;

  /// No description provided for @carbohydrates.
  ///
  /// In en, this message translates to:
  /// **'Carbohydrates'**
  String get carbohydrates;

  /// The first letter or short name of the word 'Carbohydrates', used in overviews
  ///
  /// In en, this message translates to:
  /// **'C'**
  String get carbohydratesShort;

  /// No description provided for @sugars.
  ///
  /// In en, this message translates to:
  /// **'Sugars'**
  String get sugars;

  /// No description provided for @fat.
  ///
  /// In en, this message translates to:
  /// **'Fat'**
  String get fat;

  /// The first letter or short name of the word 'Fat', used in overviews
  ///
  /// In en, this message translates to:
  /// **'F'**
  String get fatShort;

  /// No description provided for @saturatedFat.
  ///
  /// In en, this message translates to:
  /// **'Saturated fat'**
  String get saturatedFat;

  /// No description provided for @fiber.
  ///
  /// In en, this message translates to:
  /// **'Fibers'**
  String get fiber;

  /// No description provided for @sodium.
  ///
  /// In en, this message translates to:
  /// **'Sodium'**
  String get sodium;

  /// The amount (e.g. in grams) of an ingredient in a meal
  ///
  /// In en, this message translates to:
  /// **'Amount'**
  String get amount;

  /// The unit used for a repetition (kg, time, etc.)
  ///
  /// In en, this message translates to:
  /// **'Unit'**
  String get unit;

  /// Title when adding a new entry such as a weight or log entry
  ///
  /// In en, this message translates to:
  /// **'New entry'**
  String get newEntry;

  /// No description provided for @noTrophies.
  ///
  /// In en, this message translates to:
  /// **'You have no trophies yet'**
  String get noTrophies;

  /// Message shown when the user has no logged weight entries
  ///
  /// In en, this message translates to:
  /// **'You have no weight entries'**
  String get noWeightEntries;

  /// No description provided for @noMeasurementEntries.
  ///
  /// In en, this message translates to:
  /// **'You have no measurement entries'**
  String get noMeasurementEntries;

  /// Message shown when the user wants to add new measurement
  ///
  /// In en, this message translates to:
  /// **'Add new measurement'**
  String get moreMeasurementEntries;

  /// No description provided for @edit.
  ///
  /// In en, this message translates to:
  /// **'Edit'**
  String get edit;

  /// Text to show when entries are being loaded in the background: Loading...
  ///
  /// In en, this message translates to:
  /// **'Loading...'**
  String get loadingText;

  /// No description provided for @delete.
  ///
  /// In en, this message translates to:
  /// **'Delete'**
  String get delete;

  /// Confirmation text before the user deletes an object
  ///
  /// In en, this message translates to:
  /// **'Are you sure you want to delete \'{toDelete}\'?'**
  String confirmDelete(String toDelete);

  /// No description provided for @newNutritionalPlan.
  ///
  /// In en, this message translates to:
  /// **'New nutritional plan'**
  String get newNutritionalPlan;

  /// No description provided for @overview.
  ///
  /// In en, this message translates to:
  /// **'Overview'**
  String get overview;

  /// Switch to toggle detail / overview
  ///
  /// In en, this message translates to:
  /// **'Toggle details'**
  String get toggleDetails;

  /// No description provided for @goToDetailPage.
  ///
  /// In en, this message translates to:
  /// **'Go to detail page'**
  String get goToDetailPage;

  /// No description provided for @aboutWhySupportTitle.
  ///
  /// In en, this message translates to:
  /// **'Open Source & free to use ❤️'**
  String get aboutWhySupportTitle;

  /// Text in the about dialog
  ///
  /// In en, this message translates to:
  /// **'Thank you for using wger! wger is a collaborative open source project, made by fitness enthusiasts from around the world.'**
  String get aboutDescription;

  /// No description provided for @aboutDonateTitle.
  ///
  /// In en, this message translates to:
  /// **'Make a donation'**
  String get aboutDonateTitle;

  /// No description provided for @aboutDonateText.
  ///
  /// In en, this message translates to:
  /// **'While the project is free and will always remain it, running the server isn’t! Development also takes significant time and effort from volunteers. Your contribution directly supports these costs, helping to keep the service reliable.'**
  String get aboutDonateText;

  /// No description provided for @aboutContributeTitle.
  ///
  /// In en, this message translates to:
  /// **'Contribute'**
  String get aboutContributeTitle;

  /// No description provided for @aboutContributeText.
  ///
  /// In en, this message translates to:
  /// **'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!'**
  String get aboutContributeText;

  /// No description provided for @aboutBugsListTitle.
  ///
  /// In en, this message translates to:
  /// **'Report a problem or suggest a feature'**
  String get aboutBugsListTitle;

  /// No description provided for @aboutTranslationListTitle.
  ///
  /// In en, this message translates to:
  /// **'Translate the application'**
  String get aboutTranslationListTitle;

  /// No description provided for @aboutSourceListTitle.
  ///
  /// In en, this message translates to:
  /// **'View source code'**
  String get aboutSourceListTitle;

  /// No description provided for @aboutJoinCommunityTitle.
  ///
  /// In en, this message translates to:
  /// **'Join the community'**
  String get aboutJoinCommunityTitle;

  /// No description provided for @aboutMastodonTitle.
  ///
  /// In en, this message translates to:
  /// **'Mastodon'**
  String get aboutMastodonTitle;

  /// No description provided for @aboutDiscordTitle.
  ///
  /// In en, this message translates to:
  /// **'Discord'**
  String get aboutDiscordTitle;

  /// No description provided for @others.
  ///
  /// In en, this message translates to:
  /// **'Others'**
  String get others;

  /// No description provided for @calendar.
  ///
  /// In en, this message translates to:
  /// **'Calendar'**
  String get calendar;

  /// Label on button to jump back to 'today' in the calendar widget
  ///
  /// In en, this message translates to:
  /// **'Go to today'**
  String get goToToday;

  /// Error message when the user hasn't entered a value on a required field
  ///
  /// In en, this message translates to:
  /// **'Please enter a value'**
  String get enterValue;

  /// No description provided for @selectEntry.
  ///
  /// In en, this message translates to:
  /// **'Please select an entry'**
  String get selectEntry;

  /// Error message when the user hasn't selected an exercise in the form
  ///
  /// In en, this message translates to:
  /// **'Please select an exercise'**
  String get selectExercise;

  /// Error message when the user hasn't entered the correct number of characters in a form
  ///
  /// In en, this message translates to:
  /// **'Please enter between {min} and {max} characters'**
  String enterCharacters(String min, String max);

  /// Error message when the user needs to enter a value between min and max
  ///
  /// In en, this message translates to:
  /// **'Please enter a value between {min} and {max}'**
  String formMinMaxValues(int min, int max);

  /// Error message when the user hasn't entered the minimum amount characters in a form
  ///
  /// In en, this message translates to:
  /// **'Please enter at least {min} characters'**
  String enterMinCharacters(String min);

  /// No description provided for @baseNameEnglish.
  ///
  /// In en, this message translates to:
  /// **'All exercises need a base name in English'**
  String get baseNameEnglish;

  /// Label shown on the slider where the user selects the nr of sets
  ///
  /// In en, this message translates to:
  /// **'Sets per exercise: {nrOfSets}'**
  String nrOfSets(String nrOfSets);

  /// Label shown on the slider where the user can toggle showing units and RiR
  ///
  /// In en, this message translates to:
  /// **'Set units and RiR'**
  String get setUnitsAndRir;

  /// Error message when the user has submitted an invalid number (e.g. '3,.,.,.')
  ///
  /// In en, this message translates to:
  /// **'Please enter a valid number'**
  String get enterValidNumber;

  /// Error message when the user hasn't selected an ingredient from the autocompleter
  ///
  /// In en, this message translates to:
  /// **'Please select an ingredient'**
  String get selectIngredient;

  /// A message when a user adds a new ingredient to a meal.
  ///
  /// In en, this message translates to:
  /// **'Recently added ingredients'**
  String get recentlyUsedIngredients;

  /// Label and error message when the user hasn't selected an image to save
  ///
  /// In en, this message translates to:
  /// **'Please select an image'**
  String get selectImage;

  /// Label for the popup with general app options
  ///
  /// In en, this message translates to:
  /// **'Options'**
  String get optionsLabel;

  /// No description provided for @takePicture.
  ///
  /// In en, this message translates to:
  /// **'Take a picture'**
  String get takePicture;

  /// No description provided for @chooseFromLibrary.
  ///
  /// In en, this message translates to:
  /// **'Choose from photo library'**
  String get chooseFromLibrary;

  /// No description provided for @gallery.
  ///
  /// In en, this message translates to:
  /// **'Gallery'**
  String get gallery;

  /// No description provided for @addImage.
  ///
  /// In en, this message translates to:
  /// **'Add image'**
  String get addImage;

  /// Snackbar message to show on copying data to a new log entry
  ///
  /// In en, this message translates to:
  /// **'Data copied to new entry'**
  String get dataCopied;

  /// No description provided for @appUpdateTitle.
  ///
  /// In en, this message translates to:
  /// **'Update needed'**
  String get appUpdateTitle;

  /// No description provided for @appUpdateContent.
  ///
  /// In en, this message translates to:
  /// **'This version of the app is not compatible with the server, please update your application.'**
  String get appUpdateContent;

  /// Header label for dialog when product is found with barcode
  ///
  /// In en, this message translates to:
  /// **'Product found'**
  String get productFound;

  /// Dialog info when product is found with barcode
  ///
  /// In en, this message translates to:
  /// **'The barcode corresponds to this product: {productName}. Do you want to continue?'**
  String productFoundDescription(String productName);

  /// Header label for dialog when product is not found with barcode
  ///
  /// In en, this message translates to:
  /// **'Product not found'**
  String get productNotFound;

  /// Dialog info when product is not found with barcode
  ///
  /// In en, this message translates to:
  /// **'The product with the scanned barcode {barcode} was not found in the wger database'**
  String productNotFoundDescription(String barcode);

  /// Label for scan barcode button
  ///
  /// In en, this message translates to:
  /// **'Scan barcode'**
  String get scanBarcode;

  /// Translation for close
  ///
  /// In en, this message translates to:
  /// **'Close'**
  String get close;

  /// No description provided for @identicalExercisePleaseDiscard.
  ///
  /// In en, this message translates to:
  /// **'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.'**
  String get identicalExercisePleaseDiscard;

  /// No description provided for @checkInformationBeforeSubmitting.
  ///
  /// In en, this message translates to:
  /// **'Please check that the information you entered is correct before submitting the exercise'**
  String get checkInformationBeforeSubmitting;

  /// No description provided for @add_exercise_image_license.
  ///
  /// In en, this message translates to:
  /// **'Images must be compatible with the CC BY SA license. If in doubt, upload only photos you\'ve taken yourself.'**
  String get add_exercise_image_license;

  /// Title for image details form
  ///
  /// In en, this message translates to:
  /// **'Image details'**
  String get imageDetailsTitle;

  /// Label for image title field
  ///
  /// In en, this message translates to:
  /// **'Title'**
  String get imageDetailsLicenseTitle;

  /// Hint text for image title field
  ///
  /// In en, this message translates to:
  /// **'Enter image title'**
  String get imageDetailsLicenseTitleHint;

  /// Label for source link field
  ///
  /// In en, this message translates to:
  /// **'Link to the source website'**
  String get imageDetailsSourceLink;

  /// No description provided for @author.
  ///
  /// In en, this message translates to:
  /// **'Author(s)'**
  String get author;

  /// Hint text for author field
  ///
  /// In en, this message translates to:
  /// **'Enter author name'**
  String get authorHint;

  /// Label for author link field
  ///
  /// In en, this message translates to:
  /// **'Link to author website or profile'**
  String get imageDetailsAuthorLink;

  /// Label for derivative source field
  ///
  /// In en, this message translates to:
  /// **'Link to the original source, if this is a derivative work'**
  String get imageDetailsDerivativeSource;

  /// Helper text explaining derivative works
  ///
  /// In en, this message translates to:
  /// **'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.'**
  String get imageDetailsDerivativeHelp;

  /// Label for image type selector
  ///
  /// In en, this message translates to:
  /// **'Image Type'**
  String get imageDetailsImageType;

  /// No description provided for @imageDetailsLicenseNotice.
  ///
  /// In en, this message translates to:
  /// **'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.'**
  String get imageDetailsLicenseNotice;

  /// No description provided for @imageDetailsLicenseNoticeLinkToLicense.
  ///
  /// In en, this message translates to:
  /// **'See license text.'**
  String get imageDetailsLicenseNoticeLinkToLicense;

  /// Label shown on the error container when image format is not supported
  ///
  /// In en, this message translates to:
  /// **'{imageFormat} not supported'**
  String imageFormatNotSupported(String imageFormat);

  /// Label shown on the image preview container when image format is not supported
  ///
  /// In en, this message translates to:
  /// **'{imageFormat} images are not supported yet.'**
  String imageFormatNotSupportedDetail(String imageFormat);

  /// Add button text
  ///
  /// In en, this message translates to:
  /// **'add'**
  String get add;

  /// Variations of one exercise (e.g. benchpress and benchpress narrow)
  ///
  /// In en, this message translates to:
  /// **'Variations'**
  String get variations;

  /// List of alternative names for an exercise
  ///
  /// In en, this message translates to:
  /// **'Also known as: {aliases}'**
  String alsoKnownAs(String aliases);

  /// No description provided for @verifiedEmail.
  ///
  /// In en, this message translates to:
  /// **'Verified email'**
  String get verifiedEmail;

  /// No description provided for @unVerifiedEmail.
  ///
  /// In en, this message translates to:
  /// **'Unverified email'**
  String get unVerifiedEmail;

  /// No description provided for @verifiedEmailReason.
  ///
  /// In en, this message translates to:
  /// **'You need to verify your email to contribute exercises'**
  String get verifiedEmailReason;

  /// No description provided for @verifiedEmailInfo.
  ///
  /// In en, this message translates to:
  /// **'A verification email was sent to {email}'**
  String verifiedEmailInfo(String email);

  /// No description provided for @alternativeNames.
  ///
  /// In en, this message translates to:
  /// **'Alternative names'**
  String get alternativeNames;

  /// No description provided for @oneNamePerLine.
  ///
  /// In en, this message translates to:
  /// **'One name per line'**
  String get oneNamePerLine;

  /// No description provided for @whatVariationsExist.
  ///
  /// In en, this message translates to:
  /// **'What variations of this exercise exist, if any?'**
  String get whatVariationsExist;

  /// No description provided for @previous.
  ///
  /// In en, this message translates to:
  /// **'Previous'**
  String get previous;

  /// No description provided for @next.
  ///
  /// In en, this message translates to:
  /// **'Next'**
  String get next;

  /// No description provided for @images.
  ///
  /// In en, this message translates to:
  /// **'Images'**
  String get images;

  /// No description provided for @language.
  ///
  /// In en, this message translates to:
  /// **'Language'**
  String get language;

  /// No description provided for @addExercise.
  ///
  /// In en, this message translates to:
  /// **'Add exercise'**
  String get addExercise;

  /// No description provided for @fitInWeek.
  ///
  /// In en, this message translates to:
  /// **'Fit in week'**
  String get fitInWeek;

  /// No description provided for @fitInWeekHelp.
  ///
  /// In en, this message translates to:
  /// **'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.'**
  String get fitInWeekHelp;

  /// No description provided for @addSuperset.
  ///
  /// In en, this message translates to:
  /// **'Add superset'**
  String get addSuperset;

  /// No description provided for @superset.
  ///
  /// In en, this message translates to:
  /// **'Superset'**
  String get superset;

  /// No description provided for @setHasProgression.
  ///
  /// In en, this message translates to:
  /// **'Set has progression'**
  String get setHasProgression;

  /// No description provided for @setHasProgressionWarning.
  ///
  /// In en, this message translates to:
  /// **'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.'**
  String get setHasProgressionWarning;

  /// No description provided for @setHasNoExercises.
  ///
  /// In en, this message translates to:
  /// **'This set has no exercises yet!'**
  String get setHasNoExercises;

  /// No description provided for @contributeExercise.
  ///
  /// In en, this message translates to:
  /// **'Contribute an exercise'**
  String get contributeExercise;

  /// No description provided for @translation.
  ///
  /// In en, this message translates to:
  /// **'Translation'**
  String get translation;

  /// No description provided for @translateExercise.
  ///
  /// In en, this message translates to:
  /// **'Translate this exercise now'**
  String get translateExercise;

  /// The base data for an exercise such as category, trained muscles, etc.
  ///
  /// In en, this message translates to:
  /// **'Basics in English'**
  String get baseData;

  /// No description provided for @enterTextInLanguage.
  ///
  /// In en, this message translates to:
  /// **'Please enter the text in the correct language!'**
  String get enterTextInLanguage;

  /// No description provided for @settingsTitle.
  ///
  /// In en, this message translates to:
  /// **'Settings'**
  String get settingsTitle;

  /// No description provided for @settingsCacheTitle.
  ///
  /// In en, this message translates to:
  /// **'Cache'**
  String get settingsCacheTitle;

  /// No description provided for @settingsExerciseCacheDescription.
  ///
  /// In en, this message translates to:
  /// **'Exercise cache'**
  String get settingsExerciseCacheDescription;

  /// No description provided for @settingsIngredientCacheDescription.
  ///
  /// In en, this message translates to:
  /// **'Ingredient cache'**
  String get settingsIngredientCacheDescription;

  /// No description provided for @settingsCacheDeletedSnackbar.
  ///
  /// In en, this message translates to:
  /// **'Cache successfully cleared'**
  String get settingsCacheDeletedSnackbar;

  /// No description provided for @aboutPageTitle.
  ///
  /// In en, this message translates to:
  /// **'About us & Support'**
  String get aboutPageTitle;

  /// Number of days before which a person can add exercise
  ///
  /// In en, this message translates to:
  /// **'You can only contribute exercises if your account is older than {days} days and have verified your email'**
  String contributeExerciseWarning(String days);

  /// No description provided for @simpleMode.
  ///
  /// In en, this message translates to:
  /// **'Simple mode'**
  String get simpleMode;

  /// No description provided for @simpleModeHelp.
  ///
  /// In en, this message translates to:
  /// **'Hide some of the more advanced settings when editing exercises'**
  String get simpleModeHelp;

  /// No description provided for @progressionRules.
  ///
  /// In en, this message translates to:
  /// **'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.'**
  String get progressionRules;

  /// No description provided for @cacheWarning.
  ///
  /// In en, this message translates to:
  /// **'Due to caching it might take some time till the changes are visible throughout the application.'**
  String get cacheWarning;

  /// No description provided for @textPromptTitle.
  ///
  /// In en, this message translates to:
  /// **'Ready to start?'**
  String get textPromptTitle;

  /// No description provided for @textPromptSubheading.
  ///
  /// In en, this message translates to:
  /// **'Press the action button to begin'**
  String get textPromptSubheading;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Abs'**
  String get abs;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Arms'**
  String get arms;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Back'**
  String get back;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Barbell'**
  String get barbell;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Bench'**
  String get bench;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Biceps'**
  String get biceps;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Body Weight'**
  String get body_weight;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Calves'**
  String get calves;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Cardio'**
  String get cardio;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Chest'**
  String get chest;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Dumbbell'**
  String get dumbbell;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Glutes'**
  String get glutes;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Gym mat'**
  String get gym_mat;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Hamstrings'**
  String get hamstrings;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Incline bench'**
  String get incline_bench;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Kettlebell'**
  String get kettlebell;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Kilometers'**
  String get kilometers;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Kilometers Per Hour'**
  String get kilometers_per_hour;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Lats'**
  String get lats;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Legs'**
  String get legs;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Lower back'**
  String get lower_back;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Max Reps'**
  String get max_reps;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Miles'**
  String get miles;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Miles Per Hour'**
  String get miles_per_hour;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Minutes'**
  String get minutes;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Plates'**
  String get plates;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Pull-up bar'**
  String get pull_up_bar;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Quads'**
  String get quads;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Repetitions'**
  String get repetitions;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Resistance band'**
  String get resistance_band;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'SZ-Bar'**
  String get sz_bar;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Seconds'**
  String get seconds;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Shoulders'**
  String get shoulders;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Swiss Ball'**
  String get swiss_ball;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Triceps'**
  String get triceps;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'Until Failure'**
  String get until_failure;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'kg'**
  String get kg;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'lb'**
  String get lb;

  /// Generated entry for translation for server strings
  ///
  /// In en, this message translates to:
  /// **'none (bodyweight exercise)'**
  String get none__bodyweight_exercise_;

  /// Log a specific meal (imperative form)
  ///
  /// In en, this message translates to:
  /// **'Log'**
  String get log;

  /// No description provided for @done.
  ///
  /// In en, this message translates to:
  /// **'Done'**
  String get done;

  /// Overall change in weight, added for localization
  ///
  /// In en, this message translates to:
  /// **'Overall change'**
  String get overallChangeWeight;

  /// added for localization of Class GoalType's filed meals
  ///
  /// In en, this message translates to:
  /// **'From meals'**
  String get goalTypeMeals;

  /// added for localization of Class GoalType's filed basic
  ///
  /// In en, this message translates to:
  /// **'Basic'**
  String get goalTypeBasic;

  /// added for localization of Class GoalType's filed advanced
  ///
  /// In en, this message translates to:
  /// **'Advanced'**
  String get goalTypeAdvanced;

  /// added for localization of Class Indicator's field text
  ///
  /// In en, this message translates to:
  /// **'raw'**
  String get indicatorRaw;

  /// added for localization of Class Indicator's field text
  ///
  /// In en, this message translates to:
  /// **'avg'**
  String get indicatorAvg;

  /// Use the imperative, label on button to finish the current workout in gym mode
  ///
  /// In en, this message translates to:
  /// **'End workout'**
  String get endWorkout;

  /// No description provided for @themeMode.
  ///
  /// In en, this message translates to:
  /// **'Theme mode'**
  String get themeMode;

  /// No description provided for @darkMode.
  ///
  /// In en, this message translates to:
  /// **'Always dark mode'**
  String get darkMode;

  /// No description provided for @lightMode.
  ///
  /// In en, this message translates to:
  /// **'Always light mode'**
  String get lightMode;

  /// No description provided for @systemMode.
  ///
  /// In en, this message translates to:
  /// **'System settings'**
  String get systemMode;
}

class _AppLocalizationsDelegate extends LocalizationsDelegate<AppLocalizations> {
  const _AppLocalizationsDelegate();

  @override
  Future<AppLocalizations> load(Locale locale) {
    return SynchronousFuture<AppLocalizations>(lookupAppLocalizations(locale));
  }

  @override
  bool isSupported(Locale locale) => <String>[
    'am',
    'ar',
    'ca',
    'cs',
    'de',
    'el',
    'en',
    'es',
    'fa',
    'fil',
    'fr',
    'he',
    'hi',
    'hr',
    'hu',
    'id',
    'it',
    'ja',
    'ko',
    'nb',
    'nl',
    'pl',
    'pt',
    'ro',
    'ru',
    'sk',
    'ta',
    'th',
    'tr',
    'uk',
    'zh',
  ].contains(locale.languageCode);

  @override
  bool shouldReload(_AppLocalizationsDelegate old) => false;
}

AppLocalizations lookupAppLocalizations(Locale locale) {
  // Lookup logic when language+script codes are specified.
  switch (locale.languageCode) {
    case 'zh':
      {
        switch (locale.scriptCode) {
          case 'Hant':
            return AppLocalizationsZhHant();
        }
        break;
      }
  }

  // Lookup logic when language+country codes are specified.
  switch (locale.languageCode) {
    case 'pt':
      {
        switch (locale.countryCode) {
          case 'BR':
            return AppLocalizationsPtBr();
          case 'PT':
            return AppLocalizationsPtPt();
        }
        break;
      }
  }

  // Lookup logic when only language code is specified.
  switch (locale.languageCode) {
    case 'am':
      return AppLocalizationsAm();
    case 'ar':
      return AppLocalizationsAr();
    case 'ca':
      return AppLocalizationsCa();
    case 'cs':
      return AppLocalizationsCs();
    case 'de':
      return AppLocalizationsDe();
    case 'el':
      return AppLocalizationsEl();
    case 'en':
      return AppLocalizationsEn();
    case 'es':
      return AppLocalizationsEs();
    case 'fa':
      return AppLocalizationsFa();
    case 'fil':
      return AppLocalizationsFil();
    case 'fr':
      return AppLocalizationsFr();
    case 'he':
      return AppLocalizationsHe();
    case 'hi':
      return AppLocalizationsHi();
    case 'hr':
      return AppLocalizationsHr();
    case 'hu':
      return AppLocalizationsHu();
    case 'id':
      return AppLocalizationsId();
    case 'it':
      return AppLocalizationsIt();
    case 'ja':
      return AppLocalizationsJa();
    case 'ko':
      return AppLocalizationsKo();
    case 'nb':
      return AppLocalizationsNb();
    case 'nl':
      return AppLocalizationsNl();
    case 'pl':
      return AppLocalizationsPl();
    case 'pt':
      return AppLocalizationsPt();
    case 'ro':
      return AppLocalizationsRo();
    case 'ru':
      return AppLocalizationsRu();
    case 'sk':
      return AppLocalizationsSk();
    case 'ta':
      return AppLocalizationsTa();
    case 'th':
      return AppLocalizationsTh();
    case 'tr':
      return AppLocalizationsTr();
    case 'uk':
      return AppLocalizationsUk();
    case 'zh':
      return AppLocalizationsZh();
  }

  throw FlutterError(
    'AppLocalizations.delegate failed to load unsupported locale "$locale". This is likely '
    'an issue with the localizations generation tool. Please file an issue '
    'on GitHub with a reproducible sample app and the gen-l10n configuration '
    'that was used.',
  );
}
