# Mobile app for wger

wger is a free, open-source flutter application that manages and tracks/logs
your exercises and personal workouts, weight, and diet plans. This is the mobile
app written with Flutter, it talks via REST with the main server.

If you want to contribute, hop on the Discord server and say hi!


<p align="center">
<img src="https://raw.githubusercontent.com/wger-project/flutter/master/fastlane/metadata/android/en-US/images/phoneScreenshots/01%20-%20dashboard.png" width="200" alt="" />

<img src="https://raw.githubusercontent.com/wger-project/flutter/master/fastlane/metadata/android/en-US/images/phoneScreenshots/04%20-%20measurements.png" width="200" alt="" />

<img src="https://raw.githubusercontent.com/wger-project/flutter/master/fastlane/metadata/android/en-US/images/phoneScreenshots/05%20-%20nutritional%20plan.png" width="200" alt="" />
</p>

## Installation

[<img src="https://raw.githubusercontent.com/wger-project/wger/refs/heads/master/wger/core/static/images/logos/play-store/badge.svg"
alt="Get it on Google Play"
height="55">](https://play.google.com/store/apps/details?id=de.wger.flutter)
[<img src="https://raw.githubusercontent.com/wger-project/wger/refs/heads/master/wger/core/static/images/logos/fdroid/get-it-on.svg"
alt="Get it on F-Droid"
height="55">](https://f-droid.org/packages/de.wger.flutter/)
[<img src="https://raw.githubusercontent.com/wger-project/wger/refs/heads/master/wger/core/static/images/logos/app-store/black.svg"
alt="Download on the App Store"
height="55">](https://apps.apple.com/us/app/wger-workout-manager/id6502226792)
[<img src="https://raw.githubusercontent.com/wger-project/wger/refs/heads/master/wger/core/static/images/logos/flathub/black.svg"
alt="Get it on Flathub"
height="55">](https://flathub.org/apps/de.wger.flutter)

## Developing and contributing

Our goal is to build an awesome and flexible fitness and nutrition manager,
along with a comprehensive list of exercises and ingredients, all released
under a free license.

For this, we’d love your help! Whether it’s code, translations, exercises or
reporting issues and ideas, check out our
[contribution guide](https://wger.readthedocs.io/en/latest/contributing.html)
to get started.

A huge thank you to everyone who has contributed so far! ❤️ See the full list
in [AUTHORS.md](AUTHORS.md).

**TLDR**

```bash
flutter run
```

This is a regular flutter application, so there's no magic. You will need a backend
for this, so feel free to use the test server for this (the db is reset daily):

* URL: `https://wger-master.rge.uber.space`
* username: `user`
* password: `flutteruser`

## Translation

Translate the app to your language on [Weblate](https://hosted.weblate.org/engage/wger/).

[![translation status](https://hosted.weblate.org/widgets/wger/-/mobile/multi-blue.svg)](https://hosted.weblate.org/engage/wger/)

## Contact

Feel free to get in touch if you found this useful or if something didn't behave
as expected. We can't fix what we don't know about, so please report liberally.
If you're not sure if something is a bug or not, feel free to file a bug anyway.

* **Discord:** <https://discord.gg/rPWFv6W>
* **Issue tracker:** <https://github.com/wger-project/flutter/issues>
* **Mastodon:** <https://fosstodon.org/@wger>

## License

The application is licensed under the GNU Affero General Public License 3 or later
(AGPL 3+) with an app store exception.

As additional permission under section 7, you are allowed to distribute the
software through an app store, even if that store has restrictive terms and
conditions that are incompatible with the AGPL, provided that the source is also
available under the AGPL with or without this permission through a channel without
those restrictive terms and conditions.

The initial exercise and ingredient data is licensed additionally under one of
the Creative Commons licenses, see the individual exercises for more details.

