// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Tamil (`ta`).
class AppLocalizationsTa extends AppLocalizations {
  AppLocalizationsTa([String locale = 'ta']) : super(locale);

  @override
  String get userProfile => 'உங்கள் சுயவிவரம்';

  @override
  String get login => 'புகுபதிகை';

  @override
  String get logout => 'விடுபதிகை';

  @override
  String get register => 'பதிவு செய்யுங்கள்';

  @override
  String get useDefaultServer => 'இயல்புநிலை சேவையகத்தைப் பயன்படுத்தவும்';

  @override
  String get useCustomServer => 'தனிப்பயன் சேவையகத்தைப் பயன்படுத்தவும்';

  @override
  String get invalidUrl => 'செல்லுபடியாகும் முகவரி ஐ உள்ளிடவும்';

  @override
  String get usernameValidChars =>
      'ஒரு பயனர்பெயரில் கடிதங்கள், இலக்கங்கள் மற்றும் எழுத்துக்கள் @, +,., -, மற்றும் _ எழுத்துக்கள் மட்டுமே இருக்கலாம்';

  @override
  String get passwordsDontMatch => 'கடவுச்சொற்கள் பொருந்தவில்லை';

  @override
  String get passwordTooShort => 'கடவுச்சொல் மிகக் குறைவு';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'கடவுச்சொல்';

  @override
  String get confirmPassword => 'கடவுச்சொல்லை உறுதிப்படுத்தவும்';

  @override
  String get invalidEmail => 'செல்லுபடியாகும் மின்னஞ்சல் முகவரியை உள்ளிடவும்';

  @override
  String get email => 'மின்னஞ்சல் முகவரி';

  @override
  String get username => 'பயனர்பெயர்';

  @override
  String get invalidUsername => 'செல்லுபடியாகும் பயனர்பெயரை உள்ளிடவும்';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'Wger உதாரணத்தின் முகவரி';

  @override
  String get customServerHint =>
      'உங்கள் சொந்த சேவையகத்தின் முகவரியை உள்ளிடவும், இல்லையெனில் இயல்புநிலை பயன்படுத்தப்படும்';

  @override
  String get reset => 'மீட்டமை';

  @override
  String get registerInstead => 'கணக்கு இல்லையா? இப்போது பதிவு செய்யுங்கள்';

  @override
  String get loginInstead => 'ஏற்கனவே ஒரு கணக்கு இருக்கிறதா? உள்நுழைவு';

  @override
  String get labelBottomNavWorkout => 'பயிற்சி';

  @override
  String get labelBottomNavNutrition => 'ஊட்டம்';

  @override
  String get labelWorkoutLogs => 'பயிற்சி பதிவுகள்';

  @override
  String get labelWorkoutPlan => 'வொர்க்அவுட் திட்டம்';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'முகப்புப்பெட்டி';

  @override
  String get success => 'வெற்றி';

  @override
  String get successfullyDeleted => 'நீக்கப்பட்டது';

  @override
  String get successfullySaved => 'சேமிக்கப்பட்டது';

  @override
  String get exerciseList => 'உடற்பயிற்சி பட்டியல்';

  @override
  String get exercise => 'உடற்பயிற்சி';

  @override
  String get exercises => 'பயிற்சிகள்';

  @override
  String get exerciseName => 'உடற்பயிற்சி பெயர்';

  @override
  String get searchExercise => 'சேர்க்க பயிற்சியைத் தேடுங்கள்';

  @override
  String get noIngredientsDefined => 'இதுவரை எந்த பொருட்களும் வரையறுக்கப்படவில்லை';

  @override
  String get noMatchingExerciseFound => 'பொருந்தக்கூடிய பயிற்சிகள் எதுவும் கிடைக்கவில்லை';

  @override
  String get searchNamesInEnglish => 'ஆங்கிலத்தில் பெயர்களையும் தேடுங்கள்';

  @override
  String get equipment => 'உபகரணங்கள்';

  @override
  String get muscles => 'தசைகள்';

  @override
  String get musclesSecondary => 'இரண்டாம் நிலை தசைகள்';

  @override
  String get category => 'வகை';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'நடைமுறைகள்';

  @override
  String get newRoutine => 'புதிய வழக்கமான';

  @override
  String get noRoutines => 'உங்களுக்கு எந்த நடைமுறைகளும் இல்லை';

  @override
  String get reps => 'பிரதிநிதிகள்';

  @override
  String get restTime => 'ஓய்வு நேரம்';

  @override
  String get sets => 'செட்';

  @override
  String get rir => 'ஆர்.ஐ.ஆர்';

  @override
  String get rirNotUsed => 'ஆர்.ஐ.ஆர் பயன்படுத்தப்படவில்லை';

  @override
  String get useMetric => 'உடல் எடைக்கு மெட்ரிக் அலகுகளைப் பயன்படுத்துங்கள்';

  @override
  String get weightUnit => 'எடை அலகு';

  @override
  String get repetitionUnit => 'மீண்டும் அலகு';

  @override
  String get set => 'கணம்';

  @override
  String get dayDescriptionHelp =>
      'இந்த நாளில் என்ன செய்யப்படுகிறது என்பதற்கான விளக்கம் (எ.கா. \'இழுக்க நாள்\') அல்லது என்ன உடல் பாகங்கள் பயிற்சி அளிக்கப்படுகின்றன (எ.கா. \'மார்பு மற்றும் தோள்கள்\')';

  @override
  String exerciseNr(String nr) {
    return 'உடற்பயிற்சி $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'சூப்பர்செட் $nr';
  }

  @override
  String get sameRepetitions =>
      'எல்லா தொகுப்புகளுக்கும் நீங்கள் அதே மறுபடியும் எடையும் செய்தால், நீங்கள் ஒரு வரிசையை நிரப்பலாம். எடுத்துக்காட்டாக, 4 செட்களுக்கு மறுபடியும் 10 ஐ உள்ளிடவும், இது தானாகவே \"4 ஃச் 10\" ஆகிறது.';

  @override
  String get comment => 'கருத்து';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'எண்ணம்';

  @override
  String get notes => 'குறிப்புகள்';

  @override
  String get workoutSession => 'வொர்க்அவுட் அமர்வு';

  @override
  String get restDay => 'ஓய்வு நாள்';

  @override
  String get isRestDay => 'ஓய்வு நாள்';

  @override
  String get isRestDayHelp =>
      'ஒரு நாள் ஓய்வு நாளாக நீங்கள் குறிக்கும்போது அனைத்து தொகுப்புகளும் பயிற்சிகளும் அகற்றப்படும் என்பதை நினைவில் கொள்க.';

  @override
  String get needsLogsToAdvance => 'முன்னேற பதிவுகள் தேவை';

  @override
  String get needsLogsToAdvanceHelp =>
      'நீங்கள் ஒரு வொர்க்அவுட்டை பதிவு செய்திருந்தால் மட்டுமே அடுத்த திட்டமிடப்பட்ட நாளுக்கு வழக்கம் முன்னேற வேண்டுமா என்பதைத் தேர்ந்தெடுக்கவும்';

  @override
  String get routineDays => 'வழக்கமான நாட்கள்';

  @override
  String get resultingRoutine => 'இதன் விளைவாக வழக்கமான';

  @override
  String get newDay => 'புதிய நாள்';

  @override
  String get newSet => 'புதிய தொகுப்பு';

  @override
  String get selectExercises =>
      'நீங்கள் ஒரு சூப்பர்செட் செய்ய விரும்பினால், நீங்கள் பல பயிற்சிகளைத் தேடலாம், அவை ஒன்றாக தொகுக்கப்படும்';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'சிம் பயன்முறை';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'தட்டுகள்';

  @override
  String get plateCalculatorNotDivisible => 'கிடைக்கக்கூடிய தட்டுகளுடன் எடையை அடைய முடியாது';

  @override
  String get pause => 'இடைநிறுத்தம்';

  @override
  String get jumpTo => 'குதிக்கவும்';

  @override
  String get todaysWorkout => 'இன்று உங்கள் பயிற்சி';

  @override
  String get logHelpEntries =>
      'ஒரு நாளில் ஒரே எண்ணிக்கையிலான மறுபடியும் ஒன்றுக்கு மேற்பட்ட நுழைவு இருந்தால், ஆனால் வெவ்வேறு எடைகள் இருந்தால், அதிக எடையுடன் நுழைவு மட்டுமே வரைபடத்தில் காட்டப்பட்டுள்ளது.';

  @override
  String get logHelpEntriesUnits =>
      'ஒரு எடை அலகு (கிலோ அல்லது எல்பி) மற்றும் மறுபடியும் உள்ளீடுகள் மட்டுமே பட்டியலிடப்பட்டுள்ளன என்பதை நினைவில் கொள்க, நேரம் போன்ற பிற சேர்க்கைகள் அல்லது தோல்வி வரை இங்கே புறக்கணிக்கப்படும்.';

  @override
  String get description => 'விவரம்';

  @override
  String get name => 'பெயர்';

  @override
  String get save => 'சேமி';

  @override
  String get verify => 'சரிபார்க்கவும்';

  @override
  String get addSet => 'செட் சேர்';

  @override
  String get addMeal => 'உணவு சேர்க்கவும்';

  @override
  String get mealLogged => 'உணவு நாட்குறிப்புக்கு உள்நுழைந்துள்ளது';

  @override
  String get ingredientLogged => 'மூலப்பொருள் நாட்குறிப்புக்கு உள்நுழைந்துள்ளது';

  @override
  String get logMeal => 'ஊட்டச்சத்து நாட்குறிப்புக்கு உணவை பதிவு செய்யுங்கள்';

  @override
  String get addIngredient => 'மூலப்பொருள் சேர்க்கவும்';

  @override
  String get logIngredient => 'ஊட்டச்சத்து நாட்குறிப்புக்கு பதிவு மூலப்பொருள்';

  @override
  String get searchIngredient => 'மூலப்பொருளைத் தேடுங்கள்';

  @override
  String get nutritionalPlan => 'ஊட்டச்சத்து திட்டம்';

  @override
  String get nutritionalDiary => 'ஊட்டச்சத்து நாட்குறிப்பு';

  @override
  String get nutritionalPlans => 'ஊட்டச்சத்து திட்டங்கள்';

  @override
  String get noNutritionalPlans => 'உங்களிடம் ஊட்டச்சத்து திட்டங்கள் இல்லை';

  @override
  String get onlyLogging => 'கலோரிகளை மட்டுமே கண்காணிக்கவும்';

  @override
  String get onlyLoggingHelpText =>
      'உங்கள் கலோரிகளை மட்டுமே உள்நுழைய விரும்பினால், குறிப்பிட்ட உணவுடன் விரிவான ஊட்டச்சத்து திட்டத்தை அமைக்க விரும்பவில்லை என்றால் பெட்டியை சரிபார்க்கவும்';

  @override
  String get goalMacro => 'ரோ இலக்குகள்';

  @override
  String get selectMealToLog => 'நாட்குறிப்புக்கு உள்நுழைய ஒரு உணவைத் தேர்ந்தெடுக்கவும்';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'ஆற்றல் இலக்கு';

  @override
  String get goalProtein => 'புரத இலக்கு';

  @override
  String get goalCarbohydrates => 'கார்போஐட்ரேட் இலக்கு';

  @override
  String get goalFat => 'கொழுப்பு இலக்கு';

  @override
  String get goalFiber => 'ஃபைபர் இலக்கு';

  @override
  String get anErrorOccurred => 'பிழை ஏற்பட்டது!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'எடை';

  @override
  String get min => 'மணித்துளி';

  @override
  String get max => 'அதிகபட்சம்';

  @override
  String chartAllTimeTitle(String name) {
    return '$name எல்லா நேரத்திலும்';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name கடைசி 30 நாட்கள்';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartNameஊட்டச்சத்து திட்டத்தின்போது $planName';
  }

  @override
  String get measurement => 'அளவீட்டு';

  @override
  String get measurements => 'அளவீடுகள்';

  @override
  String get measurementCategoriesHelpText =>
      '\'பைசெப்ச்\' அல்லது \'உடல் கொழுப்பு\' போன்ற அளவீட்டு வகை';

  @override
  String get measurementEntriesHelpText =>
      '\'செ.மீ\' அல்லது \'%\' போன்ற வகையை அளவிட பயன்படுத்தப்படும் அலகு';

  @override
  String get date => 'திகதி';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'மதிப்பு';

  @override
  String get start => 'தொடங்கு';

  @override
  String get time => 'நேரம்';

  @override
  String get timeStart => 'தொடக்க நேரம்';

  @override
  String get timeEnd => 'இறுதி நேரம்';

  @override
  String get timeStartAhead => 'தொடக்க நேரம் இறுதி நேரத்திற்கு முன்னால் இருக்க முடியாது';

  @override
  String get ingredient => 'மூலப்பொருள்';

  @override
  String get energy => 'ஆற்றல்';

  @override
  String get energyShort => 'இ';

  @override
  String get macronutrients => 'மக்ரோனூட்ரியண்ட்ச்';

  @override
  String get planned => 'திட்டமிடப்பட்டது';

  @override
  String get logged => 'உள்நுழைந்த';

  @override
  String get today => 'இன்று';

  @override
  String get loggedToday => 'இன்று உள்நுழைந்துள்ளது';

  @override
  String get weekAverage => '7 நாள் சராசரி';

  @override
  String get surplus => 'உபரி';

  @override
  String get deficit => 'பற்றாக்குறை';

  @override
  String get difference => 'வேறுபாடு';

  @override
  String get percentEnergy => 'ஆற்றலின் விழுக்காடு';

  @override
  String get gPerBodyKg => 'g க்கு kg';

  @override
  String get total => 'மொத்தம்';

  @override
  String get kcal => 'கிலோகலோரி';

  @override
  String kcalValue(String value) {
    return '$value கிலோகலோரி';
  }

  @override
  String get kJ => 'கேசே';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'புரதம்';

  @override
  String get proteinShort => 'ப';

  @override
  String get carbohydrates => 'கார்போஐட்ரேட்டுகள்';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'சர்க்கரைகள்';

  @override
  String get fat => 'கொழுப்பு';

  @override
  String get fatShort => 'F';

  @override
  String get saturatedFat => 'பூரிதக் கொழுப்பு';

  @override
  String get fiber => 'இழைகள்';

  @override
  String get sodium => 'உவர்மம்';

  @override
  String get amount => 'தொகை';

  @override
  String get unit => 'அலகு';

  @override
  String get newEntry => 'புதிய நுழைவு';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'உங்களிடம் எடை உள்ளீடுகள் இல்லை';

  @override
  String get noMeasurementEntries => 'உங்களிடம் அளவீட்டு உள்ளீடுகள் இல்லை';

  @override
  String get moreMeasurementEntries => 'புதிய அளவீட்டைச் சேர்க்கவும்';

  @override
  String get edit => 'தொகு';

  @override
  String get loadingText => 'ஏற்றுகிறது ...';

  @override
  String get delete => 'அழி';

  @override
  String confirmDelete(String toDelete) {
    return 'நீங்கள் நிச்சயமாக \'$toDelete\' நீக்க விரும்புகிறீர்களா?';
  }

  @override
  String get newNutritionalPlan => 'புதிய ஊட்டச்சத்து திட்டம்';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'விவரங்களை மாற்றவும்';

  @override
  String get goToDetailPage => 'விவரம் பக்கத்திற்குச் செல்லவும்';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Wger ஐப் பயன்படுத்தியதற்கு நன்றி! WGER என்பது ஒரு கூட்டு திறந்த மூல திட்டமாகும், இது உலகெங்கிலும் உள்ள உடற்பயிற்சி ஆர்வலர்களால் உருவாக்கப்பட்டது.';

  @override
  String get aboutDonateTitle => 'நன்கொடை';

  @override
  String get aboutDonateText =>
      'திட்டத்திற்கு உதவ எங்களுக்கு ஒரு காபி வாங்கவும், சேவையக செலவினங்களுக்கு பணம் செலுத்தவும், எங்களை எரிபொருளாக வைத்திருக்கவும்';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'மாச்டோடன்';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'நாட்காட்டி';

  @override
  String get goToToday => 'இன்று செல்லுங்கள்';

  @override
  String get enterValue => 'தயவுசெய்து ஒரு மதிப்பை உள்ளிடவும்';

  @override
  String get selectEntry => 'உள்ளீட்டைத் தேர்ந்தெடுக்கவும்';

  @override
  String get selectExercise => 'ஒரு பயிற்சியைத் தேர்ந்தெடுக்கவும்';

  @override
  String enterCharacters(String min, String max) {
    return 'தயவுசெய்து $min மற்றும் $max எழுத்துக்களுக்கு இடையில் உள்ளிடவும்';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'தயவுசெய்து குறைந்தது $min எழுத்துக்களை உள்ளிடவும்';
  }

  @override
  String get baseNameEnglish => 'அனைத்து பயிற்சிகளுக்கும் ஆங்கிலத்தில் அடிப்படை பெயர் தேவை';

  @override
  String nrOfSets(String nrOfSets) {
    return 'ஒரு பயிற்சிக்கு அமைக்கிறது: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'அலகுகள் மற்றும் ஆர்.ஐ.ஆர்';

  @override
  String get enterValidNumber => 'செல்லுபடியாகும் எண்ணை உள்ளிடவும்';

  @override
  String get selectIngredient => 'தயவுசெய்து ஒரு மூலப்பொருளைத் தேர்ந்தெடுக்கவும்';

  @override
  String get recentlyUsedIngredients => 'அண்மைக் காலத்தில் சேர்க்கப்பட்ட பொருட்கள்';

  @override
  String get selectImage => 'ஒரு படத்தைத் தேர்ந்தெடுக்கவும்';

  @override
  String get optionsLabel => 'விருப்பங்கள்';

  @override
  String get takePicture => 'படம் எடுக்கவும்';

  @override
  String get chooseFromLibrary => 'புகைப்பட நூலகத்திலிருந்து தேர்வு செய்யவும்';

  @override
  String get gallery => 'கேலரி';

  @override
  String get addImage => 'படத்தைச் சேர்க்கவும்';

  @override
  String get dataCopied => 'தரவு புதிய நுழைவுக்கு நகலெடுக்கப்பட்டது';

  @override
  String get appUpdateTitle => 'புதுப்பிப்பு தேவை';

  @override
  String get appUpdateContent =>
      'பயன்பாட்டின் இந்த பதிப்பு சேவையகத்துடன் பொருந்தாது, தயவுசெய்து உங்கள் பயன்பாட்டைப் புதுப்பிக்கவும்.';

  @override
  String get productFound => 'தயாரிப்பு காணப்பட்டது';

  @override
  String productFoundDescription(String productName) {
    return 'பார்கோடு இந்தத் தயாரிப்புக்கு ஒத்திருக்கிறது: $productName. நீங்கள் தொடர விரும்புகிறீர்களா?';
  }

  @override
  String get productNotFound => 'தயாரிப்பு கிடைக்கவில்லை';

  @override
  String productNotFoundDescription(String barcode) {
    return 'ச்கேன் செய்யப்பட்ட பார்கோடு $barcode with உடன் தயாரிப்பு WGER தரவுத்தளத்தில் காணப்படவில்லை';
  }

  @override
  String get scanBarcode => 'ச்கேன் பார்கோடு';

  @override
  String get close => 'மூடு';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'எச்.ஏ. உரிமம் மூலம் சி.சி உடன் படங்கள் இணக்கமாக இருக்க வேண்டும். ஐயம் இருந்தால், நீங்கள் எடுத்த புகைப்படங்களை மட்டுமே பதிவேற்றவும்.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat not supported';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat images are not supported yet.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'மாறுபாடுகள்';

  @override
  String alsoKnownAs(String aliases) {
    return 'என்றும் அழைக்கப்படுகிறது: $aliases';
  }

  @override
  String get verifiedEmail => 'சரிபார்க்கப்பட்ட மின்னஞ்சல்';

  @override
  String get unVerifiedEmail => 'சரிபார்க்கப்படாத மின்னஞ்சல்';

  @override
  String get verifiedEmailReason => 'பயிற்சிகள் பங்களிக்க உங்கள் மின்னஞ்சலை சரிபார்க்க வேண்டும்';

  @override
  String verifiedEmailInfo(String email) {
    return 'சரிபார்ப்பு மின்னஞ்சல் $email க்கு அனுப்பப்பட்டது';
  }

  @override
  String get alternativeNames => 'மாற்று பெயர்கள்';

  @override
  String get oneNamePerLine => 'ஒரு வரிக்கு ஒரு பெயர்';

  @override
  String get whatVariationsExist => 'இந்த பயிற்சியின் என்ன மாறுபாடுகள் உள்ளன, ஏதேனும் இருந்தால்?';

  @override
  String get previous => 'முந்தைய';

  @override
  String get next => 'அடுத்தது';

  @override
  String get images => 'படங்கள்';

  @override
  String get language => 'மொழி';

  @override
  String get addExercise => 'உடற்பயிற்சியைச் சேர்க்கவும்';

  @override
  String get fitInWeek => 'வாரத்தில் பொருத்தம்';

  @override
  String get fitInWeekHelp =>
      'இயக்கப்பட்டிருந்தால், வாரங்கள் வாராந்திர சுழற்சியில் மீண்டும் மீண்டும் வரும், இல்லையெனில் நாட்கள் ஒரு புதிய வாரத்தின் தொடக்கத்தில் இல்லாமல் தொடர்ச்சியாக பின்பற்றப்படும்.';

  @override
  String get addSuperset => 'சூப்பர்செட் சேர்க்கவும்';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'செட் முன்னேற்றத்தைக் கொண்டுள்ளது';

  @override
  String get setHasProgressionWarning =>
      'மொபைல் பயன்பாட்டில் ஒரு தொகுப்பிற்கான அனைத்து அமைப்புகளையும் திருத்தவோ அல்லது தானியங்கி முன்னேற்றத்தை உள்ளமைக்கவோ இந்த நேரத்தில் சாத்தியமில்லை என்பதை நினைவில் கொள்க. இப்போதைக்கு, வலை பயன்பாட்டைப் பயன்படுத்தவும்.';

  @override
  String get setHasNoExercises => 'இந்த தொகுப்பில் இதுவரை எந்த பயிற்சிகளும் இல்லை!';

  @override
  String get contributeExercise => 'ஒரு உடற்பயிற்சியை பங்களிக்கவும்';

  @override
  String get translation => 'மொழிபெயர்ப்பு';

  @override
  String get translateExercise => 'இந்த பயிற்சியை இப்போது மொழிபெயர்க்கவும்';

  @override
  String get baseData => 'ஆங்கிலத்தில் அடிப்படைகள்';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'அமைப்புகள்';

  @override
  String get settingsCacheTitle => 'கேச்';

  @override
  String get settingsExerciseCacheDescription => 'கேச் உடற்பயிற்சி';

  @override
  String get settingsIngredientCacheDescription => 'மூலப்பொருள் தற்காலிக சேமிப்பு';

  @override
  String get settingsCacheDeletedSnackbar => 'கேச் வெற்றிகரமாக அழிக்கப்பட்டது';

  @override
  String get aboutPageTitle => 'Wger பற்றி';

  @override
  String contributeExerciseWarning(String days) {
    return 'உங்கள் கணக்கு $days நாட்களைவிடப் பழையதாக இருந்தால் மட்டுமே நீங்கள் பயிற்சிகளைப் பங்களிக்க முடியும், மேலும் உங்கள் மின்னஞ்சலைச் சரிபார்த்துள்ளீர்கள்';
  }

  @override
  String get simpleMode => 'எளிய முறை';

  @override
  String get simpleModeHelp => 'பயிற்சிகளைத் திருத்தும்போது சில மேம்பட்ட அமைப்புகளை மறைக்கவும்';

  @override
  String get progressionRules =>
      'இந்த பயிற்சி முன்னேற்ற விதிகளைக் கொண்டுள்ளது மற்றும் மொபைல் பயன்பாட்டில் திருத்த முடியாது. இந்த பயிற்சியைத் திருத்த வலை பயன்பாட்டைப் பயன்படுத்தவும்.';

  @override
  String get cacheWarning =>
      'கேச்சிங் காரணமாக விண்ணப்பம் முழுவதும் மாற்றங்கள் தெரியும் வரை சிறிது நேரம் ஆகலாம்.';

  @override
  String get textPromptTitle => 'தொடங்க தயாரா?';

  @override
  String get textPromptSubheading => 'தொடங்க செயல் பொத்தானை அழுத்தவும்';

  @override
  String get abs => 'ஏபிஎச்';

  @override
  String get arms => 'ஆயுதங்கள்';

  @override
  String get back => 'பின்';

  @override
  String get barbell => 'பார்பெல்';

  @override
  String get bench => 'பென்ச்';

  @override
  String get biceps => 'கயிறுகள்';

  @override
  String get body_weight => 'உடல் எடை';

  @override
  String get calves => 'கன்றுகள்';

  @override
  String get cardio => 'கார்டியோ';

  @override
  String get chest => 'மார்பு';

  @override
  String get dumbbell => 'டம்பல்';

  @override
  String get glutes => 'க்ளூட்டுகள்';

  @override
  String get gym_mat => 'சிம் பாய்';

  @override
  String get hamstrings => 'தொடை எலும்புகள்';

  @override
  String get incline_bench => 'சாய்வு பெஞ்ச்';

  @override
  String get kettlebell => 'கெட்டில் பெல்';

  @override
  String get kilometers => 'கிலோமீட்டர்';

  @override
  String get kilometers_per_hour => 'ஒரு மணி நேரத்திற்கு கிலோமீட்டர்';

  @override
  String get lats => 'லாட்ச்';

  @override
  String get legs => 'கால்கள்';

  @override
  String get lower_back => 'கீழ் முதுகு';

  @override
  String get max_reps => 'அதிகபட்ச பிரதிநிதிகள்';

  @override
  String get miles => 'மைல்கள்';

  @override
  String get miles_per_hour => 'ஒரு மணி நேரத்திற்கு மைல்கள்';

  @override
  String get minutes => 'நிமிடங்கள்';

  @override
  String get plates => 'தட்டுகள்';

  @override
  String get pull_up_bar => 'புல்-அப் பார்';

  @override
  String get quads => 'குவாட்ச்';

  @override
  String get repetitions => 'மறுபடியும்';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'பட்டி';

  @override
  String get seconds => 'நொடிகள்';

  @override
  String get shoulders => 'தோள்கள்';

  @override
  String get swiss_ball => 'சுவிச் பந்து';

  @override
  String get triceps => 'ட்ரைசெப்ச்';

  @override
  String get until_failure => 'தோல்வி வரை';

  @override
  String get kg => 'கிலோ';

  @override
  String get lb => 'எல்.பி.';

  @override
  String get none__bodyweight_exercise_ => 'எதுவுமில்லை (உடல் எடை உடற்பயிற்சி)';

  @override
  String get log => 'பதிவு';

  @override
  String get done => 'முடிந்தது';

  @override
  String get overallChangeWeight => 'ஒட்டுமொத்த மாற்றம்';

  @override
  String get goalTypeMeals => 'உணவில் இருந்து';

  @override
  String get goalTypeBasic => 'அடிப்படை';

  @override
  String get goalTypeAdvanced => 'மேம்பட்ட';

  @override
  String get indicatorRaw => 'மூல';

  @override
  String get indicatorAvg => 'ஏ.வி.சி';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'கருப்பொருள் பயன்முறை';

  @override
  String get darkMode => 'எப்போதும் இருண்ட பயன்முறை';

  @override
  String get lightMode => 'எப்போதும் ஒளி பயன்முறை';

  @override
  String get systemMode => 'கணினி அமைப்புகள்';
}
