// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Croatian (`hr`).
class AppLocalizationsHr extends AppLocalizations {
  AppLocalizationsHr([String locale = 'hr']) : super(locale);

  @override
  String get userProfile => 'Tvoj profil';

  @override
  String get login => 'Prijavi se';

  @override
  String get logout => 'Odjavi se';

  @override
  String get register => 'Registracija';

  @override
  String get useDefaultServer => 'Koristi standardni server';

  @override
  String get useCustomServer => 'Koristi prilagođeni server';

  @override
  String get invalidUrl => 'Upiši valjanu URL adresu';

  @override
  String get usernameValidChars =>
      'Korisničko ime smije sadržavati samo slova, brojeve i sljedeće znakove: @, +, ., -, _';

  @override
  String get passwordsDontMatch => 'Lozinke se ne podudaraju';

  @override
  String get passwordTooShort => 'Lozinka je prekratka';

  @override
  String get selectAvailablePlates => 'Odaberi prosjećne ploće';

  @override
  String get barWeight => 'Težina šipke';

  @override
  String get useColors => 'Koristi boje';

  @override
  String get password => 'Lozinka';

  @override
  String get confirmPassword => 'Potvrdi lozinku';

  @override
  String get invalidEmail => 'Upiši valjanu e-mail adresu';

  @override
  String get email => 'E-mail adresa';

  @override
  String get username => 'Korisničko ime';

  @override
  String get invalidUsername => 'Upiši valjano korisničko ime';

  @override
  String get useApiToken => 'Koristi API Token';

  @override
  String get useUsernameAndPassword => 'Koristi vjerodajenice (Korisničko ime i lozinku)';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Upiši valjani API ključ';

  @override
  String get apiTokenValidChars =>
      'API ključ može sadržati slova a-f, brojke od 0-9 i mora imati točno 40 znakova';

  @override
  String get customServerUrl => 'URL wger instance';

  @override
  String get customServerHint => 'Upiši adresu tvog servera, inače će se koristiti standardni';

  @override
  String get reset => 'Resetiraj';

  @override
  String get registerInstead => 'Nemaš račun? Registriraj se';

  @override
  String get loginInstead => 'Već imaš račun? Prijavi se';

  @override
  String get labelBottomNavWorkout => 'Trening';

  @override
  String get labelBottomNavNutrition => 'Prehrana';

  @override
  String get labelWorkoutLogs => 'Dnevnici treninga';

  @override
  String get labelWorkoutPlan => 'Plan treninga';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'Kontrolna ploča';

  @override
  String get success => 'Uspjeh';

  @override
  String get successfullyDeleted => 'Izbrisano';

  @override
  String get successfullySaved => 'Spremljeno';

  @override
  String get exerciseList => 'Popis vježbi';

  @override
  String get exercise => 'Vježba';

  @override
  String get exercises => 'Vježbe';

  @override
  String get exerciseName => 'Ime vježbe';

  @override
  String get searchExercise => 'Traži vježbe koje želiš dodati';

  @override
  String get noIngredientsDefined => 'Još nije određen nijedan sastojak';

  @override
  String get noMatchingExerciseFound => 'Nisu pronađene odgovarajuće vježbe';

  @override
  String get searchNamesInEnglish => 'Također traži imena na engleskom jeziku';

  @override
  String get equipment => 'Oprema';

  @override
  String get muscles => 'Mišići';

  @override
  String get musclesSecondary => 'Sekundarni mišići';

  @override
  String get category => 'Kategorija';

  @override
  String get startDate => 'Datum početka';

  @override
  String get dayTypeCustom => 'Prilagođeno';

  @override
  String get dayTypeEnom => 'Svake minute u minuti';

  @override
  String get dayTypeAmrap => 'Što više rundi';

  @override
  String get dayTypeHiit => 'Trening visokog intenziteta u intervalima';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Trening s postupnim povećanjem ponavljanja/serija';

  @override
  String get dayTypeRft => 'Runde za vrijeme';

  @override
  String get dayTypeAfap => 'Što brže moguće';

  @override
  String get slotEntryTypeNormal => 'Normalno';

  @override
  String get slotEntryTypeDropset => 'Drop set (serije sa smanjivanjem težine)';

  @override
  String get slotEntryTypeMyo => 'Myo (intenzivnije aktiviranje mišićnih vlakana)';

  @override
  String get slotEntryTypePartial => 'Djelomično';

  @override
  String get slotEntryTypeForced => 'Prisiljeno';

  @override
  String get slotEntryTypeTut => 'Vrijeme pod napetošću';

  @override
  String get slotEntryTypeIso => 'Izometrijsko držanje';

  @override
  String get slotEntryTypeJump => 'Skok';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Rutine';

  @override
  String get newRoutine => 'Nova rutina';

  @override
  String get noRoutines => 'Ti nemaš rutine';

  @override
  String get reps => 'Ponavljanja';

  @override
  String get restTime => 'Vrijeme odmora';

  @override
  String get sets => 'Serije';

  @override
  String get rir => 'PUR';

  @override
  String get rirNotUsed => 'PUR se ne koristi';

  @override
  String get useMetric => 'Koristi metričke jedinice za tjelesnu težinu';

  @override
  String get weightUnit => 'Jedinica težine';

  @override
  String get repetitionUnit => 'Jedinica ponavljanja';

  @override
  String get set => 'Serija';

  @override
  String get dayDescriptionHelp =>
      'Opis onoga što se radi na današnji dan (npr. „dan povlačenja”) ili koji su dijelovi tijela trenirani (npr. „prsa i ramena”)';

  @override
  String exerciseNr(String nr) {
    return 'Vježba $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Super-serija $nr';
  }

  @override
  String get sameRepetitions =>
      'Ako radiš ista ponavljanja i težinu za sve serije, ispuni jedan redak. Na primjer, za 4 serije jednostavno upiši 10 za ponavljanja, to automatski postaje „4 × 10”.';

  @override
  String get comment => 'Komentar';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Dojam';

  @override
  String get notes => 'Bilješke';

  @override
  String get workoutSession => 'Sesija treninga';

  @override
  String get restDay => 'Dan odmora';

  @override
  String get isRestDay => 'Je dan odmora';

  @override
  String get isRestDayHelp =>
      'Imaj na umu da će se sve serije i vježbe ukloniti kada označiš dan kao dan odmora.';

  @override
  String get needsLogsToAdvance => 'Treba dnevnike za nastavljanje';

  @override
  String get needsLogsToAdvanceHelp =>
      'Odaberi želiš li da se rutina nastavi na sljedeći zakazani dan, samo ako si za taj dan zapisao/la trening';

  @override
  String get routineDays => 'Dani u rutini';

  @override
  String get resultingRoutine => 'Rezultirajuća rutina';

  @override
  String get newDay => 'Novi dan';

  @override
  String get newSet => 'Nova serija';

  @override
  String get selectExercises =>
      'Ako želiš izraditi nasdkup, traži i odaberi vježbe koje će se grupirati u jednu grupu';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'Modus teretane';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Ploče';

  @override
  String get plateCalculatorNotDivisible =>
      'Nije moguće postići težinu s dostupnim pločastim utezima';

  @override
  String get pause => 'Pauza';

  @override
  String get jumpTo => 'Prijeđi na';

  @override
  String get todaysWorkout => 'Tvoj današnji trening';

  @override
  String get logHelpEntries =>
      'Ako u jednom danu postoji više od jednog unosa s istim brojem ponavljanja, ali različitim težinama, na dijagramu je prikazan samo unos s većom težinom.';

  @override
  String get logHelpEntriesUnits =>
      'Napomena: prikazuju se samo unosi s jedinicom težine (kg ili lb) i ponavljanja, druge kombinacije kao što su vrijeme ili do neuspjeha se ovdje zanemaruju.';

  @override
  String get description => 'Opis';

  @override
  String get name => 'Ime';

  @override
  String get save => 'Spremi';

  @override
  String get verify => 'Potvrdi';

  @override
  String get addSet => 'Dodaj seriju';

  @override
  String get addMeal => 'Dodaj obrok';

  @override
  String get mealLogged => 'Obrok prijavljen u dnevnik';

  @override
  String get ingredientLogged => 'Sastojak je upisan u dnevnik';

  @override
  String get logMeal => 'Zapiši obrok u dnevnik prehrane';

  @override
  String get addIngredient => 'Dodaj sastojak';

  @override
  String get logIngredient => 'Zapiši sastojak u dnevnik prehrane';

  @override
  String get searchIngredient => 'Traži sastojak';

  @override
  String get nutritionalPlan => 'Plan prehrane';

  @override
  String get nutritionalDiary => 'Dnevnik prehrane';

  @override
  String get nutritionalPlans => 'Planovi prehrane';

  @override
  String get noNutritionalPlans => 'Nemaš planove prehrane';

  @override
  String get onlyLogging => 'Prati samo kalorije';

  @override
  String get onlyLoggingHelpText =>
      'Označi okvir ako želiš bilježiti samo svoje kalorije i ne želiš postaviti detaljan plan prehrane s određenim obrocima';

  @override
  String get goalMacro => 'Ciljevi za makronutrijente';

  @override
  String get selectMealToLog => 'Odaberi obrok za zapisivanje u dnevnik';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Tvoj trenutačni plan prehrane nema definirane obroke';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'Za dodavanje obroka u plan, idi na detalje plana prehrane';

  @override
  String get goalEnergy => 'Cilj za energiju';

  @override
  String get goalProtein => 'Cilj za proteine';

  @override
  String get goalCarbohydrates => 'Cilj za ugljikohidrate';

  @override
  String get goalFat => 'Cilj za mast';

  @override
  String get goalFiber => 'Cilj za vlakna';

  @override
  String get anErrorOccurred => 'Dogodila se greška!';

  @override
  String get errorInfoDescription =>
      'Žao nam je, dogodila se greška. Možeš nam pomoći to popraviti prijavom problema na GitHub-u.';

  @override
  String get errorInfoDescription2 =>
      'Možeš nastaviti koristiti aplikaciju, ali neke funkcije možda neće raditi.';

  @override
  String get errorViewDetails => 'Tehnički detalji';

  @override
  String get applicationLogs => 'Dnevnici aplikacije';

  @override
  String get errorCouldNotConnectToServer => 'Neuspjelo povezivanje sa serverom';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'Aplikacija se nije mogla povezati sa serverom. Provjeri internetsku vezu ili URL servera i pokušaj ponovo. Ako problem ne nestane, obrati se administratoru servera.';

  @override
  String get copyToClipboard => 'Kopiraj u međuspremnik';

  @override
  String get weight => 'Težina';

  @override
  String get min => 'Min.';

  @override
  String get max => 'Maks.';

  @override
  String chartAllTimeTitle(String name) {
    return '$name – svo vrijeme';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name – zadnjih 30 dana';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName tijekom plana prehrane $planName';
  }

  @override
  String get measurement => 'Mjerenje';

  @override
  String get measurements => 'Mjerenja';

  @override
  String get measurementCategoriesHelpText =>
      'Kategorija mjerenja, kao što su „bicepsi” ili „tjelesna mast”';

  @override
  String get measurementEntriesHelpText =>
      'Jedinica koja se koristi za mjerenje kategorije kao što su „cm” ili „%”';

  @override
  String get date => 'Datum';

  @override
  String get endDate => 'Datum kraja';

  @override
  String get openEnded => 'Bez datuma kraja';

  @override
  String get value => 'Vrijednost';

  @override
  String get start => 'Početak';

  @override
  String get time => 'Vrijeme';

  @override
  String get timeStart => 'Vrijeme početka';

  @override
  String get timeEnd => 'Vrijeme završetka';

  @override
  String get timeStartAhead => 'Vrijeme početka ne može biti prije vremena završetka';

  @override
  String get ingredient => 'Sastojak';

  @override
  String get energy => 'Energija';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Makronutrijenti';

  @override
  String get planned => 'Planirano';

  @override
  String get logged => 'Zabilježeno';

  @override
  String get today => 'Danas';

  @override
  String get loggedToday => 'Zapisano danas';

  @override
  String get weekAverage => 'Sedmodnevni prosjek';

  @override
  String get surplus => 'višak';

  @override
  String get deficit => 'manjak';

  @override
  String get difference => 'Razlika';

  @override
  String get percentEnergy => 'Postotak energije';

  @override
  String get gPerBodyKg => 'g po tjelesnom kg';

  @override
  String get total => 'Ukupno';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Proteini';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Ugljikohidrati';

  @override
  String get carbohydratesShort => 'U';

  @override
  String get sugars => 'Šećeri';

  @override
  String get fat => 'Masti';

  @override
  String get fatShort => 'M';

  @override
  String get saturatedFat => 'Zasićene masti';

  @override
  String get fiber => 'Vlakna';

  @override
  String get sodium => 'Natrij';

  @override
  String get amount => 'Količina';

  @override
  String get unit => 'Jedinica';

  @override
  String get newEntry => 'Novi unos';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'Nemaš unose težine';

  @override
  String get noMeasurementEntries => 'Nemaš unose mjerenja';

  @override
  String get moreMeasurementEntries => 'Dodaj novo mjerenje';

  @override
  String get edit => 'Uredi';

  @override
  String get loadingText => 'Učitavanje …';

  @override
  String get delete => 'Izbriši';

  @override
  String confirmDelete(String toDelete) {
    return 'Stvarno želiš izbrisati „$toDelete”?';
  }

  @override
  String get newNutritionalPlan => 'Novi plan prehrane';

  @override
  String get overview => 'Pregled';

  @override
  String get toggleDetails => 'Prikaži detalje';

  @override
  String get goToDetailPage => 'Idi na stranicu s detaljima';

  @override
  String get aboutWhySupportTitle => 'Otvoreni kod i besplatno ❤️';

  @override
  String get aboutDescription =>
      'Hvala što koristiš wger! wger je suradnički projekt otvorenog koda koji su izradili ljubitelji fitnesa iz cijelog svijeta.';

  @override
  String get aboutDonateTitle => 'Doniraj';

  @override
  String get aboutDonateText =>
      'Iako je projekt besplatan i uvijek će to ostati, održavanje servera nije! Razvoj također zahtijeva značajno vrijeme i trud volontera. Tvoj doprinos izravno podupire te troškove i pomaže u održavanju pouzdanosti usluge.';

  @override
  String get aboutContributeTitle => 'Doprinesi';

  @override
  String get aboutContributeText =>
      'Sve vrste doprinosa su dobrodošle. Bilo da si programer, prevoditelj ili jednostavno strastveni ljubitelj fitnessa, svaka podrška je dobrodošla!';

  @override
  String get aboutBugsListTitle => 'Prijavi problem ili predloži funkciju';

  @override
  String get aboutTranslationListTitle => 'Prevedi aplikaciju';

  @override
  String get aboutSourceListTitle => 'Prikaži izvorni kod';

  @override
  String get aboutJoinCommunityTitle => 'Pridruži se zajednici';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Drugi';

  @override
  String get calendar => 'Kalendar';

  @override
  String get goToToday => 'Idi na danas';

  @override
  String get enterValue => 'Upiši vrijednost';

  @override
  String get selectEntry => 'Odaberi unos';

  @override
  String get selectExercise => 'Odaberi vježbu';

  @override
  String enterCharacters(String min, String max) {
    return 'Upiši između $min do $max znaka';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Upiši barem $min znaka';
  }

  @override
  String get baseNameEnglish => 'Sve vježbe trebaju osnovno ime na engleskom jeziku';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Broj serija po vježbi: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Postavi jedinice i PUR';

  @override
  String get enterValidNumber => 'Upiši valjani broj';

  @override
  String get selectIngredient => 'Odaberi sastojak';

  @override
  String get recentlyUsedIngredients => 'Nedavno dodani sastojci';

  @override
  String get selectImage => 'Odaberi sliku';

  @override
  String get optionsLabel => 'Opcije';

  @override
  String get takePicture => 'Snimi sliku';

  @override
  String get chooseFromLibrary => 'Odaberi iz biblioteke slika';

  @override
  String get gallery => 'Galerija';

  @override
  String get addImage => 'Dodaj sliku';

  @override
  String get dataCopied => 'Podaci kopirani u novi unos';

  @override
  String get appUpdateTitle => 'Potrebna je nova verzija';

  @override
  String get appUpdateContent =>
      'Ova verzija aplikacije nije kompatibilna sa serverom. Aktualiziraj svoju aplikaciju.';

  @override
  String get productFound => 'Pronađeni proizvod';

  @override
  String productFoundDescription(String productName) {
    return 'Barkod odgovara ovom proizvodu: $productName. Želiš li nastaviti?';
  }

  @override
  String get productNotFound => 'Proizvod nije pronađen';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Proizvod sa skeniranim barkodom $barcode nije pronađen u wger bazi podataka';
  }

  @override
  String get scanBarcode => 'Skeniraj barkod';

  @override
  String get close => 'Zatvori';

  @override
  String get identicalExercisePleaseDiscard =>
      'Ako primijetiš vježbu koja je identična onoj koju dodaješ, odbaci svoju vježbu i umjesto toga uredi tu vježbu.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Provjeri točnost tvojih unesenih podataka prije slanja vježbe';

  @override
  String get add_exercise_image_license =>
      'Slike moraju biti kompatibilne s licencom CC BY SA. Ako si u nedoumici, prenesi samo svoje vlastite fotografije.';

  @override
  String get imageDetailsTitle => 'Detalji slike';

  @override
  String get imageDetailsLicenseTitle => 'Naslov';

  @override
  String get imageDetailsLicenseTitleHint => 'Upiši naslov slike';

  @override
  String get imageDetailsSourceLink => 'Poveznica na izvornu web-stranicu';

  @override
  String get author => 'Autori';

  @override
  String get authorHint => 'Upiši ime autora';

  @override
  String get imageDetailsAuthorLink => 'Poveznica na web-stranicu ili profil autora';

  @override
  String get imageDetailsDerivativeSource =>
      'Poveznica na izvorni izvor, ako je ovo izvedeno djelo';

  @override
  String get imageDetailsDerivativeHelp =>
      'Izvedeno djelo se temelji na prethodnom djelu, ali sadrži dovoljno novog, kreativnog sadržaja da bi mu se dalo pravo na vlastita autorska prava.';

  @override
  String get imageDetailsImageType => 'Vrsta slike';

  @override
  String get imageDetailsLicenseNotice =>
      'Slanjem ove slike pristaješ na njezino objavljivanje pod licencom CC-BY-SA-4. Slika mora biti tvoje vlastito djelo ili ju je autor morao objaviti pod s njom kompatibilnom licencom.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'Pogledaj tekst licence.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat nije podržani format';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return '$imageFormat slike još nisu podržane.';
  }

  @override
  String get add => 'dodaj';

  @override
  String get variations => 'Varijante';

  @override
  String alsoKnownAs(String aliases) {
    return 'Poznato i kao: $aliases';
  }

  @override
  String get verifiedEmail => 'Potvrđena e-mail adresa';

  @override
  String get unVerifiedEmail => 'Nepotvrđena e-mail adresa';

  @override
  String get verifiedEmailReason => 'Za dodavanje vježbi moraš potvrditi tvoju e-mail adresu';

  @override
  String verifiedEmailInfo(String email) {
    return 'E-mail za ovjeru je poslan na $email';
  }

  @override
  String get alternativeNames => 'Alternativna imena';

  @override
  String get oneNamePerLine => 'Jedno ime po retku';

  @override
  String get whatVariationsExist => 'Koje varijante ove vježbe postoje?';

  @override
  String get previous => 'Prethodna';

  @override
  String get next => 'Sljedeća';

  @override
  String get images => 'Slike';

  @override
  String get language => 'Jezik';

  @override
  String get addExercise => 'Dodaj vježbu';

  @override
  String get fitInWeek => 'Prilagodi u tjedan';

  @override
  String get fitInWeekHelp =>
      'Ako je aktivirano, dani će se ponavljati u tjednom ciklusu, inače će dani slijediti uzastopno bez obzira na početak novog tjedna.';

  @override
  String get addSuperset => 'Dodaj super-seriju';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Serija ima napredovanje';

  @override
  String get setHasProgressionWarning =>
      'Imaj na umu da trenutačno nije moguće urediti sve postavke za serije na mobilnoj aplikaciji ili konfigurirati automatsko napredovanje. Za sada koristi web aplikaciju.';

  @override
  String get setHasNoExercises => 'Ova serija još nema vježbe!';

  @override
  String get contributeExercise => 'Doprinesi vježbu';

  @override
  String get translation => 'Prijevod';

  @override
  String get translateExercise => 'Prevedi ovu vježbu';

  @override
  String get baseData => 'Osnovni podaci na engleskom jeziku';

  @override
  String get enterTextInLanguage => 'Upiši tekst u ispravnom jeziku!';

  @override
  String get settingsTitle => 'Postavke';

  @override
  String get settingsCacheTitle => 'Predmemorija';

  @override
  String get settingsExerciseCacheDescription => 'Izvrši predmemoriju';

  @override
  String get settingsIngredientCacheDescription => 'Predmemorija sastojaka';

  @override
  String get settingsCacheDeletedSnackbar => 'Predmemorija je uspješno izbrisana';

  @override
  String get aboutPageTitle => 'O nama i podrška';

  @override
  String contributeExerciseWarning(String days) {
    return 'Vježbe možeš dodati samo ako je tvoj račun stariji od $days dana i ako si potvrdio/la tvoju e-mail adresu';
  }

  @override
  String get simpleMode => 'Jednostavni modus';

  @override
  String get simpleModeHelp => 'Sakrij neke naprednije postavke prilikom uređivanja vježbi';

  @override
  String get progressionRules =>
      'Ova vježba ima pravila napredovanja i ne može se uređivati u mobilnoj aplikaciji. Za uređivanje ove vježbe koristi web aplikaciju.';

  @override
  String get cacheWarning =>
      'Zbog predmemoriranja, vidljivost promjena u aplikaciji može nešto potrajati.';

  @override
  String get textPromptTitle => 'Spreman?';

  @override
  String get textPromptSubheading => 'Počni pritiskom gumba radnje';

  @override
  String get abs => 'Trbuh';

  @override
  String get arms => 'Ruke';

  @override
  String get back => 'Leđa';

  @override
  String get barbell => 'Šipka';

  @override
  String get bench => 'Klupa';

  @override
  String get biceps => 'Bicepsi';

  @override
  String get body_weight => 'Tjelesna težina';

  @override
  String get calves => 'Lisni mišići';

  @override
  String get cardio => 'Kardio';

  @override
  String get chest => 'Prsa';

  @override
  String get dumbbell => 'Ručni uteg';

  @override
  String get glutes => 'Stražnjica';

  @override
  String get gym_mat => 'Podloga za treniranje';

  @override
  String get hamstrings => 'Tetive koljena';

  @override
  String get incline_bench => 'Nagnuta klupa';

  @override
  String get kettlebell => 'Kuglasti uteg';

  @override
  String get kilometers => 'Kilometri';

  @override
  String get kilometers_per_hour => 'Kilometara na sat';

  @override
  String get lats => 'Leđni mišići';

  @override
  String get legs => 'Noge';

  @override
  String get lower_back => 'Donji dio leđa';

  @override
  String get max_reps => 'Maks. broj ponavljanja';

  @override
  String get miles => 'Milje';

  @override
  String get miles_per_hour => 'Milja na sat';

  @override
  String get minutes => 'Minute';

  @override
  String get plates => 'Ploče';

  @override
  String get pull_up_bar => 'Šipka za povlačenje';

  @override
  String get quads => 'Kvadriceps';

  @override
  String get repetitions => 'Ponavljanja';

  @override
  String get resistance_band => 'Elastična vrpca';

  @override
  String get sz_bar => 'Zaobljena šipka';

  @override
  String get seconds => 'Sekunde';

  @override
  String get shoulders => 'Ramena';

  @override
  String get swiss_ball => 'Gimnastička lopta';

  @override
  String get triceps => 'Triceps';

  @override
  String get until_failure => 'Do neuspjeha';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'bez (vježba za tjelesnu težinu)';

  @override
  String get log => 'Zapiši';

  @override
  String get done => 'Obavljeno';

  @override
  String get overallChangeWeight => 'Sveukupna promjena';

  @override
  String get goalTypeMeals => 'Od obroka';

  @override
  String get goalTypeBasic => 'Osnovno';

  @override
  String get goalTypeAdvanced => 'Napredno';

  @override
  String get indicatorRaw => 'neobrađeno';

  @override
  String get indicatorAvg => 'prosjek';

  @override
  String get endWorkout => 'Završi trening';

  @override
  String get themeMode => 'Modus teme';

  @override
  String get darkMode => 'Uvijek tamni modus';

  @override
  String get lightMode => 'Uvijek svijetli modus';

  @override
  String get systemMode => 'Postavke sustava';
}
