// ignore: unused_import
import 'package:intl/intl.dart' as intl;
import 'app_localizations.dart';

// ignore_for_file: type=lint

/// The translations for Czech (`cs`).
class AppLocalizationsCs extends AppLocalizations {
  AppLocalizationsCs([String locale = 'cs']) : super(locale);

  @override
  String get userProfile => 'Váš profil';

  @override
  String get login => 'Přihlásit se';

  @override
  String get logout => 'Odhlásit se';

  @override
  String get register => 'Registrace';

  @override
  String get useDefaultServer => 'Použít výchozí server';

  @override
  String get useCustomServer => 'Použít vlastní server';

  @override
  String get invalidUrl => 'Prosím zadejte platnou URL adresu';

  @override
  String get usernameValidChars =>
      'Uživatelské jméno může obsahovat pouze písmena, číslice a znaky @, +, ., - a _';

  @override
  String get passwordsDontMatch => 'Hesla se neshodují';

  @override
  String get passwordTooShort => 'Toto heslo je příliš krátké';

  @override
  String get selectAvailablePlates => 'Select available plates';

  @override
  String get barWeight => 'Bar weight';

  @override
  String get useColors => 'Use colors';

  @override
  String get password => 'Heslo';

  @override
  String get confirmPassword => 'Potvrdit heslo';

  @override
  String get invalidEmail => 'Zadejte platnou e-mailovou adresu';

  @override
  String get email => 'E-mailová adresa';

  @override
  String get username => 'Uživatelské jméno';

  @override
  String get invalidUsername => 'Zadejte platné uživatelské jméno';

  @override
  String get useApiToken => 'Use API Token';

  @override
  String get useUsernameAndPassword => 'Use username and password';

  @override
  String get apiToken => 'API Token';

  @override
  String get invalidApiToken => 'Please enter a valid API key';

  @override
  String get apiTokenValidChars =>
      'An API key may only contain the letters a-f, numbers 0-9 and be exactly 40 characters long';

  @override
  String get customServerUrl => 'Adresa URL instance wger';

  @override
  String get customServerHint => 'Zadejte adresu vlastního serveru, jinak bude použita výchozí';

  @override
  String get reset => 'Vymazat';

  @override
  String get registerInstead => 'Nemáte účet? Zaregistrujte se nyní';

  @override
  String get loginInstead => 'Máte již účet? Přihlaste se';

  @override
  String get labelBottomNavWorkout => 'Trénink';

  @override
  String get labelBottomNavNutrition => 'Výživa';

  @override
  String get labelWorkoutLogs => 'Záznamy o cvičení';

  @override
  String get labelWorkoutPlan => 'Plán cvičení';

  @override
  String get dashboardWidgets => 'Dashboard widgets';

  @override
  String get labelDashboard => 'Nástěnka';

  @override
  String get success => 'Úspěch';

  @override
  String get successfullyDeleted => 'Odstraněno';

  @override
  String get successfullySaved => 'Uloženo';

  @override
  String get exerciseList => 'Seznam cvičení';

  @override
  String get exercise => 'Cvičení';

  @override
  String get exercises => 'Cvičení';

  @override
  String get exerciseName => 'Název cvičení';

  @override
  String get searchExercise => 'Hledat cvičení, které chcete přidat';

  @override
  String get noIngredientsDefined => 'Zatím nebyly nastaveny žádné ingredience';

  @override
  String get noMatchingExerciseFound => 'Nenalezeny žádné odpovídající tréninky';

  @override
  String get searchNamesInEnglish => 'Také hledat názvy v angličtině';

  @override
  String get equipment => 'Nářadí';

  @override
  String get muscles => 'Svaly';

  @override
  String get musclesSecondary => 'Vedlejší svaly';

  @override
  String get category => 'Kategorie';

  @override
  String get startDate => 'Start date';

  @override
  String get dayTypeCustom => 'Custom';

  @override
  String get dayTypeEnom => 'Every minute on the minute';

  @override
  String get dayTypeAmrap => 'As many rounds as possible';

  @override
  String get dayTypeHiit => 'High intensity interval training';

  @override
  String get dayTypeTabata => 'Tabata';

  @override
  String get dayTypeEdt => 'Escalating density training';

  @override
  String get dayTypeRft => 'Rounds for time';

  @override
  String get dayTypeAfap => 'As fast as possible';

  @override
  String get slotEntryTypeNormal => 'Normal';

  @override
  String get slotEntryTypeDropset => 'Dropset';

  @override
  String get slotEntryTypeMyo => 'Myo';

  @override
  String get slotEntryTypePartial => 'Partial';

  @override
  String get slotEntryTypeForced => 'Forced';

  @override
  String get slotEntryTypeTut => 'Time under Tension';

  @override
  String get slotEntryTypeIso => 'Isometric hold';

  @override
  String get slotEntryTypeJump => 'Jump';

  @override
  String get trophies => 'Trophies';

  @override
  String get routines => 'Routines';

  @override
  String get newRoutine => 'New routine';

  @override
  String get noRoutines => 'You have no routines';

  @override
  String get reps => 'Opakování';

  @override
  String get restTime => 'Rest time';

  @override
  String get sets => 'Sets';

  @override
  String get rir => 'OvR';

  @override
  String get rirNotUsed => 'nepoužitá OvR';

  @override
  String get useMetric => 'Použít metrické jednotky pro tělesnou váhu';

  @override
  String get weightUnit => 'Jednotka váhy';

  @override
  String get repetitionUnit => 'Opakující jednotka';

  @override
  String get set => 'Sada';

  @override
  String get dayDescriptionHelp =>
      'Popis toho, co je na tento den plánováno (například \"Tahy\") nebo části těla, která budou cvičena (např. \"hrudník a ramena\")';

  @override
  String exerciseNr(String nr) {
    return 'Exercise $nr';
  }

  @override
  String supersetNr(String nr) {
    return 'Superset $nr';
  }

  @override
  String get sameRepetitions =>
      'Pokud uděláte stejné opakování a hmotnost pro všechny sady, můžete vyplnit pouze jednu řadu. Například pro 4 sady stačí zadat 10 pro opakování, toto se automaticky stává \"4 x 10\".';

  @override
  String get comment => 'Komentář';

  @override
  String topSet(String value) {
    return 'Top set: $value';
  }

  @override
  String get impressionGood => 'Good';

  @override
  String get impressionNeutral => 'Neutral';

  @override
  String get impressionBad => 'Bad';

  @override
  String get impression => 'Dojem';

  @override
  String get notes => 'Poznámky';

  @override
  String get workoutSession => 'Tréninková relace';

  @override
  String get restDay => 'Rest day';

  @override
  String get isRestDay => 'Is rest day';

  @override
  String get isRestDayHelp =>
      'Please note that all sets and exercises will be removed when you mark a day as a rest day.';

  @override
  String get needsLogsToAdvance => 'Needs logs to advance';

  @override
  String get needsLogsToAdvanceHelp =>
      'Select if you want the routine to progress to the next scheduled day only if you\'ve logged a workout for the day';

  @override
  String get routineDays => 'Days in routine';

  @override
  String get resultingRoutine => 'Resulting routine';

  @override
  String get newDay => 'Nový den';

  @override
  String get newSet => 'Nová sada';

  @override
  String get selectExercises =>
      'Chcete-li udělat superset, můžete hledat několik cvičení, budou seskupeny dohromady';

  @override
  String get personalRecords => 'Personal records';

  @override
  String get gymMode => 'Režim tělocvičny';

  @override
  String get gymModeShowExercises => 'Show exercise overview pages';

  @override
  String get gymModeShowTimer => 'Show timer between sets';

  @override
  String get gymModeTimerType => 'Timer type';

  @override
  String get gymModeTimerTypeHelText => 'If a set has pause time, a countdown is always used.';

  @override
  String get countdown => 'Countdown';

  @override
  String get stopwatch => 'Stopwatch';

  @override
  String get gymModeDefaultCountdownTime => 'Default countdown time, in seconds';

  @override
  String get gymModeNotifyOnCountdownFinish => 'Notify on countdown end';

  @override
  String get duration => 'Duration';

  @override
  String durationHoursMinutes(int hours, int minutes) {
    return '${hours}h ${minutes}m';
  }

  @override
  String get volume => 'Volume';

  @override
  String get workoutCompleted => 'Workout completed';

  @override
  String get plateCalculator => 'Závaží';

  @override
  String get plateCalculatorNotDivisible => 'Není možné dosáhnout hmotnosti s dostupnými závažími';

  @override
  String get pause => 'Pozastavit';

  @override
  String get jumpTo => 'Přeskočit na';

  @override
  String get todaysWorkout => 'Vaše cvičení dnes';

  @override
  String get logHelpEntries =>
      'Pokud je v jednom dni více než jeden záznam se stejným počtem opakování, ale různými váhami, je v diagramu zobrazen pouze záznam s vyšší hmotností.';

  @override
  String get logHelpEntriesUnits =>
      'Všimněte si, že pouze položky s hmotnostní jednotkou (kg nebo lb) a opakování jsou vykresleny, jiné kombinace, jako je čas nebo cvik do selhání jsou zde vynechány.';

  @override
  String get description => 'Popis';

  @override
  String get name => 'Název';

  @override
  String get save => 'Uložit';

  @override
  String get verify => 'Ověřit';

  @override
  String get addSet => 'Přidat sadu';

  @override
  String get addMeal => 'Přidat jídlo';

  @override
  String get mealLogged => 'Jídlo zaznamenané do deníku';

  @override
  String get ingredientLogged => 'Ingredience zaznamenána do diáře';

  @override
  String get logMeal => 'Zaznamenat do nutričního diáře';

  @override
  String get addIngredient => 'Přidat přísadu';

  @override
  String get logIngredient => 'Zaznamenat ingredienci do nutričního diáře';

  @override
  String get searchIngredient => 'Hledat přísadu';

  @override
  String get nutritionalPlan => 'Výživový plán';

  @override
  String get nutritionalDiary => 'Nutriční deník';

  @override
  String get nutritionalPlans => 'Nutriční plán';

  @override
  String get noNutritionalPlans => 'Nemáte žádné výživové plány';

  @override
  String get onlyLogging => 'Zaznamenávat pouze kalorie';

  @override
  String get onlyLoggingHelpText =>
      'Zaškrtněte, pokud chcete pouze zaznamenávat své kalorie a nechcete nastavovat podrobný výživový plán s přesnými jídly';

  @override
  String get goalMacro => 'Makro cíle';

  @override
  String get selectMealToLog => 'Vyberte jídlo k záznamu do diáře';

  @override
  String get yourCurrentNutritionPlanHasNoMealsDefinedYet =>
      'Your current nutrition plan has no meals defined';

  @override
  String get toAddMealsToThePlanGoToNutritionalPlanDetails =>
      'To add meals to the plan, go to the nutritional plan details';

  @override
  String get goalEnergy => 'Cíl energie';

  @override
  String get goalProtein => 'Cíl bílkovin';

  @override
  String get goalCarbohydrates => 'Cíl karbohydrátů';

  @override
  String get goalFat => 'Cíl tuku';

  @override
  String get goalFiber => 'Cíl vlákniny';

  @override
  String get anErrorOccurred => 'Vyskytla se chyba!';

  @override
  String get errorInfoDescription =>
      'We\'re sorry, but something went wrong. You can help us fix this by reporting the issue on GitHub.';

  @override
  String get errorInfoDescription2 =>
      'You can continue using the app, but some features may not work.';

  @override
  String get errorViewDetails => 'Technical details';

  @override
  String get applicationLogs => 'Application logs';

  @override
  String get errorCouldNotConnectToServer => 'Couldn\'t connect to server';

  @override
  String get errorCouldNotConnectToServerDetails =>
      'The application could not connect to the server. Please check your internet connection or the server URL and try again. If the problem persists, contact the server administrator.';

  @override
  String get copyToClipboard => 'Copy to clipboard';

  @override
  String get weight => 'Váha';

  @override
  String get min => 'Min';

  @override
  String get max => 'Max';

  @override
  String chartAllTimeTitle(String name) {
    return '$name all-time';
  }

  @override
  String chart30DaysTitle(String name) {
    return '$name last 30 days';
  }

  @override
  String chartDuringPlanTitle(String chartName, String planName) {
    return '$chartName during nutritional plan $planName';
  }

  @override
  String get measurement => 'Měření';

  @override
  String get measurements => 'Měření';

  @override
  String get measurementCategoriesHelpText =>
      'Kategorie měření, například \"biceps\" nebo \"tělesný tuk\"';

  @override
  String get measurementEntriesHelpText =>
      'Jednotka použitá pro měření kategorie, například \"cm\" nebo \"%\"';

  @override
  String get date => 'Datum';

  @override
  String get endDate => 'End date';

  @override
  String get openEnded => 'Open ended';

  @override
  String get value => 'Hodnota';

  @override
  String get start => 'Začni';

  @override
  String get time => 'Čas';

  @override
  String get timeStart => 'Čas začátku';

  @override
  String get timeEnd => 'Čas ukončení';

  @override
  String get timeStartAhead => 'Čas zahájení nemůže být po času ukončení';

  @override
  String get ingredient => 'Přísada';

  @override
  String get energy => 'Energie';

  @override
  String get energyShort => 'E';

  @override
  String get macronutrients => 'Makroživiny';

  @override
  String get planned => 'Plánované';

  @override
  String get logged => 'Zaznamenáno';

  @override
  String get today => 'Dnes';

  @override
  String get loggedToday => 'Zaznamenáno dnes';

  @override
  String get weekAverage => '7 denní průměr';

  @override
  String get surplus => 'přebytek';

  @override
  String get deficit => 'nedostatek';

  @override
  String get difference => 'Rozdíl';

  @override
  String get percentEnergy => 'Procento energie';

  @override
  String get gPerBodyKg => 'g na kg tělesné váhy';

  @override
  String get total => 'Celkem';

  @override
  String get kcal => 'kcal';

  @override
  String kcalValue(String value) {
    return '$value kcal';
  }

  @override
  String get kJ => 'kJ';

  @override
  String get g => 'g';

  @override
  String gValue(String value) {
    return '$value g';
  }

  @override
  String percentValue(String value) {
    return '$value %';
  }

  @override
  String get protein => 'Bílkoviny';

  @override
  String get proteinShort => 'P';

  @override
  String get carbohydrates => 'Sacharidy';

  @override
  String get carbohydratesShort => 'C';

  @override
  String get sugars => 'Cukry';

  @override
  String get fat => 'Tuky';

  @override
  String get fatShort => 'T';

  @override
  String get saturatedFat => 'Nasycené tuky';

  @override
  String get fiber => 'Vláknina';

  @override
  String get sodium => 'Sodík';

  @override
  String get amount => 'Množství';

  @override
  String get unit => 'Jednotka';

  @override
  String get newEntry => 'Nová položka';

  @override
  String get noTrophies => 'You have no trophies yet';

  @override
  String get noWeightEntries => 'Nemáte žádné záznamy o hmotnosti';

  @override
  String get noMeasurementEntries => 'Nemáte žádné záznamy měření';

  @override
  String get moreMeasurementEntries => 'Přidat nové měření';

  @override
  String get edit => 'Upravit';

  @override
  String get loadingText => 'Nahrávání ...';

  @override
  String get delete => 'Odstranit';

  @override
  String confirmDelete(String toDelete) {
    return 'Přejete si skutečně odstranit \'$toDelete\'?';
  }

  @override
  String get newNutritionalPlan => 'Nový výživový plán';

  @override
  String get overview => 'Overview';

  @override
  String get toggleDetails => 'Přepnout podrobnosti';

  @override
  String get goToDetailPage => 'Přejít na stránku s podrobnostmi';

  @override
  String get aboutWhySupportTitle => 'Open Source & free to use ❤️';

  @override
  String get aboutDescription =>
      'Děkujeme Vám za použití wger! wger je komunitní open source projekt, který je tvořen fitness nadšenci z celého světa.';

  @override
  String get aboutDonateTitle => 'Přispět';

  @override
  String get aboutDonateText =>
      'Kupte nám kávu, abyste pomohli projektu, zaplatili náklady na server a udrželi nás funkční';

  @override
  String get aboutContributeTitle => 'Contribute';

  @override
  String get aboutContributeText =>
      'All types of contributions are encouraged. Whether you\'re a developer, a translator, or just passionate about fitness, every bit of support is appreciated!';

  @override
  String get aboutBugsListTitle => 'Report a problem or suggest a feature';

  @override
  String get aboutTranslationListTitle => 'Translate the application';

  @override
  String get aboutSourceListTitle => 'View source code';

  @override
  String get aboutJoinCommunityTitle => 'Join the community';

  @override
  String get aboutMastodonTitle => 'Mastodon';

  @override
  String get aboutDiscordTitle => 'Discord';

  @override
  String get others => 'Others';

  @override
  String get calendar => 'Kalendář';

  @override
  String get goToToday => 'Přejít na dnešek';

  @override
  String get enterValue => 'Prosím zadejte hodnotu';

  @override
  String get selectEntry => 'Prosím vyberte hodnotu';

  @override
  String get selectExercise => 'Prosím vyberte cvik';

  @override
  String enterCharacters(String min, String max) {
    return 'Prosím, zadejte mezi $min a $max znaky';
  }

  @override
  String formMinMaxValues(int min, int max) {
    return 'Please enter a value between $min and $max';
  }

  @override
  String enterMinCharacters(String min) {
    return 'Prosím, zadejte alespoň $min znaků';
  }

  @override
  String get baseNameEnglish => 'Všechny cviky potřebují mít základní název v angličtině';

  @override
  String nrOfSets(String nrOfSets) {
    return 'Počet sad na cvik: $nrOfSets';
  }

  @override
  String get setUnitsAndRir => 'Nastavit jednotky a OvR';

  @override
  String get enterValidNumber => 'Prosím, zadejte platné číslo';

  @override
  String get selectIngredient => 'Prosím, vyberte přísadu';

  @override
  String get recentlyUsedIngredients => 'Naposledy přidané přísady';

  @override
  String get selectImage => 'Prosím, vyberte obrázek';

  @override
  String get optionsLabel => 'Možnosti';

  @override
  String get takePicture => 'Vyfotit';

  @override
  String get chooseFromLibrary => 'Vybrat foto z galerie';

  @override
  String get gallery => 'Galerie';

  @override
  String get addImage => 'Přidat obrázek';

  @override
  String get dataCopied => 'Data zkopírována do nového záznamu';

  @override
  String get appUpdateTitle => 'Je nutná aktualizace';

  @override
  String get appUpdateContent =>
      'Tato verze aplikace není kompatibilní se serverem, aktualizujte prosím svou aplikaci.';

  @override
  String get productFound => 'Produkt nalezen';

  @override
  String productFoundDescription(String productName) {
    return 'Čárový kód náleží tomuto produktu: $productName. Chcete pokračovat?';
  }

  @override
  String get productNotFound => 'Produkt nenalezen';

  @override
  String productNotFoundDescription(String barcode) {
    return 'Produkt s naskenovaným čárovým kódem $barcode nebyl nalezen v databázi wger';
  }

  @override
  String get scanBarcode => 'Naskenovat čárový kód';

  @override
  String get close => 'Zavřít';

  @override
  String get identicalExercisePleaseDiscard =>
      'If you notice an exercise that is identical to the one you\'re adding, please discard your draft and edit that exercise instead.';

  @override
  String get checkInformationBeforeSubmitting =>
      'Please check that the information you entered is correct before submitting the exercise';

  @override
  String get add_exercise_image_license =>
      'Obrázky musí být kompatibilní s licencí CC BY SA. Pokud si nejste jistí, nahrajte pouze fotky, které jste sami pořídili.';

  @override
  String get imageDetailsTitle => 'Image details';

  @override
  String get imageDetailsLicenseTitle => 'Title';

  @override
  String get imageDetailsLicenseTitleHint => 'Enter image title';

  @override
  String get imageDetailsSourceLink => 'Link to the source website';

  @override
  String get author => 'Author(s)';

  @override
  String get authorHint => 'Enter author name';

  @override
  String get imageDetailsAuthorLink => 'Link to author website or profile';

  @override
  String get imageDetailsDerivativeSource =>
      'Link to the original source, if this is a derivative work';

  @override
  String get imageDetailsDerivativeHelp =>
      'A derivative work is based on a previous work but contains sufficient new, creative content to entitle it to its own copyright.';

  @override
  String get imageDetailsImageType => 'Image Type';

  @override
  String get imageDetailsLicenseNotice =>
      'By submitting this image, you agree to release it under the CC-BY-SA-4. The image must be either your own work or the author must have released it under a license compatible with it.';

  @override
  String get imageDetailsLicenseNoticeLinkToLicense => 'See license text.';

  @override
  String imageFormatNotSupported(String imageFormat) {
    return '$imageFormat není podporován';
  }

  @override
  String imageFormatNotSupportedDetail(String imageFormat) {
    return 'Obrazy $imageFormat zatím nejsou podporovány.';
  }

  @override
  String get add => 'add';

  @override
  String get variations => 'Variace';

  @override
  String alsoKnownAs(String aliases) {
    return 'Také známé jako: $aliases';
  }

  @override
  String get verifiedEmail => 'Ověřený e-mail';

  @override
  String get unVerifiedEmail => 'Neověřený e-mail';

  @override
  String get verifiedEmailReason => 'Pro přidávání cvičení musíte ověřit svůj e-mail';

  @override
  String verifiedEmailInfo(String email) {
    return 'Ověřovací e-mail byl odeslán na adresu $email';
  }

  @override
  String get alternativeNames => 'Alternativní jména';

  @override
  String get oneNamePerLine => 'Jedno jméno na jeden řádek';

  @override
  String get whatVariationsExist => 'Existují nějaké varianty tohoto cviku?';

  @override
  String get previous => 'Předešlé';

  @override
  String get next => 'Další';

  @override
  String get images => 'Obrázky';

  @override
  String get language => 'Jazyk';

  @override
  String get addExercise => 'Přidat cvičení';

  @override
  String get fitInWeek => 'Fit in week';

  @override
  String get fitInWeekHelp =>
      'If enabled, the days will repeat in a weekly cycle, otherwise the days will follow sequentially without regards to the start of a new week.';

  @override
  String get addSuperset => 'Add superset';

  @override
  String get superset => 'Superset';

  @override
  String get setHasProgression => 'Set has progression';

  @override
  String get setHasProgressionWarning =>
      'Please note that at the moment it is not possible to edit all settings for a set on the mobile application or configure automatic progression. For now, please use the web application.';

  @override
  String get setHasNoExercises => 'This set has no exercises yet!';

  @override
  String get contributeExercise => 'Přidejte cvičení';

  @override
  String get translation => 'Překlad';

  @override
  String get translateExercise => 'Přeložte toto cvičení';

  @override
  String get baseData => 'Základy v angličtině';

  @override
  String get enterTextInLanguage => 'Please enter the text in the correct language!';

  @override
  String get settingsTitle => 'Nastavení';

  @override
  String get settingsCacheTitle => 'Mezipaměť';

  @override
  String get settingsExerciseCacheDescription => 'Mezipaměť cvičení';

  @override
  String get settingsIngredientCacheDescription => 'Ingredient cache';

  @override
  String get settingsCacheDeletedSnackbar => 'Mezipaměť úspěšně vymazána';

  @override
  String get aboutPageTitle => 'O aplikaci Wger';

  @override
  String contributeExerciseWarning(String days) {
    return 'Cvičení můžete přidávat pouze, pokud je váš účet starší než $days dní a máte ověřený e-mail';
  }

  @override
  String get simpleMode => 'Simple mode';

  @override
  String get simpleModeHelp => 'Hide some of the more advanced settings when editing exercises';

  @override
  String get progressionRules =>
      'This exercise has progression rules and can\'t be edited on the mobile app. Please use the web application to edit this exercise.';

  @override
  String get cacheWarning =>
      'Kvůli ukládání do mezipaměti může zobrazení změn v aplikaci chvíli trvat.';

  @override
  String get textPromptTitle => 'Připraveni začít?';

  @override
  String get textPromptSubheading => 'Začněte stisknutím akčního tlačítka';

  @override
  String get abs => 'Břišní svaly';

  @override
  String get arms => 'Paže';

  @override
  String get back => 'Záda';

  @override
  String get barbell => 'Vzpěračská činka';

  @override
  String get bench => 'Lavice';

  @override
  String get biceps => 'Bicepsy';

  @override
  String get body_weight => 'Tělesná hmotnost';

  @override
  String get calves => 'Lýtka';

  @override
  String get cardio => 'Kardio';

  @override
  String get chest => 'Hrudník';

  @override
  String get dumbbell => 'Jednoruční činka';

  @override
  String get glutes => 'Hýždě';

  @override
  String get gym_mat => 'Gymnastická podložka';

  @override
  String get hamstrings => 'Zadní stehenní svaly';

  @override
  String get incline_bench => 'Šikmá lavice';

  @override
  String get kettlebell => 'Kettlebell';

  @override
  String get kilometers => 'Kilometry';

  @override
  String get kilometers_per_hour => 'Kilometry za hodinu';

  @override
  String get lats => 'Široký sval zádový';

  @override
  String get legs => 'Nohy';

  @override
  String get lower_back => 'Dolní část zad';

  @override
  String get max_reps => 'Max. opakování';

  @override
  String get miles => 'Míle';

  @override
  String get miles_per_hour => 'Míle za hodinu';

  @override
  String get minutes => 'Minuty';

  @override
  String get plates => 'Závaží';

  @override
  String get pull_up_bar => 'Hrazda';

  @override
  String get quads => 'Čtyřhlavý sval stehenní';

  @override
  String get repetitions => 'Opakování';

  @override
  String get resistance_band => 'Resistance band';

  @override
  String get sz_bar => 'SZ-Bar';

  @override
  String get seconds => 'Sekundy';

  @override
  String get shoulders => 'Ramena';

  @override
  String get swiss_ball => 'Gymnastický míč';

  @override
  String get triceps => 'Tricepsy';

  @override
  String get until_failure => 'Do selhání';

  @override
  String get kg => 'kg';

  @override
  String get lb => 'lb';

  @override
  String get none__bodyweight_exercise_ => 'žádný (cvičení s vlastní vahou)';

  @override
  String get log => 'Záznam';

  @override
  String get done => 'Hotovo';

  @override
  String get overallChangeWeight => 'Overall change';

  @override
  String get goalTypeMeals => 'From meals';

  @override
  String get goalTypeBasic => 'Basic';

  @override
  String get goalTypeAdvanced => 'Advanced';

  @override
  String get indicatorRaw => 'raw';

  @override
  String get indicatorAvg => 'avg';

  @override
  String get endWorkout => 'End workout';

  @override
  String get themeMode => 'Theme mode';

  @override
  String get darkMode => 'Always dark mode';

  @override
  String get lightMode => 'Always light mode';

  @override
  String get systemMode => 'System settings';
}
