/*
 * Copyright (C) 2014 Bastian Venz
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

package de.serverfrog.pw;

import static de.serverfrog.pw.WebsiteType.*;
import java.net.URL;
import javax.swing.ComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.event.ListDataListener;

/**
 *
 * @author serverfrog
 */
public class GeneratorFrame extends javax.swing.JFrame {

    class EnumComboBoxModel implements ComboBoxModel<String> {

        private WebsiteType selected = DEFAULT;

        @Override
        public void setSelectedItem(Object anItem) {
            if (!(anItem instanceof String)) {
                return;
            }
            for (WebsiteType websiteType : WebsiteType.values()) {
                if (websiteType.getName().equals(anItem)) {
                    selected = websiteType;
                }
            }
        }

        @Override
        public Object getSelectedItem() {
            return selected.getName();
        }

        @Override
        public int getSize() {
            return WebsiteType.values().length;
        }

        @Override
        public String getElementAt(int index) {
            return WebsiteType.values()[index].getName();
        }

        @Override
        public void addListDataListener(ListDataListener l) {
        }

        @Override
        public void removeListDataListener(ListDataListener l) {
        }

        public WebsiteType getSelected() {
            return selected;
        }

    }
    private final EnumComboBoxModel c = new EnumComboBoxModel();

    /**
     * Creates new form TestFrame
     */
    public GeneratorFrame() {
        initComponents();
        URL imgURL = getClass().getResource("/icon.png");
        ImageIcon myAppImage = new ImageIcon(imgURL);
        setIconImage(myAppImage.getImage());
    }

    /**
     * This method is called from within the constructor to initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is always
     * regenerated by the Form Editor.
     */
    @SuppressWarnings("unchecked")
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabel1 = new javax.swing.JLabel();
        shouldSmall = new javax.swing.JCheckBox();
        shouldBig = new javax.swing.JCheckBox();
        shouldNumber = new javax.swing.JCheckBox();
        customeField = new javax.swing.JTextField();
        generateButton = new javax.swing.JButton();
        generatedField = new javax.swing.JTextField();
        shouldCustome = new javax.swing.JCheckBox();
        jLabel2 = new javax.swing.JLabel();
        bigAmount = new javax.swing.JSpinner();
        jLabel3 = new javax.swing.JLabel();
        smallAmount = new javax.swing.JSpinner();
        jLabel4 = new javax.swing.JLabel();
        numberAmount = new javax.swing.JSpinner();
        jLabel5 = new javax.swing.JLabel();
        customeAmount = new javax.swing.JSpinner();
        passwordField = new javax.swing.JPasswordField();
        jLabel6 = new javax.swing.JLabel();
        websiteNameField = new javax.swing.JTextField();
        jLabel7 = new javax.swing.JLabel();
        websiteTyp = new javax.swing.JComboBox();
        jLabel8 = new javax.swing.JLabel();
        passwordLenght = new javax.swing.JSpinner();

        setDefaultCloseOperation(javax.swing.WindowConstants.EXIT_ON_CLOSE);
        setTitle("Password Generator");
        setAlwaysOnTop(true);
        setMinimumSize(new java.awt.Dimension(430, 275));
        setResizable(false);

        jLabel1.setText("Masterpassword");

        shouldSmall.setText("a-z");

        shouldBig.setText("A-Z");

        shouldNumber.setText("0-9");

        customeField.setText("<>|!\"$%&/()=?*'_:;,.-#+öäüÖÄÜ~\\}][{@€");

        generateButton.setText("Generate");
        generateButton.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                generateButtonActionPerformed(evt);
            }
        });

        shouldCustome.setText("Addentional Characters");

        jLabel2.setText("Amount");

        bigAmount.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(1), Integer.valueOf(0), null, Integer.valueOf(1)));

        jLabel3.setText("Amount");

        smallAmount.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(1), Integer.valueOf(0), null, Integer.valueOf(1)));

        jLabel4.setText("Amount");

        numberAmount.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(1), Integer.valueOf(0), null, Integer.valueOf(1)));

        jLabel5.setText("Amount");

        customeAmount.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(1), Integer.valueOf(0), null, Integer.valueOf(1)));

        jLabel6.setText("Website Name");

        jLabel7.setText("Website Type");

        websiteTyp.setModel( c);

        jLabel8.setText("Password lenght");

        passwordLenght.setModel(new javax.swing.SpinnerNumberModel(Integer.valueOf(1), Integer.valueOf(0), null, Integer.valueOf(1)));

        javax.swing.GroupLayout layout = new javax.swing.GroupLayout(getContentPane());
        getContentPane().setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addComponent(generateButton)
                        .addGap(18, 18, 18)
                        .addComponent(generatedField))
                    .addGroup(layout.createSequentialGroup()
                        .addComponent(shouldCustome)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(customeField, javax.swing.GroupLayout.DEFAULT_SIZE, 259, Short.MAX_VALUE))
                    .addGroup(layout.createSequentialGroup()
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                            .addComponent(jLabel1, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabel8, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(passwordLenght, javax.swing.GroupLayout.PREFERRED_SIZE, 79, javax.swing.GroupLayout.PREFERRED_SIZE)
                            .addComponent(jLabel6, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addComponent(jLabel7, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE))
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                            .addComponent(websiteNameField)
                            .addComponent(passwordField, javax.swing.GroupLayout.Alignment.TRAILING)
                            .addComponent(websiteTyp, javax.swing.GroupLayout.Alignment.TRAILING, 0, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                            .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                                .addGap(0, 0, Short.MAX_VALUE)
                                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                    .addGroup(layout.createSequentialGroup()
                                        .addComponent(shouldNumber)
                                        .addGap(18, 18, 18)
                                        .addComponent(jLabel4)
                                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                        .addComponent(numberAmount, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE))
                                    .addGroup(layout.createSequentialGroup()
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                                            .addComponent(shouldBig)
                                            .addComponent(shouldSmall))
                                        .addGap(18, 18, 18)
                                        .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING, false)
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(jLabel3)
                                                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, javax.swing.GroupLayout.DEFAULT_SIZE, Short.MAX_VALUE)
                                                .addComponent(bigAmount, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE))
                                            .addGroup(layout.createSequentialGroup()
                                                .addComponent(jLabel2)
                                                .addGap(18, 18, 18)
                                                .addComponent(smallAmount, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE))))))))
                    .addGroup(javax.swing.GroupLayout.Alignment.TRAILING, layout.createSequentialGroup()
                        .addGap(0, 0, Short.MAX_VALUE)
                        .addComponent(jLabel5)
                        .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                        .addComponent(customeAmount, javax.swing.GroupLayout.PREFERRED_SIZE, 82, javax.swing.GroupLayout.PREFERRED_SIZE)))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
            .addGroup(layout.createSequentialGroup()
                .addContainerGap()
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel1)
                    .addComponent(passwordField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel6)
                    .addComponent(websiteNameField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel7)
                    .addComponent(websiteTyp, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED, 6, Short.MAX_VALUE)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(shouldSmall)
                    .addComponent(jLabel2)
                    .addComponent(smallAmount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(jLabel8))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(shouldBig)
                    .addComponent(jLabel3)
                    .addComponent(bigAmount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(passwordLenght, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.LEADING)
                    .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                        .addComponent(jLabel4)
                        .addComponent(numberAmount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                    .addComponent(shouldNumber))
                .addGap(5, 5, 5)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(customeField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(shouldCustome))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.RELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(jLabel5)
                    .addComponent(customeAmount, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE))
                .addPreferredGap(javax.swing.LayoutStyle.ComponentPlacement.UNRELATED)
                .addGroup(layout.createParallelGroup(javax.swing.GroupLayout.Alignment.BASELINE)
                    .addComponent(generatedField, javax.swing.GroupLayout.PREFERRED_SIZE, javax.swing.GroupLayout.DEFAULT_SIZE, javax.swing.GroupLayout.PREFERRED_SIZE)
                    .addComponent(generateButton))
                .addContainerGap())
        );

        pack();
    }// </editor-fold>//GEN-END:initComponents

    private void generateButtonActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_generateButtonActionPerformed
        if (((int) passwordLenght.getValue()) <= 0) {
            return;
        }
        final int passwordLength = ((int) passwordLenght.getValue());

        WebsiteBuilder wb = new WebsiteBuilder();
        final Website createWebsite = wb.setAddress(websiteNameField.getText())
                .setType(c.getSelected()).createWebsite();

        new Thread(new Runnable() {
            @Override
            public void run() {
                int amountSmall = 0;
                int amountBig = 0;
                int amountNumber = 0;
                int amountCustome = 0;
                if (shouldSmall.isSelected() && (((int) smallAmount.getValue()) > 0)) {
                    amountSmall = (int) smallAmount.getValue();
                }
                if (shouldBig.isSelected() && (((int) bigAmount.getValue()) > 0)) {
                    amountBig = (int) bigAmount.getValue();
                }
                if (shouldNumber.isSelected() && (((int) numberAmount.getValue()) > 0)) {
                    amountNumber = (int) numberAmount.getValue();
                }
                if (shouldCustome.isSelected() && !customeField.getText().isEmpty()
                        && (((int) customeAmount.getValue()) > 0)) {
                    amountCustome = (int) customeAmount.getValue();
                }

                if (amountSmall == 0 && amountBig == 0 && amountNumber == 0
                        && amountCustome == 0) {
                    return;
                }
                String generatePassword = SHA3Util.generatePassword(createWebsite,
                        new String(passwordField.getPassword()).getBytes(), passwordLength,
                        amountSmall, amountBig, amountNumber, amountCustome,
                        customeField.getText().toCharArray());
                generatedField.setText(generatePassword);
            }
        }).start();

    }//GEN-LAST:event_generateButtonActionPerformed

    /**
     * @param args the command line arguments
     */
    public static void main(String args[]) {

        /* Create and display the form */
        java.awt.EventQueue.invokeLater(new Runnable() {
            public void run() {
                new GeneratorFrame().setVisible(true);
            }
        });
    }

    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JSpinner bigAmount;
    private javax.swing.JSpinner customeAmount;
    private javax.swing.JTextField customeField;
    private javax.swing.JButton generateButton;
    private javax.swing.JTextField generatedField;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabel2;
    private javax.swing.JLabel jLabel3;
    private javax.swing.JLabel jLabel4;
    private javax.swing.JLabel jLabel5;
    private javax.swing.JLabel jLabel6;
    private javax.swing.JLabel jLabel7;
    private javax.swing.JLabel jLabel8;
    private javax.swing.JSpinner numberAmount;
    private javax.swing.JPasswordField passwordField;
    private javax.swing.JSpinner passwordLenght;
    private javax.swing.JCheckBox shouldBig;
    private javax.swing.JCheckBox shouldCustome;
    private javax.swing.JCheckBox shouldNumber;
    private javax.swing.JCheckBox shouldSmall;
    private javax.swing.JSpinner smallAmount;
    private javax.swing.JTextField websiteNameField;
    private javax.swing.JComboBox websiteTyp;
    // End of variables declaration//GEN-END:variables
}
