
// Copyright (c) 2023 Advanced Micro Devices, Inc. All rights reserved.
// Licensed under the MIT License.
#pragma once
#include "core/providers/shared_library/provider_api.h"
#define ORT_API_MANUAL_INIT
#include "core/session/onnxruntime_cxx_api.h"
#include "core/framework/provider_options.h"
#include "core/framework/execution_provider.h"
#include "vaip/my_ort.h"
#include "vaip/dll_safe.h"
#include "vaip/custom_op.h"
#include <optional>
#include <memory>
void initialize_vitisai_ep();
void deinitialize_vitisai_ep();
vaip_core::DllSafe<std::vector<std::unique_ptr<vaip_core::ExecutionProvider>>> compile_onnx_model(const onnxruntime::GraphViewer& graph_viewer, const onnxruntime::logging::Logger& logger, const onnxruntime::ProviderOptions& options);
std::shared_ptr<onnxruntime::KernelRegistry> get_kernel_registry_vitisaiep();
const std::vector<OrtCustomOpDomain*>& get_domains_vitisaiep();
std::optional<std::vector<onnxruntime::Node*>> create_ep_context_nodes(
    const std::vector<std::unique_ptr<vaip_core::ExecutionProvider>>& eps);

int vitisai_ep_on_run_start(
    const std::vector<std::unique_ptr<vaip_core::ExecutionProvider>>& eps, const void* state,
    vaip_core::DllSafe<std::string> (*get_config_entry)(const void* state, const char* entry_name));
int vitisai_ep_set_ep_dynamic_options(
    const std::vector<std::unique_ptr<vaip_core::ExecutionProvider>>& eps,
    const char* const* keys,
    const char* const* values, size_t kv_len);
/**
 * Replace EventRecord with std::tuple<std::string, int ,int, long long, long long>,
 * because EventRecord is defined in profiler_common.h which is used inside onnxruntime.
 * However, profiler_collect function will call vitis ep which can't include profiler_common.h.
 */
using EventInfo = std::tuple<
    std::string,  // name
    int,          // pid
    int,          // tid
    long long,    // timestamp
    long long     // duration
    >;
void profiler_collect(
    std::vector<EventInfo>& api_events,
    std::vector<EventInfo>& kernel_events);
std::unique_ptr<onnxruntime::IExecutionProvider>
CreateExecutionProviderFromAnotherEp(const std::string& lib, const OrtSessionOptions& session_options,
                                     std::unordered_map<std::string, std::string>& provider_options);

/**
 * Get compiled model compatibility information from execution providers.
 * Returns a JSON string containing compatibility metadata, or an empty string if unavailable.
 */
std::string get_compiled_model_compatibility_info(
    const std::vector<std::unique_ptr<vaip_core::ExecutionProvider>>& eps,
    const onnxruntime::GraphViewer& graph_viewer);

/**
 * Validate compiled model compatibility information against current runtime environment.
 * The model_compatibility is output parameter for the compatibility result.
 */
Status validate_compiled_model_compatibility_info(
    const std::vector<std::unique_ptr<vaip_core::ExecutionProvider>>& eps,
    const std::string& compatibility_info,
    OrtCompiledModelCompatibility& model_compatibility);
