## Contrib Operator Schemas
*This file is automatically generated from the registered contrib operator schemas by [this script](https://github.com/microsoft/onnxruntime/blob/main/tools/python/gen_contrib_doc.py).
Do not modify directly.*

* com.microsoft
  * <a href="#com.microsoft.Attention">com.microsoft.Attention</a>
  * <a href="#com.microsoft.AttnLSTM">com.microsoft.AttnLSTM</a>
  * <a href="#com.microsoft.BeamSearch">com.microsoft.BeamSearch</a>
  * <a href="#com.microsoft.BiasAdd">com.microsoft.BiasAdd</a>
  * <a href="#com.microsoft.BiasDropout">com.microsoft.BiasDropout</a>
  * <a href="#com.microsoft.BiasGelu">com.microsoft.BiasGelu</a>
  * <a href="#com.microsoft.BiasSoftmax">com.microsoft.BiasSoftmax</a>
  * <a href="#com.microsoft.BiasSplitGelu">com.microsoft.BiasSplitGelu</a>
  * <a href="#com.microsoft.BifurcationDetector">com.microsoft.BifurcationDetector</a>
  * <a href="#com.microsoft.BitmaskBiasDropout">com.microsoft.BitmaskBiasDropout</a>
  * <a href="#com.microsoft.BitmaskDropout">com.microsoft.BitmaskDropout</a>
  * <a href="#com.microsoft.CDist">com.microsoft.CDist</a>
  * <a href="#com.microsoft.ComplexMul">com.microsoft.ComplexMul</a>
  * <a href="#com.microsoft.ComplexMulConj">com.microsoft.ComplexMulConj</a>
  * <a href="#com.microsoft.ConvTransposeWithDynamicPads">com.microsoft.ConvTransposeWithDynamicPads</a>
  * <a href="#com.microsoft.CropAndResize">com.microsoft.CropAndResize</a>
  * <a href="#com.microsoft.DecoderAttention">com.microsoft.DecoderAttention</a>
  * <a href="#com.microsoft.DecoderMaskedMultiHeadAttention">com.microsoft.DecoderMaskedMultiHeadAttention</a>
  * <a href="#com.microsoft.DecoderMaskedSelfAttention">com.microsoft.DecoderMaskedSelfAttention</a>
  * <a href="#com.microsoft.DequantizeBFP">com.microsoft.DequantizeBFP</a>
  * <a href="#com.microsoft.DequantizeLinear">com.microsoft.DequantizeLinear</a>
  * <a href="#com.microsoft.DequantizeWithOrder">com.microsoft.DequantizeWithOrder</a>
  * <a href="#com.microsoft.DynamicQuantizeLSTM">com.microsoft.DynamicQuantizeLSTM</a>
  * <a href="#com.microsoft.DynamicQuantizeMatMul">com.microsoft.DynamicQuantizeMatMul</a>
  * <a href="#com.microsoft.DynamicTimeWarping">com.microsoft.DynamicTimeWarping</a>
  * <a href="#com.microsoft.EPContext">com.microsoft.EPContext</a>
  * <a href="#com.microsoft.EmbedLayerNormalization">com.microsoft.EmbedLayerNormalization</a>
  * <a href="#com.microsoft.ExpandDims">com.microsoft.ExpandDims</a>
  * <a href="#com.microsoft.FastGelu">com.microsoft.FastGelu</a>
  * <a href="#com.microsoft.FusedConv">com.microsoft.FusedConv</a>
  * <a href="#com.microsoft.FusedGemm">com.microsoft.FusedGemm</a>
  * <a href="#com.microsoft.FusedMatMul">com.microsoft.FusedMatMul</a>
  * <a href="#com.microsoft.FusedMatMulActivation">com.microsoft.FusedMatMulActivation</a>
  * <a href="#com.microsoft.GatedRelativePositionBias">com.microsoft.GatedRelativePositionBias</a>
  * <a href="#com.microsoft.GatherBlockQuantized">com.microsoft.GatherBlockQuantized</a>
  * <a href="#com.microsoft.GatherND">com.microsoft.GatherND</a>
  * <a href="#com.microsoft.Gelu">com.microsoft.Gelu</a>
  * <a href="#com.microsoft.GemmFastGelu">com.microsoft.GemmFastGelu</a>
  * <a href="#com.microsoft.GemmFloat8">com.microsoft.GemmFloat8</a>
  * <a href="#com.microsoft.GemmaRotaryEmbedding">com.microsoft.GemmaRotaryEmbedding</a>
  * <a href="#com.microsoft.GreedySearch">com.microsoft.GreedySearch</a>
  * <a href="#com.microsoft.GridSample">com.microsoft.GridSample</a>
  * <a href="#com.microsoft.GroupNorm">com.microsoft.GroupNorm</a>
  * <a href="#com.microsoft.GroupQueryAttention">com.microsoft.GroupQueryAttention</a>
  * <a href="#com.microsoft.Inverse">com.microsoft.Inverse</a>
  * <a href="#com.microsoft.Irfft">com.microsoft.Irfft</a>
  * <a href="#com.microsoft.LongformerAttention">com.microsoft.LongformerAttention</a>
  * <a href="#com.microsoft.MatMulBnb4">com.microsoft.MatMulBnb4</a>
  * <a href="#com.microsoft.MatMulFpQ4">com.microsoft.MatMulFpQ4</a>
  * <a href="#com.microsoft.MatMulInteger16">com.microsoft.MatMulInteger16</a>
  * <a href="#com.microsoft.MatMulIntegerToFloat">com.microsoft.MatMulIntegerToFloat</a>
  * <a href="#com.microsoft.MatMulNBits">com.microsoft.MatMulNBits</a>
  * <a href="#com.microsoft.MaxpoolWithMask">com.microsoft.MaxpoolWithMask</a>
  * <a href="#com.microsoft.MoE">com.microsoft.MoE</a>
  * <a href="#com.microsoft.MulInteger">com.microsoft.MulInteger</a>
  * <a href="#com.microsoft.MultiHeadAttention">com.microsoft.MultiHeadAttention</a>
  * <a href="#com.microsoft.MurmurHash3">com.microsoft.MurmurHash3</a>
  * <a href="#com.microsoft.NGramRepeatBlock">com.microsoft.NGramRepeatBlock</a>
  * <a href="#com.microsoft.NhwcConv">com.microsoft.NhwcConv</a>
  * <a href="#com.microsoft.NhwcFusedConv">com.microsoft.NhwcFusedConv</a>
  * <a href="#com.microsoft.NhwcMaxPool">com.microsoft.NhwcMaxPool</a>
  * <a href="#com.microsoft.PackedAttention">com.microsoft.PackedAttention</a>
  * <a href="#com.microsoft.PackedMultiHeadAttention">com.microsoft.PackedMultiHeadAttention</a>
  * <a href="#com.microsoft.Pad">com.microsoft.Pad</a>
  * <a href="#com.microsoft.PagedAttention">com.microsoft.PagedAttention</a>
  * <a href="#com.microsoft.QAttention">com.microsoft.QAttention</a>
  * <a href="#com.microsoft.QGemm">com.microsoft.QGemm</a>
  * <a href="#com.microsoft.QLinearAdd">com.microsoft.QLinearAdd</a>
  * <a href="#com.microsoft.QLinearAveragePool">com.microsoft.QLinearAveragePool</a>
  * <a href="#com.microsoft.QLinearConcat">com.microsoft.QLinearConcat</a>
  * <a href="#com.microsoft.QLinearConv">com.microsoft.QLinearConv</a>
  * <a href="#com.microsoft.QLinearGlobalAveragePool">com.microsoft.QLinearGlobalAveragePool</a>
  * <a href="#com.microsoft.QLinearLeakyRelu">com.microsoft.QLinearLeakyRelu</a>
  * <a href="#com.microsoft.QLinearMul">com.microsoft.QLinearMul</a>
  * <a href="#com.microsoft.QLinearReduceMean">com.microsoft.QLinearReduceMean</a>
  * <a href="#com.microsoft.QLinearSigmoid">com.microsoft.QLinearSigmoid</a>
  * <a href="#com.microsoft.QLinearSoftmax">com.microsoft.QLinearSoftmax</a>
  * <a href="#com.microsoft.QLinearWhere">com.microsoft.QLinearWhere</a>
  * <a href="#com.microsoft.QMoE">com.microsoft.QMoE</a>
  * <a href="#com.microsoft.QOrderedAttention">com.microsoft.QOrderedAttention</a>
  * <a href="#com.microsoft.QOrderedGelu">com.microsoft.QOrderedGelu</a>
  * <a href="#com.microsoft.QOrderedLayerNormalization">com.microsoft.QOrderedLayerNormalization</a>
  * <a href="#com.microsoft.QOrderedLongformerAttention">com.microsoft.QOrderedLongformerAttention</a>
  * <a href="#com.microsoft.QOrderedMatMul">com.microsoft.QOrderedMatMul</a>
  * <a href="#com.microsoft.QuantizeBFP">com.microsoft.QuantizeBFP</a>
  * <a href="#com.microsoft.QuantizeLinear">com.microsoft.QuantizeLinear</a>
  * <a href="#com.microsoft.QuantizeWithOrder">com.microsoft.QuantizeWithOrder</a>
  * <a href="#com.microsoft.QuickGelu">com.microsoft.QuickGelu</a>
  * <a href="#com.microsoft.Range">com.microsoft.Range</a>
  * <a href="#com.microsoft.ReduceSumInteger">com.microsoft.ReduceSumInteger</a>
  * <a href="#com.microsoft.RelativePositionBias">com.microsoft.RelativePositionBias</a>
  * <a href="#com.microsoft.RemovePadding">com.microsoft.RemovePadding</a>
  * <a href="#com.microsoft.RestorePadding">com.microsoft.RestorePadding</a>
  * <a href="#com.microsoft.Rfft">com.microsoft.Rfft</a>
  * <a href="#com.microsoft.RotaryEmbedding">com.microsoft.RotaryEmbedding</a>
  * <a href="#com.microsoft.SampleOp">com.microsoft.SampleOp</a>
  * <a href="#com.microsoft.Sampling">com.microsoft.Sampling</a>
  * <a href="#com.microsoft.SkipGroupNorm">com.microsoft.SkipGroupNorm</a>
  * <a href="#com.microsoft.SkipLayerNormalization">com.microsoft.SkipLayerNormalization</a>
  * <a href="#com.microsoft.SkipSimplifiedLayerNormalization">com.microsoft.SkipSimplifiedLayerNormalization</a>
  * <a href="#com.microsoft.Snpe">com.microsoft.Snpe</a>
  * <a href="#com.microsoft.SparseAttention">com.microsoft.SparseAttention</a>
  * <a href="#com.microsoft.SparseToDenseMatMul">com.microsoft.SparseToDenseMatMul</a>
  * <a href="#com.microsoft.Tokenizer">com.microsoft.Tokenizer</a>
  * <a href="#com.microsoft.TorchEmbedding">com.microsoft.TorchEmbedding</a>
  * <a href="#com.microsoft.TransposeMatMul">com.microsoft.TransposeMatMul</a>
  * <a href="#com.microsoft.Trilu">com.microsoft.Trilu</a>
  * <a href="#com.microsoft.UnfoldTensor">com.microsoft.UnfoldTensor</a>
  * <a href="#com.microsoft.Unique">com.microsoft.Unique</a>
  * <a href="#com.microsoft.WhisperBeamSearch">com.microsoft.WhisperBeamSearch</a>
  * <a href="#com.microsoft.WordConvEmbedding">com.microsoft.WordConvEmbedding</a>
  * <sub>experimental</sub> <a href="#com.microsoft.IsAllFinite">com.microsoft.IsAllFinite</a>
  * <sub>experimental</sub> <a href="#com.microsoft.QEmbedLayerNormalization">com.microsoft.QEmbedLayerNormalization</a>

## com.microsoft
### <a name="com.microsoft.Attention"></a><a name="com.microsoft.attention">**com.microsoft.Attention**</a>

  Multi-Head Attention that can be either unidirectional (like GPT-2) or bidirectional (like BERT).
  
  The weights for input projection of Q, K and V are merged. The data is stacked on the second dimension. Its shape
  is (input_hidden_size, hidden_size + hidden_size + v_hidden_size). Here hidden_size is the hidden dimension of Q and K,
  and v_hidden_size is that of V.
  
  The mask_index is optional. Besides raw attention mask with shape (batch_size, total_sequence_length)
  or (batch_size, sequence_length, total_sequence_length) with value 0 for masked and 1 otherwise,
  we support other two formats: When input has right-side padding, mask_index is one dimension with shape (batch_size),
  where value is actual sequence length excluding padding. When input has left-side padding, mask_index has
  shape (2 * batch_size), where the values are the exclusive end positions followed by the inclusive start positions.
  
  When unidirectional is 1, each token only attends to previous tokens.
  
  Both past and present state are optional. They shall be used together, and not allowed to use only one of them.
  The qkv_hidden_sizes is required only when K and V have different hidden sizes.
  
  When there is past state, hidden dimension for Q, K and V shall be the same.
  
  The total_sequence_length is past_sequence_length + kv_sequence_length. Here kv_sequence_length is the length of K or V.
  For self attention, kv_sequence_length equals to sequence_length (sequence length of Q).
  For cross attention, query and key might have different lengths.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>do_rotary</tt> : int</dt>
<dd>Whether to use rotary position embedding. Default value is 0.</dd>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>past_present_share_buffer</tt> : int</dt>
<dd>Corresponding past and present are same tensor, its size is (2, batch_size, num_heads, max_sequence_length, head_size)</dd>
<dt><tt>qkv_hidden_sizes</tt> : list of ints</dt>
<dd>Hidden dimension of Q, K, V: hidden_size, hidden_size and v_hidden_size</dd>
<dt><tt>rotary_embedding_dim</tt> : int</dt>
<dd>Dimension of rotary embedding. Limited to 32, 64 or 128. Default value is head_size</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
<dt><tt>unidirectional</tt> : int</dt>
<dd>Whether every token can only attend to previous tokens. Default value is 0.</dd>
</dl>

#### Inputs (2 - 7)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor with shape (batch_size, sequence_length, input_hidden_size)</dd>
<dt><tt>weights</tt> : T</dt>
<dd>Merged Q/K/V weights with shape (input_hidden_size, hidden_size + hidden_size + v_hidden_size)</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>Bias tensor with shape (hidden_size + hidden_size + v_hidden_size) for input projection</dd>
<dt><tt>mask_index</tt> (optional) : M</dt>
<dd>Attention mask with shape (batch_size, 1, max_sequence_length, max_sequence_length), (batch_size, total_sequence_length) or (batch_size, sequence_length, total_sequence_length), or index with shape (batch_size) or (2 * batch_size) or (3 * batch_size + 2)</dd>
<dt><tt>past</tt> (optional) : T</dt>
<dd>past state for key and value with shape (2, batch_size, num_heads, past_sequence_length, head_size)When past_present_share_buffer is set, its shape is (2, batch_size, num_heads, max_sequence_length, head_size)</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>additional add to QxK' with shape (batch_size or 1, num_heads or 1, sequence_length, total_sequence_length)</dd>
<dt><tt>past_sequence_length</tt> (optional) : M</dt>
<dd>When past_present_share_buffer is used, it is required to specify past_sequence_length (could be 0).</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, v_hidden_size)</dd>
<dt><tt>present</tt> (optional) : T</dt>
<dd>past state for key and value with shape (2, batch_size, num_heads, total_sequence_length, head_size). If past_present_share_buffer is set, its shape is (2, batch_size, num_heads, max_sequence_length, head_size), while effective_seq_length = (past_sequence_length + kv_sequence_length).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask index to integer types</dd>
</dl>


### <a name="com.microsoft.AttnLSTM"></a><a name="com.microsoft.attnlstm">**com.microsoft.AttnLSTM**</a>

  Computes an one-layer RNN where its RNN Cell is an AttentionWrapper wrapped a LSTM Cell. The RNN layer
  contains following basic component: LSTM Cell, Bahdanau Attention Mechanism, AttentionWrapp.
  
  Activation functions:
  
    Relu(x)                - max(0, x)
  
    Tanh(x)                - (1 - e^{-2x})/(1 + e^{-2x})
  
    Sigmoid(x)             - 1/(1 + e^{-x})
  
    (NOTE: Below are optional)
  
    Affine(x)              - alpha*x + beta
  
    LeakyRelu(x)           - x if x >= 0 else alpha * x
  
    ThresholdedRelu(x)     - x if x >= alpha else 0
  
    ScaledTanh(x)          - alpha*Tanh(beta*x)
  
    HardSigmoid(x)         - min(max(alpha*x + beta, 0), 1)
  
    Elu(x)                 - x if x >= 0 else alpha*(e^x - 1)
  
    Softsign(x)            - x/(1 + |x|)
  
    Softplus(x)            - log(1 + e^x)
  
    Softmax(x)             - exp(x) / sum(exp(x))
  
  Bahdanau Attention Mechanism:
      `M` -  Memory tensor.
  
      `VALUES` - masked Memory by its real sequence length.
  
      `MW` - Memory layer weight.
  
      `KEYS` - Processed memory tensor by the memory layer.
               KEYS = M * MW
  
      `Query` - Query tensor, normally at specific time step in sequence.
  
      `QW` - Query layer weight in the attention mechanism
  
      `PQ` - processed query,  = `Query` * `QW`
  
      `V' - attention vector
  
      `ALIGN` - calculated alignment based on Query and KEYS
          ALIGN = softmax(reduce_sum(`V` * Tanh(`KEYS` + `PQ`)))
  
      `CONTEXT` - context based on `ALIGN` and `VALUES`
          CONTEXT = `ALIGN` * `VALUES`
  
  
  LSTM Cell:
    `X` - input tensor concat with attention state in the attention wrapper
  
    `i` - input gate
  
    `o` - output gate
  
    `f` - forget gate
  
    `c` - cell gate
  
    `t` - time step (t-1 means previous time step)
  
    `W[iofc]` - W parameter weight matrix for input, output, forget, and cell gates
  
    `R[iofc]` - R recurrence weight matrix for input, output, forget, and cell gates
  
    `Wb[iofc]` - W bias vectors for input, output, forget, and cell gates
  
    `Rb[iofc]` - R bias vectors for input, output, forget, and cell gates
  
    `P[iof]`  - P peephole weight vector for input, output, and forget gates
  
    `WB[iofc]` - W parameter weight matrix for backward input, output, forget, and cell gates
  
    `RB[iofc]` - R recurrence weight matrix for backward input, output, forget, and cell gates
  
    `WBb[iofc]` - W bias vectors for backward input, output, forget, and cell gates
  
    `RBb[iofc]` - R bias vectors for backward input, output, forget, and cell gates
  
    `PB[iof]`  - P peephole weight vector for backward input, output, and forget gates
  
    `H` - Hidden state
  
    `num_directions` - 2 if direction == bidirectional else 1
  
    Equations (Default: f=Sigmoid, g=Tanh, h=Tanh):
  
      - it = f(Xt*(Wi^T) + Ht-1*(Ri^T) + Pi (.) Ct-1 + Wbi + Rbi)
  
      - ft = f(Xt*(Wf^T) + Ht-1*(Rf^T) + Pf (.) Ct-1 + Wbf + Rbf)
  
      - ct = g(Xt*(Wc^T) + Ht-1*(Rc^T) + Wbc + Rbc)
  
      - Ct = ft (.) Ct-1 + it (.) ct
  
      - ot = f(Xt*(Wo^T) + Ht-1*(Ro^T) + Po (.) Ct + Wbo + Rbo)
  
      - Ht = ot (.) h(Ct)
  
  
  AttentionWrapp Notations:
    `lstm()' - wrapped inner cell.
             Ht, Ct = lstm(concat(Xt, ATTNt-1), Ct-1)
  
    `am()` - attention mechanism the wrapper used.
             CONTEXTt, ALIGNt = am(Ht, ALIGNt-1)
  
    `AW` - attention layer weights, optional.
  
    `ATTN` - attention state, initial is zero. If `AW` provided, it is the output of the attention layer,
                  ATTNt = concat(Ht, CONTEXTt) * AW
             otherwise,
                  ATTNt = CONTEXTt
  
  RNN layer output:
    `Y` - if needed is the sequence of Ht from lstm cell.
  
    `Y_h` - is the last valid H from lstm cell.
  
    `Y_c` - is the last valid C from lstm cell.
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 3 (or 6 if bidirectional) activation functions for input, output, forget, cell, and hidden. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer.</dd>
<dt><tt>input_forget</tt> : int</dt>
<dd>Couple the input and forget gates if 1, default 0.</dd>
</dl>

#### Inputs (3 - 14)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor for the gates. Concatenation of `W[iofc]` and `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape `[num_directions, 4*hidden_size, input_size]`.</dd>
<dt><tt>R</tt> : T</dt>
<dd>The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 4*hidden_size, hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wb[iofc], Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]` </dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>initial_c</tt> (optional) : T</dt>
<dd>Optional initial value of the cell. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>P</tt> (optional) : T</dt>
<dd>The weight tensor for peepholes. Concatenation of `P[iof]` and `PB[iof]` (if bidirectional) along dimension 0. It has shape `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>QW</tt> (optional) : T</dt>
<dd>The weight tensor of the query layer in the attention mechanism. Should be of shape `[num_directions, am_query_depth(hidden_size of lstm), am_attn_size]` </dd>
<dt><tt>MW</tt> (optional) : T</dt>
<dd>The weight tensor of the memory layer in the attention mechanism. Should be of shape `[num_directions, memory_depth, am_attn_size]` </dd>
<dt><tt>V</tt> (optional) : T</dt>
<dd>The attention_v tensor in the attention mechanism. Should be of shape `[num_directions, am_attn_size]` </dd>
<dt><tt>M</tt> (optional) : T</dt>
<dd>The sequence of the memory (input) for attention mechanism. Should be of `[batch_size, max_memory_step, memory_depth]` </dd>
<dt><tt>memory_seq_lens</tt> (optional) : T1</dt>
<dd>The sequence length of the input memory for the attention mechanism. Should be of `[batch_size]` </dd>
<dt><tt>AW</tt> (optional) : T</dt>
<dd>The weights of attention layer in the attention wrapper. If exists, should be of shape `[num_directions, memory_depth+hidden_size, aw_attn_size]. Please note that attention mechanism context depth is also memory_depth in the attention mechanism.` </dd>
</dl>

#### Outputs (0 - 3)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`</dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_c</tt> (optional) : T</dt>
<dd>The last output value of the cell. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integral tensors.</dd>
</dl>


### <a name="com.microsoft.BeamSearch"></a><a name="com.microsoft.beamsearch">**com.microsoft.BeamSearch**</a>

  Beam Search for text generation. Supports GPT-2 decoder.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>decoder</tt> : graph (required)</dt>
<dd>Decoder subgraph to execute in a loop.</dd>
<dt><tt>decoder_start_token_id</tt> : int</dt>
<dd>The id of the token that indicates decoding starts.</dd>
<dt><tt>early_stopping</tt> : int</dt>
<dd>early stop or not</dd>
<dt><tt>encoder</tt> : graph</dt>
<dd>The subgraph for initialization of encoder and decoder. It will be called once before decoder subgraph.</dd>
<dt><tt>eos_token_id</tt> : int (required)</dt>
<dd>The id of the end-of-sequence token</dd>
<dt><tt>init_decoder</tt> : graph</dt>
<dd>The subgraph for the first decoding run. It will be called once before `decoder` subgraph. This is relevant only for the GPT2 model. If this attribute is missing, the `decoder` subgraph will be used for all decoding runs</dd>
<dt><tt>model_type</tt> : int</dt>
<dd>model type: 0 for GPT-2; 1 for encoder decoder like T5</dd>
<dt><tt>no_repeat_ngram_size</tt> : int</dt>
<dd>no repeat ngrams size</dd>
<dt><tt>pad_token_id</tt> : int (required)</dt>
<dd>The id of the padding token</dd>
<dt><tt>vocab_size</tt> : int</dt>
<dd>Size of the vocabulary. If not provided, it will be inferred from the decoder subgraph's output shape</dd>
</dl>

#### Inputs (5 - 12)

<dl>
<dt><tt>input_ids</tt> : F</dt>
<dd>The sequence used as a prompt for the generation in the encoder subgraph. Shape is (batch_size, sequence_length)</dd>
<dt><tt>max_length</tt> : I</dt>
<dd>The maximum length of the sequence to be generated. Shape is (1)</dd>
<dt><tt>min_length</tt> (optional) : I</dt>
<dd>The minimum length below which the score of eos_token_id is set to -Inf. Shape is (1)</dd>
<dt><tt>num_beams</tt> : I</dt>
<dd>Number of beams for beam search. 1 means no beam search. Shape is (1)</dd>
<dt><tt>num_return_sequences</tt> : I</dt>
<dd>The number of returned sequences in the batch. Shape is (1)</dd>
<dt><tt>length_penalty</tt> (optional) : T</dt>
<dd>Exponential penalty to the length. Default value 1.0 means no penalty.Value > 1.0 encourages longer sequences, while values < 1.0 produces shorter sequences.Shape is (1,)</dd>
<dt><tt>repetition_penalty</tt> (optional) : T</dt>
<dd>The parameter for repetition penalty. Default value 1.0 means no penalty. Accepts value > 0.0. Shape is (1)</dd>
<dt><tt>vocab_mask</tt> (optional) : M</dt>
<dd>Mask of vocabulary. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (vocab_size)</dd>
<dt><tt>prefix_vocab_mask</tt> (optional) : M</dt>
<dd>Mask of vocabulary for first step. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (batch_size, vocab_size)</dd>
<dt><tt>attention_mask</tt> (optional) : I</dt>
<dd>Custom attention mask. Shape is (batch_size, sequence_length)</dd>
<dt><tt>decoder_input_ids</tt> (optional) : I</dt>
<dd>The forced input id sequence for the decoder subgraph. Shape is (batch_size, initial_sequence_length)</dd>
<dt><tt>logits_processor</tt> (optional) : I</dt>
<dd>Specific logits processor for different types of beamsearch models. Default value 0 means no specific logit processor. Accepts value >= 0. Shape is (1)</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>sequences</tt> : I</dt>
<dd>Word IDs of generated sequences. Shape is (batch_size, num_return_sequences, max_sequence_length)</dd>
<dt><tt>sequences_scores</tt> (optional) : T</dt>
<dd>Final beam score of the generated sequences. Shape is (batch_size, num_return_sequences)</dd>
<dt><tt>scores</tt> (optional) : T</dt>
<dd>Processed beam scores for each vocabulary token at each generation step.Beam scores consisting of log softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this beam.Shape is (max_length - sequence_length, batch_size, num_beams, vocab_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain to float tensors.</dd>
<dt><tt>F</tt> : tensor(float), tensor(int32), tensor(float16)</dt>
<dd>Constrain input type to float or int tensors.</dd>
<dt><tt>I</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask to integer types</dd>
</dl>


### <a name="com.microsoft.BiasAdd"></a><a name="com.microsoft.biasadd">**com.microsoft.BiasAdd**</a>

  Add input with bias, then add residual inputs.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor. Dimensions are (N, S, C), where N is the batch size, S is image size H*W, and C is number of channels</dd>
<dt><tt>bias</tt> : T</dt>
<dd>Bias tensor. Dimensions are (C)</dd>
<dt><tt>skip</tt> : T</dt>
<dd>Residual tensor. Dimensions are (N, S, C)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output tensor with dimensions (N, S, C)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.BiasDropout"></a><a name="com.microsoft.biasdropout">**com.microsoft.BiasDropout**</a>

  output, dropout_mask = Dropout(data + bias, ratio) + residual, Intended to specialize the dropout pattern commonly found in transformer models.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>seed</tt> : int</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs (2 - 5)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
<dt><tt>bias</tt> : T</dt>
<dd>The bias input, a vector with the same shape as last dim of data OR same shape with data</dd>
<dt><tt>residual</tt> (optional) : T</dt>
<dd>The residual input, must have the same shape as data</dd>
<dt><tt>ratio</tt> (optional) : T1</dt>
<dd>The ratio of random dropout, with value in [0, 1). If this input was not set, or if it was set to 0, the output would be a simple copy of the input. If it's non-zero, output will be a random dropout of the scaled input, which is typically the case during training. It is an optional value, if not specified it will default to 0.5.</dd>
<dt><tt>training_mode</tt> (optional) : T2</dt>
<dd>If set to true then it indicates dropout is being used for training. It is an optional value hence unless specified explicitly, it is false. If it is false, ratio is ignored and the operation mimics inference mode where nothing will be dropped from the input data and if mask is requested as output it will contain all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T2</dt>
<dd>The output mask of dropout.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input 'ratio' types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain output 'mask' types to boolean tensors.</dd>
</dl>


### <a name="com.microsoft.BiasGelu"></a><a name="com.microsoft.biasgelu">**com.microsoft.BiasGelu**</a>

  Bias Gelu.
  It's an extension of Gelu. It takes the sum of input A and bias input B as the input of Gelu activation. 

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>The normal input data.</dd>
<dt><tt>B</tt> : T</dt>
<dd>The bias input data that is a 1D tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>The output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.BiasSoftmax"></a><a name="com.microsoft.biassoftmax">**com.microsoft.BiasSoftmax**</a>

  Y = softmax(scores + bias)) with simple broadcast on bias. Intended to specialize softmax(scores + additive_mask) commonly found in transformer models.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>apply softmax to elements for dimensions axis or higher</dd>
<dt><tt>is_inner_broadcast</tt> : int (required)</dt>
<dd>true if broadcast bias across input for dimensions broadcast_axis to axis-1, otherwise broadcast bias across input for dimensions 0 to broadcast_axis - 1</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
<dt><tt>bias</tt> : T</dt>
<dd>The bias (or mask) as Tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.BiasSplitGelu"></a><a name="com.microsoft.biassplitgelu">**com.microsoft.BiasSplitGelu**</a>

  A fusion used in diffusion model that after adding bias, hidden state is sliced into two tensors of same size, then left
  tensor multiplies the Gelu activation result of right tensor.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor. Dimensions are (N, S, D), where N is the batch size, S are image size, and D is hidden dimension</dd>
<dt><tt>bias</tt> : T</dt>
<dd>Bias tensor. Dimensions are (D), where D is the same hidden dimension as input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output tensor with dimensions (N, S, D/2)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain input X and output Y types to float tensors.</dd>
</dl>


### <a name="com.microsoft.BifurcationDetector"></a><a name="com.microsoft.bifurcationdetector">**com.microsoft.BifurcationDetector**</a>

  Component for aggressive decoding. Find the bifurcation index of predicted tokens, between source tokens,
  starting from previous suffix match index, and predicted tokens.
  Concat predicted tokens, starting from bifurcation index, to the back
  of current tokens. This forms the output tokens.
  Detect suffix match index in source tokens, between source tokens and output tokens.
  Detection is based on finding the appearances of last n-gram in output tokens
  in source tokens.
  A match is considered found if source tokens contain a single matching n-gram.
  Return the index of the start of the n-gram in source tokens.
  No matching if found if src tokens contain multiple or zero matching n-grams. Return -1.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>max_ngram_size</tt> : int</dt>
<dd>The maximum NGram size for suffix matching.</dd>
<dt><tt>min_ngram_size</tt> : int</dt>
<dd>The minimum NGram size for suffix matching.</dd>
</dl>

#### Inputs (3 - 4)

<dl>
<dt><tt>src_tokens</tt> : T</dt>
<dd>Encoder input ids.</dd>
<dt><tt>cur_tokens</tt> : T</dt>
<dd>Decoder input ids.</dd>
<dt><tt>prev_suffix_match_idx</tt> : T</dt>
<dd>Previous suffix match index</dd>
<dt><tt>pred_tokens</tt> (optional) : T</dt>
<dd>Predicted token ids from aggressive decoding</dd>
</dl>

#### Outputs

<dl>
<dt><tt>tokens</tt> : T</dt>
<dd>Decoder input ids after merging predicted tokens</dd>
<dt><tt>suffix_match_idx</tt> : T</dt>
<dd>new suffix match index</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int64)</dt>
<dd>Constrain to integer types.</dd>
</dl>


### <a name="com.microsoft.BitmaskBiasDropout"></a><a name="com.microsoft.bitmaskbiasdropout">**com.microsoft.BitmaskBiasDropout**</a>

  output, dropout_bitmask = Dropout(data + bias, ratio) + residual, Intended to specialize the dropout pattern commonly found in transformer models.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>seed</tt> : int</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs (2 - 5)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
<dt><tt>bias</tt> : T</dt>
<dd>The bias input, a vector with the same shape as last dim of data OR same shape with data</dd>
<dt><tt>residual</tt> (optional) : T</dt>
<dd>The residual input, must have the same shape as data</dd>
<dt><tt>ratio</tt> (optional) : T1</dt>
<dd>The ratio of random dropout, with value in [0, 1). If this input was not set, or if it was set to 0, the output would be a simple copy of the input. If it's non-zero, output will be a random dropout of the scaled input, which is typically the case during training. It is an optional value, if not specified it will default to 0.5.</dd>
<dt><tt>training_mode</tt> (optional) : T2</dt>
<dd>If set to true then it indicates dropout is being used for training. It is an optional value hence unless specified explicitly, it is false. If it is false, ratio is ignored and the operation mimics inference mode where nothing will be dropped from the input data and if mask is requested as output it will contain all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T3</dt>
<dd>The output mask of dropout.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input 'ratio' types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain input 'training_mode' types to boolean tensors.</dd>
<dt><tt>T3</tt> : tensor(uint32)</dt>
<dd>Constrain output 'mask' types to uint32 tensors.</dd>
</dl>


### <a name="com.microsoft.BitmaskDropout"></a><a name="com.microsoft.bitmaskdropout">**com.microsoft.BitmaskDropout**</a>

  BitmaskDropout takes an input floating-point tensor, an optional input ratio (floating-point scalar) and an optional input training_mode (boolean scalar).
  It produces two tensor outputs: output (floating-point tensor) and mask (optional `Tensor<uint32>`). If `training_mode` is true then the output Y will be a random dropout.
  Note that this Dropout scales the masked input data by the following equation, so to convert the trained model into inference mode, the user can simply not pass `training_mode` input or set it to false.
  ```
  output = scale * data * mask,
  ```
  where
  ```
  scale = 1. / (1. - ratio).
  ```
  
  This op functions in much the same was as Dropout-11 and Dropout-13 do, except that the mask is output as a bit-packed uint32 tensor, instead of a boolean tensor.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>seed</tt> : int</dt>
<dd>(Optional) Seed to the random generator, if not specified we will auto generate one.</dd>
</dl>

#### Inputs (1 - 3)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>The input data as Tensor.</dd>
<dt><tt>ratio</tt> (optional) : T1</dt>
<dd>The ratio of random dropout, with value in [0, 1). If this input was not set, or if it was set to 0, the output would be a simple copy of the input. If it's non-zero, output will be a random dropout of the scaled input, which is typically the case during training. It is an optional value, if not specified it will default to 0.5.</dd>
<dt><tt>training_mode</tt> (optional) : T2</dt>
<dd>If set to true then it indicates dropout is being used for training. It is an optional value hence unless specified explicitly, it is false. If it is false, ratio is ignored and the operation mimics inference mode where nothing will be dropped from the input data and if mask is requested as output it will contain all ones.</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output.</dd>
<dt><tt>mask</tt> (optional) : T3</dt>
<dd>The bit-packed output mask.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input 'ratio' types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(bool)</dt>
<dd>Constrain 'training_mode' to boolean tensor.</dd>
<dt><tt>T3</tt> : tensor(uint32)</dt>
<dd>Constrain output 'mask' types to bit-packed uint32 tensor.</dd>
</dl>


### <a name="com.microsoft.CDist"></a><a name="com.microsoft.cdist">**com.microsoft.CDist**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>metric</tt> : string</dt>
<dd>The distance metric to use. If a string, the distance function can be "braycurtis", "canberra", "chebyshev", "cityblock", "correlation", "cosine", "dice", "euclidean", "hamming", "jaccard", "jensenshannon", "kulsinski", "mahalanobis", "matching", "minkowski", "rogerstanimoto", "russellrao", "seuclidean", "sokalmichener", "sokalsneath", "sqeuclidean", "wminkowski", "yule".</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>2D matrix with shape (M,N)</dd>
<dt><tt>B</tt> : T</dt>
<dd>2D matrix with shape (K,N)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>A 2D Matrix that represents the distance between each pair of the two collections of inputs.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double)</dt>
<dd>Constrains input to only numeric types.</dd>
</dl>


### <a name="com.microsoft.ComplexMul"></a><a name="com.microsoft.complexmul">**com.microsoft.ComplexMul**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>input_0</dd>
<dt><tt>B</tt> : T</dt>
<dd>input_1</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(float16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
</dl>


### <a name="com.microsoft.ComplexMulConj"></a><a name="com.microsoft.complexmulconj">**com.microsoft.ComplexMulConj**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>input_0</dd>
<dt><tt>B</tt> : T</dt>
<dd>input_1</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(float16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
</dl>


### <a name="com.microsoft.ConvTransposeWithDynamicPads"></a><a name="com.microsoft.convtransposewithdynamicpads">**com.microsoft.ConvTransposeWithDynamicPads**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd></dd>
<dt><tt>group</tt> : int</dt>
<dd></dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd></dd>
<dt><tt>output_padding</tt> : list of ints</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs (2 - 4)

<dl>
<dt><tt>X</tt> : T</dt>
<dd></dd>
<dt><tt>W</tt> : T</dt>
<dd></dd>
<dt><tt>Pads</tt> (optional) : tensor(int64)</dt>
<dd></dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd></dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd></dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors</dd>
</dl>


### <a name="com.microsoft.CropAndResize"></a><a name="com.microsoft.cropandresize">**com.microsoft.CropAndResize**</a>

  Extracts crops from the input image tensor and resizes them using bilinear sampling or nearest neighbor sampling
          (possibly with aspect ratio change) to a common output size specified by crop_height and crop_width.
          Returns a tensor with crops from the input image at positions defined at the bounding box locations in boxes.
          The cropped boxes are all resized (with bilinear or nearest neighbor interpolation) to
          a fixed size = [crop_height, crop_width]. The result is a 4-D tensor [num_boxes, crop_height, crop_width, depth].
          The resizing is corner aligned.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>extrapolation_value</tt> : float</dt>
<dd>Value used for extrapolation, when applicable. Default is 0.0f. </dd>
<dt><tt>mode</tt> : string</dt>
<dd>The pooling method. Two modes are supported: 'bilinear' and 'nearest'. Default is 'bilinear'.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>Input data tensor from the previous operator; 4-D feature map of shape (N, C, H, W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data.</dd>
<dt><tt>rois</tt> : T1</dt>
<dd>RoIs (Regions of Interest) to pool over; rois is 2-D input of shape (num_rois, 4) given as [[y1, x1, y2, x2], ...]. The RoIs' coordinates are normalized in the coordinate system of the input image. Each coordinate set has a 1:1 correspondence with the 'batch_indices' input.</dd>
<dt><tt>batch_indices</tt> : T2</dt>
<dd>1-D tensor of shape (num_rois,) with each element denoting the index of the corresponding image in the batch.</dd>
<dt><tt>crop_size</tt> : T2</dt>
<dd>1-D tensor of 2 elements: [crop_height, crop_width]. All cropped image patches are resized to this size. Both crop_height and crop_width need to be positive.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>RoI pooled output, 4-D tensor of shape (num_rois, C, crop_height, crop_width). The r-th batch element Y[r-1] is a pooled feature map corresponding to the r-th RoI X[r-1].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int32)</dt>
<dd>Constrain types to int tensors.</dd>
</dl>


### <a name="com.microsoft.DecoderAttention"></a><a name="com.microsoft.decoderattention">**com.microsoft.DecoderAttention**</a>

  This DecoderAttention supports self attention and cross attention, key and value cache, and key_padding_mask. The attention mask is not support at the moment.
  Some boolean parameters are passed by runtime input for generic purpose

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
</dl>

#### Inputs

<dl>
<dt><tt>query</tt> : T</dt>
<dd>3D input tensor with shape (sequence_length, batch_size, hidden_size), hidden_size = num_heads * head_size</dd>
<dt><tt>key</tt> : T</dt>
<dd>3D input tensor with shape (total_sequence_length, batch_size, hidden_size)</dd>
<dt><tt>q_weight</tt> : T</dt>
<dd>2D input tensor with shape (hidden_size, hidden_size)</dd>
<dt><tt>kv_weight</tt> : T</dt>
<dd>2D input tensor with shape (hidden_size, 2 * hidden_size)</dd>
<dt><tt>bias</tt> : T</dt>
<dd>1D input tensor with shape (3 * hidden_size)</dd>
<dt><tt>key_padding_mask</tt> (optional) : B</dt>
<dd>2D input tensor with shape (batch_size, total_sequence_length)</dd>
<dt><tt>key_cache</tt> (optional) : T</dt>
<dd>input tensor with shape (batch_size, num_heads, sequence_length or total_sequence_length, head_size)</dd>
<dt><tt>value_cache</tt> (optional) : T</dt>
<dd>input tensor with shape (batch_size, num_heads, sequence_length or total_sequence_length, head_size)</dd>
<dt><tt>static_kv</tt> : B</dt>
<dd>If static_kv = true, cross-attention; else self-attention</dd>
<dt><tt>use_past</tt> : B</dt>
<dd>If use_past = true, use cache; else no cache</dd>
<dt><tt>has_layer_state</tt> : B</dt>
<dd>If has_layer_state = true, layer_state = {} or [a,b]; else layer_state = None</dd>
<dt><tt>has_key_padding_mask</tt> : B</dt>
<dd>has_key_padding_mask or not</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (sequence_length, batch_size, hidden_size)</dd>
<dt><tt>new_key_cache</tt> (optional) : T</dt>
<dd>output tensor with shape (batch_size, num_heads, new sequence_length, head_size)</dd>
<dt><tt>new_value_cache</tt> (optional) : T</dt>
<dd>output tensor with shape (batch_size, num_heads, new sequence_length, head_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float and float16 tensors.</dd>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Constrain key_padding_mask to bool tensors.</dd>
</dl>


### <a name="com.microsoft.DecoderMaskedMultiHeadAttention"></a><a name="com.microsoft.decodermaskedmultiheadattention">**com.microsoft.DecoderMaskedMultiHeadAttention**</a>

  Multihead attention that supports input sequence length of 1.
  Similar to DecoderMaskedSelfAttention but this op excludes QKV MatMul and Bias.
  This op supports both Self and Cross Attention.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>output_qk</tt> : int</dt>
<dd>Need output the cross attention MatMul(Q, K)</dd>
<dt><tt>past_present_share_buffer</tt> : int</dt>
<dd>Corresponding past and present are same tensor, its size is (batch_size, num_heads, max_sequence_length, head_size)</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
</dl>

#### Inputs (1 - 11)

<dl>
<dt><tt>query</tt> : T</dt>
<dd>Query with shape (batch_size, 1, hidden_size) or packed QKV with shape (batch_size, 1, 2 * hidden_size + v_hidden_size)</dd>
<dt><tt>key</tt> (optional) : T</dt>
<dd>Key with shape (batch_size, 1, hidden_size) for self attention or past_key with shape (batch_size, num_heads, kv_sequence_length, head_size) for cross attention</dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>Value with shape (batch_size, 1, v_hidden_size) for self attention or past_value with shape (batch_size, num_heads, kv_sequence_length, head_size) for cross attention</dd>
<dt><tt>mask_index</tt> (optional) : M</dt>
<dd>Mask values of shape (batch_size, total_sequence_length) or (batch_size, kv_sequence_length)</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>additional add to QxK' with shape (batch_size or 1, num_heads or 1, sequence_length, total_sequence_length)</dd>
<dt><tt>past_key</tt> (optional) : T</dt>
<dd>past state for key with shape (batch_size, num_heads, past_sequence_length, head_size) for self attentionWhen past_present_share_buffer is set, its shape is (batch_size, num_heads, max_sequence_length, head_size). The keys buffer is re-ordered in such a way that its virtual sub-tensor of shape (batch_size, num_heads, max_sequence_length, head_size) which may be perceived as being of shape (batch_size, num_heads, max_sequence_length, head_size / x, x) is reordered to become (batch_size, num_heads, head_size / x, max_sequence_length, x) where `x = 16 / sizeof(T)`.</dd>
<dt><tt>past_value</tt> (optional) : T</dt>
<dd>past state for value with shape (batch_size, num_heads, past_sequence_length, head_size) for self attentionWhen past_present_share_buffer is set, its shape is (batch_size, num_heads, max_sequence_length, head_size). </dd>
<dt><tt>past_sequence_length</tt> (optional) : M</dt>
<dd>When past_present_share_buffer is used, it is required to specify past_sequence_length (could be 0).Cross Attention doesn't need this input.</dd>
<dt><tt>beam_width</tt> (optional) : M</dt>
<dd>The beam width that is being used while decoding. If not provided, the beam width will be assumed to be 1.</dd>
<dt><tt>cache_indirection</tt> (optional) : M</dt>
<dd>A buffer of shape [batch_size, beam_width, max_output_length] where an `[i, j, k]` entry specifies which beam the `k`-th token came from for the `j`-th beam for batch `i` in the current iteration</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>Bias tensor with shape (hidden_size + hidden_size + v_hidden_size) from input projection</dd>
</dl>

#### Outputs (1 - 4)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, v_hidden_size)</dd>
<dt><tt>present_key</tt> (optional) : T</dt>
<dd>present state for key with shape (batch_size, num_heads, total_sequence_length, head_size). If past_present_share_buffer is set, its shape is (batch_size, num_heads, max_sequence_length, head_size), while effective_seq_length = (past_sequence_length + kv_sequence_length).</dd>
<dt><tt>present_value</tt> (optional) : T</dt>
<dd>present state for value with shape (batch_size, num_heads, total_sequence_length, head_size). If past_present_share_buffer is set, its shape is (batch_size, num_heads, max_sequence_length, head_size), while effective_seq_length = (past_sequence_length + kv_sequence_length).</dd>
<dt><tt>qk</tt> (optional) : QK</dt>
<dd>normalized Q * K, of shape (batch_size, num_heads, 1, total_sequence_length). </dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>QK</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain QK output to float32 or float16 tensors, independent of input type or output type.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask index to integer types</dd>
</dl>


### <a name="com.microsoft.DecoderMaskedSelfAttention"></a><a name="com.microsoft.decodermaskedselfattention">**com.microsoft.DecoderMaskedSelfAttention**</a>

  Self attention that supports input sequence length of 1.
  
  The weights for input projection of Q, K and V are merged. The data is stacked on the second dimension. Its shape
  is (input_hidden_size, hidden_size + hidden_size + v_hidden_size). Here hidden_size is the hidden dimension of Q and K,
  and v_hidden_size is that of V.
  
  The mask_index is optional. If it is provided, only raw attention mask with shape (batch_size, total_sequence_length) is supported currently.
  
  Both past and present state need to be provided.
  
  The qkv_hidden_sizes is required only when K and V have different hidden sizes.
  
  The total_sequence_length is past_sequence_length + kv_sequence_length. Here kv_sequence_length is the length of K or V.
  Currently, only self attention is supported which means that kv_sequence_length equals to sequence_length (sequence length of Q).

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>do_rotary</tt> : int</dt>
<dd>Whether to use rotary position embedding. Default value is 0.</dd>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>past_present_share_buffer</tt> : int</dt>
<dd>Corresponding past and present are same tensor, its size is (2, batch_size, num_heads, max_sequence_length, head_size)</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
</dl>

#### Inputs (7 - 9)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor with shape (batch_size, 1, input_hidden_size)</dd>
<dt><tt>weights</tt> : T</dt>
<dd>Merged Q/K/V weights with shape (input_hidden_size, hidden_size + hidden_size + v_hidden_size)</dd>
<dt><tt>bias</tt> : T</dt>
<dd>Bias tensor with shape (hidden_size + hidden_size + v_hidden_size) for input projection</dd>
<dt><tt>mask_index</tt> (optional) : M</dt>
<dd>Mask values of shape (batch_size, total_sequence_length)</dd>
<dt><tt>past</tt> : T</dt>
<dd>past state for key and value with shape (2, batch_size, num_heads, past_sequence_length, head_size)When past_present_share_buffer is set, its shape is (2, batch_size, num_heads, max_sequence_length, head_size). The first `batch_size * num_heads * max_sequence_length * head_size` elements correspond to keys and the next `batch_size * num_heads * max_sequence_length * head_size` elements correspond to values. The keys buffer is re-ordered in such a way that its virtual sub-tensor of shape (batch_size, num_heads, max_sequence_length, head_size) which may be perceived as being of shape (batch_size, num_heads, max_sequence_length, head_size / x, x) is reordered to become (batch_size, num_heads, head_size / x, max_sequence_length, x) where `x = 16 / sizeof(T)`.</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>additional add to QxK' with shape (batch_size or 1, num_heads or 1, sequence_length, total_sequence_length)</dd>
<dt><tt>past_sequence_length</tt> : M</dt>
<dd>When past_present_share_buffer is used, it is required to specify past_sequence_length (could be 0).</dd>
<dt><tt>beam_width</tt> (optional) : M</dt>
<dd>The beam width that is being used while decoding. If not provided, the beam width will be assumed to be 1.</dd>
<dt><tt>cache_indirection</tt> (optional) : M</dt>
<dd>A buffer of shape [batch_size, beam_width, max_output_length] where an `[i, j, k]` entry specifies which beam the `k`-th token came from for the `j`-th beam for batch `i` in the current iteration</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, v_hidden_size)</dd>
<dt><tt>present</tt> : T</dt>
<dd>past state for key and value with shape (2, batch_size, num_heads, total_sequence_length, head_size). If past_present_share_buffer is set, its shape is (2, batch_size, num_heads, max_sequence_length, head_size), while effective_seq_length = (past_sequence_length + kv_sequence_length).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask index to integer types</dd>
</dl>


### <a name="com.microsoft.DequantizeBFP"></a><a name="com.microsoft.dequantizebfp">**com.microsoft.DequantizeBFP**</a>

  The BFP dequantization operator.
  It consumes the raw BFP data and some metadata such as the shape and strides of the original tensor and computes the dequantized tensor.
  More documentation on the BFP format can be found in this paper: https://www.microsoft.com/en-us/research/publication/pushing-the-limits-of-narrow-precision-inferencing-at-cloud-scale-with-microsoft-floating-point/

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>bfp_type</tt> : int (required)</dt>
<dd>The type of BFP - must match with the BFPType enum</dd>
<dt><tt>block_dim</tt> : int</dt>
<dd>Each bounding box spans this dimension.Typically, the block dimension corresponds to the reduction dimension of the matrix multipication that consumes the output of this operator.For example, for a 2D matrix multiplication A@W, QuantizeBFP(A) would use block_dim 1 and QuantizeBFP(W) would use block_dim 0.The default is the last dimension.</dd>
<dt><tt>dtype</tt> : int</dt>
<dd>The datatype to dequantize to.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>1-D, contiguous, raw, BFP data to be de-quantized.</dd>
<dt><tt>shape</tt> : T2</dt>
<dd>shape of the original tensor.</dd>
<dt><tt>strides</tt> : T2</dt>
<dd>strides of the original tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T3</dt>
<dd>de-quantized tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8)</dt>
<dd>Constrain the input to uint8.</dd>
<dt><tt>T2</tt> : tensor(int64)</dt>
<dd>Constrain shape and strides to uint64.</dd>
<dt><tt>T3</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain y to float and bfloat16.</dd>
</dl>


### <a name="com.microsoft.DequantizeLinear"></a><a name="com.microsoft.dequantizelinear">**com.microsoft.DequantizeLinear**</a>

  The linear dequantization operator. It consumes a quantized data, a scale, a zero point and computes the full precision data.
  The dequantization formula is y = (x - x_zero_point) * x_scale.
  Scale and zero point must have same shape. They must be either scalar (per tensor) or 1-D tensor (per 'axis').

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>The axis along which same quantization parameters are applied. It's optional.If it's not specified, it means per-tensor quantization and input 'x_scale' and 'x_zero_point' must be scalars.If it's specified, it means per 'axis' quantization and input 'x_scale' and 'x_zero_point' must be 1-D tensors.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>N-D quantized Input tensor to be de-quantized.</dd>
<dt><tt>x_scale</tt> : T2</dt>
<dd>Scale for input 'x'. It can be a scalar, which means a per-tensor/layer dequantization, or a 1-D tensor for per-axis dequantization.</dd>
<dt><tt>x_zero_point</tt> (optional) : T1</dt>
<dd>Zero point for input 'x'. Shape must match x_scale. It's optional. Zero point is 0 when it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T2</dt>
<dd>N-D full precision output tensor. It has same shape as input 'x'.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8), tensor(int16), tensor(uint16), tensor(int32), tensor(int4), tensor(uint4)</dt>
<dd>Constrain 'x' and 'x_zero_point' to 8-bit integer tensors, 16-bit integer tensors, or 32-bit signed integer tensors.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain 'y', 'x_scale' to float tensors.</dd>
</dl>


### <a name="com.microsoft.DequantizeWithOrder"></a><a name="com.microsoft.dequantizewithorder">**com.microsoft.DequantizeWithOrder**</a>

  Dequantize input matrix to specific layout used in cublaslt. attr to specify output type, float16 or float32

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>order_input</tt> : int (required)</dt>
<dd>cublasLt order of input matrix. See the schema of QuantizeWithOrder for order definition.</dd>
<dt><tt>order_output</tt> : int (required)</dt>
<dd>cublasLt order of output matrix</dd>
<dt><tt>to</tt> : int (required)</dt>
<dd>The output data type, only support TensorProto_DataType_FLOAT (1) and TensorProto_DataType_FLOAT16 (10)</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : Q</dt>
<dd>TODO: input tensor of (ROWS, COLS). if less than 2d, will broadcast to (1, X). If 3d, it is treated as (B, ROWS, COS)</dd>
<dt><tt>scale_input</tt> : S</dt>
<dd>scale of the input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : F</dt>
<dd>output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>F</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain to float types</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>Constrain Scale to float32 types</dd>
</dl>


### <a name="com.microsoft.DynamicQuantizeLSTM"></a><a name="com.microsoft.dynamicquantizelstm">**com.microsoft.DynamicQuantizeLSTM**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.For example with LeakyRelu, the default alpha is 0.01.</dd>
<dt><tt>activation_beta</tt> : list of floats</dt>
<dd>Optional scaling values used by some activation functions. The values are consumed in the order of activation functions, for example (f, g, h) in LSTM. Default values are the same as of corresponding ONNX operators.</dd>
<dt><tt>activations</tt> : list of strings</dt>
<dd>A list of 3 (or 6 if bidirectional) activation functions for input, output, forget, cell, and hidden. The activation functions must be one of the activation functions specified above. Optional: See the equations for default if not specified.</dd>
<dt><tt>clip</tt> : float</dt>
<dd>Cell clip threshold. Clipping bounds the elements of a tensor in the range of [-threshold, +threshold] and is applied to the input of activations. No clip if not specified.</dd>
<dt><tt>direction</tt> : string</dt>
<dd>Specify if the RNN is forward, reverse, or bidirectional. Must be one of forward (default), reverse, or bidirectional.</dd>
<dt><tt>hidden_size</tt> : int</dt>
<dd>Number of neurons in the hidden layer</dd>
<dt><tt>input_forget</tt> : int</dt>
<dd>Couple the input and forget gates if 1.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input sequences packed (and potentially padded) into one 3-D tensor with the shape of `[seq_length, batch_size, input_size]`.</dd>
<dt><tt>W</tt> : T2</dt>
<dd>The weight tensor for the gates. Concatenation of `W[iofc]` and `WB[iofc]` (if bidirectional) along dimension 0. The tensor has shape `[num_directions, input_size, 4*hidden_size]`.</dd>
<dt><tt>R</tt> : T2</dt>
<dd>The recurrence weight tensor. Concatenation of `R[iofc]` and `RB[iofc]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, hidden_size, 4*hidden_size]`.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>The bias tensor for input gate. Concatenation of `[Wb[iofc], Rb[iofc]]`, and `[WBb[iofc], RBb[iofc]]` (if bidirectional) along dimension 0. This tensor has shape `[num_directions, 8*hidden_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>sequence_lens</tt> (optional) : T1</dt>
<dd>Optional tensor specifying lengths of the sequences in a batch. If not specified - assumed all sequences in the batch to have length `seq_length`. It has shape `[batch_size]`.</dd>
<dt><tt>initial_h</tt> (optional) : T</dt>
<dd>Optional initial value of the hidden. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>initial_c</tt> (optional) : T</dt>
<dd>Optional initial value of the cell. If not specified - assumed to be 0. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>P</tt> (optional) : T</dt>
<dd>The weight tensor for peepholes. Concatenation of `P[iof]` and `PB[iof]` (if bidirectional) along dimension 0. It has shape `[num_directions, 3*hidde_size]`. Optional: If not specified - assumed to be 0.</dd>
<dt><tt>W_scale</tt> : T</dt>
<dd>W's scale. Its size is [num_directions] for per-tensor/layer quantization, or [num_directions, 4*hidden_size] for per-channel quantization on the axis input_size.</dd>
<dt><tt>W_zero_point</tt> : T2</dt>
<dd>W's zero point. Its size is [num_directions] for per-tensor/layer quantization, or [num_directions, 4*hidden_size] for per-channel quantization on the axis input_size.</dd>
<dt><tt>R_scale</tt> : T</dt>
<dd>R's scale. Its size is [num_directions] for per-tensor/layer quantization, or [num_directions, 4*hidden_size] for per-channel quantization on the axis input_size.</dd>
<dt><tt>R_zero_point</tt> : T2</dt>
<dd>R's zero point. Its size is [num_directions] for per-tensor/layer quantization, or [num_directions, 4*hidden_size] for per-channel quantization on the axis input_size.</dd>
</dl>

#### Outputs (0 - 3)

<dl>
<dt><tt>Y</tt> (optional) : T</dt>
<dd>A tensor that concats all the intermediate output values of the hidden. It has shape `[seq_length, num_directions, batch_size, hidden_size]`. </dd>
<dt><tt>Y_h</tt> (optional) : T</dt>
<dd>The last output value of the hidden. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
<dt><tt>Y_c</tt> (optional) : T</dt>
<dd>The last output value of the cell. It has shape `[num_directions, batch_size, hidden_size]`.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain seq_lens to integer tensor.</dd>
<dt><tt>T2</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain weights types to 8 bit tensors.</dd>
</dl>


### <a name="com.microsoft.DynamicQuantizeMatMul"></a><a name="com.microsoft.dynamicquantizematmul">**com.microsoft.DynamicQuantizeMatMul**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (3 - 5)

<dl>
<dt><tt>A</tt> : T1</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T2</dt>
<dd>N-dimensional matrix B</dd>
<dt><tt>b_scale</tt> : T1</dt>
<dd>Scale of quantized input 'B'. It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'B'.</dd>
<dt><tt>b_zero_point</tt> (optional) : T2</dt>
<dd>Zero point tensor for input 'B'. It's optional and default value is 0.  It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'B'.</dd>
<dt><tt>bias</tt> (optional) : T1</dt>
<dd>1D input tensor, whose dimension is same as B's last dimension</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float)</dt>
<dd>Constrain input A, b_scale and output Y data type as float tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input B data type to 8-bit integer tensor.</dd>
</dl>


### <a name="com.microsoft.DynamicTimeWarping"></a><a name="com.microsoft.dynamictimewarping">**com.microsoft.DynamicTimeWarping**</a>

  Input is cost matrix where each value in input[r][c] is the cost for pass the point (r, c). From current point(r, c),  points (r+1, c), (r+1, c+1) or (r, c+1) could be arrived in next move. Given such cost matrix, return dynamic time warping of shape [2, x], where the path made by all points (output[0][t], output[1][t])have the lowest cost among all paths from (0, 0) to (M-1, N-1).

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : F</dt>
<dd>Input cost tensor, it must be 2D tensor of shape M x N, or 1 x M x N</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : I</dt>
<dd>Output tensor. shape is [2, x], where max(M, N) <= x < M + N</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>F</tt> : tensor(float)</dt>
<dd>Constrain to float tensors.</dd>
<dt><tt>I</tt> : tensor(int32)</dt>
<dd>Constrain to integer types.</dd>
</dl>


### <a name="com.microsoft.EPContext"></a><a name="com.microsoft.epcontext">**com.microsoft.EPContext**</a>

  Onnx node container for EP context.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>embed_mode</tt> : int</dt>
<dd>1: indicate ep_cache_context is the context content. 0: indicate ep_cache_context is the file path to the context content.The path is relative to this Onnx file. Default is 1.</dd>
<dt><tt>ep_cache_context</tt> : string</dt>
<dd>payload of the execution provider context if embed_mode=1, or path to the context file if embed_mode=0.</dd>
<dt><tt>ep_sdk_version</tt> : string</dt>
<dd>(Optional) SDK version used to convert the model.</dd>
<dt><tt>hardware_architecture</tt> : string</dt>
<dd>(Optional) Hardware architecture.</dd>
<dt><tt>main_context</tt> : int</dt>
<dd>Usually each single EPContext associate with a graph partition.But for some case like QNN, it has single EPContext contains all partitions.In that case, the node with ep_cache_context should set main_context=1. Other nodes set main_context=0 and skip ep_cache_context.The path is relative to this Onnx file. Default is 1.</dd>
<dt><tt>max_size</tt> : int</dt>
<dd>max size in the context. Usage depend on the EP.</dd>
<dt><tt>notes</tt> : string</dt>
<dd>(Optional) Some notes for the model</dd>
<dt><tt>onnx_model_filename</tt> : string</dt>
<dd>(Optional) Filename of the original ONNX model.</dd>
<dt><tt>partition_name</tt> : string</dt>
<dd>(Optional) partitioned graph name.</dd>
<dt><tt>source</tt> : string</dt>
<dd>(Optional) the source used to generate the engine/context cache file. Ort EP or native SDK tool chain</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic, heterogeneous) : T</dt>
<dd>List of tensors for inputs</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic, heterogeneous) : T</dt>
<dd>One or more outputs, list of tensors for outputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(bool), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types.</dd>
</dl>


### <a name="com.microsoft.EmbedLayerNormalization"></a><a name="com.microsoft.embedlayernormalization">**com.microsoft.EmbedLayerNormalization**</a>

  EmbedLayerNormalization is the fusion of embedding layer in BERT model, with optional mask processing.
  The embedding layer takes input_ids (word IDs) and segment_ids (sentence IDs) to look up word_embedding, position_embedding,
  and segment_emedding; the embeddings are added then applied layer normalization using gamma and beta tensors.
  The last input mask is optional. If mask is provided, mask index (that is position of first 0 in mask, or number of words)
  will be calculated.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>mask_index_type</tt> : int</dt>
<dd>The mask index tensor type for shape inference (0: None, 1: 1D mask_index)</dd>
</dl>

#### Inputs (7 - 9)

<dl>
<dt><tt>input_ids</tt> : T1</dt>
<dd>2D words IDs with shape (batch_size, sequence_length)</dd>
<dt><tt>segment_ids</tt> (optional) : T1</dt>
<dd>2D segment IDs with shape (batch_size, sequence_length)</dd>
<dt><tt>word_embedding</tt> : T</dt>
<dd>2D with shape (,hidden_size)</dd>
<dt><tt>position_embedding</tt> : T</dt>
<dd>2D with shape (, hidden_size)</dd>
<dt><tt>segment_embedding</tt> (optional) : T</dt>
<dd>2D with shape (, hidden_size)</dd>
<dt><tt>gamma</tt> : T</dt>
<dd>1D gamma tensor for layer normalization with shape (hidden_size)</dd>
<dt><tt>beta</tt> : T</dt>
<dd>1D beta tensor for layer normalization  with shape (hidden_size)</dd>
<dt><tt>mask</tt> (optional) : T1</dt>
<dd>2D attention mask with shape (batch_size, sequence_length)</dd>
<dt><tt>position_ids</tt> (optional) : T1</dt>
<dd>2D position ids with shape (batch_size, sequence_length) or (1, sequence_length)</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>mask_index</tt> (optional) : T1</dt>
<dd>1D mask_index tensor with shape (batch_size)</dd>
<dt><tt>embedding_sum</tt> (optional) : T</dt>
<dd>sum of word_embedding and position_embedding without layer normalization</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain input and output integer tensors types</dd>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output float tensors types.</dd>
</dl>


### <a name="com.microsoft.ExpandDims"></a><a name="com.microsoft.expanddims">**com.microsoft.ExpandDims**</a>

  ExpandDims echo operator.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input</dd>
<dt><tt>axis</tt> : tensor(int32)</dt>
<dd>Specified axis to insert a dimension</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain to any tensor type. If the dtype attribute is not provided this must be a valid output type.</dd>
</dl>


### <a name="com.microsoft.FastGelu"></a><a name="com.microsoft.fastgelu">**com.microsoft.FastGelu**</a>

  GELU (Gaussian Error Linear Unit) approximation: Y=0.5*X*(1+tanh(0.797885*X+0.035677*X*X*X)) with an optional input of bias that will be added to X before GELU.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (1 - 2)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input tensor</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>bias tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
</dl>


### <a name="com.microsoft.FusedConv"></a><a name="com.microsoft.fusedconv">**com.microsoft.FusedConv**</a>

  The fused convolution operator schema is the same as Conv besides it includes an attribute
  activation.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : string</dt>
<dd></dd>
<dt><tt>activation_params</tt> : list of floats</dt>
<dd></dd>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd></dd>
<dt><tt>group</tt> : int</dt>
<dd></dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd></dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs (2 - 4)

<dl>
<dt><tt>X</tt> : T</dt>
<dd></dd>
<dt><tt>W</tt> : T</dt>
<dd></dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd></dd>
<dt><tt>Z</tt> (optional) : T</dt>
<dd></dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd></dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors</dd>
</dl>


### <a name="com.microsoft.FusedGemm"></a><a name="com.microsoft.fusedgemm">**com.microsoft.FusedGemm**</a>

  The FusedGemm operator schema is the same as Gemm besides it includes attributes
  activation and leaky_relu_alpha.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : string</dt>
<dd></dd>
<dt><tt>activation_alpha</tt> : float</dt>
<dd></dd>
<dt><tt>activation_beta</tt> : float</dt>
<dd></dd>
<dt><tt>activation_gamma</tt> : float</dt>
<dd></dd>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>beta</tt> : float</dt>
<dd>Scalar multiplier for input tensor C.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>A</tt> : T</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>C</tt> (optional) : T</dt>
<dd>Input tensor C. The shape of C should be unidirectional broadcastable to (M, N).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(uint32), tensor(uint64), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to float/int tensors.</dd>
</dl>


### <a name="com.microsoft.FusedMatMul"></a><a name="com.microsoft.fusedmatmul">**com.microsoft.FusedMatMul**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of the input tensors.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed on the last two dimensions before doing multiplication</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed on the last two dimensions before doing multiplication</dd>
<dt><tt>transBatchA</tt> : int</dt>
<dd>Whether A should be transposed on the 1st dimension and batch dimensions (dim-1 to dim-rank-2) before doing multiplication</dd>
<dt><tt>transBatchB</tt> : int</dt>
<dd>Whether B should be transposed on the 1st dimension and batch dimensions (dim-1 to dim-rank-2) before doing multiplication</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Matrix multiply results</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.FusedMatMulActivation"></a><a name="com.microsoft.fusedmatmulactivation">**com.microsoft.FusedMatMulActivation**</a>

  Executes the same operation as FusedMatMul, but also has an activation function fused to its output.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : string (required)</dt>
<dd></dd>
<dt><tt>activation_alpha</tt> : float</dt>
<dd></dd>
<dt><tt>activation_axis</tt> : int</dt>
<dd></dd>
<dt><tt>activation_beta</tt> : float</dt>
<dd></dd>
<dt><tt>activation_gamma</tt> : float</dt>
<dd></dd>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of the input tensors.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed on the last two dimensions before doing multiplication</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed on the last two dimensions before doing multiplication</dd>
<dt><tt>transBatchA</tt> : int</dt>
<dd>Whether A should be transposed on the 1st dimension and batch dimensions (dim-1 to dim-rank-2) before doing multiplication</dd>
<dt><tt>transBatchB</tt> : int</dt>
<dd>Whether B should be transposed on the 1st dimension and batch dimensions (dim-1 to dim-rank-2) before doing multiplication</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Matrix multiply results</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.GatedRelativePositionBias"></a><a name="com.microsoft.gatedrelativepositionbias">**com.microsoft.GatedRelativePositionBias**</a>

  query_layer = (query_layer + query_bias).reshape(batch_size, seq_len, num_heads, head_size).transpose(1, 2)
    gate_u, gate_r = torch.sigmoid(
        self.gate_ur_linear(query_layer).view(batch_size, num_head, seq_len, 2, D/2).sum(-1, keepdim=False)
    ).chunk(2, dim=-1)
    gate_u_1 = gate_u * (gate_r * self.eco_a - 1.0) + 2.0
    rel_pos_bias = gate_u_1 * rel_pos

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
</dl>

#### Inputs (6 - 7)

<dl>
<dt><tt>query_layer</tt> : T</dt>
<dd>tensor with shape (batch_size, seq_len, num_heads x head_size) or (token_count, num_heads x head_size)</dd>
<dt><tt>query_bias</tt> : T</dt>
<dd>1-d tensor with shape (num_heads x head_size)</dd>
<dt><tt>rel_pos</tt> : T</dt>
<dd>tensor with shape (1, num_head, seq_len, seq_len)</dd>
<dt><tt>weight</tt> : T</dt>
<dd>gemm weight for the gated_ur_linear, shape (head_size, D), D is divisible by 2</dd>
<dt><tt>bias</tt> : T</dt>
<dd>bias for the gated_ur_linear, shape (D)</dd>
<dt><tt>eco_a</tt> : T</dt>
<dd>tensor of shape (1, num_heads, 1, 1)</dd>
<dt><tt>token_offset</tt> (optional) : M</dt>
<dd>offset of each token with shape (batch_size, seq_len)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>output tensor with shape (batch_size, num_heads, seq_len, seq_len)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain token_offset to integer types</dd>
</dl>


### <a name="com.microsoft.GatherBlockQuantized"></a><a name="com.microsoft.gatherblockquantized">**com.microsoft.GatherBlockQuantized**</a>

  GatherBlockQuantized is a Gather with data quantized. It is similar to Gather (https://github.com/onnx/onnx/blob/main/docs/Operators.md#gather) with differences:
    1. Input `data` is a constant. It is quantized block-wise along attribute `quantize_axis` with block size specified by attribute `block_size`.
       `block_size` must be a power of 2 and not smaller than 16, like 16, 32, 64, 128, ...
    2. Input `data`'s scale and zero point are specified by input `scales` and `zero_points`. `scales` and `zero_points` are also constants.
       If `zero_points` is not provided, the default value is 0 for int4/uint4, or 2^(bits-1) for uint8.
    3. During the op execution, `data` and `indices` are first used to generate the quantized output. Then, `scales` and `zero_points` are used
       to dequantize the output.
    4. The `output` and `scales` have the same type. The `data` and `zero_points` have the same type.
    5. For uint8 data, the `gather_axis` must be 0.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>bits</tt> : int</dt>
<dd>Number of bits used for weight quantization. Must be either 4 or 8. </dd>
<dt><tt>block_size</tt> : int</dt>
<dd>(Optional) block size used for weight quantization. It needs to be a power of 2 and not smaller than 16.</dd>
<dt><tt>gather_axis</tt> : int</dt>
<dd>(Optional) Which axis to gather on. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
<dt><tt>quantize_axis</tt> : int</dt>
<dd>(Optional) Which axis to block-wise quantize. Negative value means counting dimensions from the back. Accepted range is [-r, r-1] where r = rank(data).</dd>
</dl>

#### Inputs (3 - 4)

<dl>
<dt><tt>data</tt> : T1</dt>
<dd>Tensor of rank r >= 1. Block-wise quantized.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of int32/int64 indices, of any rank q. All index values are expected to be within bounds [-s, s-1] along axis of size s. It is an error if any of the index values are out of bounds.</dd>
<dt><tt>scales</tt> : T2</dt>
<dd>quantization scale</dd>
<dt><tt>zero_points</tt> (optional) : T1</dt>
<dd>quantization zero points</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T2</dt>
<dd>Dequantized output tensor of rank q + (r - 1).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int4), tensor(uint4), tensor(uint8)</dt>
<dd>Constrain quantized types.</dd>
<dt><tt>T2</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain dequantized types.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indices to integer types.</dd>
</dl>


### <a name="com.microsoft.GatherND"></a><a name="com.microsoft.gathernd">**com.microsoft.GatherND**</a>

  Given `data` tensor of rank r >= 1, and `indices` tensor of rank q >= 1, gather
  slices of `data` into an output tensor of rank q - 1 + r - indices[-1].
  Example 1:
    data    = [[0,1],[2,3]]
    indices = [[0,0],[1,1]]
    output  = [0,3]
  Example 2:
    data    = [[0,1],[2,3]]
    indices = [[1],[0]]
    output  = [[2,3],[0,1]]
  Example 3:
    data    = [[[0,1],[2,3]],[[4,5],[6,7]]]
    indices = [[0,1],[1,0]]
    output  = [[2,3],[4,5]]
  Example 4:
    data    = [[[0,1],[2,3]],[[4,5],[6,7]]]
    indices = [[[0,1]],[[1,0]]]
    output  = [[[2,3]],[[4,5]]]

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Tensor of rank r >= 1.</dd>
<dt><tt>indices</tt> : Tind</dt>
<dd>Tensor of rank q >= 1.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor of rank q-1+r-indices[-1].</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input and output types to any tensor type.</dd>
<dt><tt>Tind</tt> : tensor(int32), tensor(int64)</dt>
<dd>Constrain indice type to int32 or int64</dd>
</dl>


### <a name="com.microsoft.Gelu"></a><a name="com.microsoft.gelu">**com.microsoft.Gelu**</a>

  Gaussian Error Linear Unit.
  A high-performing neural network activation function.The GELU nonlinearity is
  the expected transformation of a stochastic regularizer which randomly applies
  the identity or zero map to a neuron's input. The GELU nonlinearity weights
  inputs by their magnitude, rather than gates inputs by their sign as in ReLUs.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.GemmFastGelu"></a><a name="com.microsoft.gemmfastgelu">**com.microsoft.GemmFastGelu**</a>

  It's a fusion of MatMul and FastGelu.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input tensor</dd>
<dt><tt>W</tt> : T</dt>
<dd>input tensor</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>bias tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
</dl>


### <a name="com.microsoft.GemmFloat8"></a><a name="com.microsoft.gemmfloat8">**com.microsoft.GemmFloat8**</a>

  Generic Gemm for float and float 8.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : string</dt>
<dd>Activation function, RELU or GELU or NONE (default).</dd>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>beta</tt> : float</dt>
<dd>Scalar multiplier for the product of input bias C.</dd>
<dt><tt>dtype</tt> : int</dt>
<dd>Output Type. Same definition as attribute 'to' for operator Cast.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed. Float 8 only supported transA=0.</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed. Float 8 only supported transB=1.</dd>
</dl>

#### Inputs (2 - 6)

<dl>
<dt><tt>A</tt> : TA</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>B</tt> : TB</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>C</tt> (optional) : TC</dt>
<dd>Input tensor C.</dd>
<dt><tt>scaleA</tt> (optional) : TS</dt>
<dd>Scale of tensor A if A is float 8 tensor</dd>
<dt><tt>scaleB</tt> (optional) : TS</dt>
<dd>Scale of tensor B if B is float 8 tensor</dd>
<dt><tt>scaleY</tt> (optional) : TS</dt>
<dd>Scale of the output tensor if A or B is float 8.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : TR</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>TA</tt> : tensor(float8e4m3fn), tensor(float8e5m2), tensor(float16), tensor(bfloat16), tensor(float)</dt>
<dd>Constrain type to input A.</dd>
<dt><tt>TB</tt> : tensor(float8e4m3fn), tensor(float8e5m2), tensor(float16), tensor(bfloat16), tensor(float)</dt>
<dd>Constrain type to input B.</dd>
<dt><tt>TC</tt> : tensor(float16), tensor(bfloat16), tensor(float)</dt>
<dd>Constrain type to input C.</dd>
<dt><tt>TR</tt> : tensor(float8e4m3fn), tensor(float8e5m2), tensor(float16), tensor(bfloat16), tensor(float)</dt>
<dd>Constrain type to result type.</dd>
<dt><tt>TS</tt> : tensor(float)</dt>
<dd>Constrain type for all input scales (scaleA, scaleB, scaleY).</dd>
</dl>


### <a name="com.microsoft.GemmaRotaryEmbedding"></a><a name="com.microsoft.gemmarotaryembedding">**com.microsoft.GemmaRotaryEmbedding**</a>

  GemmaRotaryEmbedding is the implementation of below part of rotary positional embeddings (RoPE). It implements below from modeling_gemma.py.
  
  Here's onnxscript that was tested
  
  from onnxscript import FLOAT, FLOAT16, script
  from onnxscript import opset18 as op
  
  @script()
  def gemma_rotary_embedding(emb: FLOAT["bs", "seq_len", "dim"], q: FLOAT16["bs", "num_heads", "seq_len", "dim"], q_rot: FLOAT16["bs", "num_heads", "seq_len", "dim"], k: FLOAT16["bs", "num_heads", "seq_len", "dim"], k_rot: FLOAT16["bs", "num_heads", "seq_len", "dim"]):
    sin_val = op.Sin(emb)
    casted_sin = op.Cast(sin_val, to=10) # for fp16 mix-precision training. Other types are not supported.
    cos_val = op.Cos(emb)
    casted_cos = op.Cast(cos_val, to=10)
    unsqueezed_sin = op.Unsqueeze(casted_sin, [1])
    unsqueezed_cos = op.Unsqueeze(casted_cos, [1])
    q_embed = (q * casted_cos) + (q_rot * casted_sin)
    k_embed = (k * casted_cos) + (k_rot * casted_sin)
    return q_embed, k_embed
  
  onnx_model = gemma_rotary_embedding.to_model_proto()
  
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>emb</tt> : U</dt>
<dd>embedding - 3D tensor with shape (batch_size, seq_len, dim)</dd>
<dt><tt>q</tt> : T</dt>
<dd>q state - 4D tensor with shape (batch_size, num_heads, seq_len, dim)</dd>
<dt><tt>q_rot</tt> : T</dt>
<dd>half rotated q state - 4D tensor with shape (batch_size, num_heads, seq_len, dim)</dd>
<dt><tt>k</tt> : T</dt>
<dd>k state - 4D tensor with shape (batch_size, num_heads, seq_len, dim)</dd>
<dt><tt>k_rot</tt> : T</dt>
<dd>k state - 4D tensor with shape (batch_size, num_heads, seq_len, dim)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output1</tt> : T</dt>
<dd>4D tensor with shape (batch_size, num_heads, seq_len, dim)</dd>
<dt><tt>output2</tt> : T</dt>
<dd>4D tensor with shape (batch_size, num_heads, seq_len, dim)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16)</dt>
<dd>Constrain input and output types to float16 tensors.</dd>
<dt><tt>U</tt> : tensor(float)</dt>
<dd>Constrain input 0 type to float tensors</dd>
</dl>


### <a name="com.microsoft.GreedySearch"></a><a name="com.microsoft.greedysearch">**com.microsoft.GreedySearch**</a>

  Greedy Search for text generation.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>decoder</tt> : graph (required)</dt>
<dd>Decoder subgraph to execute in a loop.</dd>
<dt><tt>decoder_start_token_id</tt> : int</dt>
<dd>The id of the token that indicates decoding starts.</dd>
<dt><tt>encoder</tt> : graph</dt>
<dd>The subgraph for initialization of encoder and decoder. It will be called once before `decoder` subgraph.</dd>
<dt><tt>eos_token_id</tt> : int (required)</dt>
<dd>The id of the end-of-sequence token</dd>
<dt><tt>init_decoder</tt> : graph</dt>
<dd>The subgraph for the first decoding run. It will be called once before `decoder` subgraph. This is relevant only for the GPT2 model. If this attribute is missing, the `decoder` subgraph will be used for all decoding runs</dd>
<dt><tt>model_type</tt> : int</dt>
<dd>model type: 0 for decoder only like GPT-2; 1 for encoder decoder like Bart</dd>
<dt><tt>no_repeat_ngram_size</tt> : int</dt>
<dd>no repeat ngrams size</dd>
<dt><tt>pad_token_id</tt> : int (required)</dt>
<dd>The id of the padding token</dd>
<dt><tt>vocab_size</tt> : int</dt>
<dd>Size of the vocabulary. If not provided, it will be inferred from the decoder subgraph's output shape</dd>
</dl>

#### Inputs (2 - 7)

<dl>
<dt><tt>input_ids</tt> : I</dt>
<dd>The sequence used as a prompt for the generation. Shape is (batch_size, sequence_length)</dd>
<dt><tt>max_length</tt> : I</dt>
<dd>The maximum length of the sequence to be generated. Shape is (1)</dd>
<dt><tt>min_length</tt> (optional) : I</dt>
<dd>The minimum length below which the score of eos_token_id is set to -Inf. Shape is (1)</dd>
<dt><tt>repetition_penalty</tt> (optional) : T</dt>
<dd>The parameter for repetition penalty. Default value 1.0 means no penalty. Accepts value > 0.0. Shape is (1)</dd>
<dt><tt>vocab_mask</tt> (optional) : I</dt>
<dd>Mask of vocabulary. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (vocab_size)</dd>
<dt><tt>prefix_vocab_mask</tt> (optional) : I</dt>
<dd>Mask of vocabulary for first step. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (batch_size, vocab_size)</dd>
<dt><tt>attention_mask</tt> (optional) : I</dt>
<dd>Custom attention mask. Shape is (batch_size, sequence_length)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>sequences</tt> : I</dt>
<dd>Word IDs of generated sequences. Shape is (batch_size, max_sequence_length)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
</dl>


### <a name="com.microsoft.GridSample"></a><a name="com.microsoft.gridsample">**com.microsoft.GridSample**</a>

  Given an `input` and a flow-field `grid`, computes the `output` using `input` values and pixel locations from `grid`.
        Currently, only spatial (4-D) inputs are supported. For `input` with shape (N, C, H, W) and `grid` with shape (N, H_out, W_out, 2),
        the `output` will have shape (N, C, H_out, W_out).
        For each output location `output[n, :, h, w]`, the size-2 vector `grid[n, h, w]` specifies `input` pixel locations `x` and `y`,
        which are used to interpolate the output value `output[n, :, h, w]`.
        The GridSample operator is often used in doing grid generator and sampler in the [Spatial Transformer Networks](https://arxiv.org/abs/1506.02025).
        See also in [torch.nn.functional.grid_sample](https://pytorch.org/docs/master/generated/torch.nn.functional.grid_sample.html#torch-nn-functional-grid-sample).
        

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>align_corners</tt> : int</dt>
<dd>If align_corners=1, the extrema (-1 and 1) are considered as referring to the center points of the input's corner pixels. If align_corners=0, they are instead considered as referring to the corner points of the input's corner pixels, making the sampling more resolution agnostic.</dd>
<dt><tt>mode</tt> : string</dt>
<dd>Three interpolation modes: bilinear (default), nearest and bicubic.</dd>
<dt><tt>padding_mode</tt> : string</dt>
<dd>Support padding modes for outside grid values: `zeros`(default), `border`, `reflection`. zeros: use 0 for out-of-bound grid locations, border: use border values for out-of-bound grid locations, reflection: use values at locations reflected by the border for out-of-bound grid locations.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>4-D tensor of shape (N, C, H, W), where N is the batch size, C is the numbers of channels, H and W are the height and width of the input data.</dd>
<dt><tt>Grid</tt> : T1</dt>
<dd>Input offset, 4-D tensor of shape (N, H_out, W_out, 2), where H_out and W_out are the height and width of grid and output, Grid specifies the sampling pixel locations normalized by the input spatial dimensions. Therefore, it should have most values in the range of [-1, 1]. If grid has values outside the range of [-1, 1], the corresponding outputs will be handled as defined by padding_mode.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>4-D tensor of shape (N, C, H_out, W_out).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Constrain input types to all tensor types.</dd>
<dt><tt>T2</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.GroupNorm"></a><a name="com.microsoft.groupnorm">**com.microsoft.GroupNorm**</a>

  Applies Group Normalization over a mini-batch of inputs as described in the paper Group Normalization (https://arxiv.org/abs/1803.08494).
  
  This operator transforms input according to
    y = gamma * (x - mean) / sqrt(variance + epsilon) + beta
  
  The input channels are separated into num_groups groups, each containing num_channels / num_groups channels. num_channels must be divisible by num_groups. The mean and standard-deviation are calculated separately over the each group.
  The weight and bias are per-channel affine transform parameter vectors of size num_channels.
  
  The activation attribute can be used to enable activation after group normalization.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : int (required)</dt>
<dd>Activation after group normalization: 0 for None, 1 for SiLU</dd>
<dt><tt>channels_last</tt> : int</dt>
<dd>1 if the input and output are in the NHWC layout, 0 if it is in the NCHW layout. Defaults to 1.</dd>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero</dd>
<dt><tt>groups</tt> : int (required)</dt>
<dd>The number of groups of channels. It should be a divisor of the number of channels C</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor. Dimensions are (N x H x W x C) when channels_last is 1 or (N x C x H x W) otherwise, where N is the batch size, C is the number of channels, and H and W are the height and width of the data</dd>
<dt><tt>gamma</tt> : M</dt>
<dd>1D gamma tensor for normalization with shape (C), where C is number of channels</dd>
<dt><tt>beta</tt> : M</dt>
<dd>1D beta tensor for normalization  with shape (C), where C is number of channels</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output tensor of the same shape as X</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain input X and output Y types to float tensors.</dd>
<dt><tt>M</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain gamma and beta to float tensors.</dd>
</dl>


### <a name="com.microsoft.GroupQueryAttention"></a><a name="com.microsoft.groupqueryattention">**com.microsoft.GroupQueryAttention**</a>

  Group Query Self/Cross Attention.
  
  *Highly recommend using k-v cache share buffer for both CPU and CUDA. Enabled through IOBinding past and present kv.
  Supports different number of heads for q and kv for CPU and CUDA.
  Only supports causal and local attention.
  Supports rotary position embedding for CPU and CUDA.
  Supports packed input for CPU and CUDA.
  Supports continuous decoding for batch_size == 1 for CPU and CUDA.
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>do_rotary</tt> : int</dt>
<dd>Whether to use rotary position embedding. Default value is 0.</dd>
<dt><tt>kv_num_heads</tt> : int (required)</dt>
<dd>Number of attention heads for k and v</dd>
<dt><tt>local_window_size</tt> : int</dt>
<dd>left_window_size for local attention (like Mistral). Default value is -1 meaning unused.</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads for q</dd>
<dt><tt>qk_output</tt> : int</dt>
<dd>Output values of QK matrix multiplication before (1) or after (2) softmax normalization. Default value is 0 (don't output).</dd>
<dt><tt>rotary_interleaved</tt> : int</dt>
<dd>Rotate using interleaved pattern. Default value is 0 (False).</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
<dt><tt>smooth_softmax</tt> : int</dt>
<dd>Use a smooth factor in softmax.</dd>
<dt><tt>softcap</tt> : float</dt>
<dd>Softcap value for attention weights. Default value is 0.</dd>
</dl>

#### Inputs (7 - 12)

<dl>
<dt><tt>query</tt> : T</dt>
<dd>Query with shape (batch_size, sequence_length, hidden_size), or packed QKV with shape(batch_size, sequence_length, d) where d is (num_heads * head_size + 2 * kv_num_heads * head_size).</dd>
<dt><tt>key</tt> (optional) : T</dt>
<dd>Key with shape (batch_size, kv_sequence_length, kv_hidden_size) </dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>Value with shape (batch_size, kv_sequence_length, kv_hidden_size)</dd>
<dt><tt>past_key</tt> (optional) : T</dt>
<dd>past state key with support for format BNSH. When past_key uses same tensor as present_key(k-v cache), it is of length max_sequence_length... otherwise of length past_sequence_length.</dd>
<dt><tt>past_value</tt> (optional) : T</dt>
<dd>past state value with support for format BNSH. When past_value uses same tensor as present_value(k-v cache), it is of length max_sequence_length... otherwise of length past_sequence_length.</dd>
<dt><tt>seqlens_k</tt> : M</dt>
<dd>1D Tensor of shape (batch_size). Equivalent to (total_sequence_lengths - 1).</dd>
<dt><tt>total_sequence_length</tt> : M</dt>
<dd>Scalar tensor equivalent to the maximum total sequence length (past + new) of the batch. Used for checking inputs and determining prompt vs token generation case.</dd>
<dt><tt>cos_cache</tt> (optional) : T</dt>
<dd>2D tensor with shape (max_sequence_length, head_size / 2).</dd>
<dt><tt>sin_cache</tt> (optional) : T</dt>
<dd>2D tensor with shape (max_sequence_length, head_size / 2).</dd>
<dt><tt>position_ids</tt> (optional) : tensor(int64)</dt>
<dd>2D tensor with shape (batch_size, sequence_length). When processing the first prompt the kernel uses only the first element</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>additional add to QxK' with shape (batch_size or 1, num_heads or 1, sequence_length, total_sequence_length)</dd>
<dt><tt>head_sink</tt> (optional) : T</dt>
<dd>1D tensor with shape (num_heads). Each head has a smooth factor adding to the denominator of softmax.</dd>
</dl>

#### Outputs (3 - 4)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>present_key</tt> : T</dt>
<dd>present state key with support for format BNSH. When past_key uses same tensor as present_key(k-v buffer), it is of length max_sequence_length... otherwise of length past_sequence_length +kv_sequence_length.</dd>
<dt><tt>present_value</tt> : T</dt>
<dd>present state value with support for format BNSH. When past_value uses same tensor as present_value(k-v buffer), it is of length max_sequence_length... otherwise of length past_sequence_length +kv_sequence_length.</dd>
<dt><tt>output_qk</tt> (optional) : T</dt>
<dd>Values of QK matrix multiplication, either before or after softmax normalization</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(bfloat16), tensor(float)</dt>
<dd>Constrain input and output to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask to int tensor.</dd>
</dl>


### <a name="com.microsoft.Inverse"></a><a name="com.microsoft.inverse">**com.microsoft.Inverse**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor. Every matrix in the batch must be invertible.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of the same type and shape as the input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.Irfft"></a><a name="com.microsoft.irfft">**com.microsoft.Irfft**</a>

  This function computes the inverse of the one-dimensional n-point RFFT computed in 'com.microsoft.rfft'.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>normalized</tt> : int</dt>
<dd>must be 0, normalization currently not supported</dd>
<dt><tt>onesided</tt> : int</dt>
<dd>must be 1, only one sided FFTs supported</dd>
<dt><tt>signal_ndim</tt> : int (required)</dt>
<dd>number of dimensions comprising the signal</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input tensor with size (n//2 + 1) in the signal dim and 2 in the last dimension for the real and complex parts</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>output tensor with size n in the signal dim</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(float16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
</dl>


### <a name="com.microsoft.LongformerAttention"></a><a name="com.microsoft.longformerattention">**com.microsoft.LongformerAttention**</a>

  Longformer Self Attention with a local context and a global context. Tokens attend locally: Each token
  attends to its W previous tokens and W succeeding tokens with W being the window length. A selected few tokens
  attend globally to all other tokens.
  
  The attention mask is of shape (batch_size, sequence_length), where sequence_length is a multiple of 2W after padding.
  Mask value < 0 (like -10000.0) means the token is masked, 0 otherwise.
  
  Global attention flags have value 1 for the tokens attend globally and 0 otherwise.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>window</tt> : int (required)</dt>
<dd>One sided attention windows length W, or half of total window length</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, hidden_size), hidden_size = num_heads * head_size</dd>
<dt><tt>weight</tt> : T</dt>
<dd>2D input tensor with shape (hidden_size, 3 * hidden_size)</dd>
<dt><tt>bias</tt> : T</dt>
<dd>1D input tensor with shape (3 * hidden_size)</dd>
<dt><tt>mask</tt> : T</dt>
<dd>Attention mask with shape (batch_size, sequence_length)</dd>
<dt><tt>global_weight</tt> : T</dt>
<dd>2D input tensor with shape (hidden_size, 3 * hidden_size)</dd>
<dt><tt>global_bias</tt> : T</dt>
<dd>1D input tensor with shape (3 * hidden_size)</dd>
<dt><tt>global</tt> : G</dt>
<dd>Global attention flags with shape (batch_size, sequence_length)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>G</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
</dl>


### <a name="com.microsoft.MatMulBnb4"></a><a name="com.microsoft.matmulbnb4">**com.microsoft.MatMulBnb4**</a>

  MatMulBnb4 is a MatMul with weight quantized with 4 bits using either FP4 or NF4 data type (https://arxiv.org/pdf/2305.14314.pdf). It does Matrix Multiplication like MatMul (https://github.com/onnx/onnx/blob/main/docs/Operators.md#matmul) with differences:
    1. Input B is a 2D constant Matrix. Its input feature count and output feature count are specified by attribute 'K' and 'N'.
    2. Input B is quantized with 4 bits with quantization data type specified by attribute 'quant_type'. It is transposed, flattened and quantized blockwisely with block size specified by attribute 'block_size'.
       And block_size is not an arbitrary number and must be a power of 2 and not smaller than 16, like 16, 32, 64, 128,..
    3. Input B's quantization constants or scales are specified by input 'absmax'.
  
    Input B is stored as uint8_t with shape: [(N * K + 1) / 2].
    Input absmax is stored in same type as original type of B(float32, float16) with shape like: [(N * K + block_size - 1) / block_size].
  
  
    1. (Default value) transB=True (Majorly used for forward pass)
      Shape of A: [D0, D1, ..., Dn, K]
      Shape of Dequanted B: [N, K], this is aligned with how PyTorch defined the linear weight, .e.g [out_features, in_features].
  
      The computation math:
        dequant_B = dequant(B, absmax, quant_type, block_size)
        transposed_dequant_B = dequant_B^T
        output = A @ transposed_dequant_B
  
      Shape of output: [D0, D1, ..., Dn, N]
  
    2. transB=False (Majorly used for backward pass)
      Shape of A: [D0, D1, ..., Dn, N]
      Shape of Dequanted B: [N, K], this is aligned with how PyTorch defined the linear weight, .e.g [out_features, in_features].
  
      The computation math:
        dequant_B = dequant(B, absmax, quant_type, block_size)
        output = A @ dequant_B
  
      Shape of output: [D0, D1, ..., Dn, K]
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>K</tt> : int (required)</dt>
<dd>size of each input feature</dd>
<dt><tt>N</tt> : int (required)</dt>
<dd>size of each output feature</dd>
<dt><tt>block_size</tt> : int (required)</dt>
<dd>number of groupsize used for weight quantization. It needs to be a power of 2 and not smaller than 16.</dd>
<dt><tt>quant_type</tt> : int (required)</dt>
<dd>quantization data type. 0 for FP4, 1 for NF4.</dd>
<dt><tt>training_mode</tt> : int</dt>
<dd>Indicate if the ops run in training_mode, by default, False.</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed on the last two dimensions before doing multiplication. Default to be 1.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T1</dt>
<dd>The input tensor, not quantized</dd>
<dt><tt>B</tt> : T2</dt>
<dd>1-dimensional quantized data for weight</dd>
<dt><tt>absmax</tt> : T1</dt>
<dd>quantization constants</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>tensor. The output tensor has the same rank as the input. </dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float/half_float/brain_float tensors.</dd>
<dt><tt>T2</tt> : tensor(uint8)</dt>
<dd>Constrain quantized weight types to uint8.</dd>
</dl>


### <a name="com.microsoft.MatMulFpQ4"></a><a name="com.microsoft.matmulfpq4">**com.microsoft.MatMulFpQ4**</a>

  Matrix product with right hand matrix being pre-packed and quantized int4 data blob.
  During quantization, the matrix is divided into blocks, where each block is a
  contiguous subset inside each column. Each block is quantized into a
  sequence of 4b integers with a scaling factor and an optional offset.
  Currently 3 quantization types are supported:
  (0): block size 32, no offset, (1): block size 32, with offset, (2): block size 64,
  no offset

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>blk_quant_type</tt> : int</dt>
<dd>Quantization type</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T1</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T2</dt>
<dd>1-dimensional data blob</dd>
<dt><tt>B_shape</tt> : T3</dt>
<dd>Shape information of B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float)</dt>
<dd>Constrain input matrix data types as single precision float tensor</dd>
<dt><tt>T2</tt> : tensor(uint8)</dt>
<dd>Constrain input B data types as data blob</dd>
<dt><tt>T3</tt> : tensor(int64)</dt>
<dd>Constrain shape of B must be int64 tensor.</dd>
</dl>


### <a name="com.microsoft.MatMulInteger16"></a><a name="com.microsoft.matmulinteger16">**com.microsoft.MatMulInteger16**</a>

  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html.
   The production MUST never overflow. The accumulation may overflow if and only if in 32 bits.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>A</tt> : T1</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T2</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T3</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int16), tensor(uint16)</dt>
<dd>Constrain input A data types as 16-bit integer tensor</dd>
<dt><tt>T2</tt> : tensor(int16), tensor(uint16)</dt>
<dd>Constrain input B data types as 16-bit integer tensor</dd>
<dt><tt>T3</tt> : tensor(int32), tensor(uint32)</dt>
<dd>Constrain output Y data types as 32-bit integer tensor.T3 must be tensor(uint32) when both T1 and T2 are tensor(uint16),or must be tensor(int32) when either T1 or T2 is tensor(int16).</dd>
</dl>


### <a name="com.microsoft.MatMulIntegerToFloat"></a><a name="com.microsoft.matmulintegertofloat">**com.microsoft.MatMulIntegerToFloat**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (4 - 7)

<dl>
<dt><tt>A</tt> : T1</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T2</dt>
<dd>N-dimensional matrix B</dd>
<dt><tt>a_scale</tt> : T3</dt>
<dd>Scale of quantized input 'A'. It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'A'.</dd>
<dt><tt>b_scale</tt> : T3</dt>
<dd>Scale of quantized input 'B'. It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'B'.</dd>
<dt><tt>a_zero_point</tt> (optional) : T1</dt>
<dd>Zero point tensor for input 'A'. It's optional and default value is 0.  It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'A'.</dd>
<dt><tt>b_zero_point</tt> (optional) : T2</dt>
<dd>Zero point tensor for input 'B'. It's optional and default value is 0.  It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'B'.</dd>
<dt><tt>bias</tt> (optional) : T3</dt>
<dd>1D input tensor, whose dimension is same as B's last dimension</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T3</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input A data type to 8-bit integer tensor.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input B data type to 8-bit integer tensor.</dd>
<dt><tt>T3</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input a_scale, b_scale and output Y data type as float tensor.</dd>
</dl>


### <a name="com.microsoft.MatMulNBits"></a><a name="com.microsoft.matmulnbits">**com.microsoft.MatMulNBits**</a>

  MatMulNBits performs a matrix multiplication where the right-hand-side matrix (weights) is quantized to N bits.
  
  It is a fusion of two operations:
  1. Linear dequantization of the quantized weights using scale and (optionally) zero-point with formula:
     dequantized_weight = (quantized_weight - zero_point) * scale
  2. Matrix multiplication between the input matrix A and the dequantized weight matrix.
  
  The weight matrix is a 2D constant matrix with the input feature count and output feature count specified by attributes 'K' and 'N'.
  It is quantized block-wise along the K dimension with a block size specified by the 'block_size' attribute.
  The block size must be a power of 2 and not smaller than 16 (e.g., 16, 32, 64, 128). Each block has its own scale and zero-point.
  The quantization is performed using a bit-width specified by the 'bits' attribute, which can take values from 2 to 8.
  
  The quantized weights are stored in a bit-packed format along the K dimension, with each block being represented by a blob of uint8.
  For example, for 4 bits, the first 4 bits are stored in the lower 4 bits of a byte, and the second 4 bits are stored in the higher 4 bits of a byte.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>K</tt> : int (required)</dt>
<dd>Input feature dimension of the weight matrix.</dd>
<dt><tt>N</tt> : int (required)</dt>
<dd>Output feature dimension of the weight matrix.</dd>
<dt><tt>accuracy_level</tt> : int</dt>
<dd>The minimum accuracy level of input A, can be: 0(unset), 1(fp32), 2(fp16), 3(bf16), or 4(int8) (default unset). It is used to control how input A is quantized or downcast internally while doing computation, for example: 0 means input A will not be quantized or downcast while doing computation. 4 means input A can be quantized with the same block_size to int8 internally from type T1.</dd>
<dt><tt>bits</tt> : int</dt>
<dd>Bit-width used to quantize the weights (valid range: 2~8)</dd>
<dt><tt>block_size</tt> : int (required)</dt>
<dd>Size of each quantization block along the K (input feature) dimension. Must be a power of two and ≥ 16 (e.g., 16, 32, 64, 128).</dd>
</dl>

#### Inputs (3 - 6)

<dl>
<dt><tt>A</tt> : T1</dt>
<dd>The input tensor, not quantized.</dd>
<dt><tt>B</tt> : T2</dt>
<dd>Packed uint8 tensor of shape (N, k_blocks, blob_size), where k_blocks = ceil(K / block_size) and blob_size = (block_size * bits / 8). The quantized weights are stored in a bit-packed format along the K dimension, packed within each block_size.</dd>
<dt><tt>scales</tt> : T1</dt>
<dd>Per-block scaling factors for dequantization with shape (N, k_blocks) and same data type as input A.</dd>
<dt><tt>zero_points</tt> (optional) : T3</dt>
<dd>Per-block zero point for dequantization. It can be either packed or unpacked: Packed (uint8) format has shape (N, ceil(k_blocks * bits / 8)), and it uses same bit-packing method as Input B. Unpacked (same type as A) format has shape (N, k_blocks). If not provided, a default zero point is used: 2^(bits - 1) (e.g., 8 for 4-bit quantization, 128 for 8-bit). </dd>
<dt><tt>g_idx</tt> (optional) : T4</dt>
<dd>group_idx. This input is deprecated</dd>
<dt><tt>bias</tt> (optional) : T1</dt>
<dd>Bias to add to result. It should have shape [N].</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>tensor. The output tensor has the same rank as the input. </dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T2</tt> : tensor(uint8)</dt>
<dd>Constrain quantized weight types to uint8.</dd>
<dt><tt>T3</tt> : tensor(uint8), tensor(float16), tensor(float), tensor(bfloat16)</dt>
<dd>Constrain quantized zero point types to uint8 or float tensors.</dd>
<dt><tt>T4</tt> : tensor(int32)</dt>
<dd>the index tensor.</dd>
</dl>


### <a name="com.microsoft.MaxpoolWithMask"></a><a name="com.microsoft.maxpoolwithmask">**com.microsoft.MaxpoolWithMask**</a>

  For internal use.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd></dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd></dd>
<dt><tt>storage_order</tt> : int</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd></dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>mask</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd></dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain input0 and output types to float tensors</dd>
</dl>


### <a name="com.microsoft.MoE"></a><a name="com.microsoft.moe">**com.microsoft.MoE**</a>

  Mixture of experts. Examples: Switch transformer(https://arxiv.org/pdf/2101.03961.pdf) use top 1,
        GLaM(https://arxiv.org/abs/2112.06905) activates top 2 FFN, Vision MOE(https://arxiv.org/pdf/2106.05974.pdf)
        usually uses top 32 experts and Mixtral(https://huggingface.co/blog/mixtral).
  
        The SwiGLU (Swish-Gated Linear Unit) activation function is like:
           g = xW + b
           l = xV + c
           G = clamp(g, max=limit)
           L = clamp(l, min=-limit, max=limit)
           swiglu = G * sigmoid(alpha * G) * (L + beta)
        where x is the input, W and V are weight matrices, b and c are bias vectors, and alpha, beta and limit are constant float parameters.
        When swiglu_fusion=0, two GEMMs are not fused, and they are FC1 and FC3 in the inputs.
        When swiglu_fusion=1, two GEMMs are fused so that g and l are computed in a single GEMM (FC1), and g and l are interleaved on each row of size 2 * inter_size.
        When swiglu_fusion=2, two GEMMs are fused, and g and l are concatenated on each row.
        

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : float</dt>
<dd>Alpha parameter used in activation function.</dd>
<dt><tt>activation_beta</tt> : float</dt>
<dd>Beta parameter used in activation function.</dd>
<dt><tt>activation_type</tt> : string</dt>
<dd>Activation function to use. Choose from relu, gelu, silu, swiglu and identity. Default is relu</dd>
<dt><tt>k</tt> : int</dt>
<dd>Number of top experts to select from expert pool</dd>
<dt><tt>normalize_routing_weights</tt> : int</dt>
<dd>Whether to normalize routing weights</dd>
<dt><tt>swiglu_fusion</tt> : int</dt>
<dd>0: not fused, 1: fused and interleaved. 2: fused and not interleaved.</dd>
<dt><tt>swiglu_limit</tt> : float</dt>
<dd>The limit used to clamp in SwiGLU. No clamp when limit is not provided.</dd>
<dt><tt>use_sparse_mixer</tt> : int</dt>
<dd>Whether to use sparse mixer</dd>
</dl>

#### Inputs (5 - 8)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>2D input tensor with shape (num_tokens, hidden_size) or 3D input tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>router_probs</tt> : T</dt>
<dd>2D input tensor with shape (num_tokens, num_experts)</dd>
<dt><tt>fc1_experts_weights</tt> : T</dt>
<dd>3D input tensor with shape (num_experts, fusion_size * inter_size, hidden_size), where fusion_size is 2 for fused swiglu, and 1 otherwise</dd>
<dt><tt>fc1_experts_bias</tt> (optional) : T</dt>
<dd>2D optional input tensor with shape (num_experts, fusion_size * inter_size)</dd>
<dt><tt>fc2_experts_weights</tt> : T</dt>
<dd>3D input tensor with shape (num_experts, hidden_size, inter_size)</dd>
<dt><tt>fc2_experts_bias</tt> (optional) : T</dt>
<dd>2D optional input tensor with shape (num_experts, hidden_size)</dd>
<dt><tt>fc3_experts_weights</tt> (optional) : T</dt>
<dd>3D optional input tensor with shape (num_experts, inter_size, hidden_size)</dd>
<dt><tt>fc3_experts_bias</tt> (optional) : T</dt>
<dd>2D optional input tensor with shape (num_experts, inter_size)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>2D input tensor with shape (num_tokens, hidden_size) or 3D input tensor with shape (batch_size, sequence_length, hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.MulInteger"></a><a name="com.microsoft.mulinteger">**com.microsoft.MulInteger**</a>

  Performs element-wise binary quantized multiplication (with Numpy-style broadcasting support).
  "This operator supports **multidirectional (i.e., Numpy-style) broadcasting**"
  The output of this op is the int32 accumulated result of the mul operation
  
  ```
  C (int32) = (A - A_zero_point) * (B - B_zero_point)
  ```
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (3 - 4)

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>A_zero_point</tt> (optional) : T</dt>
<dd>Input A zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
<dt><tt>B_zero_point</tt> (optional) : T</dt>
<dd>Input B zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T1</dt>
<dd>Constrain output to 32 bit tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input types to 8 bit signed and unsigned tensors.</dd>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain output types to 32 bit tensors.</dd>
</dl>


### <a name="com.microsoft.MultiHeadAttention"></a><a name="com.microsoft.multiheadattention">**com.microsoft.MultiHeadAttention**</a>

  Multi-Head Self/Cross Attention. Bias from input projection is included.
  
  The key padding mask is optional. When its shape is (batch_size, kv_sequence_length), value 0
  means padding or 1 otherwise. When key has right-side padding, its shape could be (batch_size): it is actual length of
  each key sequence excluding paddings.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
<dt><tt>unidirectional</tt> : int</dt>
<dd>Whether every token can only attend to previous tokens. Default value is 0.</dd>
</dl>

#### Inputs (1 - 10)

<dl>
<dt><tt>query</tt> : T</dt>
<dd>Query with shape (batch_size, sequence_length, hidden_size), or packed QKV with shape (batch_size, kv_sequence_length, num_heads, 3, head_size)</dd>
<dt><tt>key</tt> (optional) : T</dt>
<dd>Key with shape (batch_size, kv_sequence_length, hidden_size), or packed KV with shape (batch_size, kv_sequence_length, num_heads, 2, head_size), or past_key with shape (batch_size, num_heads, kv_sequence_length, head_size)</dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>Value with shape (batch_size, kv_sequence_length, v_hidden_size), or past_value with shape (batch_size, num_heads, kv_sequence_length, head_size)</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>Bias tensor with shape (hidden_size + hidden_size + v_hidden_size) from input projection</dd>
<dt><tt>key_padding_mask</tt> (optional) : M</dt>
<dd>Key padding mask with shape (batch_size), (3 * batch_size + 2), (batch_size, kv_sequence_length), (batch_size, total_sequence_length), or (batch_size, sequence_length, total_sequence_length)</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>bias added to QxK' with shape (batch_size or 1, num_heads or 1, sequence_length, total_sequence_length)</dd>
<dt><tt>past_key</tt> (optional) : T</dt>
<dd>past state for key with shape (batch_size, num_heads, past_sequence_length, head_size) or (batch_size, num_heads, max_sequence_length, head_size) when buffer sharing is used</dd>
<dt><tt>past_value</tt> (optional) : T</dt>
<dd>past state for value with shape (batch_size, num_heads, past_sequence_length, head_size) or (batch_size, num_heads, max_sequence_length, head_size) when buffer sharing is used</dd>
<dt><tt>past_sequence_length</tt> (optional) : M</dt>
<dd>The past_sequence_length buffer sharing is used with</dd>
<dt><tt>cache_indirection</tt> (optional) : M</dt>
<dd>A buffer of shape [batch_size, beam_width, max_sequence_length] where an [i, j, k] entry specifieswhich beam the 'k' th token came from for the 'j' th beam for batch 'i' in the current iteration</dd>
</dl>

#### Outputs (1 - 4)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, v_hidden_size)</dd>
<dt><tt>present_key</tt> (optional) : T</dt>
<dd>present state for key with shape (batch_size, num_heads, total_sequence_length, head_size) or (batch_size, num_heads, max_sequence_length, head_size) when buffer sharing is used</dd>
<dt><tt>present_value</tt> (optional) : T</dt>
<dd>present state for value with shape (batch_size, num_heads, total_sequence_length, head_size) or (batch_size, num_heads, max_sequence_length, head_size) when buffer sharing is used</dd>
<dt><tt>qk</tt> (optional) : QK</dt>
<dd>normalized Q * K, of shape (batch_size, num_heads, sequence_length, total_sequence_length). </dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output to float tensors.</dd>
<dt><tt>QK</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain QK output to float32 or float16 tensors, independent of input type or output type.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask to integer types</dd>
</dl>


### <a name="com.microsoft.MurmurHash3"></a><a name="com.microsoft.murmurhash3">**com.microsoft.MurmurHash3**</a>

  The underlying implementation is MurmurHash3_x86_32 generating low latency 32bits hash suitable for implementing lookup tables, Bloom filters, count min sketch or feature hashing.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>positive</tt> : int</dt>
<dd>If value is 1, output type is uint32_t, else int32_t. Default value is 1.</dd>
<dt><tt>seed</tt> : int</dt>
<dd>Seed for the hashing algorithm, unsigned 32-bit integer, default to 0.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T1</dt>
<dd>An input tensor to hash.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T2</dt>
<dd>32-bit hash value.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(uint32), tensor(int32), tensor(uint64), tensor(int64), tensor(float), tensor(double), tensor(string)</dt>
<dd>Constrain input type to unsigned or signed 32-bit integer tensor, or string tensor. It should be utf-8 encoded if using unicode.</dd>
<dt><tt>T2</tt> : tensor(uint32), tensor(int32)</dt>
<dd>Constrain output type to unsigned and signed 32-bit integer tensor.</dd>
</dl>


### <a name="com.microsoft.NGramRepeatBlock"></a><a name="com.microsoft.ngramrepeatblock">**com.microsoft.NGramRepeatBlock**</a>

  Enforce no repetition of n-grams. Scores are set to `-inf` for tokens that form a repeated n-gram if added to the back of the input_ids.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>ngram_size</tt> : int (required)</dt>
<dd>The NGram size.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input_ids</tt> : Tid</dt>
<dd>2D input tensor with shape (batch_size, sequence_length)</dd>
<dt><tt>scores</tt> : T</dt>
<dd>2D input tensor with shape (batch_size, vocab_size)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>scores_out</tt> : T</dt>
<dd>2D output tensor with shape (batch_size, vocab_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Tid</tt> : tensor(int64)</dt>
<dd>Constrain indices to integer types</dd>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain scores input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.NhwcConv"></a><a name="com.microsoft.nhwcconv">**com.microsoft.NhwcConv**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd>dilation value along each spatial axis of the filter. If not present, the dilation defaults is 1 along each spatial axis.</dd>
<dt><tt>group</tt> : int</dt>
<dd>number of groups input channels and output channels are divided into.</dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd>The shape of the convolution kernel. If not present, should be inferred from input W.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults is 1 along each spatial axis.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from previous layer; has size (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and width. Note that this is for the 2D image. Otherwise the size is (N x C x D1 x D2 ... x Dn). Optionally, if dimension denotation is in effect, the operation expects input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>W</tt> : T</dt>
<dd>The weight tensor that will be used in the convolutions; has size (M x C/group x kH x kW), where C is the number of channels, and kH and kW are the height and width of the kernel, and M is the number of feature maps. For more than 2 dimensions, the kernel shape will be (M x C/group x k1 x k2 x ... x kn), where (k1 x k2 x ... kn) is the dimension of the kernel. Optionally, if dimension denotation is in effect, the operation expects the weight tensor to arrive with the dimension denotation of [FILTER_OUT_CHANNEL, FILTER_IN_CHANNEL, FILTER_SPATIAL, FILTER_SPATIAL ...]. Assuming zero based indices for the shape array, X.shape[1] == (W.shape[1] * group) == C and W.shape[0] mod G == 0. Or in other words FILTER_IN_CHANNEL multiplied by the number of groups should be equal to DATA_CHANNEL and the number of feature maps M should be a multiple of the number of groups G.</dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd>Optional 1D bias to be added to the convolution, has size of M.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor that contains the result of the convolution. The output dimensions are functions of the kernel size, stride size, and pad lengths.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.NhwcFusedConv"></a><a name="com.microsoft.nhwcfusedconv">**com.microsoft.NhwcFusedConv**</a>

  NhwcFusedConv is a Conv operator with optional activation and add operators fused in.
  Only has fp16 implementation as of 2023/04/15.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : string</dt>
<dd></dd>
<dt><tt>activation_params</tt> : list of floats</dt>
<dd></dd>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd></dd>
<dt><tt>group</tt> : int</dt>
<dd></dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd></dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs (2 - 4)

<dl>
<dt><tt>X</tt> : T</dt>
<dd></dd>
<dt><tt>W</tt> : T</dt>
<dd></dd>
<dt><tt>B</tt> (optional) : T</dt>
<dd></dd>
<dt><tt>Z</tt> (optional) : T</dt>
<dd>Tensor to be added to the output, must be the same shape and format as the output tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd></dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16)</dt>
<dd>Constrain input and output types to float tensors</dd>
</dl>


### <a name="com.microsoft.NhwcMaxPool"></a><a name="com.microsoft.nhwcmaxpool">**com.microsoft.NhwcMaxPool**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>ceil_mode</tt> : int</dt>
<dd></dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd></dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd></dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs

<dl>
<dt><tt>x</tt> : T</dt>
<dd></dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T</dt>
<dd></dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int8), tensor(uint8)</dt>
<dd></dd>
</dl>


### <a name="com.microsoft.PackedAttention"></a><a name="com.microsoft.packedattention">**com.microsoft.PackedAttention**</a>

  This is the packed version of Attention.
  
  Sequences in one batch usually don't have same length and they are padded to have same length,
  e.g., below is a batch with 3 sequences and tokens* are padded.
    Sequence_0:   0,  1*, 2*,  3*
    Sequence_1:   4,  5,  6*,  7*
    Sequence_2:   8,  9,  10,  11
  
  PackedAttention is designed to takes in packed input, i.e., only the real tokens without padding.
  An input as above will be packed into 3 tensors like below:
   - input ([h0, h4, h5, h8, h9, h10, h11])
   - token_offset: 0, 4, 5, 8, 9, 10, 11,  1*, 2*, 3*, 6*, 7*
   - cumulated_token_count: 0, 1, 1+2, 1+2+4
  
  Input tensors contains the hidden embedding of real tokens.
  Token_offset records the offset of token in the unpacked input.
  cumulated_token_count records cumulated length of each sequence length.
  
  The operator only supports BERT like model with padding on right now.
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>qkv_hidden_sizes</tt> : list of ints</dt>
<dd>Hidden dimension of Q, K, V: hidden_size, hidden_size and v_hidden_size</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
</dl>

#### Inputs (5 - 6)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor with shape (token_count, input_hidden_size)</dd>
<dt><tt>weights</tt> : T</dt>
<dd>Merged Q/K/V weights with shape (input_hidden_size, hidden_size + hidden_size + v_hidden_size)</dd>
<dt><tt>bias</tt> : T</dt>
<dd>Bias tensor with shape (hidden_size + hidden_size + v_hidden_size) for input projection</dd>
<dt><tt>token_offset</tt> : M</dt>
<dd>In packing mode, it specifies the offset of each token(batch_size, sequence_length).</dd>
<dt><tt>cumulative_sequence_length</tt> : M</dt>
<dd>A tensor with shape (batch_size + 1). It specifies the cumulative sequence length.</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>A tensor with shape (batch_size or 1, num_heads or 1, sequence_length, sequence_length).It specifies the additional bias to QxK'</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>2D output tensor with shape (token_count, v_hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask index to integer types</dd>
</dl>


### <a name="com.microsoft.PackedMultiHeadAttention"></a><a name="com.microsoft.packedmultiheadattention">**com.microsoft.PackedMultiHeadAttention**</a>

  This is the packed version of MultiHeadAttention.
  
  Sequences in one batch usually don't have same length and they are padded to have same length,
  e.g., below is a batch with 3 sequences and * is padding token.
    Sequence_0:   0,  1*, 2*,  3*
    Sequence_1:   4,  5,  6*,  7*
    Sequence_2:   8,  9,  10,  11
  
  PackedMultiHeadAttention is designed to takes in packed input, i.e., only the real tokens without padding.
  An input as above will be packed into 3 tensors like below:
   - query ([q0, q4, q5, q8, q9, q10, q11])
   - key ([k0, k4, k5, k8, k9, k10, k11])
   - value ([v0, v4, v5, v8, v9, v10, v11])
   - token_offset: 0, 4, 5, 8, 9, 10, 11,  1*, 2*, 3*, 6*, 7*
   - cumulative_sequence_length: 0, 1, 1+2, 1+2+4
  
  The query, key and value tensors contain result of hidden embedding of real tokens after input projections.
  Token_offset records the offset of token in the unpacked input.
  cumulative_sequence_length records cumulated length of each sequence length.
  
  The operator only supports BERT like model with padding on right now.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
</dl>

#### Inputs (6 - 7)

<dl>
<dt><tt>query</tt> : T</dt>
<dd>Query with shape (token_count, hidden_size) or packed qkv with shape (token_count, num_heads, 3, head_size)</dd>
<dt><tt>key</tt> (optional) : T</dt>
<dd>Key with shape (token_count, hidden_size)</dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>Value with shape (token_count, v_hidden_size)</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>Bias tensor with shape (hidden_size + hidden_size + v_hidden_size) from input projection</dd>
<dt><tt>token_offset</tt> : M</dt>
<dd>Offset of each token before packing, with shape (batch_size, sequence_length).</dd>
<dt><tt>cumulative_sequence_length</tt> : M</dt>
<dd>A tensor with shape (batch_size + 1). It specifies the cumulative sequence length.</dd>
<dt><tt>attention_bias</tt> (optional) : T</dt>
<dd>It specifies the additional bias to QxK'. The shape is (batch_size or 1, num_heads or 1, sequence_length, sequence_length)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>output tensor with shape (token_count, v_hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask, offset and sequence length to integer types</dd>
</dl>


### <a name="com.microsoft.Pad"></a><a name="com.microsoft.pad">**com.microsoft.Pad**</a>

  Given `data` tensor, pads, mode, and value.
              Example:
              Insert 0 pads to the beginning of the second dimension.
              data = [
                      [1.0, 1.2],
                      [2.3, 3.4],
                      [4.5, 5.7],
                      ]
              pads = [0, 2, 0, 0]
              output = [
                      [
                      [0.0, 0.0, 1.0, 1.2],
                      [0.0, 0.0, 2.3, 3.4],
                      [0.0, 0.0, 4.5, 5.7],
                      ],
                      ]
              

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>mode</tt> : string</dt>
<dd>Three modes: `constant`(default) - pads with a given constant value, `reflect` - pads with the reflection of the vector mirrored on the first and last values of the vector along each axis, `edge` - pads with the edge values of array</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>Input tensor.</dd>
<dt><tt>pads</tt> : tensor(int64)</dt>
<dd>Tensor of integers indicating the number of padding elements to add or remove (if negative) at the beginning and end of each axis. For 2D input tensor, it is the number of pixels. `pads` should be a 1D tensor of shape [2 * input_rank] or a 2D tensor of shape [1, 2 * input_rank]. `pads` format (1D example) should be as follow [x1_begin, x2_begin,...,x1_end, x2_end,...], where xi_begin is the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`.</dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>(Optional) A scalar or rank 1 tensor containing a single value to be filled if the mode chosen is `constant` (by default it is 0.0).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Tensor after padding.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.PagedAttention"></a><a name="com.microsoft.pagedattention">**com.microsoft.PagedAttention**</a>

  Paged Attention.
  
  This op leverages a block-based KV cache to enable continuous batching for LLMs. Currently, it is designed to work with
  the CUDA Execution Provider only.
  
  In other attention ops, batch entries typically aren't of the same length, so they are padded.
  Below is a batch with 3 sequences where * denotes a padding token.
    Sequence_0:   0,  1*, 2*,  3*
    Sequence_1:   4,  5,  6*,  7*
    Sequence_2:   8,  9,  10,  11
  
  PagedAttention is designed to take in packed input, i.e., only the real tokens without padding.
  For example, the input shown above will be packed into 3 tensors like below:
   - query ([q0, q4, q5, q8, q9, q10, q11])
   - key ([k0, k4, k5, k8, k9, k10, k11])
   - value ([v0, v4, v5, v8, v9, v10, v11])
   - cumulative_sequence_length: 0, 1, 1+2, 1+2+4
  This packing omits padding tokens.
  
  The query, key and value tensors contain result of hidden embedding of real tokens after input projections.
  cumulative_sequence_length records cumulated length of each sequence length.
  

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>do_rotary</tt> : int</dt>
<dd>Whether to use rotary position embedding. Default value is 0.</dd>
<dt><tt>kv_num_heads</tt> : int (required)</dt>
<dd>Number of attention heads for k and v</dd>
<dt><tt>local_window_size</tt> : int</dt>
<dd>left_window_size for local attention (like Mistral). Default value is -1 meaning unused.</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads for q</dd>
<dt><tt>rotary_interleaved</tt> : int</dt>
<dd>Rotate using interleaved pattern. Default value is 0 (False).</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
<dt><tt>softcap</tt> : float</dt>
<dd>Softcap value for attention weights. Default value is 0.</dd>
</dl>

#### Inputs (8 - 10)

<dl>
<dt><tt>query</tt> : T</dt>
<dd>Query with shape (num_tokens, hidden_size), or packed QKV with shape (num_tokens, d) where d is (num_heads * head_size + 2 * kv_num_heads * head_size).</dd>
<dt><tt>key</tt> (optional) : T</dt>
<dd>Key with shape (num_tokens, kv_hidden_size) </dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>Value with shape (num_tokens, kv_hidden_size)</dd>
<dt><tt>key_cache</tt> : T</dt>
<dd>Block-based key cache with shape (num_blocks, block_size, kv_num_heads, head_size). This is updated in place within the op.</dd>
<dt><tt>value_cache</tt> : T</dt>
<dd>Block-based value cache with shape (num_blocks, block_size, kv_num_heads, head_size). This is updated in place within the op. This should be the same shape as key_cache.</dd>
<dt><tt>cumulative_sequence_length</tt> : S</dt>
<dd>A tensor with shape (batch_size + 1). It specifies the cumulative sequence lengths between the packed entries in Q/K/V.</dd>
<dt><tt>past_seqlens</tt> : S</dt>
<dd>A tensor with shape (batch_size). It specifies the past lengths of cached sequence in the KV cache.</dd>
<dt><tt>block_table</tt> : S</dt>
<dd>2D tensor with shape (batch_size, max_blocks_per_sequence) that maps each sequence in the batch to itscorresponding blocks in the KV cache.</dd>
<dt><tt>cos_cache</tt> (optional) : T</dt>
<dd>2D tensor with shape (max total seqlen, head_size / 2).</dd>
<dt><tt>sin_cache</tt> (optional) : T</dt>
<dd>2D tensor with shape (max total seqlen, head_size / 2).</dd>
</dl>

#### Outputs (1 - 3)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (num_tokens, hidden_size)</dd>
<dt><tt>key_cache_out</tt> (optional) : T</dt>
<dd>Block-based key cache with shape (num_blocks, block_size, kv_num_heads, head_size). This is always the same tensor as key_cache.</dd>
<dt><tt>value_cache_out</tt> (optional) : T</dt>
<dd>Block-based value cache with shape (num_blocks, block_size, kv_num_heads, head_size). This is always the same tensor as value_cache.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output to float tensors.</dd>
<dt><tt>S</tt> : tensor(int32)</dt>
<dd>Constrain Positional inputs to int tensor.</dd>
</dl>


### <a name="com.microsoft.QAttention"></a><a name="com.microsoft.qattention">**com.microsoft.QAttention**</a>

  Quantization of Multi-Head Self Attention.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>do_rotary</tt> : int</dt>
<dd>Whether to use rotary position embedding. Default value is 0.</dd>
<dt><tt>mask_filter_value</tt> : float</dt>
<dd>The value to be filled in the attention mask. Default value is -10000.0f</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>past_present_share_buffer</tt> : int</dt>
<dd>Corresponding past and present are same tensor, its shape is (2, batch_size, num_heads, max_sequence_length, head_size)</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1/sqrt(head_size)</dd>
<dt><tt>unidirectional</tt> : int</dt>
<dd>Whether every token can only attend to previous tokens. Default value is 0.</dd>
</dl>

#### Inputs (5 - 9)

<dl>
<dt><tt>input</tt> : T1</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, input_hidden_size)</dd>
<dt><tt>weight</tt> : T2</dt>
<dd>2D input tensor with shape (input_hidden_size, 3 * hidden_size), hidden_size = num_heads * head_size</dd>
<dt><tt>bias</tt> : T3</dt>
<dd>1D input tensor with shape (3 * hidden_size)</dd>
<dt><tt>input_scale</tt> : T3</dt>
<dd>scale of quantized input tensor. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>weight_scale</tt> : T3</dt>
<dd>scale of weight scale. It's a scalar or a 1D tensor, which means a per-tensor/per-column quantization.Its size should be 3 * hidden_size if it is per-column quantization</dd>
<dt><tt>mask_index</tt> (optional) : T4</dt>
<dd>Attention mask index with shape (batch_size)</dd>
<dt><tt>input_zero_point</tt> (optional) : T1</dt>
<dd>zero point of quantized input tensor.It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>weight_zero_point</tt> (optional) : T2</dt>
<dd>zero point of quantized weight tensor. It's a scalar or a 1D tensor, which means a per-tensor/per-column quantization.Its size should be 3 * hidden_size if it is per-column quantization</dd>
<dt><tt>past</tt> (optional) : T3</dt>
<dd>past state for key and value with shape (2, batch_size, num_heads, past_sequence_length, head_size).</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>output</tt> : T3</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>present</tt> (optional) : T3</dt>
<dd>present state for key and value with shape (2, batch_size, num_heads, past_sequence_length + sequence_length, head_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>T3</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T4</tt> : tensor(int32)</dt>
<dd>Constrain mask index to integer types</dd>
</dl>


### <a name="com.microsoft.QGemm"></a><a name="com.microsoft.qgemm">**com.microsoft.QGemm**</a>

  Quantized Gemm

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of input tensors A * B.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed</dd>
</dl>

#### Inputs (6 - 9)

<dl>
<dt><tt>A</tt> : TA</dt>
<dd>Input tensor A. The shape of A should be (M, K) if transA is 0, or (K, M) if transA is non-zero.</dd>
<dt><tt>a_scale</tt> : T</dt>
<dd>Scale of quantized input 'A'. It is a scalar,which means a per-tensor quantization.</dd>
<dt><tt>a_zero_point</tt> : TA</dt>
<dd>Zero point tensor for input 'A'. It is a scalar.</dd>
<dt><tt>B</tt> : TB</dt>
<dd>Input tensor B. The shape of B should be (K, N) if transB is 0, or (N, K) if transB is non-zero.</dd>
<dt><tt>b_scale</tt> : T</dt>
<dd>Scale of quantized input 'B'. It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'B'.</dd>
<dt><tt>b_zero_point</tt> : TB</dt>
<dd>Zero point tensor for input 'B'. It's optional and default value is 0.  It could be a scalar or a 1-D tensor, which means a per-tensor or per-column quantization. If it's a 1-D tensor, its number of elements should be equal to the number of columns of input 'B'.</dd>
<dt><tt>C</tt> (optional) : TC</dt>
<dd>Optional input tensor C. If not specified, the computation is done as if C is a scalar 0. The shape of C should be unidirectional broadcastable to (M, N). Its type is int32_t and must be quantized with zero_point = 0 and scale = alpha / beta * a_scale * b_scale.</dd>
<dt><tt>y_scale</tt> (optional) : T</dt>
<dd>Scale of output 'Y'. It is a scalar, which means a per-tensor quantization. It is optional. The output is full precision(float32) if it is not provided. Or the output is quantized.</dd>
<dt><tt>y_zero_point</tt> (optional) : TYZ</dt>
<dd>Zero point tensor for output 'Y'. It is a scalar, which means a per-tensor quantization. It is optional. The output is full precision(float32) if it is not provided. Or the output is quantized.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : TY</dt>
<dd>Output tensor of shape (M, N).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain scale types to float tensors.</dd>
<dt><tt>TA</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input A and its zero point types to 8 bit tensors.</dd>
<dt><tt>TB</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input B and its zero point types to 8 bit tensors.</dd>
<dt><tt>TC</tt> : tensor(int32)</dt>
<dd>Constrain input C to 32 bit integer tensors.</dd>
<dt><tt>TYZ</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain output zero point types to 8 bit tensors.</dd>
<dt><tt>TY</tt> : tensor(float), tensor(uint8), tensor(int8)</dt>
<dd>Constrain output type to float32 or 8 bit tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearAdd"></a><a name="com.microsoft.qlinearadd">**com.microsoft.QLinearAdd**</a>

  Performs element-wise binary addition on 8 bit data types (with Numpy-style broadcasting support).
  
  C = (A_scale * (A - A_zero_point) + B_scale * (B - B_zero_point))/C_scale + C_zero_point

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (7 - 8)

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>A_scale</tt> : tensor(float)</dt>
<dd>Input A's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>A_zero_point</tt> (optional) : T</dt>
<dd>Input A zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
<dt><tt>B_scale</tt> : tensor(float)</dt>
<dd>Input B's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>B_zero_point</tt> (optional) : T</dt>
<dd>Input B zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>C_scale</tt> : tensor(float)</dt>
<dd>Output scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>C_zero_point</tt> (optional) : T</dt>
<dd>Output zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit signed and unsigned tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearAveragePool"></a><a name="com.microsoft.qlinearaveragepool">**com.microsoft.QLinearAveragePool**</a>

  QLinearAveragePool consumes an input tensor X and applies average pooling across
   the tensor according to kernel sizes, stride sizes, and pad lengths.
   average pooling consisting of computing the average on all values of a
   subset of the input tensor according to the kernel size and downsampling the
   data into the output tensor Y for further processing. The output spatial shape will be following:
   ```
   output_spatial_shape[i] = floor((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)
   ```
   or
   ```
   output_spatial_shape[i] = ceil((input_spatial_shape[i] + pad_shape[i] - kernel_spatial_shape[i]) / strides_spatial_shape[i] + 1)
   ```
   if ceil_mode is enabled
  
   ```
   * pad_shape[i] is sum of pads along axis i
   ```
  
   `auto_pad` is a DEPRECATED attribute. If you are using them currently, the output spatial shape will be following:
   ```
   VALID: output_spatial_shape[i] = ceil((input_spatial_shape[i] - kernel_spatial_shape[i] + 1) / strides_spatial_shape[i])
   SAME_UPPER or SAME_LOWER: output_spatial_shape[i] = ceil(input_spatial_shape[i] / strides_spatial_shape[i])
   ```
   And pad shape will be following if `SAME_UPPER` or `SAME_LOWER`:
   ```
   pad_shape[i] = (output_spatial_shape[i] - 1) * strides_spatial_shape[i] + kernel_spatial_shape[i] - input_spatial_shape[i]
   ```
  
  The output of each pooling window is divided by the number of elements (exclude pad when attribute count_include_pad is zero).
  
  Input and output scales and zero points are used to convert the output to a new quantization range.
  Output = Dequantize(Input) -> AveragePool on fp32 data -> Quantize(output)

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string</dt>
<dd>auto_pad must be either NOTSET, SAME_UPPER, SAME_LOWER or VALID. Where default value is NOTSET, which means explicit padding is used. SAME_UPPER or SAME_LOWER mean pad the input so that the output spatial size match the input.In case of odd number add the extra padding at the end for SAME_UPPER and at the beginning for SAME_LOWER. VALID mean no padding.</dd>
<dt><tt>ceil_mode</tt> : int</dt>
<dd>Whether to use ceil or floor (default) to compute the output shape.</dd>
<dt><tt>channels_last</tt> : int</dt>
<dd>Works on NHWC layout or not? Default not.</dd>
<dt><tt>count_include_pad</tt> : int</dt>
<dd>Whether include pad pixels when calculating values for the edges. Default is 0, doesn't count include pad.</dd>
<dt><tt>kernel_shape</tt> : list of ints (required)</dt>
<dd>The size of the kernel along each axis.</dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd>Padding for the beginning and ending along each spatial axis, it can take any value greater than or equal to 0. The value represent the number of pixels added to the beginning and end part of the corresponding axis. `pads` format should be as follow [x1_begin, x2_begin...x1_end, x2_end,...], where xi_begin the number of pixels added at the beginning of axis `i` and xi_end, the number of pixels added at the end of axis `i`. This attribute cannot be used simultaneously with auto_pad attribute. If not present, the padding defaults to 0 along start and end of each spatial axis.</dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd>Stride along each spatial axis. If not present, the stride defaults to 1 along each spatial axis.</dd>
</dl>

#### Inputs (4 - 5)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; dimensions for image case are (N x C x H x W), where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), where N is the batch size. Optionally, if dimension denotation is in effect, the operation expects the input data tensor to arrive with the dimension denotation of [DATA_BATCH, DATA_CHANNEL, DATA_FEATURE, DATA_FEATURE ...].</dd>
<dt><tt>x_scale</tt> : tensor(float)</dt>
<dd>Input scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>x_zero_point</tt> (optional) : T</dt>
<dd>Input zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Output scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>y_zero_point</tt> (optional) : T</dt>
<dd>Output zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from average or max pooling across the input tensor. Dimensions will vary based on various kernel, stride, and pad sizes. Floor value of the dimension is used</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearConcat"></a><a name="com.microsoft.qlinearconcat">**com.microsoft.QLinearConcat**</a>

  Concatenate a list of tensors into a single tensor.All input tensors must have the same shape, except for the dimension size of the axis to concatenate on.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int (required)</dt>
<dd>Which axis to concat on</dd>
</dl>

#### Inputs (3 - &#8734;)

<dl>
<dt><tt>Y_scale</tt> : TF</dt>
<dd>Y's scale.</dd>
<dt><tt>Y_zero_point</tt> : T8</dt>
<dd>Y's zero point.</dd>
<dt><tt>inputs</tt> (variadic, heterogeneous) : TV</dt>
<dd>List of tensors/scale/zero_point for concatenation</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T8</dt>
<dd>Concatenated tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T8</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit signed and unsigned tensors.</dd>
<dt><tt>TF</tt> : tensor(float)</dt>
<dd>Constrain scale types to any float tensor type.</dd>
<dt><tt>TV</tt> : tensor(uint8), tensor(int8), tensor(float)</dt>
<dd>Sequence of (Tensor, Scale, ZeroPoint) tuples. The type is sequence of (T8, TF, T8).</dd>
</dl>


### <a name="com.microsoft.QLinearConv"></a><a name="com.microsoft.qlinearconv">**com.microsoft.QLinearConv**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>auto_pad</tt> : string</dt>
<dd></dd>
<dt><tt>channels_last</tt> : int</dt>
<dd></dd>
<dt><tt>dilations</tt> : list of ints</dt>
<dd></dd>
<dt><tt>group</tt> : int</dt>
<dd></dd>
<dt><tt>kernel_shape</tt> : list of ints</dt>
<dd></dd>
<dt><tt>pads</tt> : list of ints</dt>
<dd></dd>
<dt><tt>strides</tt> : list of ints</dt>
<dd></dd>
</dl>

#### Inputs (8 - 9)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd></dd>
<dt><tt>x_scale</tt> : tensor(float)</dt>
<dd></dd>
<dt><tt>x_zero_point</tt> : T1</dt>
<dd></dd>
<dt><tt>w</tt> : T2</dt>
<dd></dd>
<dt><tt>w_scale</tt> : tensor(float)</dt>
<dd></dd>
<dt><tt>w_zero_point</tt> : T2</dt>
<dd></dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd></dd>
<dt><tt>y_zero_point</tt> : T3</dt>
<dd></dd>
<dt><tt>B</tt> (optional) : T4</dt>
<dd></dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T3</dt>
<dd></dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd></dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd></dd>
<dt><tt>T3</tt> : tensor(int8), tensor(uint8)</dt>
<dd></dd>
<dt><tt>T4</tt> : tensor(int32)</dt>
<dd></dd>
</dl>


### <a name="com.microsoft.QLinearGlobalAveragePool"></a><a name="com.microsoft.qlinearglobalaveragepool">**com.microsoft.QLinearGlobalAveragePool**</a>

  QLinearGlobalAveragePool consumes an input tensor X and applies Average pooling across
  the values in the same channel. This is equivalent to AveragePool with kernel size
  equal to the spatial dimension of input tensor. Input is of type uint8_t or int8_t.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>channels_last</tt> : int</dt>
<dd></dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor from the previous operator; According to channels_last, dimensions for image case are (N x C x H x W), or (N x H x W x C) where N is the batch size, C is the number of channels, and H and W are the height and the width of the data. For non image case, the dimensions are in the form of (N x C x D1 x D2 ... Dn), or (N x D1 X D2 ... Dn x C) where N is the batch size.</dd>
<dt><tt>x_scale</tt> : tensor(float)</dt>
<dd>Scale of quantized input 'X'. It must be a scalar.</dd>
<dt><tt>x_zero_point</tt> : T</dt>
<dd>Zero point tensor for input 'X'. It must be a scalar.</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Scale of quantized output 'Y'. It must be a scalar.</dd>
<dt><tt>y_zero_point</tt> : T</dt>
<dd>Zero point tensor for output 'Y'. It must be a scalar.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from pooling across the input tensor. The output tensor has the same rank as the input. with the N and C value keep it value, while the otherdimensions are all 1.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to signed/unsigned int8 tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearLeakyRelu"></a><a name="com.microsoft.qlinearleakyrelu">**com.microsoft.QLinearLeakyRelu**</a>

  QLinearLeakyRelu takes quantized input data (Tensor), an argument alpha, and quantize parameter for output,
  and produces one output data (Tensor<T>) where the function `f(x) = quantize(alpha * dequantize(x)) for dequantize(x) < 0`,
  `f(x) = quantize(dequantize(x)) for dequantize(x) >= 0`, is applied to the data tensor elementwise.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float</dt>
<dd>Coefficient of leakage.</dd>
</dl>

#### Inputs (4 - 5)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
<dt><tt>X_scale</tt> : tensor(float)</dt>
<dd>Input X's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>X_zero_point</tt> (optional) : T</dt>
<dd>Input X's zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>Y_scale</tt> : tensor(float)</dt>
<dd>Output Y's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>Y_zero_point</tt> (optional) : T</dt>
<dd>Output Y's zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearMul"></a><a name="com.microsoft.qlinearmul">**com.microsoft.QLinearMul**</a>

  Performs element-wise binary multiplication on 8 bit data types (with Numpy-style broadcasting support).
  
  C = ((A - A_zero_point) * (B - B_zero_point)) * (A_scale * B_scale)/C_scale + C_zero_point

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (7 - 8)

<dl>
<dt><tt>A</tt> : T</dt>
<dd>First operand.</dd>
<dt><tt>A_scale</tt> : tensor(float)</dt>
<dd>Input A's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>A_zero_point</tt> (optional) : T</dt>
<dd>Input A zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>B</tt> : T</dt>
<dd>Second operand.</dd>
<dt><tt>B_scale</tt> : tensor(float)</dt>
<dd>Input B's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>B_zero_point</tt> (optional) : T</dt>
<dd>Input B zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>C_scale</tt> : tensor(float)</dt>
<dd>Output scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>C_zero_point</tt> (optional) : T</dt>
<dd>Output zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>C</tt> : T</dt>
<dd>Result, has same element type as two inputs</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit signed and unsigned tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearReduceMean"></a><a name="com.microsoft.qlinearreducemean">**com.microsoft.QLinearReduceMean**</a>

  Computes the mean of the low-precision input tensor's element along the provided axes.
  The resulting tensor has the same rank as the input if keepdims equal 1. If keepdims equal 0,
  then the resulting tensor have the reduced dimension pruned. The above behavior is similar to numpy,
  with the exception that numpy default keepdims to False instead of True.
  Input and Output scales and zero points are used to requantize the output in a new range.
  This helps to improve accuracy as after ReduceMean operation the range of the output is expected to decrease.
  
  ```
  "Output = Dequantize(Input) -> ReduceMean on fp32 data -> Quantize(output)",
  
  ```

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints (required)</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (required)</dt>
<dd>Keep the reduced dimension or not, default 1 mean keep reduced dimension.</dd>
</dl>

#### Inputs (4 - 5)

<dl>
<dt><tt>data</tt> : T</dt>
<dd>An input tensor.</dd>
<dt><tt>data_scale</tt> : tensor(float)</dt>
<dd>Input scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>data_zero_point</tt> (optional) : T</dt>
<dd>Input zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>reduced_scale</tt> : tensor(float)</dt>
<dd>Output scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>reduced_zero_point</tt> (optional) : T</dt>
<dd>Output zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input types to 8 bit signed and unsigned tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearSigmoid"></a><a name="com.microsoft.qlinearsigmoid">**com.microsoft.QLinearSigmoid**</a>

  QLinearSigmoid takes quantized input data (Tensor), and quantize parameter for output, and produces one output data
  (Tensor<T>) where the function `f(x) = quantize(Sigmoid(dequantize(x)))`, is applied to the data tensor elementwise.
  Wwhere the function `Sigmoid(x) = 1 / (1 + exp(-x))` 

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (4 - 5)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor</dd>
<dt><tt>X_scale</tt> : tensor(float)</dt>
<dd>Input X's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>X_zero_point</tt> (optional) : T</dt>
<dd>Input X's zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>Y_scale</tt> : tensor(float)</dt>
<dd>Output Y's scale. It's a scalar, which means a per-tensor/layer quantization.</dd>
<dt><tt>Y_zero_point</tt> (optional) : T</dt>
<dd>Output Y's zero point. Default value is 0 if it's not specified. It's a scalar, which means a per-tensor/layer quantization.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearSoftmax"></a><a name="com.microsoft.qlinearsoftmax">**com.microsoft.QLinearSoftmax**</a>

  QLinearSoftmax computes the normalized exponential values for the given input:
  Softmax(input, axis) = Exp(input) / ReduceSum(Exp(input), axis=axis, keepdims=1)
  The input does not need to explicitly be a 2D vector. The "axis" attribute
  indicates the dimension along which QLinearSoftmax will be performed for onnx v.13+.
  or the dimension coerced to NxD Matrix for onnx v.12-.
  The output tensor has the same shape.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>apply softmax to elements for dimensions axis,or all dims along with axis according to op-version</dd>
<dt><tt>opset</tt> : int (required)</dt>
<dd>opset version of corresponding SoftMax.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input tensor</dd>
<dt><tt>X_scale</tt> : tensor(float)</dt>
<dd>Scale of quantized input 'X'. It must be a scalar.</dd>
<dt><tt>x_zero_point</tt> (optional) : T</dt>
<dd>Zero point tensor for input 'X'.It must be a scalar.</dd>
<dt><tt>y_scale</tt> : tensor(float)</dt>
<dd>Scale of quantized output 'Y'. It must be a scalar.</dd>
<dt><tt>y_zero_point</tt> : T</dt>
<dd>Zero point tensor for output 'Y'. It must be a scalar.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output data tensor from pooling across the input tensor. The output tensor has the same rank as the input. </dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to signed/unsigned int8 tensors.</dd>
</dl>


### <a name="com.microsoft.QLinearWhere"></a><a name="com.microsoft.qlinearwhere">**com.microsoft.QLinearWhere**</a>

  Return elements, either from X or Y, depending on condition.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>condition</tt> : B</dt>
<dd> When True (nonzero), yield x, otherwise yield y</dd>
<dt><tt>X</tt> : T</dt>
<dd>Y's zero point.</dd>
<dt><tt>x_scale</tt> : TF</dt>
<dd>X's scale.</dd>
<dt><tt>x_zero_point</tt> : T</dt>
<dd>X's zero point.</dd>
<dt><tt>Y</tt> : T</dt>
<dd>Y's zero point.</dd>
<dt><tt>y_scale</tt> : TF</dt>
<dd>Y's scale.</dd>
<dt><tt>y_zero_point</tt> : T</dt>
<dd>Y's zero point.</dd>
<dt><tt>z_scale</tt> : TF</dt>
<dd>Z's scale.</dd>
<dt><tt>z_zero_point</tt> : T</dt>
<dd>Z's zero point.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Z</tt> : T</dt>
<dd>Tensor of shape equal to the broadcasted shape of condition, X, and Y</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>B</tt> : tensor(bool)</dt>
<dd>Constrain input and output types to 8 bit signed and unsigned tensors.</dd>
<dt><tt>TF</tt> : tensor(float)</dt>
<dd>Constrain scale types to any float tensor type.</dd>
<dt><tt>T</tt> : tensor(uint8), tensor(int8)</dt>
<dd>Constrain input and output types to 8 bit signed and unsigned tensors.</dd>
</dl>


### <a name="com.microsoft.QMoE"></a><a name="com.microsoft.qmoe">**com.microsoft.QMoE**</a>

  Quantized mixture of experts (MoE).
  
        The quantized weights are stored in column major order per expert.
        The quantization block size can be specified. If not provided, column wise quantization is used.
  
        The formula of linear dequantization of the quantized weights using scale and (optionally) zero-point is:
          dequantized_weight = (quantized_weight - zero_point) * scale
        When zero_point is not provided, the default value is 2^(bits-1): 8 for 4 bits, 128 for 8 bits.
  
        If block_size is provided, both hidden_size and inter_size must be divisible by the block size, and
        the dequantization is performed per block of size block_size along the K (input feature) dimension.
  
        If block_size and zero_point are provided, both hidden_size and inter_size must be divisible by block_size * pack_size,
        where pack_size = 8 / expert_weight_bits.
  
        The SwiGLU (Swish-Gated Linear Unit) activation function is like:
           g = xW + b
           l = xV + c
           G = clamp(g, max=limit)
           L = clamp(l, min=-limit, max=limit)
           swiglu = G * sigmoid(alpha * G) * (L + beta)
        where x is the input, W and V are weight matrices, b and c are bias vectors, and alpha, beta and limit are constant float parameters.
        When swiglu_fusion=0, two GEMMs are not fused, and they are FC1 and FC3 in the inputs.
        When swiglu_fusion=1, two GEMMs are fused so that g and l are computed in a single GEMM (FC1), and g and l are interleaved on each row of size 2 * inter_size.
        When swiglu_fusion=2, two GEMMs are fused, and g and l are concatenated on each row.
        

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation_alpha</tt> : float</dt>
<dd>Alpha parameter used in activation function.</dd>
<dt><tt>activation_beta</tt> : float</dt>
<dd>Beta parameter used in activation function.</dd>
<dt><tt>activation_type</tt> : string</dt>
<dd>Activation function to use. Choose from relu, gelu, silu, swiglu and identity. Default is relu</dd>
<dt><tt>block_size</tt> : int</dt>
<dd>Size of each quantization block along the K (input feature) dimension. Must be power of two and ≥ 16 (e.g., 16, 32, 64, 128). If provided, both hidden_size and inter_size must be divisible by the block size. Otherwise, there is no blocking and a whole column shares one scaling factor. </dd>
<dt><tt>expert_weight_bits</tt> : int</dt>
<dd>Number of bits used in quantized weights. Default is 4 bits</dd>
<dt><tt>k</tt> : int</dt>
<dd>Number of top experts to select from expert pool</dd>
<dt><tt>normalize_routing_weights</tt> : int</dt>
<dd>Whether to normalize routing weights</dd>
<dt><tt>swiglu_fusion</tt> : int</dt>
<dd>0: not fused, 1: fused and interleaved. 2: fused and not interleaved.</dd>
<dt><tt>swiglu_limit</tt> : float</dt>
<dd>The limit used to clamp inputs in SwiGLU. It is infinite when limit is not provided.</dd>
<dt><tt>use_sparse_mixer</tt> : int</dt>
<dd>Whether to use sparse mixer</dd>
</dl>

#### Inputs (7 - 14)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>2D tensor with shape (num_tokens, hidden_size), or 3D tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>router_probs</tt> : T</dt>
<dd>2D tensor with shape (num_tokens, num_experts)</dd>
<dt><tt>fc1_experts_weights</tt> : T1</dt>
<dd>3D tensor with shape (num_experts, fusion_size * inter_size, hidden_size / pack_size), The fusion_size is 2 for fused swiglu, or 1 otherwise. The pack_size is 8 / expert_weight_bits.</dd>
<dt><tt>fc1_scales</tt> : T2</dt>
<dd>2D tensor with shape (num_experts, fusion_size * inter_size), or 3D tensor with shape (num_experts, fusion_size * inter_size, hidden_size / block_size) when block_size is provided.</dd>
<dt><tt>fc1_experts_bias</tt> (optional) : T</dt>
<dd>2D optional tensor with shape (num_experts, fusion_size * inter_size)</dd>
<dt><tt>fc2_experts_weights</tt> : T1</dt>
<dd>3D tensor with shape (num_experts, hidden_size, inter_size / pack_size)</dd>
<dt><tt>fc2_scales</tt> : T2</dt>
<dd>2D tensor with shape (num_experts, hidden_size), or 3D tensor with shape (num_experts, hidden_size, inter_size / block_size) when block_size is provided.</dd>
<dt><tt>fc2_experts_bias</tt> (optional) : T</dt>
<dd>2D optional tensor with shape (num_experts, hidden_size)</dd>
<dt><tt>fc3_experts_weights</tt> (optional) : T1</dt>
<dd>3D optional tensor with shape (num_experts, inter_size, hidden_size / pack_size)</dd>
<dt><tt>fc3_scales</tt> (optional) : T2</dt>
<dd>2D optional tensor with shape (num_experts, inter_size), or 3D optional tensor with shape (num_experts, inter_size, hidden_size / block_size) when block_size is provided.</dd>
<dt><tt>fc3_experts_bias</tt> (optional) : T</dt>
<dd>2D optional tensor with shape (num_experts, inter_size)</dd>
<dt><tt>fc1_zero_points</tt> (optional) : T1</dt>
<dd>2D tensor with shape (num_experts, fusion_size * inter_size / pack_size), or 3D tensor with shape (num_experts, fusion_size * inter_size, hidden_size / block_size / pack_size) when block_size is provided.</dd>
<dt><tt>fc2_zero_points</tt> (optional) : T1</dt>
<dd>2D tensor with shape (num_experts, hidden_size / pack_size), or 3D tensor with shape (num_experts, hidden_size, inter_size / block_size / pack_size) when block_size is provided.</dd>
<dt><tt>fc3_zero_points</tt> (optional) : T1</dt>
<dd>2D optional tensor with shape (num_experts, inter_size / pack_size), or 3D optional tensor with shape (num_experts, inter_size, hidden_size / block_size / pack_size) when block_size is provided.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>output tensor with same shape of input</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(uint8)</dt>
<dd>Constrain weights type to uint8 tensors.</dd>
<dt><tt>T2</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain scales type to float tensors.</dd>
</dl>


### <a name="com.microsoft.QOrderedAttention"></a><a name="com.microsoft.qorderedattention">**com.microsoft.QOrderedAttention**</a>

  Quantized version of simplified Multi-Head Self Attention(using int8 with specific matrix Layout).
  Multi-Head Self Attention that can be either unidirectional (like GPT-2) or bidirectional (like BERT).
  The mask_index input is optional. Besides raw attention mask with shape (batch_size, past_sequence_length + sequence_length)
  or (batch_size, sequence_length, past_sequence_length + sequence_length) with value 0 for masked and 1 otherwise,
  we also support other two formats: When input has right-side padding, mask_index is one dimension with shape (batch_size),
  where value of each element is the end position, or valid length of actual sequence excluding padding. When input has
  left-side padding, mask_index has shape (2 * batch_size), where the values are the exclusive end positions followed by
  the inclusive start positions. When unidirectional is 1, and each token only attend to previous tokens. For GPT-2, both past
  and present state are optional. Present state could appear in output even when past state is not in input.
  Current version does not support past/present, attention_bias and qkv_hidden_sizes.
  TODO: Support them if needed in the future.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>order_input</tt> : int (required)</dt>
<dd>cublasLt order of input matrix. See the schema of QuantizeWithOrder for order definition.</dd>
<dt><tt>order_output</tt> : int (required)</dt>
<dd>cublasLt order of global bias</dd>
<dt><tt>order_weight</tt> : int (required)</dt>
<dd>cublasLt order of weight matrix</dd>
<dt><tt>qkv_hidden_sizes</tt> : list of ints</dt>
<dd>Hidden layer sizes of Q, K, V paths in Attention</dd>
<dt><tt>unidirectional</tt> : int</dt>
<dd>Whether every token can only attend to previous tokens. Default value is 0.</dd>
</dl>

#### Inputs (17 - 20)

<dl>
<dt><tt>input</tt> : Q</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, input_hidden_size)</dd>
<dt><tt>scale_input</tt> : S</dt>
<dd>scale of the input, scalar value (per tensor) currently.</dd>
<dt><tt>scale_Q_gemm</tt> : S</dt>
<dd>scale of the gemm - scalar (per-tensor quantization)</dd>
<dt><tt>scale_K_gemm</tt> : S</dt>
<dd>scale of the gemm - scalar (per-tensor quantization)</dd>
<dt><tt>scale_V_gemm</tt> : S</dt>
<dd>scale of the gemm - scalar (per-tensor quantization)</dd>
<dt><tt>Q_weight</tt> : Q</dt>
<dd>2D input tensor with shape (input_hidden_size, hidden_size), where hidden_size = num_heads * head_size</dd>
<dt><tt>K_weight</tt> : Q</dt>
<dd>2D input tensor with shape (input_hidden_size, hidden_size), where hidden_size = num_heads * head_size</dd>
<dt><tt>V_weight</tt> : Q</dt>
<dd>2D input tensor with shape (input_hidden_size, hidden_size), where hidden_size = num_heads * head_size</dd>
<dt><tt>scale_Q_weight</tt> : S</dt>
<dd>scale of the weight (scalar for per-tensor quantization or 1-D of dims [hidden_size] for per-channel quantization)</dd>
<dt><tt>scale_K_weight</tt> : S</dt>
<dd>scale of the weight (scalar for per-tensor quantization or 1-D of dims [hidden_size] for per-channel quantization)</dd>
<dt><tt>scale_V_weight</tt> : S</dt>
<dd>scale of the weight (scalar for per-tensor quantization or 1-D of dims [hidden_size] for per-channel quantization)</dd>
<dt><tt>Q_bias</tt> : S</dt>
<dd>1D input tensor with shape (hidden_size)</dd>
<dt><tt>K_bias</tt> : S</dt>
<dd>1D input tensor with shape (hidden_size)</dd>
<dt><tt>V_bias</tt> : S</dt>
<dd>1D input tensor with shape (hidden_size)</dd>
<dt><tt>scale_QKT_gemm</tt> (optional) : S</dt>
<dd>scale of the gemm - scalar (per-tensor quantization)</dd>
<dt><tt>scale_QKT_softmax</tt> (optional) : S</dt>
<dd>scale of the softmax result - scalar (per-tensor quantization)</dd>
<dt><tt>scale_values_gemm</tt> : S</dt>
<dd>scale of the gemm - scalar (per-tensor quantization). Also this is the output scale for the operator.</dd>
<dt><tt>mask_index</tt> (optional) : G</dt>
<dd>Attention mask with shape (batch_size, 1, max_sequence_length, max_sequence_length), (batch_size, past_sequence_length + sequence_length)or (batch_size, sequence_length, past_sequence_length + sequence_length), or index with shape (batch_size) or (2 * batch_size).</dd>
<dt><tt>past</tt> (optional) : Q</dt>
<dd>past state for key and value with shape (2, batch_size, num_heads, past_sequence_length, head_size).</dd>
<dt><tt>attention_bias</tt> (optional) : S</dt>
<dd>additional add to QxK' with shape (batch_size or 1, num_heads or 1, sequence_length, total_sequence_length).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : Q</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>Constrain scales to float32 tensors.</dd>
<dt><tt>G</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
</dl>


### <a name="com.microsoft.QOrderedGelu"></a><a name="com.microsoft.qorderedgelu">**com.microsoft.QOrderedGelu**</a>

  Ordered Quantize Gelu.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>order_X</tt> : int</dt>
<dd>cublasLt order of input X. Optional. See the schema of QuantizeWithOrder for order definition.</dd>
<dt><tt>order_Y</tt> : int</dt>
<dd>cublasLt order of matrix Y, must be same as order_X if specified together. Optional.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : Q</dt>
<dd>N-dimensional input A</dd>
<dt><tt>scale_X</tt> : S</dt>
<dd>scale of the input A</dd>
<dt><tt>scale_Y</tt> : S</dt>
<dd>scale of the output Y</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : Q</dt>
<dd>Output of the Gelu</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>Constrain scales to float32</dd>
</dl>


### <a name="com.microsoft.QOrderedLayerNormalization"></a><a name="com.microsoft.qorderedlayernormalization">**com.microsoft.QOrderedLayerNormalization**</a>

  QOrderedLayerNormalization

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>The first normalization dimension: normalization will be performed along dimensions axis : rank(inputs).</dd>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
<dt><tt>order_X</tt> : int</dt>
<dd>cublasLt order of input X. Default is ROW MAJOR. See the schema of QuantizeWithOrder for order definition.</dd>
<dt><tt>order_Y</tt> : int</dt>
<dd>cublasLt order of matrix Y, must be same as order_X. Default is ROW MAJOR.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : Q</dt>
<dd>Input data tensor from the previous layer.</dd>
<dt><tt>scale_X</tt> : S</dt>
<dd>scale of the quantized X</dd>
<dt><tt>scale</tt> : F</dt>
<dd>Scale tensor, i.e., gamma vector.</dd>
<dt><tt>B</tt> (optional) : F</dt>
<dd>Bias tensor.</dd>
<dt><tt>scale_Y</tt> : S</dt>
<dd>scale of the quantized X</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : Q</dt>
<dd>Output data tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>F</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain input gamma and bias could be float16/float tensors. float may get better precision, float16 runs faster.</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>quantization scale must be float tensors.</dd>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>quantization tensor must be int8 tensors.</dd>
</dl>


### <a name="com.microsoft.QOrderedLongformerAttention"></a><a name="com.microsoft.qorderedlongformerattention">**com.microsoft.QOrderedLongformerAttention**</a>

  Quantized version of Longformer Self Attention (using int8 with specific matrix Layout).

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads</dd>
<dt><tt>order_global_weight</tt> : int (required)</dt>
<dd>cublasLt order of weight matrix</dd>
<dt><tt>order_input</tt> : int (required)</dt>
<dd>cublasLt order of input matrix. See the schema of QuantizeWithOrder for order definition.</dd>
<dt><tt>order_output</tt> : int (required)</dt>
<dd>cublasLt order of global bias</dd>
<dt><tt>order_weight</tt> : int (required)</dt>
<dd>cublasLt order of weight matrix</dd>
<dt><tt>window</tt> : int (required)</dt>
<dd>One sided attention windows length W, or half of total window length</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : Q</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, hidden_size), hidden_size = num_heads * head_size</dd>
<dt><tt>scale_input</tt> : S</dt>
<dd>scale of the input</dd>
<dt><tt>weight</tt> : Q</dt>
<dd>2D input tensor with shape (hidden_size, 3 * hidden_size)</dd>
<dt><tt>scale_weight</tt> : S</dt>
<dd>scale of the weight</dd>
<dt><tt>bias</tt> : S</dt>
<dd>1D input tensor with shape (3 * hidden_size), fp32 only currently.</dd>
<dt><tt>scale_bias</tt> : S</dt>
<dd>reserved. (not used as add bias need float value in cublasLt for normal order.)</dd>
<dt><tt>scale_qkv_gemm</tt> : S</dt>
<dd>scale of the output for fused kqv gemm</dd>
<dt><tt>mask</tt> : F</dt>
<dd>Attention mask with shape (batch_size, sequence_length)</dd>
<dt><tt>global_weight</tt> : Q</dt>
<dd>2D input tensor with shape (hidden_size, 3 * hidden_size)</dd>
<dt><tt>scale_global_weight</tt> : S</dt>
<dd>scale of the global_weight</dd>
<dt><tt>global_bias</tt> : S</dt>
<dd>1D input tensor with shape (3 * hidden_size)</dd>
<dt><tt>scale_global_gemm</tt> : S</dt>
<dd>scale of the global_qkv_gemm</dd>
<dt><tt>global</tt> : G</dt>
<dd>Global attention flags with shape (batch_size, sequence_length)</dd>
<dt><tt>scale_output</tt> : S</dt>
<dd>scale of the output</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : Q</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>Constrain scales to float32 tensors.</dd>
<dt><tt>G</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
<dt><tt>F</tt> : tensor(float16)</dt>
<dd>Be compatible with float version.</dd>
</dl>


### <a name="com.microsoft.QOrderedMatMul"></a><a name="com.microsoft.qorderedmatmul">**com.microsoft.QOrderedMatMul**</a>

  Quantize (Int8) MatMul with order. Implement Y = alpha * A * B + bias + beta * C. Matrix A, B, C, Y are all int8 matrix.
  Two type of order combination supported:
    *) When order_B is ORDER_COL, order_A must be ORDER_ROW.
           bias is vector of {#cols of Y} of float32, C should be batch 1/batch_A. B could be of batch 1 or batch_A.
           Note B is reorder to ORDER_COL, or Transposed. Not Transposed first and then Reordered here.
    *) When order_B is specify ORDER_COL4_4R2_8C or ORDER_COL32_2R_4R4, orderA must be ORDER_COL32.
           MatMul will be implemented using alpha(A * B) + beta * C => Y.
           bias is not supported here. B in fact is transposed first then reordered into ORDER_COL4_4R2_8C or ORDER_COL32_2R_4R4 here.
  order_Y and order_C will be same as order_A.
  Support per column quantized weight, ie, scale_B is 1-D vector of size [#cols of matrix B].

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>order_A</tt> : int (required)</dt>
<dd>cublasLt order of matrix A. See the schema of QuantizeWithOrder for order definition.</dd>
<dt><tt>order_B</tt> : int (required)</dt>
<dd>cublasLt order of matrix B</dd>
<dt><tt>order_Y</tt> : int (required)</dt>
<dd>cublasLt order of matrix Y and optional matrix C</dd>
</dl>

#### Inputs (5 - 8)

<dl>
<dt><tt>A</tt> : Q</dt>
<dd>3-dimensional matrix A</dd>
<dt><tt>scale_A</tt> : S</dt>
<dd>scale of the input A.</dd>
<dt><tt>B</tt> : Q</dt>
<dd>2-dimensional matrix B. Transposed if order_B is ORDER_COL.</dd>
<dt><tt>scale_B</tt> : S</dt>
<dd>scale of the input B. Scalar or 1-D float32.</dd>
<dt><tt>scale_Y</tt> : S</dt>
<dd>scale of the output Y.</dd>
<dt><tt>bias</tt> (optional) : S</dt>
<dd>1d bias, not scaled with scale_Y.</dd>
<dt><tt>C</tt> (optional) : Q</dt>
<dd>3d or 2d matrix C. if 2d expand to 3d first. Shape[0] should be 1 or same as A.shape[0] </dd>
<dt><tt>scale_C</tt> (optional) : S</dt>
<dd>scale of the input A.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : Q</dt>
<dd>Matrix multiply results from A * B</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>Constrain bias and scales to float32</dd>
</dl>


### <a name="com.microsoft.QuantizeBFP"></a><a name="com.microsoft.quantizebfp">**com.microsoft.QuantizeBFP**</a>

  The BFP quantization operator. It consumes a full precision tensor and computes an BFP tensor.
  More documentation on the BFP format can be found in this paper: https://www.microsoft.com/en-us/research/publication/pushing-the-limits-of-narrow-precision-inferencing-at-cloud-scale-with-microsoft-floating-point/

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>bfp_type</tt> : int (required)</dt>
<dd>The type of BFP - must match with the BFPType enum</dd>
<dt><tt>block_dim</tt> : int</dt>
<dd>Each bounding box spans this dimension.Typically, the block dimension corresponds to the reduction dimension of the matrix multipication that consumes the output of this operator.For example, for a 2D matrix multiplication A@W, QuantizeBFP(A) would use block_dim 1 and QuantizeBFP(W) would use block_dim 0.The default is the last dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>N-D full precision input tensor to be quantized.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T2</dt>
<dd>1-D, contiguous BFP data</dd>
<dt><tt>shape</tt> : T3</dt>
<dd>Shape of x</dd>
<dt><tt>strides</tt> : T3</dt>
<dd>Strides of x</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain the input to float and bfloat.</dd>
<dt><tt>T2</tt> : tensor(uint8)</dt>
<dd>Constrain y to uint8.</dd>
<dt><tt>T3</tt> : tensor(int64)</dt>
<dd>Constrain shape and strides to uint64.</dd>
</dl>


### <a name="com.microsoft.QuantizeLinear"></a><a name="com.microsoft.quantizelinear">**com.microsoft.QuantizeLinear**</a>

  The linear quantization operator. It consumes a full precision data, a scale, a zero point to compute the low precision / quantized tensor.
  The quantization formula is y = saturate ((x / y_scale) + y_zero_point). For saturation, it saturates to [0, 255] if it's uint8, [-128, 127] if it's int8,
  [0, 65,535] if it's uint16, and [-32,768, 32,767] if it's int16. For (x / y_scale), it's rounding to nearest ties to even.
  Refer to https://en.wikipedia.org/wiki/Rounding for details.
  Scale and zero point must have same shape. They must be either scalar (per tensor) or 1-D tensor (per 'axis').

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axis</tt> : int</dt>
<dd>The axis along which same quantization parameters are applied. It's optional.If it's not specified, it means per-tensor quantization and input 'x_scale' and 'x_zero_point' must be scalars.If it's specified, it means per 'axis' quantization and input 'x_scale' and 'x_zero_point' must be 1-D tensors.</dd>
</dl>

#### Inputs (2 - 3)

<dl>
<dt><tt>x</tt> : T1</dt>
<dd>N-D full precision Input tensor to be quantized.</dd>
<dt><tt>y_scale</tt> : T1</dt>
<dd>Scale for doing quantization to get 'y'. It can be a scalar, which means per-tensor/layer quantization, or a 1-D tensor for per-axis quantization.</dd>
<dt><tt>y_zero_point</tt> (optional) : T2</dt>
<dd>Zero point for doing quantization to get 'y'. Shape must match y_scale. Default is uint8 with zero point of 0 if it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T2</dt>
<dd>N-D quantized output tensor. It has same shape as input 'x'.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain 'x', 'y_scale' to float tensors.</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8), tensor(int16), tensor(uint16), tensor(int4), tensor(uint4)</dt>
<dd>Constrain 'y_zero_point' and 'y' to 8-bit and 16-bit integer tensors.</dd>
</dl>


### <a name="com.microsoft.QuantizeWithOrder"></a><a name="com.microsoft.quantizewithorder">**com.microsoft.QuantizeWithOrder**</a>

  Quantize input matrix to specific layout used in cublaslt.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>order_input</tt> : int (required)</dt>
<dd>cublasLt order of input matrix. ORDER_COL = 0, ORDER_ROW = 1, ORDER_COL32 = 2, ORDER_COL4_4R2_8C = 3, ORDER_COL32_2R_4R4 = 4. Please refer https://docs.nvidia.com/cuda/cublas/index.html#cublasLtOrder_t for their meaning.</dd>
<dt><tt>order_output</tt> : int (required)</dt>
<dd>cublasLt order of output matrix.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : F</dt>
<dd>TODO: input tensor of (ROWS, COLS). if less than 2d, will broadcast to (1, X). If 3d, it is treated as (B, ROWS, COS)</dd>
<dt><tt>scale_input</tt> : S</dt>
<dd>scale of the input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : Q</dt>
<dd>output tensor</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>Q</tt> : tensor(int8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>F</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain to float types</dd>
<dt><tt>S</tt> : tensor(float)</dt>
<dd>Constrain Scale to float32 types</dd>
</dl>


### <a name="com.microsoft.QuickGelu"></a><a name="com.microsoft.quickgelu">**com.microsoft.QuickGelu**</a>

  Compute x * Sigmoid(alpha * x).

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float</dt>
<dd>Alpha value.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>The input data as Tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.Range"></a><a name="com.microsoft.range">**com.microsoft.Range**</a>

  Creates a sequence of numbers that begins at `start` and extends by increments of `delta`
  up to but not including `limit`.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (2 - 3)

<dl>
<dt><tt>start</tt> : T</dt>
<dd>Tensor(scalar, or dims=[1]). First entry in the range.</dd>
<dt><tt>limit</tt> : T</dt>
<dd>Tensor(scalar, or dims=[1]). Upper limit of sequence, exclusive.</dd>
<dt><tt>delta</tt> (optional) : T</dt>
<dd>Tensor(scalar, or dims=[1]). Number that increments start. Defaults to 1.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>1-D Tensor of the range.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(int16), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types.</dd>
</dl>


### <a name="com.microsoft.ReduceSumInteger"></a><a name="com.microsoft.reducesuminteger">**com.microsoft.ReduceSumInteger**</a>

  Computes the sum of the low-precision input tensor's element along the provided axes.
  The resulting tensor has the same rank as the input if keepdims equal 1. If keepdims equal 0,
  then the resulting tensor have the reduced dimension pruned. The above behavior is similar to numpy,
  with the exception that numpy default keepdims to False instead of True.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>axes</tt> : list of ints (required)</dt>
<dd>A list of integers, along which to reduce. The default is to reduce over all the dimensions of the input tensor.</dd>
<dt><tt>keepdims</tt> : int (required)</dt>
<dd>Keep the reduced dimension or not, default 1 mean keep reduced dimension.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>data</tt> : T1</dt>
<dd>An input tensor.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>reduced</tt> : T2</dt>
<dd>Reduced output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input type to 8-bit integer tensor.</dd>
<dt><tt>T2</tt> : tensor(int32), tensor(uint32)</dt>
<dd>Constrain output data type to 32-bit integer tensor.T2 must be tensor(uint32) when T1 is tensor(uint8),or must be tensor(int32) when T1 is tensor(int8).</dd>
</dl>


### <a name="com.microsoft.RelativePositionBias"></a><a name="com.microsoft.relativepositionbias">**com.microsoft.RelativePositionBias**</a>

  Compute binned relative position bias for T5 model. ref: https://arxiv.org/abs/1803.02155v2

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>is_bidirectional</tt> : int</dt>
<dd>Default value is 0.</dd>
<dt><tt>max_distance</tt> : int (required)</dt>
<dd>Max distance</dd>
</dl>

#### Inputs

<dl>
<dt><tt>bias_table</tt> : T</dt>
<dd>2D input tensor with shape (num_buckets, num_heads), COL-major(See UT for example)</dd>
<dt><tt>query_length</tt> : U</dt>
<dd>The length of query. Self Attention requires query_length = key_length</dd>
<dt><tt>key_length</tt> : U</dt>
<dd>The length of key.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>4D output tensor with shape (1, num_heads, sequence_length, sequence_length)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
<dt><tt>U</tt> : tensor(int64)</dt>
<dd>Constrain sequence_length to int tensors.</dd>
</dl>


### <a name="com.microsoft.RemovePadding"></a><a name="com.microsoft.removepadding">**com.microsoft.RemovePadding**</a>

  Compress transformer input by removing paddings. It assumes padding is on the right side of sequence.
  
  The input has padding with shape (batch_size, sequence_length, hidden_size). This will generate two outputs:
  output has shape (total_tokens, hidden_size); token_offset with shape (batch_size, sequence_length).
  
  token_offset has offsets of all non-padding tokens first, then offset of all padding tokens. It is
  a list of batch_size * sequence_length elements, which is reshaped to 2D for convenience of shape inference.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>sequence_token_count</tt> : M</dt>
<dd>Number of non-padding tokens in each sequence with shape (batch_size).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>output tensor with shape (total_tokens, hidden_size)</dd>
<dt><tt>token_offset</tt> : M</dt>
<dd>Offset of non-padding tokens, and those of padding tokens. Its shape is (batch_size, sequence_length)</dd>
<dt><tt>cumulated_seq_len</tt> : M</dt>
<dd>Cumulated sequence lengths. Its shape is (batch_size + 1)</dd>
<dt><tt>max_seq_len</tt> : M</dt>
<dd>Max sequence length without padding. Its shape is (1)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain sequence_token_count and token_offset to integer types</dd>
</dl>


### <a name="com.microsoft.RestorePadding"></a><a name="com.microsoft.restorepadding">**com.microsoft.RestorePadding**</a>

  Restore paddings and fill padding with zeros.
  
  The input has padding with shape (total_tokens, hidden_size) and token_offset with shape (batch_size, sequence_length).
  The output has shape (batch_size, sequence_length, hidden_size).

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>Input tensor with shape (total_tokens, hidden_size)</dd>
<dt><tt>token_offset</tt> : M</dt>
<dd>Offset of non-padding tokens and paddings. Its shape is (batch_size, sequence_length)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain token_offset to integer types</dd>
</dl>


### <a name="com.microsoft.Rfft"></a><a name="com.microsoft.rfft">**com.microsoft.Rfft**</a>

  This function computes the n-point one dimensional Fourier transform for a real-valued input where n is an even number.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>normalized</tt> : int</dt>
<dd>must be 0, normalization currently not supported</dd>
<dt><tt>onesided</tt> : int</dt>
<dd>must be 1, only one sided FFTs supported</dd>
<dt><tt>signal_ndim</tt> : int</dt>
<dd>number of dimensions comprising the signal, collected in reverse order (e.g. 1 = last dimension is the signal)</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input tensor of size n in the signal dim</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>output tensor of size (n//2 + 1) in the signal dim and 2 in the last dimension for the real and complex parts</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(double), tensor(float16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
</dl>


### <a name="com.microsoft.RotaryEmbedding"></a><a name="com.microsoft.rotaryembedding">**com.microsoft.RotaryEmbedding**</a>

  RotaryEmbedding is the implementation of rotary positional embeddings (RoPE). The positions are represented as rotation matrices
  that are multiplied to query and key before the inner product of query and key is taken.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>interleaved</tt> : int</dt>
<dd>Indicates whether the input has real and imaginary parts interleaved. Default value is 0 (False), meaning the first half of the input consists of real values and the second half consists of imaginary values.</dd>
<dt><tt>is_packed_batching</tt> : int</dt>
<dd>ragged batch inputs or not. Default value is 0</dd>
<dt><tt>num_heads</tt> : int</dt>
<dd>Number of attention heads. Default value is 0. Must use with rotary_embedding_dim</dd>
<dt><tt>rotary_embedding_dim</tt> : int</dt>
<dd>Rotary embedding dimension. Default value is 0.</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Custom scale will be used if specified. Default value is 1.0</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>3D tensor with shape (batch_size, sequence_length, hidden_size) or 4D with shape (batch_size, num_heads, sequence_length, head_size)</dd>
<dt><tt>position_ids</tt> : M</dt>
<dd>1D tensor with shape (1) or 2D tensor with shape (batch_size, sequence_length)</dd>
<dt><tt>cos_cache</tt> : T</dt>
<dd>2D tensor with shape (max_sequence_length, head_size / 2) or (max_sequence_length, rotary_embedding_dim / 2)</dd>
<dt><tt>sin_cache</tt> : T</dt>
<dd>2D tensor with shape (max_sequence_length, head_size / 2) or (max_sequence_length, rotary_embedding_dim / 2)</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>tensor with same shape as input.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>M</tt> : tensor(int64)</dt>
<dd>Constrain input and output types to integer tensors</dd>
</dl>


### <a name="com.microsoft.SampleOp"></a><a name="com.microsoft.sampleop">**com.microsoft.SampleOp**</a>

  Sample echo operator.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>input</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint32), tensor(uint64), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double)</dt>
<dd>Constrain to any tensor type. If the dtype attribute is not provided this must be a valid output type.</dd>
</dl>


### <a name="com.microsoft.Sampling"></a><a name="com.microsoft.sampling">**com.microsoft.Sampling**</a>

  Greedy Sampling for text generation.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>custom</tt> : int</dt>
<dd>If 1 custom sampling logic</dd>
<dt><tt>decoder</tt> : graph (required)</dt>
<dd>Decoder subgraph to execute in a loop.</dd>
<dt><tt>decoder_start_token_id</tt> : int</dt>
<dd>The id of the token that indicates decoding starts.</dd>
<dt><tt>encoder</tt> : graph</dt>
<dd>The subgraph for initialization of encoder and decoder. It will be called once before decoder subgraph.</dd>
<dt><tt>eos_token_id</tt> : int (required)</dt>
<dd>The id of the end-of-sequence token</dd>
<dt><tt>filter_value</tt> : float</dt>
<dd>All filtered values will be set to this float value.</dd>
<dt><tt>init_decoder</tt> : graph</dt>
<dd>The subgraph for the first decoding run. It will be called once before `decoder` subgraph. This is relevant only for the GPT2 model. If this attribute is missing, the `decoder` subgraph will be used for all decoding runs</dd>
<dt><tt>min_tokens_to_keep</tt> : int</dt>
<dd>Minimumber of tokens we keep per batch example in the output.</dd>
<dt><tt>model_type</tt> : int</dt>
<dd>Model type: 0 for decoder only like GPT-2; 1 for encoder decoder like Bart</dd>
<dt><tt>no_repeat_ngram_size</tt> : int</dt>
<dd>no repeat ngrams size</dd>
<dt><tt>pad_token_id</tt> : int (required)</dt>
<dd>The id of the padding token</dd>
<dt><tt>presence_penalty</tt> : float</dt>
<dd>Presence penalty for custom sampling</dd>
<dt><tt>temperature</tt> : float</dt>
<dd>The value used to module the next token probabilities.</dd>
<dt><tt>top_p</tt> : float</dt>
<dd>If set to float < 1, only the smallest set of most probable tokens with probabilities that add up to `top_p` or higher are kept for generation.</dd>
<dt><tt>vocab_size</tt> : int</dt>
<dd>Size of the vocabulary. If not provided, it will be inferred from the decoder subgraph's output shape</dd>
</dl>

#### Inputs (2 - 9)

<dl>
<dt><tt>input_ids</tt> : I</dt>
<dd>The sequence used as a prompt for the generation. Shape is (batch_size, sequence_length)</dd>
<dt><tt>max_length</tt> : I</dt>
<dd>The maximum length of the sequence to be generated. Shape is (1)</dd>
<dt><tt>min_length</tt> (optional) : I</dt>
<dd>The minimum length below which the score of eos_token_id is set to -Inf. Shape is (1)</dd>
<dt><tt>repetition_penalty</tt> (optional) : T</dt>
<dd>The parameter for repetition penalty. Default value 1.0 means no penalty. Accepts value > 0.0. Shape is (1)</dd>
<dt><tt>vocab_mask</tt> (optional) : I</dt>
<dd>Mask of vocabulary. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (vocab_size)</dd>
<dt><tt>prefix_vocab_mask</tt> (optional) : I</dt>
<dd>Mask of vocabulary for first step. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (batch_size, vocab_size)</dd>
<dt><tt>attention_mask</tt> (optional) : I</dt>
<dd>Custom attention mask. Shape is (batch_size, sequence_length)</dd>
<dt><tt>presence_mask</tt> (optional) : I</dt>
<dd>Presence penalty mask. Shape is (batch_size, vocab_size)</dd>
<dt><tt>seed</tt> (optional) : I</dt>
<dd>Seed for random number generator. Shape is (1)</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>sequences</tt> : I</dt>
<dd>Word IDs of generated sequences. Shape is (batch_size, max_sequence_length)</dd>
<dt><tt>filtered_logits</tt> (optional) : T</dt>
<dd>Filtered logits as input to the mutinomial function for debug purpose. Shape is (batch_size, vocab_size)</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>I</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
</dl>


### <a name="com.microsoft.SkipGroupNorm"></a><a name="com.microsoft.skipgroupnorm">**com.microsoft.SkipGroupNorm**</a>

  This operator element-wise adds x, skip and bias, then apply group normalization and optional activation.
  
  This operator transforms input according to
    s = x + skip + bias
    y = gamma * (s - mean) / sqrt(variance + epsilon) + beta
  
  The input channels are separated into num_groups groups, each containing num_channels / num_groups channels.
  The num_channels must be divisible by num_groups.
  The mean and standard-deviation of s are calculated separately over the each group.
  The weight and bias are per-channel affine transform parameter vectors of size num_channels.
  
  The activation attribute can be used to enable activation after group normalization.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>activation</tt> : int (required)</dt>
<dd>Activation after group normalization: 0 for None, 1 for SiLU</dd>
<dt><tt>channels_last</tt> : int</dt>
<dd>1 if the input and output are in the NHWC layout, 0 if it is in the NCHW layout. Defaults to 1.</dd>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero</dd>
<dt><tt>groups</tt> : int (required)</dt>
<dd>The number of groups of channels. It should be a divisor of the number of channels C</dd>
</dl>

#### Inputs (4 - 5)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input data tensor. Dimensions are (N x H x W x C) when channels_last is 1  or (N x C x H x W) otherwise, where N is the batch size, C is the number of channels, and H and W are the height and width of the data</dd>
<dt><tt>gamma</tt> : M</dt>
<dd>1D gamma tensor for normalization with shape (C), where C is number of channels</dd>
<dt><tt>beta</tt> : M</dt>
<dd>1D beta tensor for normalization with shape (C), where C is number of channels</dd>
<dt><tt>skip</tt> : T</dt>
<dd>4D or 2D skip tensor. The shape can be (N x H x W x C) or (N x 1 x 1 x C) or (N x C)</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>1D bias tensor. Dimensions are (C), where C is number of channels</dd>
</dl>

#### Outputs (1 - 2)

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>The output tensor of the same shape as X</dd>
<dt><tt>S</tt> (optional) : T</dt>
<dd>The element-wise sum of input x, skip and bias tensors. It has the same shape as X</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain input X, skip, bias and output Y, S types to float tensors.</dd>
<dt><tt>M</tt> : tensor(float16), tensor(float)</dt>
<dd>Constrain gamma and beta to float tensors.</dd>
</dl>


### <a name="com.microsoft.SkipLayerNormalization"></a><a name="com.microsoft.skiplayernormalization">**com.microsoft.SkipLayerNormalization**</a>

  Skip and Layer Normalization Fusion

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
</dl>

#### Inputs (3 - 5)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>skip</tt> : T</dt>
<dd>3D skip tensor with shape (batch_size, sequence_length, hidden_size) or (1, sequence_length, hidden_size) or (sequence_length, hidden_size)</dd>
<dt><tt>gamma</tt> : T</dt>
<dd>1D input tensor with shape (hidden_size)</dd>
<dt><tt>beta</tt> (optional) : T</dt>
<dd>1D skip tensor with shape (hidden_size</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>1D bias tensor with shape (hidden_size</dd>
</dl>

#### Outputs (1 - 4)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)</dd>
<dt><tt>mean</tt> (optional) : U</dt>
<dd>Saved mean used during training to speed up gradient computation</dd>
<dt><tt>inv_std_var</tt> (optional) : U</dt>
<dd>Saved inverse standard variance used during training to speed up gradient computation.</dd>
<dt><tt>input_skip_bias_sum</tt> (optional) : T</dt>
<dd>Sum of the input and skip inputs (and bias if it exists) with shape (batch_size, sequence_length, hidden_size).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float or half tensors.</dd>
<dt><tt>U</tt> : tensor(float)</dt>
<dd>Constrain mean and inv_std_var to float tensors.</dd>
</dl>


### <a name="com.microsoft.SkipSimplifiedLayerNormalization"></a><a name="com.microsoft.skipsimplifiedlayernormalization">**com.microsoft.SkipSimplifiedLayerNormalization**</a>

  Skip and Root Mean Square Layer Normalization

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
</dl>

#### Inputs (3 - 4)

<dl>
<dt><tt>input</tt> : T</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, hidden_size)Or 2D input tensor with shape (token_count, hidden_size)</dd>
<dt><tt>skip</tt> : T</dt>
<dd>3D input tensor with shape (batch_size, sequence_length, hidden_size)Or 2D input tensor with shape (token_count, hidden_size)</dd>
<dt><tt>gamma</tt> : T</dt>
<dd>1D input tensor with shape (hidden_size)</dd>
<dt><tt>bias</tt> (optional) : T</dt>
<dd>1D bias tensor with shape (hidden_size</dd>
</dl>

#### Outputs (1 - 4)

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, hidden_size)Or 2D output tensor with shape (token_count, hidden_size)</dd>
<dt><tt>mean</tt> (optional) : U</dt>
<dd>Saved mean used during training to speed up gradient computation</dd>
<dt><tt>inv_std_var</tt> (optional) : U</dt>
<dd>Saved inverse standard variance used during training to speed up gradient computation.</dd>
<dt><tt>input_skip_bias_sum</tt> (optional) : T</dt>
<dd>Sum of the input and skip inputs (and bias if it exists)with shape (batch_size, sequence_length, hidden_size) or (token_count, hidden_size).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output to float tensors.</dd>
<dt><tt>U</tt> : tensor(float)</dt>
<dd>Constrain mean and inv_std_var to float tensors.</dd>
</dl>


### <a name="com.microsoft.Snpe"></a><a name="com.microsoft.snpe">**com.microsoft.Snpe**</a>

  Onnx node for SNPE.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>DLC</tt> : string (required)</dt>
<dd>payload of the SNPE DLC file.</dd>
<dt><tt>notes</tt> : string</dt>
<dd>(Optional) Some notes for the model</dd>
<dt><tt>snpe_version</tt> : string</dt>
<dd>(Optional) SNPE version used to convert the model.</dd>
<dt><tt>target_device</tt> : string</dt>
<dd>(Optional) Target device like CPU, DSP, etc.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>inputs</tt> (variadic) : T</dt>
<dd>List of tensors for SNPE DLC input</dd>
</dl>

#### Outputs (1 - &#8734;)

<dl>
<dt><tt>outputs</tt> (variadic) : T</dt>
<dd>One or more outputs, list of tensors for DLC output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(float)</dt>
<dd>Constrain input and output types to uint8, uint16, float tensors.</dd>
</dl>


### <a name="com.microsoft.SparseAttention"></a><a name="com.microsoft.sparseattention">**com.microsoft.SparseAttention**</a>

  Block Sparse Attention used in Phi-3-small (https://arxiv.org/pdf/2404.14219).
  
  It is inspired by Sparse Transformers (https://arxiv.org/pdf/1904.10509) and BigBird (https://arxiv.org/pdf/2007.14062).
  
  block_mask can be used to configure sparse layout for different head.
  When number of sparse layout is 1, all heads have same sparse layout. Otherwise, different layouts are used cyclically.
  For example, given 4 layouts (S0, S1, S2, S3), 8 heads will have layouts like (S0, S1, S2, S3, S0, S1, S2, S3).
  
  The block_row_indices and block_col_indices are the CSR representation of block mask. The block_col_indices might contain
  paddings at the right side when different layout has different number of non-zeros in block mask.
  
  An example of block mask with 2 layouts where each layout is 4 x 4 blocks:
    [[[1, 0, 0, 0],
      [1, 1, 0, 0],
      [0, 1, 1, 0],
      [0, 1, 1, 1]],
  
     [[1, 0, 0, 0],
      [1, 1, 0, 0],
      [1, 1, 1, 0],
      [1, 0, 1, 1]]]
  
  The corresponding CSR format:
    block_col_indices = [[0,  0,  1,  1,  2,  1,  2,  3, -1], [0,  0,  1,  0,  1,  2,  0,  2,  3]]
    block_row_indices = [[0, 1, 3, 5, 8], [0, 1, 3, 6, 9]]
  
  When do_rotary is True, cos_cache and sin_cache are required. Note that the maximum sequence length supported by cos
  or sin cache can be different from the maximum sequence length used by kv cache.
  
  Only supports unidirectional attention with cache of past key and value in linear buffers.
  
  For performance, past_key and present_key share same memory buffer, and past_value and present_value too.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>do_rotary</tt> : int</dt>
<dd>Whether to use rotary position embedding. Default value is 0.</dd>
<dt><tt>kv_num_heads</tt> : int (required)</dt>
<dd>Number of attention heads for key and value</dd>
<dt><tt>num_heads</tt> : int (required)</dt>
<dd>Number of attention heads for query</dd>
<dt><tt>rotary_interleaved</tt> : int</dt>
<dd>Rotary use interleaved pattern or not. Default value is 0.</dd>
<dt><tt>scale</tt> : float</dt>
<dd>Scaling factor applied prior to softmax. The default value is 1/sqrt(head_size)</dd>
<dt><tt>sparse_block_size</tt> : int (required)</dt>
<dd>Number of tokens per sparse block. Choices: 16, 32, 64, 128</dd>
</dl>

#### Inputs (9 - 11)

<dl>
<dt><tt>query</tt> : T</dt>
<dd>Query with shape (batch_size, sequence_length, num_heads * head_size), or packed QKV with shape is(batch_size, sequence_length, d) where d is (num_heads + 2 * kv_num_heads) * head_size.</dd>
<dt><tt>key</tt> (optional) : T</dt>
<dd>Key with shape (batch_size, sequence_length, kv_num_heads * head_size)</dd>
<dt><tt>value</tt> (optional) : T</dt>
<dd>Value with shape (batch_size, sequence_length, kv_num_heads * head_size)</dd>
<dt><tt>past_key</tt> : T</dt>
<dd>Key cache with shape (batch_size, kv_num_heads, max_cache_sequence_length, head_size)</dd>
<dt><tt>past_value</tt> : T</dt>
<dd>Value cache with shape (batch_size, kv_num_heads, max_cache_sequence_length, head_size)</dd>
<dt><tt>block_row_indices</tt> : M</dt>
<dd>The row indices of CSR format of block mask with shape (num_layout, max_blocks + 1).The num_heads is divisible by num_layout, and max_blocks is max_sequence_length / sparse_block_size.</dd>
<dt><tt>block_col_indices</tt> : M</dt>
<dd>The col indices of CSR format of block mask with shape (num_layout, max_nnz_blocks).The max_nnz_blocks is the maximum number of non-zeros per layout in block mask.</dd>
<dt><tt>total_sequence_length</tt> : M</dt>
<dd>Scalar tensor of maximum total sequence length (past_sequence_length + sequence_length) among keys.</dd>
<dt><tt>key_total_sequence_lengths</tt> : M</dt>
<dd>1D tensor with shape (batch_size) where each value is total sequence length of key excluding paddings.</dd>
<dt><tt>cos_cache</tt> (optional) : T</dt>
<dd>Cos cache of rotary with shape (max_rotary_sequence_length, head_size / 2).</dd>
<dt><tt>sin_cache</tt> (optional) : T</dt>
<dd>Sin cache of rotary with shape (max_rotary_sequence_length, head_size / 2).</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>3D output tensor with shape (batch_size, sequence_length, num_heads * head_size)</dd>
<dt><tt>present_key</tt> : T</dt>
<dd>Updated key cache with shape (batch_size, kv_num_heads, max_cache_sequence_length, head_size).</dd>
<dt><tt>present_value</tt> : T</dt>
<dd>Updated value cache with shape (batch_size, kv_num_heads, max_cache_sequence_length, head_size).</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16), tensor(bfloat16)</dt>
<dd>Constrain input and output to float tensors.</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain integer type.</dd>
</dl>


### <a name="com.microsoft.SparseToDenseMatMul"></a><a name="com.microsoft.sparsetodensematmul">**com.microsoft.SparseToDenseMatMul**</a>

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of the input tensors.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed on the last two dimensions before doing multiplication</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed on the last two dimensions before doing multiplication</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>2-dimensional sparse matrix A. Either COO or CSR format</dd>
<dt><tt>B</tt> : T1</dt>
<dd>N-dimensional dense matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>Matrix multiply results</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : sparse_tensor(float), sparse_tensor(double), sparse_tensor(int64), sparse_tensor(int32), sparse_tensor(uint64), sparse_tensor(uint32)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T1</tt> : tensor(float), tensor(double), tensor(int64), tensor(int32), tensor(uint64), tensor(uint32)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.Tokenizer"></a><a name="com.microsoft.tokenizer">**com.microsoft.Tokenizer**</a>

  Tokenizer divides each string in X into a vector of strings along the last axis. Allowed input shapes are [C] and [N, C].
    If the maximum number of tokens found per input string is D, the output shape would be [N, C, D] when input shape is [N, C].
    Similarly, if input shape is [C] then the output should be [C, D]. Tokenizer has two different operation modes.
    The first mode is selected when "tokenexp" is not set and "separators" is set. If "tokenexp" is set and "separators" is not set,
    the second mode will be used. The first mode breaks each input string into tokens by matching and removing separators.
    "separators" is a list of strings which are regular expressions. "tokenexp" is a single regular expression.
    Let's assume "separators" is [" "] and consider an example.
    If input is
    ["Hello World", "I love computer science !"] whose shape is [2],
    then the output would be
   [["Hello", "World", padvalue, padvalue, padvalue],
   ["I", "love", "computer", "science", "!"]]
   whose shape is [2, 5] because you can find at most 5 tokens per input string.
   Note that the input at most can have two axes, so 3-D and higher dimension are not supported.
   If "separators" contains a single empty string, the Tokenizer will enter into character tokenezation mode. This means all strings
   will be broken part into individual characters.
   For each input string, the second mode searches matches of "tokenexp" and each match will be a token in Y.
   The matching of "tokenexp" is conducted greedily (i.e., a match should be as long as possible).
   This operator searches for the first match starting from the beginning of the considered string,
   and then launches another search starting from the first remained character after the first matched token.
   If no match found, this operator will remove the first character from the remained string and do another search.
   This procedure will be repeated until reaching the end of the considered string.
    Let's consider another example to illustrate the effect of setting "mark" to true.
    If input is ["Hello", "World"],
    then the corresponding output would be [0x02, "Hello", "World", 0x03].
    This implies that if mark is true, [C]/[N, C] - input's output shape becomes [C, D+2]/[N, C, D+2].
  If tokenizer removes the entire content of [C]-input, it will produce [[]].
  I.e. the output shape should be [C][0] or [N][C][0] if input shape was [N][C].
  If the tokenizer receives empty input of [0] then the output is [0] if empty input
  of [N, 0] then [N, 0].

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>mark</tt> : int (required)</dt>
<dd>Boolean whether to mark the beginning/end character with start of text character (0x02)/end of text character (0x03).</dd>
<dt><tt>mincharnum</tt> : int (required)</dt>
<dd>Minimum number of characters allowed in the output. For example, if mincharnum is 2, tokens such as "A" and "B" would be ignored</dd>
<dt><tt>pad_value</tt> : string (required)</dt>
<dd>The string used to pad output tensors when the tokens extracted doesn't match the maximum number of tokens found. If start/end markers are needed, padding will appear outside the markers.</dd>
<dt><tt>separators</tt> : list of strings</dt>
<dd>an optional list of strings attribute that contains a list of separators - regular expressions to match separators Two consecutive segments in X connected by a separator would be divided into two tokens. For example, if the input is "Hello World!" and this attribute contains only one space character, the corresponding output would be ["Hello", "World!"]. To achieve character-level tokenization, one should set the 'separators' to [""], which contains an empty string.</dd>
<dt><tt>tokenexp</tt> : string</dt>
<dd>An optional string. Token's regular expression in basic POSIX format (pubs.opengroup.org/onlinepubs/9699919799/basedefs/V1_chap09.html#tag_09_03). If set, tokenizer may produce tokens matching the specified pattern. Note that one and only of 'tokenexp' and 'separators' should be set.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Strings to tokenize</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Tokenized strings</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(string)</dt>
<dd>Input/Output is a string tensor</dd>
</dl>


### <a name="com.microsoft.TorchEmbedding"></a><a name="com.microsoft.torchembedding">**com.microsoft.TorchEmbedding**</a>

  Based on Torch operator Embedding, creates a lookup table of embedding vectors of fixed size,
         for a dictionary of fixed size.
        

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs (2 - 4)

<dl>
<dt><tt>weight</tt> : T</dt>
<dd>The embedding matrix of size N x M. 'N' is equal to the maximum possible index + 1, and 'M' is equal to the embedding size</dd>
<dt><tt>indices</tt> : tensor(int64)</dt>
<dd>Long tensor containing the indices to extract from embedding matrix.</dd>
<dt><tt>padding_idx</tt> (optional) : tensor(int64)</dt>
<dd>A 0-D scalar tensor. If specified, the entries at `padding_idx` do not contribute to the gradient; therefore, the embedding vector at `padding_idx` is not updated during training, i.e. it remains as a fixed pad.</dd>
<dt><tt>scale_grad_by_freq</tt> (optional) : tensor(bool)</dt>
<dd>A 0-D bool tensor. If given, this will scale gradients by the inverse of frequency of the indices (words) in the mini-batch. Default  is ``False``</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of the same type as the input tensor. Shape of the output is * x M, where '*' is the shape of input indices, and 'M' is the embedding size.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64)</dt>
<dd>Constrain input and output types to all numeric tensors.</dd>
</dl>


### <a name="com.microsoft.TransposeMatMul"></a><a name="com.microsoft.transposematmul">**com.microsoft.TransposeMatMul**</a>

  Duplicate of FusedMatMul. Going forward FusedMatMul should be used. This OP will be supported for backward compatibility.
  Matrix product that behaves like numpy.matmul: https://docs.scipy.org/doc/numpy-1.13.0/reference/generated/numpy.matmul.html

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>alpha</tt> : float</dt>
<dd>Scalar multiplier for the product of the input tensors.</dd>
<dt><tt>transA</tt> : int</dt>
<dd>Whether A should be transposed on the last two dimensions before doing multiplication</dd>
<dt><tt>transB</tt> : int</dt>
<dd>Whether B should be transposed on the last two dimensions before doing multiplication</dd>
</dl>

#### Inputs

<dl>
<dt><tt>A</tt> : T</dt>
<dd>N-dimensional matrix A</dd>
<dt><tt>B</tt> : T</dt>
<dd>N-dimensional matrix B</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Matrix multiply results</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
</dl>


### <a name="com.microsoft.Trilu"></a><a name="com.microsoft.trilu">**com.microsoft.Trilu**</a>

  Returns the upper or lower triangular part of a 2-D matrix, or batches of 2-D matrices. If the attribute "upper" is set to true,
        the upper triangular matrix is retained. Lower triangular matrix is retained otherwise. Default value for upper is true.
        Trilu takes one input tensor of shape [*, N, M], where * is zero or more batch dimensions. The upper triangular part consists
        of the elements on and above the given diagonal (k). The lower triangular part consists of elements on and below the diagonal.
        All other elements in the matrix are set to zero.
        If k = 0, the triangular part on and above/below the main diagonal is retained.
        If upper is set to true, a positive k retains the upper triangular matrix excluding k diagonals above
        the main diagonal. A negative k value includes as many diagonals below the main diagonal.
        If upper is set to false, a positive k retains the lower triangular matrix including k diagonals above
        the main diagonal. A negative k value excludes as many diagonals below the main diagonal.
        

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>upper</tt> : int</dt>
<dd>Boolean. Indicates whether upper or lower part of matrix is retained. Default is true.</dd>
</dl>

#### Inputs (1 - 2)

<dl>
<dt><tt>X</tt> : T</dt>
<dd>Input tensor of rank 2 or higher.</dd>
<dt><tt>k</tt> (optional) : tensor(int64)</dt>
<dd>A 0-D tensor containing a single value corresponding to the number diagonals above or the main diagonal to exclude or include.Default value is 0 if it's not specified.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T</dt>
<dd>Output tensor of the same type and shape as the input tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16), tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bool)</dt>
<dd>Constrain input and output types to all numeric tensors and bool tensors.</dd>
</dl>


### <a name="com.microsoft.UnfoldTensor"></a><a name="com.microsoft.unfoldtensor">**com.microsoft.UnfoldTensor**</a>

  Returns a tensor which contains all slices of size `size` from input tensor in the dimension `dim`. Step between two slices is given by `step`. If `sizedim` is the size of dimension `dim` for input tensor, the size of dimension `dim` in the returned tensor will be `(sizedim - size) / step + 1`. An additional dimension of size `size` is appended in the returned tensor.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>dim</tt> : int</dt>
<dd>specify the dimension to unfold</dd>
<dt><tt>size</tt> : int (required)</dt>
<dd>specify the size</dd>
<dt><tt>step</tt> : int</dt>
<dd>specify the step.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input</tt> : T</dt>
<dd>input tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>Output tensor.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(bfloat16), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Allow inputs and outputs to be any kind of tensor.</dd>
</dl>


### <a name="com.microsoft.Unique"></a><a name="com.microsoft.unique">**com.microsoft.Unique**</a>

  Finds all the unique values (deduped list) present in the given input tensor.
                This operator returns 3 outputs.
                The first output tensor 'uniques' contains all of the unique elements of the input,
                sorted in the same order that they occur in the input.
                The second output tensor 'idx' is the same size as the input and it contains the index
                of each value of the input in 'uniques'.
                The third output tensor 'counts' contains the count of each element of 'uniques' in the input.
                Example:
                  input_x = [2, 1, 1, 3, 4, 3]
                  output_uniques = [2, 1, 3, 4]
                  output_idx = [0, 1, 1, 2, 3, 2]
                  output_counts = [1, 2, 2, 1]
                

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Inputs

<dl>
<dt><tt>x</tt> : T</dt>
<dd>A 1-D input tensor that is to be processed.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>y</tt> : T</dt>
<dd>A 1-D tensor of the same type as 'x' containing all the unique values in 'x' sorted in the same order that they occur in the input 'x'</dd>
<dt><tt>idx</tt> : tensor(int64)</dt>
<dd>A 1-D INT64 tensor of the same size as 'x' containing the indices for each value in 'x' in the output 'uniques'</dd>
<dt><tt>counts</tt> : tensor(int64)</dt>
<dd>A 1-D INT64 tensor containing the the count of each element of 'uniques' in the input 'x'</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(uint8), tensor(uint16), tensor(uint32), tensor(uint64), tensor(int8), tensor(int16), tensor(int32), tensor(int64), tensor(float16), tensor(float), tensor(double), tensor(string), tensor(bool), tensor(complex64), tensor(complex128)</dt>
<dd>Input can be of any tensor type.</dd>
</dl>


### <a name="com.microsoft.WhisperBeamSearch"></a><a name="com.microsoft.whisperbeamsearch">**com.microsoft.WhisperBeamSearch**</a>

  Beam Search for whisper model, especially with cross_qk features etc.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>beginning_timestamp_token_id</tt> : int</dt>
<dd>The id of the first timestamp</dd>
<dt><tt>decoder</tt> : graph (required)</dt>
<dd>Decoder subgraph to execute in a loop.</dd>
<dt><tt>decoder_output_cross_qk</tt> : int</dt>
<dd>If nozero, decoder subgraph contains output Q*K from cross attentions. Default 0.</dd>
<dt><tt>decoder_start_token_id</tt> : int</dt>
<dd>The id of the token that indicates decoding starts (i.e. the start of transcription token id)</dd>
<dt><tt>early_stopping</tt> : int</dt>
<dd>early stop or not</dd>
<dt><tt>encoder</tt> : graph</dt>
<dd>The subgraph for initialization of encoder and decoder. It will be called once before decoder subgraph.</dd>
<dt><tt>eos_token_id</tt> : int (required)</dt>
<dd>The id of the end-of-sequence token</dd>
<dt><tt>init_decoder</tt> : graph</dt>
<dd>The subgraph for the first decoding run. It will be called once before `decoder` subgraph. This is relevant only for the GPT2 model. If this attribute is missing, the `decoder` subgraph will be used for all decoding runs</dd>
<dt><tt>model_type</tt> : int</dt>
<dd>Must be 2 for whisper</dd>
<dt><tt>no_repeat_ngram_size</tt> : int</dt>
<dd>no repeat ngrams size</dd>
<dt><tt>no_speech_token_id</tt> : int</dt>
<dd>The token in whisper model that marks all sequence empty. With this model, whisper could output no_speech_prob after. Default -1.</dd>
<dt><tt>no_timestamps_token_id</tt> : int</dt>
<dd>The id of the token that indicates no timestamps</dd>
<dt><tt>pad_token_id</tt> : int (required)</dt>
<dd>The id of the padding token</dd>
<dt><tt>start_of_lm_token_id</tt> : int</dt>
<dd>The id of the token that indicates LM starts</dd>
<dt><tt>transcribe_token_id</tt> : int</dt>
<dd>The id of the transcribe task</dd>
<dt><tt>translate_token_id</tt> : int</dt>
<dd>The id of the translate task</dd>
<dt><tt>vocab_size</tt> : int</dt>
<dd>Size of the vocabulary. If not provided, it will be inferred from the decoder subgraph's output shape</dd>
</dl>

#### Inputs (5 - 15)

<dl>
<dt><tt>input_ids</tt> : F</dt>
<dd>The sequence used as a prompt for the generation in the encoder subgraph. Shape is (batch_size, sequence_length)</dd>
<dt><tt>max_length</tt> : I</dt>
<dd>The maximum length of the sequence to be generated. Shape is (1)</dd>
<dt><tt>min_length</tt> (optional) : I</dt>
<dd>The minimum length below which the score of eos_token_id is set to -Inf. Shape is (1)</dd>
<dt><tt>num_beams</tt> : I</dt>
<dd>Number of beams for beam search. 1 means no beam search. Shape is (1)</dd>
<dt><tt>num_return_sequences</tt> : I</dt>
<dd>The number of returned sequences in the batch. Shape is (1)</dd>
<dt><tt>length_penalty</tt> (optional) : T</dt>
<dd>Exponential penalty to the length. Default value 1.0 means no penalty. Value > 1.0 encourages longer sequences, while values < 1.0 produces shorter sequences. Shape is (1,)</dd>
<dt><tt>repetition_penalty</tt> (optional) : T</dt>
<dd>The parameter for repetition penalty. Default value 1.0 means no penalty. Accepts value > 0.0. Shape is (1)</dd>
<dt><tt>vocab_mask</tt> (optional) : M</dt>
<dd>Mask of vocabulary. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (vocab_size)</dd>
<dt><tt>prefix_vocab_mask</tt> (optional) : M</dt>
<dd>Mask of vocabulary for first step. Words that masked with 0 are not allowed to be generated, and 1 is allowed. Shape is (batch_size, vocab_size)</dd>
<dt><tt>attention_mask</tt> (optional) : I</dt>
<dd>Custom attention mask. Shape is (batch_size, sequence_length)</dd>
<dt><tt>decoder_input_ids</tt> (optional) : I</dt>
<dd>The forced input id sequence for the decoder subgraph. Shape is (batch_size, initial_sequence_length)</dd>
<dt><tt>logits_processor</tt> (optional) : I</dt>
<dd>Specific logits processor for different types of beamsearch models. Default value 0 means no specific logit processor. Accepts value >= 0. Shape is (1)</dd>
<dt><tt>cross_qk_layer_head</tt> (optional) : I</dt>
<dd>Only keep this list of (layer, head) of QK in the final cross_qk output when use_cross_qk is set. Default collect all its shape is (number of (layer, head) to keep, 2), i.e., [[layer_id1, head_id1], [layer_id2, head_id2]......]</dd>
<dt><tt>extra_decoding_ids</tt> (optional) : I</dt>
<dd>Part of the decoder_input_ids that we need cross qk for it. it is of shape  (batch_size, extra_decoding_ids_len).In such case, we should remove this from the tail of the decoder_input_ids, and put it here. ids < 0 in it (for multiple batch) are treated as stop of the extra_decoding_ids for corresponding batch.</dd>
<dt><tt>temperature</tt> (optional) : T</dt>
<dd>Temperature value to apply to logits processing during this execution's decoding. Shape is (1)</dd>
</dl>

#### Outputs (1 - 5)

<dl>
<dt><tt>sequences</tt> : I</dt>
<dd>Word IDs of generated sequences. Shape is (batch_size, num_return_sequences, max_sequence_length)</dd>
<dt><tt>sequences_scores</tt> (optional) : T</dt>
<dd>Final beam score of the generated sequences. Shape is (batch_size, num_return_sequences)</dd>
<dt><tt>scores</tt> (optional) : T</dt>
<dd>Processed beam scores for each vocabulary token at each generation step. Beam scores consisting of log softmax scores for each vocabulary token and sum of log softmax of previously generated tokens in this beam. Shape is (max_length - sequence_length, batch_size, num_beams, vocab_size)</dd>
<dt><tt>cross_qk</tt> (optional) : V</dt>
<dd>Output the accumulated stacked Q*K in cross attentions. Let H = number of Head of cross attention, F = the frames or kv-seq-len of the cross attention input, T = real decoded token length, L = number of layers, B = batch size, R = num_return_sequences. It then should return tensor of shape [B, R, L*H, T, F]. If cross_qk_layer_head is given, shape is [B, R, cross_qk_layer_head.shape[0], T, F]</dd>
<dt><tt>non_speech_probs</tt> (optional) : T</dt>
<dd>For whisper model, output the probabilities from logits after encoder and context decoding for the no_speech_token_id. The shape of non_speech_probs is [B]</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(float), tensor(float16)</dt>
<dd>Constrain to float tensors.</dd>
<dt><tt>F</tt> : tensor(float), tensor(int32), tensor(float16)</dt>
<dd>Constrain input type to float or int tensors.</dd>
<dt><tt>I</tt> : tensor(int32)</dt>
<dd>Constrain to integer types</dd>
<dt><tt>M</tt> : tensor(int32)</dt>
<dd>Constrain mask to integer types</dd>
<dt><tt>V</tt> : tensor(float)</dt>
<dd>Constrain cross_qk to float32 tensors.</dd>
</dl>


### <a name="com.microsoft.WordConvEmbedding"></a><a name="com.microsoft.wordconvembedding">**com.microsoft.WordConvEmbedding**</a>

  The WordConvEmbedding takes in a batch of sequence words and embed each word to a vector.

#### Version

This version of the operator has been available since version 1 of the 'com.microsoft' operator set.

#### Attributes

<dl>
<dt><tt>char_embedding_size</tt> : int</dt>
<dd>Integer representing the embedding vector size for each char.If not provide, use the char embedding size of embedding vector.</dd>
<dt><tt>conv_window_size</tt> : int</dt>
<dd>This operator applies convolution to word from left to right with window equal to conv_window_size and stride to 1.Take word 'example' for example, with conv_window_size equal to 2, conv is applied to [ex],[xa], [am], [mp]...If not provide, use the first dimension of conv kernel shape.</dd>
<dt><tt>embedding_size</tt> : int</dt>
<dd>Integer representing the embedding vector size for each word.If not provide, use the filter size of conv weight</dd>
</dl>

#### Inputs

<dl>
<dt><tt>Sequence</tt> : T</dt>
<dd>Specify batchs of sequence words to embedding</dd>
<dt><tt>W</tt> : T1</dt>
<dd>Specify weights of conv</dd>
<dt><tt>B</tt> : T1</dt>
<dd>Specify bias of conv</dd>
<dt><tt>C</tt> : T1</dt>
<dd>Specify embedding vector of char</dd>
</dl>

#### Outputs

<dl>
<dt><tt>Y</tt> : T1</dt>
<dd>output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T</tt> : tensor(int32)</dt>
<dd>Constrain to tensor(int32).</dd>
<dt><tt>T1</tt> : tensor(float)</dt>
<dd>Constrain to tensor(float).</dd>
</dl>


### <sub>experimental</sub> <a name="com.microsoft.IsAllFinite"></a><a name="com.microsoft.isallfinite">**com.microsoft.IsAllFinite**</a>

  IsAllFinite

#### Version

No versioning maintained for experimental ops.
#### Attributes

<dl>
<dt><tt>isinf_only</tt> : int</dt>
<dd>If true, check only for Inf, -Inf.</dd>
<dt><tt>isnan_only</tt> : int</dt>
<dd>If true, check only for NaN.</dd>
</dl>

#### Inputs (1 - &#8734;)

<dl>
<dt><tt>input</tt> (variadic) : V</dt>
<dd>Input tensors to check.</dd>
</dl>

#### Outputs

<dl>
<dt><tt>output</tt> : T</dt>
<dd>The output scalar. Its value is true if all input tensors are finite. Otherwise, the output value would be false.</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>V</tt> : tensor(float16), tensor(float), tensor(double), tensor(bfloat16)</dt>
<dd>Constrain input and output types to float tensors.</dd>
<dt><tt>T</tt> : tensor(bool)</dt>
<dd>Constrain the output to a boolean tensor.</dd>
</dl>


### <sub>experimental</sub> <a name="com.microsoft.QEmbedLayerNormalization"></a><a name="com.microsoft.qembedlayernormalization">**com.microsoft.QEmbedLayerNormalization**</a>

  QEmbedLayerNormalization is the quantized fusion of embedding layer in BERT model, with optional mask processing.
  The embedding layer takes input_ids (word IDs) and segment_ids (sentence IDs) to look up word_embedding, position_embedding,
  and segment_emedding; the embeddings are added then applied layer normalization using gamma and beta tensors. The input_ids
  and segment_ids remain int32. All embeddings, gamma, and beta tensors are converted to int8/uint8. The last input mask is optional.
  If mask is provided, mask index (that is position of first 0 in mask, or number of words will be calculated.

#### Version

No versioning maintained for experimental ops.
#### Attributes

<dl>
<dt><tt>epsilon</tt> : float</dt>
<dd>The epsilon value to use to avoid division by zero.</dd>
</dl>

#### Inputs

<dl>
<dt><tt>input_ids</tt> : T1</dt>
<dd>2D words IDs with shape (batch_size, sequence_length)</dd>
<dt><tt>segment_ids</tt> (optional) : T1</dt>
<dd>2D segment IDs with shape (batch_size, sequence_length)</dd>
<dt><tt>word_embedding_quant</tt> : T2</dt>
<dd>2D with shape (,hidden_size)</dd>
<dt><tt>position_embedding_quant</tt> : T2</dt>
<dd>2D with shape (, hidden_size)</dd>
<dt><tt>segment_embedding</tt> (optional) : T2</dt>
<dd>2D with shape (, hidden_size)</dd>
<dt><tt>gamma_quant</tt> : T2</dt>
<dd>1D gamma tensor for layer normalization with shape (hidden_size)</dd>
<dt><tt>beta_quant</tt> : T2</dt>
<dd>1D beta tensor for layer normalization  with shape (hidden_size)</dd>
<dt><tt>mask</tt> (optional) : T1</dt>
<dd>Mask</dd>
<dt><tt>word_embedding_scale</tt> : T</dt>
<dd>Scale for word embeddings</dd>
<dt><tt>position_embedding_scale</tt> : T</dt>
<dd>Scale for position embeddings</dd>
<dt><tt>segment_embedding_scale</tt> (optional) : T</dt>
<dd>Scale for segment embeddings</dd>
<dt><tt>gamma_scale</tt> : T</dt>
<dd>Scale for 1D gamma tensor</dd>
<dt><tt>beta_scale</tt> : T</dt>
<dd>Scale for 1D beta tensor</dd>
<dt><tt>word_embedding_zero_point</tt> : T2</dt>
<dd>Zero point for word embeddings</dd>
<dt><tt>position_embedding_zero_point</tt> : T2</dt>
<dd>Zero point for position embeddings</dd>
<dt><tt>segment_embedding_zero_point</tt> (optional) : T2</dt>
<dd>Zero Point for segment embeddings</dd>
<dt><tt>gamma_zero_point</tt> : T2</dt>
<dd>Zero Point for 1D gamma tensor</dd>
<dt><tt>beta_zero_point</tt> : T2</dt>
<dd>Zero Point for 1D beta tensor</dd>
</dl>

#### Outputs

<dl>
<dt><tt>layernorm_out</tt> : T</dt>
<dd>LayerNorm Output</dd>
<dt><tt>mask_index_out</tt> : T1</dt>
<dd>Mask Index Output</dd>
</dl>

#### Type Constraints

<dl>
<dt><tt>T1</tt> : tensor(int32)</dt>
<dd>Constrain mask index to integer types</dd>
<dt><tt>T2</tt> : tensor(int8), tensor(uint8)</dt>
<dd>Constrain input and output types to int8 tensors.</dd>
<dt><tt>T</tt> : tensor(float)</dt>
<dd>Constrain input and output types to float32 tensors.</dd>
</dl>


