# MakeACopy – Accessibility‑Modus

Dieser Leitfaden erklärt Schritt für Schritt, wie du den Accessibility‑Modus in MakeACopy benutzt. Der Modus ist speziell dafür gedacht, die Kamera ohne visuelle Hinweise zu bedienen – mit klaren akustischen Ansagen und leichter haptischer Rückmeldung.

Hinweis: Die Begriffe „Tippen“, „Doppeltippen“ und „Taste“ beziehen sich auf die übliche Bedienung mit einem Screenreader wie TalkBack.

---

Inhalt
- Was macht der Accessibility‑Modus?
- Accessibility‑Modus einschalten
- Kamera bedienen (Ablauf)
- Rückmeldungen im Detail
- Auslösen mit Lautstärketasten
- Verhalten bei wenig Licht (Taschenlampe)
- Erfolg- und Fehlermeldungen nach der Aufnahme
- Tipps für gute Ergebnisse
- Datenschutz und Offline‑Betrieb
- Häufige Fragen (FAQ)

---

Was macht der Accessibility‑Modus?
- Fokus auf Audio/Haptik. Die visuelle Ecken‑Überlagerung folgt der Option „Ecken‑Vorschau/Analyse“.
- Spricht wichtige Zustände an, z. B. „Kamera bereit“, „Schwaches Licht“, „Dokument erkannt – bereit zum Aufnehmen“.
- Gibt bei Bedarf Ausrichtungs‑Hinweise, z. B. „Nach links bewegen“, „Nach oben bewegen“, „Näher ran“, „Kippen nach vorn“.
- Erlaubt das Auslösen über die Hardware‑Lautstärketasten, damit du nicht auf eine kleine Schaltfläche zielen musst.
- Funktioniert vollständig offline – keine Datenverbindung, kein Upload.

Accessibility‑Modus einschalten
1) Öffne in der Kamera unten die Schaltfläche „Optionen“ (deutsch: „Optionen“, englisch: „Options“).
2) Aktiviere die Checkbox „Accessibility Mode“.
3) Bestätige mit „Bestätigen/Confirm“.

Ab jetzt:
- Du erhältst gesprochene Hinweise und kurze Haptik. Wenn du in den Optionen „Ecken‑Vorschau/Analyse“ aktivierst, wird die Ecken‑Überlagerung angezeigt; ansonsten bleibt sie verborgen.

Kamera bedienen (Ablauf)
1) Kamera öffnen: Nach der Initialisierung hörst du die Ansage „Kamera bereit. Doppeltippe Scan zum Aufnehmen.“
2) Ausrichten: Bewege das Gerät über dem Dokument. Das System analysiert fortlaufend das Kamerabild.
3) Gutes Framing erkannt: Sobald das Dokument stabil und gut erkannt ist, hörst du einen kurzen Bestätigungston, eine leichte Vibration und die Ansage „Dokument erkannt – bereit zum Aufnehmen.“
4) Auslösen: 
   - Doppeltippe die Schaltfläche „Scan“ ODER
   - Drücke eine der beiden Lautstärketasten (siehe Abschnitt unten).

Rückmeldungen im Detail
- Kamera bereit: Gesprochen, sobald die Kamera startet.
- Dokument erkannt (stabil):
  - Kurzer Ton
  - Leichte Haptik
  - Gesprochene Ansage „Dokument erkannt – bereit zum Aufnehmen.“
  - Hinweis: Diese Signale sind zeitlich gedrosselt, damit sie sich nicht ständig wiederholen.
- Schwaches Licht: Statt eines Pop‑up‑Dialogs hörst du „Schwaches Licht erkannt. Doppeltippe Taschenlampe zum Einschalten.“
- Taschenlampe umschalten: Beim Ein‑ oder Ausschalten hörst du „Taschenlampe an/aus“.

 Ausrichtungs‑Hinweise (Beispiele)
 - Bewegung:
   - „Nach links bewegen“ / „Nach rechts bewegen“
   - „Nach oben bewegen“ / „Nach unten bewegen“
 - Abstand:
   - „Näher ran“ / „Weiter weg“
   - „Näher ran. Dokument ist zu weit entfernt." (wenn das Dokument erkannt wurde, aber zu klein im Bild ist)
 - Kippen (Neigung):
   - „Kippen nach links“ / „Kippen nach rechts“
   - „Kippen nach vorn“ / „Kippen nach hinten“
 - Ausrichtung ok: „Dokument ausgerichtet“

 Hinweise zur Frequenz:
 - Die Ansagen sind bewusst ruhig: Es wird erst nach kurzer Stabilität gesprochen (Hysterese) und frühestens etwa alle 1–1,5 Sekunden (Rate‑Limit).
 - „OK“ (ausgerichtet) wird in der Regel nur bei Übergang in einen guten Zustand oder nach längerer Stille erneut angesagt, um Wiederholungen zu vermeiden.

Auslösen mit Lautstärketasten
- Wenn der Accessibility‑Modus aktiv ist, kannst du mit Lautstärke‑Lauter oder ‑Leiser auslösen.
- Die App unterdrückt dabei die eigentliche Lautstärkeänderung und löst stattdessen die Aufnahme aus.
- Es gibt eine kurze Vibrationsrückmeldung beim Drücken.
- Eingaben sind entprellt: Mehrfaches schnelles Drücken innerhalb von ca. 0,8 Sekunden löst nicht mehrfach aus.
- Während eine Aufnahme verarbeitet wird, sind Tastendrücke gesperrt, damit nichts durcheinander gerät.

Verhalten bei wenig Licht (Taschenlampe)
- Erkennt die App wenig Licht, wird im Accessibility‑Modus keine blockierende Abfrage angezeigt.
- Stattdessen hörst du die gesprochene Empfehlung, die Taschenlampe einzuschalten.
- Doppeltippe die „Taschenlampe“‑Schaltfläche, um sie zu aktivieren/deaktivieren. Du hörst „Taschenlampe an“ bzw. „Taschenlampe aus“.


Erfolg- und Fehlermeldungen nach der Aufnahme
- Erfolgreich gespeichert: „Bild aufgenommen.“ plus eine kurze Vibration.
- Aufnahme fehlgeschlagen: „Aufnahme fehlgeschlagen.“ – du kannst anschließend erneut auslösen.


Tipps für gute Ergebnisse
- Abstand: Halte das Gerät so, dass das Dokument vollständig im Bild ist (meist 20–40 cm über dem Blatt).
- Stabilität: Ein kurzer Moment ruhiges Halten hilft der Erkennung.
- Ausrichtung: Falls möglich, richte das Gerät parallel zur Dokumentfläche aus.
- Licht: Bei Schatten oder sehr wenig Licht die Taschenlampe einschalten.

Datenschutz und Offline‑Betrieb
- MakeACopy verarbeitet Bilder lokal auf deinem Gerät.
- Es findet kein Hochladen oder Teilen im Accessibility‑Modus statt. Keine Internetverbindung nötig.

Häufige Fragen (FAQ)
Siehe auch: Website‑FAQ → Scannen (Kamera): docs/index_de.html#faq-scanning
F: Ich höre die „Dokument erkannt“‑Hinweise sehr häufig.
A: Die App begrenzt Wiederholungen bereits. Bewege das Gerät leicht weg und richte es dann erneut aus. Beim stabilen Erkennen kommt ein Ton + Vibration + Ansage.

F: Die Lautstärketasten ändern trotzdem die Lautstärke.
A: Das sollte im Accessibility‑Modus während der Kameravorschau nicht passieren. Stelle sicher, dass der Accessibility‑Modus aktiv ist und die Kamera sichtbar ist. Während der Bildverarbeitung sind Tastendrücke gesperrt.

F: Es ist sehr dunkel, und die Erkennung gelingt nicht.
A: Schalte die Taschenlampe ein. Achte darauf, das Dokument möglichst schattenfrei zu beleuchten.


F: Muss die visuelle „Ecken‑Vorschau“ (Analyse) aktiviert sein, damit der Accessibility‑Modus funktioniert?
A: Nein. Der Accessibility‑Modus führt die dafür nötige Analyse intern aus – auch wenn die visuelle Analyse‑Option ausgeschaltet ist. Die App analysiert die Frames weiterhin für Audio/Haptik.

F: Wenn sowohl „Ecken‑Vorschau/Analyse“ als auch der Accessibility‑Modus aktiviert sind – ist die Kameravorschau sichtbar?
A: Ja. Die normale Kameravorschau bleibt sichtbar. Ist „Ecken‑Vorschau/Analyse“ eingeschaltet, wird die Ecken‑Überlagerung auch im Accessibility‑Modus angezeigt. Die Analyse läuft in jedem Fall im Hintergrund für Scoring/Feedback.

F: Funktioniert der Accessibility‑Modus auch ohne TalkBack?
A: Teilweise. Gesprochene Ausgaben erfordern einen aktiven Screenreader (z. B. TalkBack oder „Vorlesen/Select‑to‑Speak“). Ohne Screenreader erhältst du weiterhin Töne und leichte Haptik, aber keine Sprachausgabe.

<a id="guide-de-directional-hints-landscape"></a>
F: Was bedeuten „links/rechts/oben/unten“, wenn ich das Gerät im Querformat halte?
A: Hinweis zur Gerätehaltung (Querformat): Die Kameraansicht der App bleibt im Hochformat (Portrait). Die Richtungs‑Hinweise („links/rechts/oben/unten“) beziehen sich auf die aufrecht ausgerichtete Vorschau.

Wenn du das Telefon seitlich hältst, kann es je nach Gerät/Android‑Version sein,
- dass die Hinweise weiterhin wie im Hochformat gemeint sind (weil die Oberfläche nicht ins Querformat wechselt), oder
- dass die Analyse‑Achsen intern mit der Display‑Ausrichtung mitgehen.

Wenn dir „links/rechts/oben/unten“ unlogisch vorkommt, richte das Telefon wieder ins Hochformat aus oder drehe es um 180° und prüfe, ob die Hinweise dann besser passen.

<a id="guide-de-orientation-tip"></a>
F: Gibt die App einen Tipp, ob Hoch- oder Querformat besser ist?
A: Ja. Im Accessibility‑Modus kann die App einen Hinweis geben, ob Hoch‑ oder Querformat für die aktuelle Seite sinnvoller wirkt.

Der Hinweis wird nur gegeben, wenn
- die Schätzung ausreichend sicher ist (Konfidenz ≥ 0,30) und
- aktuell kein plausibles Dokument erkannt wird (damit die normalen Ausrichtungs‑Hinweise nicht überlagert werden).

Damit es ruhig bleibt, wird der Hinweis über dieselbe Guidance‑Logik wie die anderen Ansagen geglättet (kurze Stabilität über mehrere Frames) und zeitlich begrenzt (Rate‑Limit). Du hörst dann z. B. „Das sieht nach Hochformat aus …“ oder „… nach Querformat …“. Die normalen Richtungs‑Hinweise bleiben unverändert.

F: Was bedeutet der Framing-/Qualitäts‑Score?
A: Während des Ausrichtens kann der Accessibility‑Modus einen Prozentwert (0–100 %) ansagen. Dieser Wert ist ein „Confidence“-Indikator der aktuellen Eckenerkennung: Er basiert auf (a) dem Flächenanteil des erkannten Vierecks im Bild, (b) wie rechteckig die Ecken sind (Winkel näher an 90°), und (c) wie symmetrisch gegenüberliegende Kantenlängen sind.

Wichtig: Die Stabilität über mehrere Frames wird separat genutzt, um Ansagen ruhiger zu machen – sie ist nicht Teil dieses Prozentwerts. Wenn der Wert unter ca. 20 % liegt, behandelt die App das als „Kein Dokument erkannt“.

F: Wie kann ich den Score verbessern?
A: Nutze gleichmäßiges, helles Licht und vermeide Blendungen; halte das Telefon parallel zur Seite; lasse alle vier Ecken mit einem kleinen Rand sichtbar; wenn du zu nah dran bist, gehe ein Stück zurück und schneide später zu; lege das Papier auf einen kontrastreichen, matten Hintergrund; halte kurz ruhig, damit sich die Erkennung stabilisiert; wähle eine passende Ausrichtung (A4/Letter: meist Hochformat).

Hinweis: Eine ausführlichere Erklärung mit Beispielen findest du auf der Website: docs/index.html → FAQ → „Scanning (Camera)“.

<a id="guide-de-move-back"></a>
F: Ich höre ständig „Weiter weg/Move back“.
A: Die App unterdrückt Entfernungs‑Hinweise, wenn kein plausibler Dokument‑Kandidat erkannt wird, und bremst Wiederholungen. Verbessere die Beleuchtung (Taschenlampe einschalten, falls nötig), nimm die komplette Seite mit kleinem Rand ins Bild und halte kurz ruhig, damit sich die Erkennung stabilisieren kann.

<a id="guide-de-ready-decision"></a>
F: Wie entscheidet die App, wann ein Dokument „bereit zur Aufnahme" ist?
A: Die App sucht nach einer plausiblen Dokumentform (einem Viereck) und prüft, ob diese für einen kurzen Moment stabil bleibt. Erst dann spielt sie einen kurzen Ton + leichte Vibration ab und sagt „Dokument erkannt – bereit zum Aufnehmen."

Wenn die Erkennung instabil ist (z. B. weil du dich bewegst, die Seite teilweise außerhalb des Bildes ist oder die Beleuchtung schwierig ist), hörst du stattdessen Richtungshinweise.

—

Technischer Hinweis (für Mitwirkende)

Eine detaillierte Erklärung des zugrundeliegenden Konzepts „Plausibilität + Framing‑Metriken + Stabilität" (einschließlich Spec‑Sheet und QA‑Szenarien) findest du in: `docs/accessibility_mode_docquad_concept.md`.

—

Kontakt
Wenn etwas unklar ist oder du Verbesserungsvorschläge für die Barrierefreiheit hast, freuen wir uns über Feedback in den App‑Store‑Bewertungen oder im Projekt‑Repository.
