@TestOn('vm')
library;

import 'dart:io';
import 'dart:isolate';

import 'package:path/path.dart' as p;
import 'package:test/test.dart';
import 'package:timezone/tzdata.dart' as tzdata;

void main() {
  test('Read US/Eastern 2014h tzfile', () async {
    var packageUri = Uri(scheme: 'package', path: 'timezone/timezone.dart');
    var packagePath = p.dirname(
        p.dirname((await Isolate.resolvePackageUri(packageUri))!.path));
    var locationDir = p.join(packagePath, 'test');
    var rawData =
        await File(p.join(locationDir, 'data/US/Eastern')).readAsBytes();
    final loc = tzdata.Location.fromBytes('US/Eastern', rawData);

    expect(loc.name, equals('US/Eastern'));
    expect(loc.abbreviations, equals(['LMT', 'EDT', 'EST', 'EWT', 'EPT']));
    expect(loc.isStd, equals([0, 0, 0, 0, 1]));
    expect(loc.isUtc, equals([0, 0, 0, 0, 1]));
    expect(loc.leapAt, equals(<int>[]));
    expect(loc.leapDiff, equals(<int>[]));

    expect(
        loc.transitionAt,
        equals([
          -576460752303423488,
          -2717650800,
          -1633280400,
          -1615140000,
          -1601830800,
          -1583690400,
          -1570381200,
          -1551636000,
          -1536512400,
          -1523210400,
          -1504458000,
          -1491760800,
          -1473008400,
          -1459706400,
          -1441558800,
          -1428256800,
          -1410109200,
          -1396807200,
          -1378659600,
          -1365357600,
          -1347210000,
          -1333908000,
          -1315155600,
          -1301853600,
          -1283706000,
          -1270404000,
          -1252256400,
          -1238954400,
          -1220806800,
          -1207504800,
          -1189357200,
          -1176055200,
          -1157302800,
          -1144605600,
          -1125853200,
          -1112551200,
          -1094403600,
          -1081101600,
          -1062954000,
          -1049652000,
          -1031504400,
          -1018202400,
          -1000054800,
          -986752800,
          -968000400,
          -955303200,
          -936550800,
          -923248800,
          -905101200,
          -891799200,
          -880218000,
          -769395600,
          -765396000,
          -747248400,
          -733946400,
          -715798800,
          -702496800,
          -684349200,
          -671047200,
          -652899600,
          -639597600,
          -620845200,
          -608148000,
          -589395600,
          -576093600,
          -557946000,
          -544644000,
          -526496400,
          -513194400,
          -495046800,
          -481744800,
          -463597200,
          -447271200,
          -431542800,
          -415821600,
          -400093200,
          -384372000,
          -368643600,
          -352922400,
          -337194000,
          -321472800,
          -305744400,
          -289418400,
          -273690000,
          -257968800,
          -242240400,
          -226519200,
          -210790800,
          -195069600,
          -179341200,
          -163620000,
          -147891600,
          -131565600,
          -116442000,
          -100116000,
          -84387600,
          -68666400,
          -52938000,
          -37216800,
          -21488400,
          -5767200,
          9961200,
          25682400,
          41410800,
          57736800,
          73465200,
          89186400,
          104914800,
          120636000,
          126687600,
          152085600,
          162370800,
          183535200,
          199263600,
          215589600,
          230713200,
          247039200,
          262767600,
          278488800,
          294217200,
          309938400,
          325666800,
          341388000,
          357116400,
          372837600,
          388566000,
          404892000,
          420015600,
          436341600,
          452070000,
          467791200,
          483519600,
          499240800,
          514969200,
          530690400,
          544604400,
          562140000,
          576054000,
          594194400,
          607503600,
          625644000,
          638953200,
          657093600,
          671007600,
          688543200,
          702457200,
          719992800,
          733906800,
          752047200,
          765356400,
          783496800,
          796806000,
          814946400,
          828860400,
          846396000,
          860310000,
          877845600,
          891759600,
          909295200,
          923209200,
          941349600,
          954658800,
          972799200,
          986108400,
          1004248800,
          1018162800,
          1035698400,
          1049612400,
          1067148000,
          1081062000,
          1099202400,
          1112511600,
          1130652000,
          1143961200,
          1162101600,
          1173596400,
          1194156000,
          1205046000,
          1225605600,
          1236495600,
          1257055200,
          1268550000,
          1289109600,
          1299999600,
          1320559200,
          1331449200,
          1352008800,
          1362898800,
          1383458400,
          1394348400,
          1414908000,
          1425798000,
          1446357600,
          1457852400,
          1478412000,
          1489302000,
          1509861600,
          1520751600,
          1541311200,
          1552201200,
          1572760800,
          1583650800,
          1604210400,
          1615705200,
          1636264800,
          1647154800,
          1667714400,
          1678604400,
          1699164000,
          1710054000,
          1730613600,
          1741503600,
          1762063200,
          1772953200,
          1793512800,
          1805007600,
          1825567200,
          1836457200,
          1857016800,
          1867906800,
          1888466400,
          1899356400,
          1919916000,
          1930806000,
          1951365600,
          1962860400,
          1983420000,
          1994310000,
          2014869600,
          2025759600,
          2046319200,
          2057209200,
          2077768800,
          2088658800,
          2109218400,
          2120108400,
          2140668000
        ]));
    expect(
        loc.transitionZone,
        equals([
          0,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          3,
          4,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2,
          1,
          2
        ]));
  });
}
