/*
 * Copyright (C) 2021 Bernhard Rauch.
 *
 * This file is part of Mooltifill.
 *
 * Mooltifill is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * Mooltifill is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Mooltifill.  If not, see <https://www.gnu.org/licenses/>.
 */

package de.mathfactory.mooltifill;

enum class MooltipassCommand(val cmd: Int) {
    EXPORT_FLASH_START(0x8A),
    EXPORT_FLASH(0x8B),
    EXPORT_FLASH_END(0x8C),
    IMPORT_FLASH_BEGIN(0x8D),
    IMPORT_FLASH(0x8E),
    IMPORT_FLASH_END(0x8F),
    EXPORT_EEPROM_START(0x90),
    EXPORT_EEPROM(0x91),
    EXPORT_EEPROM_END(0x92),
    IMPORT_EEPROM_BEGIN(0x93),
    IMPORT_EEPROM(0x94),
    IMPORT_EEPROM_END(0x95),
    ERASE_EEPROM(0x96),
    ERASE_FLASH(0x97),
    ERASE_SMC(0x98),
    DRAW_BITMAP(0x99),
    SET_FONT(0x9A),
    USB_KEYBOARD_PRESS(0x9B),
    STACK_FREE(0x9C),
    CLONE_SMARTCARD(0x9D),
    DEBUG_MINI(0xA0),
    PING_MINI(0xA1),
    DEBUG_BLE(0x8000),
    PING_BLE(0x0001),
    VERSION(0xA2),
    CONTEXT(0xA3),
    GET_LOGIN(0xA4),
    GET_PASSWORD(0xA5),
    SET_LOGIN(0xA6),
    SET_PASSWORD(0xA7),
    CHECK_PASSWORD(0xA8),
    ADD_CONTEXT(0xA9),
    SET_BOOTLOADER_PWD(0xAA),
    JUMP_TO_BOOTLOADER(0xAB),
    GET_RANDOM_NUMBER_MINI(0xAC),
    START_MEMORYMGMT_MINI(0xAD),
    GET_RANDOM_NUMBER_BLE(0x0008),
    START_MEMORYMGMT_BLE(0x0009),
    IMPORT_MEDIA_START(0xAE),
    IMPORT_MEDIA(0xAF),
    IMPORT_MEDIA_END(0xB0),
    SET_MOOLTIPASS_PARM(0xB1),
    GET_MOOLTIPASS_PARM(0xB2),
    RESET_CARD_MINI(0xB3),
    RESET_CARD_BLE(0x000E),
    READ_CARD_LOGIN(0xB4),
    READ_CARD_PASS(0xB5),
    SET_CARD_LOGIN(0xB6),
    SET_CARD_PASS(0xB7),
    ADD_UNKNOWN_CARD(0xB8),
    MOOLTIPASS_STATUS_MINI(0xB9),
    MOOLTIPASS_STATUS_BLE(0x0011),
    FUNCTIONAL_TEST_RES(0xBA),
    SET_DATE_MINI(0xBB),
    SET_DATE_BLE(0x0004),
    SET_UID(0xBC),
    GET_UID(0xBD),
    SET_DATA_SERVICE(0xBE),
    ADD_DATA_SERVICE(0xBF),
    WRITE_32B_IN_DN(0xC0),
    READ_32B_IN_DN(0xC1),
    GET_CUR_CARD_CPZ_MINI(0xC2),
    CANCEL_USER_REQUEST_MINI(0xC3),
    PLEASE_RETRY_MINI(0xC4),
    READ_FLASH_NODE_MINI(0xC5),
    GET_CUR_CARD_CPZ_BLE(0x000B),
    CANCEL_USER_REQUEST_BLE(0x0005),
    PLEASE_RETRY_BLE(0x0002),
    READ_FLASH_NODE_BLE(0x0102),
    WRITE_FLASH_NODE(0xC6),
    GET_FAVORITE(0xC7),
    SET_FAVORITE(0xC8),
    GET_STARTING_PARENT_MINI(0xC9),
    GET_STARTING_PARENT_BLE(0x0100),
    SET_STARTING_PARENT(0xCA),
    GET_CTRVALUE_MINI(0xCB),
    GET_CTRVALUE_BLE(0x0109),
    SET_CTRVALUE(0xCC),
    ADD_CARD_CPZ_CTR(0xCD),
    GET_CARD_CPZ_CTR(0xCE),
    CARD_CPZ_CTR_PACKET(0xCF),
    GET_30_FREE_SLOTS(0xD0),
    GET_DN_START_PARENT(0xD1),
    SET_DN_START_PARENT(0xD2),
    END_MEMORYMGMT_MINI(0xD3),
    END_MEMORYMGMT_BLE(0x0101),
    SET_USER_CHANGE_NB(0xD4),
    GET_DESCRIPTION(0xD5),
    GET_USER_CHANGE_NB_MINI(0xD6),
    GET_USER_CHANGE_NB_BLE(0x000A),
    GET_AVAILABLE_USERS_MINI(0xD7),
    SET_DESCRIPTION(0xD8),
    LOCK_DEVICE_MINI(0xD9),
    LOCK_DEVICE_BLE(0x0010),
    GET_SERIAL(0xDA),

    CMD_DBG_MESSAGE_BLE(0x8000),
    GET_PLAT_INFO_BLE(0x0003),
    STORE_CREDENTIAL_BLE(0x0006),
    GET_CREDENTIAL_BLE(0x0007),
    GET_DEVICE_SETTINGS_BLE(0x000C),
    SET_DEVICE_SETTINGS_BLE(0x000D),
    GET_AVAILABLE_USERS_BLE(0x000F),
    CHECK_CREDENTIAL_BLE(0x0012),
    GET_USER_SETTINGS_BLE(0x0013),
    GET_USER_CATEGORIES_BLE(0x0014),
    SET_USER_CATEGORIES_BLE(0x0015),
    GET_DEVICE_SN(0x0038),
    CMD_DBG_OPEN_DISP_BUFFER_BLE(0x8001),
    CMD_DBG_SEND_TO_DISP_BUFFER_BLE(0x8002),
    CMD_DBG_CLOSE_DISP_BUFFER_BLE(0x8003),
    CMD_DBG_ERASE_DATA_FLASH_BLE(0x8004),
    CMD_DBG_IS_DATA_FLASH_READY_BLE(0x8005),
    CMD_DBG_DATAFLASH_WRITE_256B_BLE(0x8006),
    CMD_DBG_REBOOT_TO_BOOTLOADER_BLE(0x8007),
    CMD_DBG_GET_ACC_32_SAMPLES_BLE(0x8008),
    CMD_DBG_FLASH_AUX_MCU_BLE(0x8009),
    CMD_DBG_GET_PLAT_INFO_BLE(0x800A),
    CMD_DBG_REINDEX_BUNDLE_BLE(0x800B);

    companion object {
        private val map = MooltipassCommand.values().associateBy(MooltipassCommand::cmd)
        fun fromInt(type: Int) = map[type]
    }
}
