package de.k4ever.k4android.fragments;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import android.app.Activity;
import android.content.SharedPreferences;
import android.database.Cursor;
import android.graphics.Color;
import android.os.Bundle;
import android.preference.PreferenceManager;
import android.support.v4.app.ListFragment;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.SimpleCursorAdapter;
import android.support.v4.widget.SimpleCursorAdapter.ViewBinder;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.widget.ListView;
import android.widget.TextView;
import de.k4ever.k4android.R;
import de.k4ever.k4android.database.KassenContentProvider;
import de.k4ever.k4android.database.KassenSQLiteHelper.VirtualTransactions;
import de.k4ever.k4android.database.KassenUpdateDatasets;
import de.k4ever.k4android.database.KassenUpdateDatasets.RequestType;

public class VirtualsListFragment extends SwipeRefreshListFragment
implements LoaderManager.LoaderCallbacks<Cursor> {
	private SimpleCursorAdapter mAdapter;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	@Override public void onActivityCreated(Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
		setEmptyText(getString(R.string.please_update));

		mAdapter = new SimpleCursorAdapter(getActivity(),
				R.layout.listitem_virtuals, null,
				new String[] { 
			VirtualTransactions.COLUMN_RECIPIENT,
			VirtualTransactions.COLUMN_DATETIME,
			VirtualTransactions.COLUMN_COMMENT,
			VirtualTransactions.COLUMN_AMOUNT},
			new int[] {
			R.id.participant,
			R.id.datetime,
			R.id.comment,
			R.id.amount
		}, 0);
		mAdapter.setViewBinder(new ViewBinder() {
			@Override
			public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
				final SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(getActivity());
				final String receiver = cursor.getString(cursor.getColumnIndex(VirtualTransactions.COLUMN_RECIPIENT));
				final String sender = cursor.getString(cursor.getColumnIndex(VirtualTransactions.COLUMN_USER));
				final String owner = prefs.getString("pref_username", "");

				switch(view.getId()) {
				
				case R.id.datetime:
					final long datetime = cursor.getLong(columnIndex);
					final String date = DateFormat.
							getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT, Locale.GERMANY).
							format(new Date(datetime));
					((TextView)view).setText(date);
					return true;
				case R.id.amount:
					final double amount = cursor.getDouble(columnIndex);
					((TextView)view).setText(String.format(getString(R.string.currency_format), amount));

					if(receiver.equals(owner)) {
						((TextView)view).setTextColor(Color.rgb(0, 128, 0));
					} else {
						((TextView)view).setTextColor(Color.RED);
					}
					return true;
				case R.id.participant:
					if(receiver.equals(owner)) {
						((TextView)view).setText(sender);
					} else {
						((TextView)view).setText(receiver);
					}
					return true;
				default:
					return false;
				}
			}
		});

		setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
			@Override
			public void onRefresh() {
				if (!isRefreshing())
					setRefreshing(true);

				new KassenUpdateDatasets(getActivity()) {
					@Override
					protected void onPostExecute(Void result) {
						super.onPostExecute(result);

						setRefreshing(false);
					}
				}.execute(RequestType.VIRTUALS);
			}
		});

		setListAdapter(mAdapter);
		setListShown(false);
		getLoaderManager().initLoader(0, null, this);
	}

	@Override
	public void onListItemClick(ListView l, View v, int position, long id) {
		VirtualsFragment fragment = (VirtualsFragment)getFragmentManager()
				.findFragmentById(R.id.fragment_virtuals);
		if (fragment != null && fragment.isInLayout()) {
			fragment.setFields(
					((TextView)v.findViewById(R.id.participant)).getText(), 
					((TextView)v.findViewById(R.id.comment)).getText());
		}
	}

	@Override
	public Loader<Cursor> onCreateLoader(int id, Bundle args) {
		return new CursorLoader(getActivity(), 
				KassenContentProvider.CONTENT_VIRTUALS, 
				null, null, null, 
				VirtualTransactions.COLUMN_DATETIME + " DESC");
	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
		mAdapter.swapCursor(data);

		if (isResumed()) {
			setListShown(true);
		} else {
			setListShownNoAnimation(true);
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> arg0) {
		mAdapter.swapCursor(null);
	}
}
