package de.k4ever.k4android.fragments;

import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Map;

import android.util.Log;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import de.k4ever.k4android.database.KassenUpdateDatasets;
import de.k4ever.k4android.utils.KassenHttpUtils;

import android.app.ProgressDialog;
import android.os.Bundle;
import android.support.v4.app.Fragment;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.Menu;
import android.view.MenuInflater;
import android.view.MenuItem;
import android.view.View;
import android.view.ViewGroup;
import android.view.inputmethod.EditorInfo;
import android.widget.Button;
import android.widget.EditText;
import android.widget.TextView;
import android.widget.TextView.OnEditorActionListener;
import android.widget.Toast;
import de.k4ever.k4android.R;
import de.k4ever.k4android.utils.KassenConfig;
import org.json.JSONException;
import org.json.JSONObject;

public class VirtualsFragment extends Fragment {
	EditText mSum, mRecipient, mComment;

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View view = inflater.inflate(R.layout.layout_virtuals, container, false);

		mSum = (EditText)view.findViewById(R.id.sum);
        mSum.setText(String.format("%.2f", 1f));

		mRecipient = (EditText)view.findViewById(R.id.receiver);
		mComment = (EditText)view.findViewById(R.id.comment);
		Button incButton = (Button)view.findViewById(R.id.inc);
		Button decButton = (Button)view.findViewById(R.id.dec);

		mSum.setOnEditorActionListener(new OnEditorActionListener() {
			@Override
			public boolean onEditorAction(TextView v, int actionId, KeyEvent event) {
				if (actionId == EditorInfo.IME_ACTION_SEND) {
					submit();
					return true;
				}
				return false;
			}
		});
		
		incButton.setOnClickListener(new View.OnClickListener() {
		    public void onClick(View v) {
				try {
                    float currentSum =  NumberFormat.getInstance().parse(mSum.getText().toString()).floatValue();
                    mSum.setText(String.format("%.2f", currentSum + 1f));
				} catch (ParseException e) {}
		    }
		});

		decButton.setOnClickListener(new View.OnClickListener() {
		    public void onClick(View v) {
				try {
                    float currentSum = NumberFormat.getInstance().parse(mSum.getText().toString()).floatValue();
                    if (currentSum > 1) {
                        mSum.setText(String.format("%.2f", currentSum - 1f));
                    }
				} catch (ParseException e) {}
		    }
		});

		setHasOptionsMenu(true);
		return view;
	}

	public void onCreateOptionsMenu(Menu menu, MenuInflater inflater) {
		inflater.inflate(R.menu.virtuals_menu, menu);
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch(item.getItemId()) {
		case R.id.menu_send:
			submit();
			break;
		}
		return super.onOptionsItemSelected(item);
	}
	
	public void setFields(CharSequence recipient, CharSequence comment) {
		mRecipient.setText(recipient);
		mComment.setText(comment);
	}

	public void submit() {
		boolean validForm = false;
        NumberFormat numFormat = NumberFormat.getInstance();
        float amount = 0;

		try {
            amount = numFormat.parse(mSum.getText().toString()).floatValue();
            if (amount > 0f) {
                validForm = true;
            }
		} catch (ParseException e) {
                e.printStackTrace();
        }

		if(!validForm) {
            Toast.makeText(getActivity(), R.string.invalid_sum, Toast.LENGTH_SHORT).show();
        }
		else if(mRecipient.getText().length() <= 0) {
            Toast.makeText(getActivity(), R.string.invalid_recipient, Toast.LENGTH_SHORT).show();
        }
		else {
			final ProgressDialog dialog = ProgressDialog.show(getActivity(), "",
					getString(R.string.please_wait), true);
			String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_VIRTUAL, getActivity());

			JSONObject virtualObj = null;
			try {
				virtualObj = new JSONObject();
				virtualObj.put("amount", Float.toString(amount));
				virtualObj.put("recipient", mRecipient.getText().toString());
				virtualObj.put("comment", mComment.getText().toString());
			} catch (JSONException e) {
				e.printStackTrace();
			}

			JsonObjectRequest request = new JsonObjectRequest(
					Request.Method.POST,
					url,
					virtualObj,
					new Response.Listener<JSONObject>() {
						@Override
						public void onResponse(JSONObject result) {
							dialog.dismiss();
							String balance = result.optString("balance");
							if(balance != null)
								Toast.makeText(getActivity(), getString(R.string.balance) + ": " + balance, Toast.LENGTH_LONG).show();
							new KassenUpdateDatasets(getActivity()).
									execute(KassenUpdateDatasets.RequestType.VIRTUALS);

						}
					},
					new Response.ErrorListener() {
						@Override
						public void onErrorResponse(VolleyError volleyError) {
							dialog.dismiss();
							Log.e("Volley", "Error: " + volleyError.toString());

							Toast.makeText(getActivity(), volleyError.getLocalizedMessage(), Toast.LENGTH_LONG).show();
						}
					}
			) {
				@Override
				public Map<String, String> getHeaders() throws AuthFailureError {
					return KassenHttpUtils.getAuthHeader(getActivity());
				}
			};

			KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(request);
		}
	}
}
