package de.k4ever.k4android.fragments;

import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.support.v4.app.Fragment;
import android.support.v4.app.FragmentTransaction;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.Toast;
import com.android.volley.AuthFailureError;
import com.android.volley.Request;
import com.android.volley.Response;
import com.android.volley.VolleyError;
import com.android.volley.toolbox.JsonObjectRequest;
import de.k4ever.k4android.R;
import de.k4ever.k4android.database.KassenUpdateDatasets;
import de.k4ever.k4android.database.KassenUpdateDatasets.RequestType;
import de.k4ever.k4android.utils.KassenConfig;
import de.k4ever.k4android.utils.KassenHttpUtils;
import de.k4ever.k4android.utils.KassenUtils;
import org.json.JSONObject;

import java.util.Map;

public class SyncFragment extends DialogFragment {
	ProgressBar mBalance, mHistory, mVirtuals, mProducts, mTransactions;
	ImageView mBalanceCheck, mVirtualsCheck, mTransactionsCheck, mHistoryCheck, mProductsCheck;
	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setStyle(STYLE_NORMAL, android.R.style.Theme_Holo_Dialog);
	}

	@Override
	public View onCreateView(LayoutInflater inflater, ViewGroup container,
			Bundle savedInstanceState) {
		View v = inflater.inflate(R.layout.layout_sync, container, false);
		mBalance = (ProgressBar)v.findViewById(R.id.progressBar1);
		mVirtuals = (ProgressBar)v.findViewById(R.id.progressBar2);
		mTransactions = (ProgressBar)v.findViewById(R.id.progressBar3);
		mHistory = (ProgressBar)v.findViewById(R.id.progressBar4);
		mProducts = (ProgressBar)v.findViewById(R.id.progressBar5);

		mBalanceCheck = (ImageView)v.findViewById(R.id.imageView1);
		mVirtualsCheck = (ImageView)v.findViewById(R.id.imageView2);
		mTransactionsCheck = (ImageView)v.findViewById(R.id.imageView3);
		mHistoryCheck = (ImageView)v.findViewById(R.id.imageView4);
		mProductsCheck = (ImageView)v.findViewById(R.id.imageView5);


		getDialog().setTitle(getString(R.string.please_wait));
		update_balance();
		return v;
	}

	private void update_balance() {
		String url = KassenHttpUtils.getUrl(KassenConfig.KASSEN_SUBDIR_BALANCE, getActivity());

		mBalance.setVisibility(View.VISIBLE);
		JsonObjectRequest request = new JsonObjectRequest(
				Request.Method.GET,
				url,
				null,
				new Response.Listener<JSONObject>() {
					@Override
					public void onResponse(JSONObject result) {
						if (!KassenUtils.parseMoney(result, getActivity())) {
							Toast.makeText(getActivity(), R.string.error_wrongpw, Toast.LENGTH_LONG).show();
						} else {
							mBalance.setVisibility(View.INVISIBLE);
							mBalanceCheck.setVisibility(View.VISIBLE);
							update_virtuals();
						}
					}
				},
				new Response.ErrorListener() {
					@Override
					public void onErrorResponse(VolleyError volleyError) {
						Log.e("Volley", "Error: " + volleyError.toString());

						Toast.makeText(getActivity(), R.string.error_wrongpw, Toast.LENGTH_LONG).show();
					}
				}
		) {
			@Override
			public Map<String, String> getHeaders() throws AuthFailureError {
				return KassenHttpUtils.getAuthHeader(getActivity());
			}
		};

		KassenHttpUtils.getInstance(getActivity()).addToRequestQueue(request);
	}

	private void update_virtuals() {
		new KassenUpdateDatasets(getActivity()) {
			@Override
			public void onPreExecute() {
				mVirtuals.setVisibility(View.VISIBLE);
			}

			@Override
			protected void onPostExecute(Void result) {
				super.onPostExecute(result);
				mVirtuals.setVisibility(View.INVISIBLE);
				mVirtualsCheck.setVisibility(View.VISIBLE);

				update_transactions();
			}
		}.execute(RequestType.VIRTUALS);

	}

	private void update_transactions() {
		new KassenUpdateDatasets(getActivity()) {
			@Override
			public void onPreExecute() {
				mTransactions.setVisibility(View.VISIBLE);
			}

			@Override
			protected void onPostExecute(Void result) {
				super.onPostExecute(result);
				mTransactions.setVisibility(View.INVISIBLE);
				mTransactionsCheck.setVisibility(View.VISIBLE);

				update_history();
			}
		}.execute(RequestType.TRANSACTIONS);
	}


	private void update_history() {
		new KassenUpdateDatasets(getActivity()) {
			@Override
			public void onPreExecute() {
				mHistory.setVisibility(View.VISIBLE);
			}

			@Override
			protected void onPostExecute(Void result) {
				super.onPostExecute(result);
				mHistory.setVisibility(View.INVISIBLE);
				mHistoryCheck.setVisibility(View.VISIBLE);

				update_products();
			}
		}.execute(RequestType.HISTORY);
	}

	private void update_products() {
		new KassenUpdateDatasets(getActivity()) {
			@Override
			public void onPreExecute() {
				mProducts.setVisibility(View.VISIBLE);
			}

			@Override
			protected void onPostExecute(Void result) {
				super.onPostExecute(result);
				mProducts.setVisibility(View.INVISIBLE);
				mProductsCheck.setVisibility(View.VISIBLE);
				FragmentTransaction transaction = getFragmentManager().beginTransaction();
				Fragment loginFrag = getFragmentManager().findFragmentByTag("dialog");
				transaction.remove(loginFrag);
				transaction.commit();
				dismiss();
			}
		}.execute(RequestType.PRODUCTS);
	}
}
