package de.k4ever.k4android;

import android.content.Intent;
import android.database.Cursor;
import android.net.Uri;
import android.os.Bundle;
import android.support.v4.app.FragmentActivity;
import android.view.MenuItem;
import de.k4ever.k4android.database.KassenContentProvider;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;
import de.k4ever.k4android.fragments.BuyScreenFragment;

public class BuyScreenActivity extends FragmentActivity {
	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);

		// Need to check if Activity has been switched to landscape mode
		// If yes, finished and go back to the start Activity
		/*if (getResources().getConfiguration().orientation == 
				Configuration.ORIENTATION_LANDSCAPE) {
			finish();
			return;
		}*/

		setContentView(R.layout.fragment_buyscreen);
		getActionBar().setDisplayHomeAsUpEnabled(true);

		Bundle extras = getIntent().getExtras();
		if (extras != null) {
			final long id = extras.getLong("id");

			Cursor cursor = getContentResolver().query(
					Uri.withAppendedPath(KassenContentProvider.CONTENT_PRODUCTS, "/"+id),
					Products.COLUMNS_ALL, null, null, null);
			cursor.moveToFirst();

			BuyScreenFragment kaufscreen = (BuyScreenFragment)getSupportFragmentManager()
					.findFragmentById(R.id.fragment_buyscreen);
			kaufscreen.showProdukt(cursor);
		}
	}

	@Override
	public boolean onOptionsItemSelected(MenuItem item) {
		switch (item.getItemId()) {
		case android.R.id.home:
			// app icon in action bar clicked; go home
			Intent intent = new Intent(this, ProdukteActivity.class);
			intent.addFlags(Intent.FLAG_ACTIVITY_CLEAR_TOP);
			startActivity(intent);
			return true;
		default:
			return super.onOptionsItemSelected(item);
		}
	}

}
