/*
 * Copyright (C) 2011 Andrew Karpow <andy@mail.tu-berlin.de>
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package de.k4ever.k4android.utils;

import java.util.List;

import org.json.JSONException;
import org.json.JSONObject;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.SharedPreferences;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.preference.PreferenceManager;

public class KassenUtils {
	public static boolean isIntentAvailable(Context context, String action) {
		final PackageManager packageManager = context.getPackageManager();
		final Intent intent = new Intent(action);
		List<ResolveInfo> list =
				packageManager.queryIntentActivities(intent,
						PackageManager.MATCH_DEFAULT_ONLY);
		return list.size() > 0;
	}

	public static void startScanner(final Activity context, Intent action, int requestcode) {
		try {
			if(requestcode == 0)
				context.startActivity(action);
			else
				context.startActivityForResult(action, requestcode);
		} catch (ActivityNotFoundException e) {
			AlertDialog.Builder builder = new AlertDialog.Builder(context);
			builder.setTitle("Barcode Scanner installieren?")
			.setMessage("Du brauchst den Open Source Barcode Scanner von ZXing um diese Funktion zu nutzen.")
			.setCancelable(false)
			.setPositiveButton("Installieren", new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int id) {
					Intent goToMarket = new Intent(Intent.ACTION_VIEW,Uri.parse("market://details?id=com.google.zxing.client.android"));
					context.startActivity(goToMarket);
				}
			})
			.setNegativeButton("Abbrechen", new DialogInterface.OnClickListener() {
				public void onClick(DialogInterface dialog, int id) {
					dialog.cancel();
				}
			});
			AlertDialog alert = builder.create();
			alert.show();
		}

	}

	public static boolean isLoggedIn(Context ctx) {
		final SharedPreferences prefs = PreferenceManager.getDefaultSharedPreferences(ctx);
		final Boolean loginsuccess = prefs.getBoolean("pref_loginsuccess", false);
		return loginsuccess;
	}

	public static String trimQuotes( String value )
	{
		if ( value == null )
			return value;

		value = value.trim( );
		if ( value.startsWith( "\"" ) && value.endsWith( "\"" ) )
			return value.substring( 1, value.length( ) - 1 );

		return value;
	}

	public static boolean parseMoney(JSONObject money, Context activity) {
		try {
			PreferenceManager.getDefaultSharedPreferences(activity)
			.edit()
			.putFloat("balance", (float) money.getDouble("balance"))
			.apply();
			return true;
		} catch (JSONException e) {
			e.printStackTrace();
		}
		return false;
	}
}
