package de.k4ever.k4android.fragments;

import java.text.DateFormat;
import java.util.Date;
import java.util.Locale;

import android.database.Cursor;
import android.os.Bundle;
import android.support.v4.app.LoaderManager;
import android.support.v4.content.CursorLoader;
import android.support.v4.content.Loader;
import android.support.v4.widget.SwipeRefreshLayout;
import android.view.View;
import android.widget.LinearLayout;
import android.widget.SimpleCursorAdapter;
import android.widget.SimpleCursorAdapter.ViewBinder;
import android.widget.TextView;
import de.k4ever.k4android.R;
import de.k4ever.k4android.database.KassenContentProvider;
import de.k4ever.k4android.database.KassenSQLiteHelper.History;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;
import de.k4ever.k4android.database.KassenUpdateDatasets;
import de.k4ever.k4android.database.KassenUpdateDatasets.RequestType;

public class HistoryListFragment extends SwipeRefreshListFragment
implements LoaderManager.LoaderCallbacks<Cursor> {
	final private static int LOADER_HISTORY = -1;
	final private static int LOADER_PRODUCTS = 2;

	private Cursor mProductCursor = null;
	private SimpleCursorAdapter mAdapter;

	@Override
	public void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
	}

	private void putProducts(LinearLayout v, String items) {
		if(v.getChildCount() > 0)
			return;
		
		for(String itemID: items.split(",")) {
			/* Baaaad code, needs rewrite */
			mProductCursor.moveToFirst();
			while(mProductCursor.getInt(mProductCursor.getColumnIndex(Products.COLUMN_ID)) != Integer.parseInt(itemID))
				if(!mProductCursor.moveToNext())
					break;

			View child = View.inflate(getActivity(), R.layout.listitem_history_product, null);

			final TextView amountView = (TextView) child.findViewById(R.id.amount);
			final double amount = mProductCursor.getDouble(mProductCursor.getColumnIndex(Products.COLUMN_PRICE));
			amountView.setText(String.format(getString(R.string.currency_format), amount));
			
			final TextView titleView = (TextView) child.findViewById(R.id.producttitle);
			final String title = mProductCursor.getString(mProductCursor.getColumnIndex(Products.COLUMN_NAME));
			titleView.setText(title);

			v.addView(child);
		}
	}
	
	@Override public void onActivityCreated(Bundle savedInstanceState) {
		super.onActivityCreated(savedInstanceState);
		setEmptyText("You never bought something. :/");

		mAdapter = new SimpleCursorAdapter(getActivity(),
				R.layout.listitem_history, null,
				new String[] { 
			History.COLUMN_PRICE, 
			History.COLUMN_DATETIME,
			History.COLUMN_ITEMS
		}, new int[] {
			R.id.amount,
			R.id.datetime,
			R.id.products
		}, 0);

		mAdapter.setViewBinder(new ViewBinder() {
			@Override
			public boolean setViewValue(View view, Cursor cursor, int columnIndex) {
				switch (view.getId()) {
					case R.id.datetime:
						final long datetime = cursor.getLong(columnIndex);
						final String date = DateFormat.
								getDateTimeInstance(DateFormat.SHORT, DateFormat.SHORT, Locale.GERMANY).
								format(new Date(datetime));
						((TextView) view).setText(date);
						return true;
					case R.id.amount:
						final double amount = cursor.getDouble(columnIndex);
						((TextView) view).setText(String.format(getString(R.string.currency_format), amount));
						return true;
					case R.id.products:
						if (mProductCursor == null)
							return true;

						putProducts((LinearLayout) view, cursor.getString(columnIndex));
						return true;
					default:
						return false;
				}
			}
		});

		setOnRefreshListener(new SwipeRefreshLayout.OnRefreshListener() {
			@Override
			public void onRefresh() {
				if (!isRefreshing()) {
					setRefreshing(true);
				}
				new KassenUpdateDatasets(getActivity()) {
					@Override
					protected void onPostExecute(Void result) {
						super.onPostExecute(result);
						setRefreshing(false);
					}
				}.execute(RequestType.HISTORY);
			}
		});

		setListAdapter(mAdapter);
		setListShown(false);
		getLoaderManager().initLoader(LOADER_HISTORY, null, this);
		getLoaderManager().initLoader(LOADER_PRODUCTS, null, this);

	}

	@Override
	public android.support.v4.content.Loader<Cursor> onCreateLoader(int id, Bundle args) {
		if(id == LOADER_HISTORY)
			return new CursorLoader(getActivity(),
					KassenContentProvider.CONTENT_HISTORY, 
					null, null, null, 
					History.COLUMN_DATETIME + " DESC");
		else
			return new CursorLoader(getActivity(), 
					KassenContentProvider.CONTENT_PRODUCTS, 
					null, null, null, null);

	}

	@Override
	public void onLoadFinished(Loader<Cursor> loader, Cursor data) {
		if(loader.getId() == LOADER_HISTORY) {
			mAdapter.swapCursor(data);

			if (isResumed()) {
				setListShown(true);
			} else {
				setListShownNoAnimation(true);
			}
		} else if (loader.getId() == LOADER_PRODUCTS){
			mProductCursor = data;

			getListView().invalidate();
		}
	}

	@Override
	public void onLoaderReset(Loader<Cursor> id) {
		mAdapter.swapCursor(null);
	}
}
