package de.k4ever.k4android.database;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.content.UriMatcher;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteQueryBuilder;
import android.net.Uri;
import de.k4ever.k4android.database.KassenSQLiteHelper.History;
import de.k4ever.k4android.database.KassenSQLiteHelper.Products;
import de.k4ever.k4android.database.KassenSQLiteHelper.Transactions;
import de.k4ever.k4android.database.KassenSQLiteHelper.VirtualTransactions;

public class KassenContentProvider extends ContentProvider {
	private KassenSQLiteHelper db;
	private static final String AUTHORITY = "de.k4ever.k4android.database";
	private static final String BASE_PRODUCT = "PRODUCT";
	private static final String BASE_TRANSACTION = "TRANSACTION";
	private static final String BASE_VIRTUALS = "VIRTUALS";
	private static final String BASE_BUY = "BUY";

	public static final Uri CONTENT_PRODUCTS = Uri.parse("content://" + AUTHORITY + "/" + BASE_PRODUCT);
	public static final Uri CONTENT_TRANSACTIONS = Uri.parse("content://" + AUTHORITY + "/" + BASE_TRANSACTION);
	public static final Uri CONTENT_VIRTUALS = Uri.parse("content://" + AUTHORITY + "/" + BASE_VIRTUALS);
	public static final Uri CONTENT_HISTORY = Uri.parse("content://" + AUTHORITY + "/" + BASE_BUY);

	private static final int PRODUCTS = 1;
	private static final int PRODUCT = 2;
	private static final int TRANSACTIONS = 3;
	private static final int TRANSACTION = 4;
	private static final int BUYS = 5;
	private static final int BUY = 6;
	private static final int VIRTUALS = 7;
	private static final int VIRTUAL = 8;

	private static final UriMatcher sURIMatcher = new UriMatcher(UriMatcher.NO_MATCH);
	static {
		sURIMatcher.addURI(AUTHORITY, BASE_PRODUCT, PRODUCTS);
		sURIMatcher.addURI(AUTHORITY, BASE_PRODUCT + "/#", PRODUCT);
		sURIMatcher.addURI(AUTHORITY, BASE_TRANSACTION, TRANSACTIONS);
		sURIMatcher.addURI(AUTHORITY, BASE_TRANSACTION + "/#", TRANSACTION);
		sURIMatcher.addURI(AUTHORITY, BASE_BUY, BUYS);
		sURIMatcher.addURI(AUTHORITY, BASE_BUY + "/#", BUY);
		sURIMatcher.addURI(AUTHORITY, BASE_VIRTUALS, VIRTUALS);
		sURIMatcher.addURI(AUTHORITY, BASE_VIRTUALS + "/#", VIRTUAL);
	}


	@Override
	public boolean onCreate() {
		db = new KassenSQLiteHelper(getContext());
		return true;
	}

	@Override
	public int delete(Uri uri, String selection, String[] selectionArgs) {
		SQLiteDatabase sqlDB = db.getWritableDatabase();
		String whereClause = null;
		int rowsDeleted = 0;

		switch (sURIMatcher.match(uri)) {
		case PRODUCT:
			whereClause = Products.COLUMN_ID + "=" + uri.getLastPathSegment();
		case PRODUCTS:
			rowsDeleted = sqlDB.delete(Products.TABLE_NAME, whereClause, null);
			break;
		case TRANSACTION:
			whereClause = Transactions.COLUMN_ID + "=" + uri.getLastPathSegment();
		case TRANSACTIONS:
			rowsDeleted = sqlDB.delete(Transactions.TABLE_NAME, whereClause, null);
			break;
		case BUY:
			whereClause = History.COLUMN_ID + "=" + uri.getLastPathSegment();
		case BUYS:
			rowsDeleted = sqlDB.delete(History.TABLE_NAME, whereClause, null);
			break;
		case VIRTUAL:
			whereClause = VirtualTransactions.COLUMN_ID + "=" + uri.getLastPathSegment();
		case VIRTUALS:
			rowsDeleted = sqlDB.delete(VirtualTransactions.TABLE_NAME, whereClause, null);
			break;

		default:
			throw new IllegalArgumentException("Unknown URI: " + uri);
		}

		getContext().getContentResolver().notifyChange(uri, null);
		return rowsDeleted;
	}

	@Override
	public String getType(Uri uri) {
		return null;
	}

	@Override
	public Uri insert(Uri uri, ContentValues values) {
		SQLiteDatabase sqlDB = db.getWritableDatabase();
		long row = 0;

		switch (sURIMatcher.match(uri)) {
		case PRODUCTS:
			row = sqlDB.insert(Products.TABLE_NAME, null, values);
			break;
		case TRANSACTIONS:
			row = sqlDB.insert(Transactions.TABLE_NAME, null, values);
			break;
		case BUYS:
			row = sqlDB.insert(History.TABLE_NAME, null, values);
			break;
		case VIRTUALS:
			row = sqlDB.insert(VirtualTransactions.TABLE_NAME, null, values);
			break;
		default:
			throw new IllegalArgumentException("Unknown URI: " + uri);
		}

		getContext().getContentResolver().notifyChange(uri, null);
		return Uri.withAppendedPath(uri, row+"");
	}

	@Override
	public Cursor query(Uri uri, String[] projection, String selection,
			String[] selectionArgs, String sortOrder) {
		SQLiteQueryBuilder query = new SQLiteQueryBuilder();

		switch (sURIMatcher.match(uri)) {
		case PRODUCT:
			query.appendWhere(Products.COLUMN_ID + "=" + uri.getLastPathSegment());
		case PRODUCTS:
			query.setTables(Products.TABLE_NAME);
			break;
		case TRANSACTION:
			query.appendWhere(Transactions.COLUMN_ID + "=" + uri.getLastPathSegment());
		case TRANSACTIONS:
			query.setTables(Transactions.TABLE_NAME);
			break;
		case BUY:
			query.appendWhere(History.COLUMN_ID + "=" + uri.getLastPathSegment());
		case BUYS:
			query.setTables(History.TABLE_NAME);
			break;
		case VIRTUAL:
			query.appendWhere(VirtualTransactions.COLUMN_ID + "=" + uri.getLastPathSegment());
		case VIRTUALS:
			query.setTables(VirtualTransactions.TABLE_NAME);
			break;
		default:
			throw new IllegalArgumentException("Unknown URI: " + uri);
		}

		SQLiteDatabase sql = db.getWritableDatabase();
		Cursor cursor = query.query(sql, projection, selection,
				selectionArgs, null, null, sortOrder);

		// Make sure that potential listeners are getting notified
		cursor.setNotificationUri(getContext().getContentResolver(), uri);

		return cursor;

	}

	@Override
	public int update(Uri uri, ContentValues values, String selection,
			String[] selectionArgs) {

		SQLiteDatabase sqlDB = db.getWritableDatabase();
		switch(sURIMatcher.match(uri)) {
		case PRODUCT:
			return sqlDB.update(Products.TABLE_NAME, values, Products.COLUMN_ID + "=" + uri.getLastPathSegment(), null);
		}
		return 0;
	}

}
