# ToGoZip: "Add To Zip" for Android's Share/Send Menu
<a href="https://f-droid.org/packages/de.k3b.android.toGoZip" target="_blank">
<img src="https://raw.githubusercontent.com/k3b/ToGoZip/master/app/src/main/res/drawable-xxhdpi/ic_launcher.png" alt="ToGoZip logo" height="100"/>
<img src="https://f-droid.org/badge/get-it-on.png" alt="Get it on F-Droid" height="100"/>
</a>

Easy collection of files from every supporting app into one ZIP file while
being "on the go" or offline.

This collecting "2go.zip" file is like a suitcase in which you can put things (files)
from nearly everywhere (from every app that supports "share"/"send") and
that can travel everywhere (via email, Bluetooth, NFC).

In the beginning this program was developed to collect new Android calendar
entry [ics-files](https://f-droid.org/wiki/page/de.k3b.android.calendar.ics.adapter)
in order to transfer them to a desktop PC's calendar.

## Features
* Supports view/send/SendMultiple for file(s), folder(s), URLs and texts.
* Automatic file renaming in the ZIP if the same name with different file date already exists.
* If settings/DebugMode is enabled, processing is logged to logcat and to clipboard as text.
* Settings automatically pop up if the ZIP folder is not writable.
* [Translations](https://crowdin.com/project/togozip) : ar,  bn,  cs,  de,  en,  es,  eu,  fr,  he,  hi,  hu,  id,  ja,  nl,  no,  pl,  pt,  ru,  si,  tr,  uk,  vi,  zh-CN,  zh-TW
  * [![Crowdin](https://d322cqt584bo4o.cloudfront.net/togozip/localized.svg)](https://crowdin.com/project/togozip) [Help us to translate into other languages.](https://crowdin.com/project/togozip)
* Minimual requirements: 
  * Version 2.0.17 works with Android-2.1 (api 7) up to Android-5. apk size is only about 100 KB.
  * Version 2.1.27 works with Android-4.1 (api 16) and later (including Android-10). apk size is only about 200 KB.

## Required Android Permissions
* WRITE_EXTERNAL_STORAGE used to store the created/updated ZIP file.
* The Android device must have external storage (aka SD card) where the ZIP file is written to.

## Links
* [Changelog](https://github.com/k3b/toGoZip/wiki/History)
* [Technical Features](https://github.com/k3b/toGoZip/wiki/Features)

## Screenshots
![Share menu with ToGoZip entry](https://raw.githubusercontent.com/k3b/ToGoZip/master/fastlane/metadata/android/en-US/images/phoneScreenshots/1-send.png)

![App settings](https://github.com/k3b/ToGoZip/raw/master/fastlane/metadata/android/en-US/images/phoneScreenshots/2-settings.png)


-----

## Donations
If you like this app, please consider [donating to F-Droid](https://f-droid.org/donate).

Since Android development is a hobby (and an educational tool) I don't want any money for my apps, so donations should go to projects I benefit from.

