package de.determapp.android.ui.contentlist

import android.os.Bundle
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.fragment.app.Fragment
import androidx.lifecycle.Observer
import androidx.lifecycle.ViewModelProviders
import androidx.recyclerview.widget.StaggeredGridLayoutManager
import com.google.android.material.snackbar.Snackbar
import de.determapp.android.R
import de.determapp.android.ui.viewer.ProjectSpec
import de.determapp.android.ui.viewer.ViewerActivity
import kotlinx.android.synthetic.main.fragment_content_list.*

class ContentListFragment: Fragment(), Handlers {
    override fun onCreateView(inflater: LayoutInflater, container: ViewGroup?, savedInstanceState: Bundle?): View? {
        return inflater.inflate(R.layout.fragment_content_list, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)

        val adapter = ContentListAdapter()

        adapter.setHandlers(this)

        ContentList.with(context!!).observe(this, Observer {
            adapter.setList(it)

            if (it == null || it.size == 0) {
                empty.visibility = View.VISIBLE
            } else {
                empty.visibility = View.GONE
            }
        })

        recycler.layoutManager = StaggeredGridLayoutManager(
                resources.getInteger(R.integer.grid_column_count),
                StaggeredGridLayoutManager.VERTICAL
        )
        recycler.adapter = adapter

        val model = ViewModelProviders.of(this).get(ContentListModel::class.java)
        model.doInitialRequest()
        model.response.observe(this, Observer {
            if (it != null) {
                if (!model.showedResult) {
                    model.showedResult = true

                    if (it.failedUrls.isNotEmpty()) {
                        val message: String

                        if (it.failedUrls.size == it.processedUrls.size) {
                            if (it.failedUrls.size == 1) {
                                message = getString(R.string.content_list_refresh_all_only_one_failed)
                            } else {
                                message = getString(R.string.content_list_refresh_all_failed)
                            }
                        } else {
                            message = getString(R.string.content_list_refresh_some_failed)
                        }

                        Snackbar.make(recycler, message, Snackbar.LENGTH_SHORT).show()
                    }
                }
            }
        })
    }

    override fun onContentListItemClicked(item: ContentListItem) {
        ViewerActivity.start(
                context!!,
                ProjectSpec(item.projectId, item.source)
        )
    }
}
